/*
 * Decompiled with CFR 0.152.
 */
package net.silvertide.homebound.network;

import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.NetworkEvent;
import net.silvertide.homebound.events.custom.StartWarpEvent;
import net.silvertide.homebound.item.IWarpItem;
import net.silvertide.homebound.services.WarpManager;
import net.silvertide.homebound.util.HomeboundUtil;
import org.jetbrains.annotations.Nullable;

public class ServerboundUseHomeboundStoneMessage {
    private final byte isKeybindDown;

    public ServerboundUseHomeboundStoneMessage(byte isKeybindDown) {
        this.isKeybindDown = isKeybindDown;
    }

    public ServerboundUseHomeboundStoneMessage(FriendlyByteBuf buf) {
        this(buf.readByte());
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeByte((int)this.isKeybindDown);
    }

    static void handle(ServerboundUseHomeboundStoneMessage msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> ServerboundUseHomeboundStoneMessage.handleMessage(context.getSender(), msg));
        context.setPacketHandled(true);
    }

    private static void handleMessage(@Nullable ServerPlayer player, ServerboundUseHomeboundStoneMessage msg) {
        if (player == null) {
            return;
        }
        if (msg.isKeybindDown == 1) {
            if (!WarpManager.get().isPlayerWarping(player)) {
                Optional<ItemStack> warpItemStack = HomeboundUtil.findWarpInitiatiorItemStack((Player)player);
                warpItemStack.ifPresentOrElse(stack -> {
                    IWarpItem warpItem = (IWarpItem)stack.m_41720_();
                    if (MinecraftForge.EVENT_BUS.post((Event)new StartWarpEvent((Player)player, warpItem))) {
                        return;
                    }
                    WarpManager.get().startWarping(player, (ItemStack)stack);
                }, () -> HomeboundUtil.displayClientMessage((Player)player, "No Homebound stone found."));
            }
        } else if (WarpManager.get().isPlayerWarping(player)) {
            WarpManager.get().cancelWarp(player);
        }
    }
}

