/*
 * Decompiled with CFR 0.152.
 */
package net.silvertide.homebound.services;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.silvertide.homebound.config.Config;
import net.silvertide.homebound.data.ScheduledBindHome;
import net.silvertide.homebound.network.ClientboundSyncHomeScheduleMessage;
import net.silvertide.homebound.network.PacketHandler;
import net.silvertide.homebound.util.AttributeUtil;
import net.silvertide.homebound.util.CapabilityUtil;
import net.silvertide.homebound.util.HomeboundUtil;

public class HomeManager {
    private static final HomeManager INSTANCE = new HomeManager();
    private final Map<UUID, ScheduledBindHome> scheduledBindHomeMap = new HashMap<UUID, ScheduledBindHome>();

    private HomeManager() {
    }

    public static HomeManager get() {
        return INSTANCE;
    }

    public void startBindingHome(ServerPlayer player) {
        if ((Integer)Config.BIND_HOME_USE_DURATION.get() > 0) {
            ScheduledBindHome scheduledBindHome = new ScheduledBindHome(player, (Integer)Config.BIND_HOME_USE_DURATION.get() * 20, player.m_9236_().m_46467_());
            long currentGameTime = player.m_9236_().m_46467_();
            long finishGameTime = currentGameTime + (long)((Integer)Config.BIND_HOME_USE_DURATION.get() * 20);
            PacketHandler.sendToPlayer(player, new ClientboundSyncHomeScheduleMessage(currentGameTime, finishGameTime));
            AttributeUtil.tryAddChannelSlow((Player)player, (Double)Config.CHANNEL_SLOW_PERCENTAGE.get());
            this.scheduledBindHomeMap.put(player.m_20148_(), scheduledBindHome);
        } else {
            this.setPlayerHome(player);
        }
    }

    public boolean canPlayerSetHome(ServerPlayer player) {
        int remainingCooldown;
        if (((Boolean)Config.CANT_BIND_HOME_ON_COOLDOWN.get()).booleanValue() && (remainingCooldown = CapabilityUtil.getRemainingCooldown((Player)player)) > 0) {
            String message = "\u00a7cCan't set home, you haven't recovered. [" + HomeboundUtil.formatTime(remainingCooldown) + "]\u00a7r";
            HomeboundUtil.displayClientMessage((Player)player, message);
            return false;
        }
        ServerLevel serverLevel = player.m_284548_();
        String dimensionLocation = serverLevel.m_46472_().m_135782_().toString();
        List setHomeBlacklist = (List)Config.HOME_DIMENSION_BLACKLIST.get();
        if (!setHomeBlacklist.isEmpty() && setHomeBlacklist.contains(dimensionLocation)) {
            String message = "\u00a7cYou can't set a home in this dimension.\u00a7r";
            HomeboundUtil.displayClientMessage((Player)player, message);
            return false;
        }
        List dimensionBlacklist = (List)Config.TELEPORT_DIMENSION_BLACKLIST.get();
        if (!dimensionBlacklist.isEmpty() && dimensionBlacklist.contains(dimensionLocation)) {
            String message = "\u00a7cYou can't set a home in this dimension.\u00a7r";
            HomeboundUtil.displayClientMessage((Player)player, message);
            return false;
        }
        List structureBlacklist = (List)Config.TELEPORT_STRUCTURE_BLACKLIST.get();
        if (!structureBlacklist.isEmpty() && HomeboundUtil.withinAnyStructuresBounds(player, structureBlacklist)) {
            String message = "\u00a7cYou can't set a home in this structure.\u00a7r";
            HomeboundUtil.displayClientMessage((Player)player, message);
            return false;
        }
        return true;
    }

    public void cancelBindHome(ServerPlayer player) {
        if (this.isPlayerBindingHome(player)) {
            PacketHandler.sendToPlayer(player, new ClientboundSyncHomeScheduleMessage(0L, 0L));
            AttributeUtil.removeChannelSlow((Player)player);
            this.scheduledBindHomeMap.remove(player.m_20148_());
        }
    }

    public boolean isPlayerBindingHome(ServerPlayer player) {
        return this.scheduledBindHomeMap.containsKey(player.m_20148_());
    }

    public boolean bindHomeIsActive() {
        return this.scheduledBindHomeMap.size() > 0;
    }

    public List<ScheduledBindHome> getBindHomeSchedules() {
        return new ArrayList<ScheduledBindHome>(this.scheduledBindHomeMap.values());
    }

    public double bindHomePercentComplete(ServerPlayer player) {
        ScheduledBindHome scheduledBindHome = this.scheduledBindHomeMap.get(player.m_20148_());
        if (scheduledBindHome == null) {
            return 0.0;
        }
        long timeElapsed = player.m_9236_().m_46467_() - scheduledBindHome.startedBindingHomeGameTimeStamp();
        return (double)timeElapsed / (double)scheduledBindHome.useDuration() * 100.0;
    }

    public void setPlayerHome(ServerPlayer player) {
        CapabilityUtil.getWarpCap((LivingEntity)player).ifPresent(warpCap -> {
            warpCap.setWarpPos((Player)player);
            if ((Integer)Config.BIND_HOME_COOLDOWN_DURATION.get() > 0) {
                warpCap.addCooldown(player.m_9236_().m_46467_(), (Integer)Config.BIND_HOME_COOLDOWN_DURATION.get());
            }
            HomeboundUtil.displayClientMessage((Player)player, "\u00a7aHome set.\u00a7r");
        });
        this.cancelBindHome(player);
    }

    public void triggerHomeBindEffects(ServerPlayer serverPlayer) {
        ServerLevel serverLevel = serverPlayer.m_284548_();
        HomeboundUtil.spawnParticals(serverLevel, (Player)serverPlayer, (ParticleOptions)ParticleTypes.f_123797_, 20);
        HomeboundUtil.playSound((Level)serverLevel, serverPlayer.m_20185_(), serverPlayer.m_20186_(), serverPlayer.m_20189_(), SoundEvents.f_11736_);
    }
}

