/*
 * Decompiled with CFR 0.152.
 */
package net.silvertide.homebound.services;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraftforge.server.ServerLifecycleHooks;
import net.silvertide.homebound.Homebound;
import net.silvertide.homebound.capabilities.WarpPos;
import net.silvertide.homebound.config.Config;
import net.silvertide.homebound.data.ScheduledWarp;
import net.silvertide.homebound.data.WarpResult;
import net.silvertide.homebound.item.IWarpItem;
import net.silvertide.homebound.network.ClientboundSyncWarpScheduleMessage;
import net.silvertide.homebound.network.PacketHandler;
import net.silvertide.homebound.util.AttributeUtil;
import net.silvertide.homebound.util.CapabilityUtil;
import net.silvertide.homebound.util.HomeboundUtil;
import org.jetbrains.annotations.Nullable;

public class WarpManager {
    private static final WarpManager INSTANCE = new WarpManager();
    private final Map<UUID, ScheduledWarp> scheduledWarpMap = new HashMap<UUID, ScheduledWarp>();

    private WarpManager() {
    }

    public static WarpManager get() {
        return INSTANCE;
    }

    public void startWarping(ServerPlayer player, ItemStack warpItemStack) {
        IWarpItem warpItem = (IWarpItem)warpItemStack.m_41720_();
        if (warpItem.getWarpUseDuration(warpItemStack) > 0) {
            ScheduledWarp scheduledWarp = new ScheduledWarp(player, warpItemStack, warpItem.getWarpUseDuration(warpItemStack), player.m_9236_().m_46467_());
            this.scheduledWarpMap.put(player.m_20148_(), scheduledWarp);
            PacketHandler.sendToPlayer(player, new ClientboundSyncWarpScheduleMessage(scheduledWarp.startedWarpingGameTimeStamp(), scheduledWarp.scheduledGameTimeTickToWarp()));
            AttributeUtil.tryAddChannelSlow((Player)player, (Double)Config.CHANNEL_SLOW_PERCENTAGE.get());
        } else {
            this.warpPlayerHome(player);
        }
    }

    public void cancelWarp(ServerPlayer player) {
        if (this.isPlayerWarping(player)) {
            PacketHandler.sendToPlayer(player, new ClientboundSyncWarpScheduleMessage(0L, 0L));
            AttributeUtil.removeChannelSlow((Player)player);
            this.scheduledWarpMap.remove(player.m_20148_());
        }
    }

    public boolean isPlayerWarping(ServerPlayer player) {
        return this.scheduledWarpMap.containsKey(player.m_20148_());
    }

    public boolean warpIsActive() {
        return !this.scheduledWarpMap.isEmpty();
    }

    public List<ScheduledWarp> getWarpAttributeList() {
        return new ArrayList<ScheduledWarp>(this.scheduledWarpMap.values());
    }

    public double warpPercentComplete(ServerPlayer player) {
        ScheduledWarp scheduledWarp = this.scheduledWarpMap.get(player.m_20148_());
        if (scheduledWarp == null) {
            return 0.0;
        }
        long timeElapsed = player.m_9236_().m_46467_() - scheduledWarp.startedWarpingGameTimeStamp();
        return (double)timeElapsed / (double)scheduledWarp.useDuration() * 100.0;
    }

    public WarpResult canPlayerWarp(ServerPlayer serverPlayer, IWarpItem warpItem) {
        int distanceFromWarp;
        if (!CapabilityUtil.isHomeSet((Player)serverPlayer)) {
            return new WarpResult(false, "\u00a7cNo home set.\u00a7r");
        }
        String dimensionLocation = serverPlayer.m_9236_().m_46472_().m_135782_().toString();
        List teleportBlacklist = (List)Config.TELEPORT_DIMENSION_BLACKLIST.get();
        if (!teleportBlacklist.isEmpty() && teleportBlacklist.contains(dimensionLocation)) {
            return new WarpResult(false, "\u00a7cYou can't warp home from this dimension.\u00a7r");
        }
        List structureBlacklist = (List)Config.TELEPORT_STRUCTURE_BLACKLIST.get();
        if (!structureBlacklist.isEmpty() && HomeboundUtil.withinAnyStructuresBounds(serverPlayer, structureBlacklist)) {
            return new WarpResult(false, "\u00a7cYou can't teleport home from this structure.\u00a7r");
        }
        int minimumHostileMobDist = (Integer)Config.MINIMUM_MOB_DISTANCE.get();
        if (minimumHostileMobDist > 0 && HomeboundUtil.hostileMobWithinRange(serverPlayer, minimumHostileMobDist)) {
            return new WarpResult(false, "\u00a7cYou can't teleport home, there are monsters nearby.\u00a7r");
        }
        int remainingCooldown = CapabilityUtil.getRemainingCooldown((Player)serverPlayer);
        if (remainingCooldown > 0) {
            String message = "\u00a7cYou haven't recovered. [" + HomeboundUtil.formatTime(remainingCooldown) + "]\u00a7r";
            return new WarpResult(false, message);
        }
        if (!CapabilityUtil.inValidDimension((Player)serverPlayer, warpItem)) {
            String message = "\u00a7cCan't warp between dimensions.\u00a7r";
            return new WarpResult(false, message);
        }
        int maxDistance = warpItem.getMaxDistance();
        if (maxDistance > 0 && (distanceFromWarp = CapabilityUtil.getWarpCap((LivingEntity)serverPlayer).resolve().map(warpCap -> warpCap.getWarpPos().calculateDistance(new WarpPos(serverPlayer.m_20097_(), serverPlayer.m_9236_().m_46472_().m_135782_()))).orElse(10000).intValue()) > maxDistance) {
            String message = "\u00a7cToo far from home. [" + distanceFromWarp + " / " + maxDistance + "]\u00a7r";
            return new WarpResult(false, message);
        }
        return new WarpResult(true, "");
    }

    public void warpPlayerHome(ServerPlayer player) {
        CapabilityUtil.getWarpCap((LivingEntity)player).ifPresent(playerWarpCapability -> {
            this.warp((Entity)player, playerWarpCapability.getWarpPos());
            ScheduledWarp scheduledWarp = this.scheduledWarpMap.get(player.m_20148_());
            ItemStack warpItemStack = scheduledWarp.warpItemStack();
            IWarpItem warpItem = (IWarpItem)warpItemStack.m_41720_();
            if (!player.m_150110_().f_35937_) {
                int cooldown = warpItem.getWarpCooldown(player, warpItemStack);
                if (cooldown > 0) {
                    playerWarpCapability.setCooldown(player.m_9236_().m_46467_(), cooldown);
                }
                if (warpItem.isConsumedOnUse()) {
                    warpItemStack.m_41774_(1);
                }
            }
        });
        this.cancelWarp(player);
    }

    public void playWarpEffects(ServerPlayer player) {
        HomeboundUtil.spawnParticals(player.m_284548_(), (Player)player, (ParticleOptions)ParticleTypes.f_123760_, 8);
        HomeboundUtil.playSound((Level)player.m_284548_(), (Player)player, SoundEvents.f_11702_);
    }

    private void warp(Entity entity, WarpPos warpPos) {
        ServerLevel destLevel;
        ServerLevel s;
        entity.f_19789_ = 0.0f;
        BlockPos destinationPos = warpPos.blockPos();
        ResourceLocation destinationDim = warpPos.dimension();
        Level originalLevel = entity.m_9236_();
        double currX = entity.m_20185_();
        double currY = entity.m_20186_();
        double currZ = entity.m_20189_();
        double destX = (double)destinationPos.m_123341_() + 0.5;
        double destY = (double)destinationPos.m_123342_() + 1.0;
        double destZ = (double)destinationPos.m_123343_() + 0.5;
        boolean inSameDimension = entity.m_9236_().m_46472_().m_135782_().equals((Object)destinationDim);
        ServerLevel serverLevel = inSameDimension ? (originalLevel instanceof ServerLevel ? (s = (ServerLevel)originalLevel) : null) : (destLevel = ServerLifecycleHooks.getCurrentServer().m_129880_(ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)destinationDim)));
        if (destLevel == null) {
            Homebound.LOGGER.error("World {} doesn't exist.", (Object)destinationDim);
            return;
        }
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            destLevel.m_7726_().m_8387_(TicketType.f_9448_, new ChunkPos(destinationPos), 1, (Object)entity.m_19879_());
            AbstractHorse riddenEntityToTeleport = this.getHorseIfRidingAndOwnedByPlayer(player);
            if (player.m_20159_()) {
                player.m_8127_();
            }
            if (player.m_5803_()) {
                player.m_5796_();
            }
            if (inSameDimension) {
                player.f_8906_.m_9780_(destX, destY, destZ, player.m_146908_(), player.m_146909_(), Collections.emptySet());
                if (riddenEntityToTeleport != null) {
                    riddenEntityToTeleport.m_7678_(destX, destY, destZ, riddenEntityToTeleport.m_146908_(), riddenEntityToTeleport.m_146909_());
                }
            } else {
                player.m_8999_(destLevel, destX, destY, destZ, player.m_146908_(), player.m_146909_());
                if (riddenEntityToTeleport != null) {
                    riddenEntityToTeleport.m_264318_(destLevel, destX, destY, destZ, new HashSet(), riddenEntityToTeleport.m_146908_(), riddenEntityToTeleport.m_146909_());
                }
            }
        } else {
            entity.m_19877_();
            if (inSameDimension) {
                entity.m_7678_(destX, destY, destZ, entity.m_146908_(), entity.m_146909_());
            } else {
                Entity e2 = entity.m_6095_().m_20615_((Level)destLevel);
                if (e2 == null) {
                    Homebound.LOGGER.warn("Failed to move Entity {}", (Object)entity);
                    return;
                }
                e2.m_20361_(entity);
                e2.m_7678_(destX, destY, destZ, e2.m_146908_(), e2.m_146909_());
                destLevel.m_7967_(e2);
                entity.m_142687_(Entity.RemovalReason.CHANGED_DIMENSION);
            }
        }
        HomeboundUtil.playSound(originalLevel, currX, currY, currZ, SoundEvents.f_11852_);
        HomeboundUtil.playSound((Level)destLevel, destX, destY, destZ, SoundEvents.f_11852_);
    }

    @Nullable
    private AbstractHorse getHorseIfRidingAndOwnedByPlayer(ServerPlayer player) {
        Entity vehicle;
        if (player.m_20159_() && (vehicle = player.m_20202_()) instanceof AbstractHorse) {
            AbstractHorse horseLike = (AbstractHorse)vehicle;
            boolean hasOwner = horseLike.m_21805_() != null;
            boolean riddenByOwner = horseLike.m_21805_().toString().equals(player.m_20148_().toString());
            if (hasOwner && riddenByOwner) {
                return horseLike;
            }
        }
        return null;
    }
}

