/*
 * Decompiled with CFR 0.152.
 */
package net.silvertide.homebound.util;

import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.util.LazyOptional;
import net.silvertide.homebound.capabilities.IWarpCap;
import net.silvertide.homebound.capabilities.WarpPos;
import net.silvertide.homebound.item.IWarpItem;
import net.silvertide.homebound.registry.CapabilityRegistry;
import org.jetbrains.annotations.Nullable;

public final class CapabilityUtil {
    private CapabilityUtil() {
    }

    @Nullable
    public static IWarpCap getWarpCapOrNull(Player player) {
        return (IWarpCap)CapabilityUtil.getWarpCap((LivingEntity)player).orElse(null);
    }

    public static LazyOptional<IWarpCap> getWarpCap(LivingEntity entity) {
        if (entity == null) {
            return LazyOptional.empty();
        }
        return entity.getCapability(CapabilityRegistry.HOME_CAPABILITY);
    }

    public static WarpPos createWarpPosOnPlayer(Player player) {
        return new WarpPos(player.m_20097_(), player.m_9236_().m_46472_().m_135782_());
    }

    public static boolean isHomeSet(Player player) {
        return CapabilityUtil.getWarpCap((LivingEntity)player).map(warpCap -> warpCap.getWarpPos() != null).orElse(false);
    }

    public static int getRemainingCooldown(Player player) {
        return CapabilityUtil.getWarpCap((LivingEntity)player).map(warpCap -> {
            long currGameTime = player.m_9236_().m_46467_();
            return warpCap.getRemainingCooldown(currGameTime);
        }).orElse(0);
    }

    public static boolean inValidDimension(Player player, IWarpItem warpItem) {
        boolean isPlayerInWarpPosDimension = CapabilityUtil.getWarpCap((LivingEntity)player).map(warpCap -> warpCap.getWarpPos().isSameDimension(player.m_9236_().m_46472_().m_135782_())).orElse(false);
        return warpItem.canDimTravel() || isPlayerInWarpPosDimension;
    }

    public static boolean withinMaxDistance(Player player, IWarpItem warpItem) {
        int maxDistance = warpItem.getMaxDistance();
        if (maxDistance == 0) {
            return true;
        }
        IWarpCap playerWarpCap = CapabilityUtil.getWarpCapOrNull(player);
        if (playerWarpCap == null) {
            return false;
        }
        int distanceFromWarp = playerWarpCap.getWarpPos().calculateDistance(new WarpPos(player.m_20097_(), player.m_9236_().m_46472_().m_135782_()));
        return distanceFromWarp <= maxDistance;
    }
}

