/*
 * Decompiled with CFR 0.152.
 */
package net.silvertide.homebound.util;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fml.ModList;
import net.silvertide.homebound.capabilities.IWarpCap;
import net.silvertide.homebound.capabilities.WarpPos;
import net.silvertide.homebound.compat.CuriosCompat;
import net.silvertide.homebound.item.IWarpItem;
import net.silvertide.homebound.util.CapabilityUtil;

public final class HomeboundUtil {
    private static final Random SOUND_RNG = new Random();
    public static final int TICKS_PER_SECOND = 20;

    private HomeboundUtil() {
    }

    public static boolean withinAnyStructuresBounds(ServerPlayer serverPlayer, List<String> structureRLs) {
        ServerLevel serverLevel = serverPlayer.m_284548_();
        for (Map.Entry structureEntry : serverLevel.m_215010_().m_220522_(serverPlayer.m_20183_()).entrySet()) {
            Registry structureRegistry = serverLevel.m_9598_().m_175515_(Registries.f_256944_);
            ResourceLocation structureRL = structureRegistry.m_7981_((Object)((Structure)structureEntry.getKey()));
            if (structureRL == null || !structureRLs.contains(structureRL.toString()) || !HomeboundUtil.withinStructureBounds(serverPlayer, (Structure)structureEntry.getKey())) continue;
            return true;
        }
        return false;
    }

    public static boolean withinStructureBounds(ServerPlayer serverPlayer, Structure structure) {
        BlockPos playerPos = serverPlayer.m_20183_();
        StructureStart structureStart = serverPlayer.m_284548_().m_215010_().m_220494_(playerPos, structure);
        if (structureStart != StructureStart.f_73561_) {
            return structureStart.m_73601_().m_71051_((Vec3i)playerPos);
        }
        return false;
    }

    public static boolean hostileMobWithinRange(ServerPlayer serverPlayer, int minimumHostileMobDist) {
        return !serverPlayer.m_284548_().m_45971_(Monster.class, TargetingConditions.m_148352_(), (LivingEntity)serverPlayer, AABB.m_165882_((Vec3)serverPlayer.m_20182_(), (double)(minimumHostileMobDist * 2), (double)(minimumHostileMobDist * 2), (double)(minimumHostileMobDist * 2))).isEmpty();
    }

    public static int applyDistanceCooldownModifier(IWarpItem warpItem, ServerPlayer player, int cooldown) {
        double maxCooldownReduction = warpItem.getDistanceBasedCooldownReduction();
        if (maxCooldownReduction > 0.0) {
            int blocksPerPercentAdded = warpItem.getBlocksPerBonusReducedBy1Percent();
            IWarpCap playerWarpCap = CapabilityUtil.getWarpCapOrNull((Player)player);
            if (playerWarpCap == null) {
                return cooldown;
            }
            WarpPos currentPos = CapabilityUtil.createWarpPosOnPlayer((Player)player);
            int dimensionMultiplier = playerWarpCap.getWarpPos().isSameDimension(currentPos) ? 1 : 2;
            int distanceToHome = playerWarpCap.getWarpPos().calculateDistance(currentPos);
            double distancePenalty = (double)(distanceToHome / blocksPerPercentAdded) / 100.0 * (double)dimensionMultiplier;
            if (distancePenalty < maxCooldownReduction) {
                double cooldownReductionBonus = 1.0 - (maxCooldownReduction - distancePenalty);
                double modifiedCooldown = (double)cooldown * cooldownReductionBonus;
                return (int)modifiedCooldown;
            }
        }
        return cooldown;
    }

    public static Optional<ItemStack> findWarpInitiatiorItemStack(Player player) {
        Optional<ItemStack> curiosWarpItemStack;
        Inventory playerInventory = player.m_150109_();
        int currentlySelectedSlotIndex = player.m_150109_().f_35977_;
        if (Inventory.m_36045_((int)currentlySelectedSlotIndex) && ((ItemStack)player.m_150109_().f_35974_.get(currentlySelectedSlotIndex)).m_41720_() instanceof IWarpItem) {
            return Optional.of((ItemStack)player.m_150109_().f_35974_.get(currentlySelectedSlotIndex));
        }
        if (((ItemStack)playerInventory.f_35976_.get(0)).m_41720_() instanceof IWarpItem) {
            return Optional.of((ItemStack)playerInventory.f_35976_.get(0));
        }
        if (ModList.get().isLoaded("curios") && (curiosWarpItemStack = CuriosCompat.findCuriosWarpItemStack(player)).isPresent()) {
            return curiosWarpItemStack;
        }
        for (int i = 0; i < playerInventory.f_35974_.size(); ++i) {
            ItemStack stack = (ItemStack)playerInventory.f_35974_.get(i);
            if (!(stack.m_41720_() instanceof IWarpItem)) continue;
            return Optional.of(stack);
        }
        return Optional.empty();
    }

    public static void spawnParticals(ServerLevel serverLevel, Player player, ParticleOptions particle, int numParticles) {
        Level level = player.m_9236_();
        for (int i = 0; i < numParticles; ++i) {
            serverLevel.m_8767_(particle, player.m_20185_() + level.f_46441_.m_188500_() - 0.5, player.m_20186_() + 1.0, player.m_20189_() + level.f_46441_.m_188500_() - 0.5, 1, 0.0, 0.0, 0.0, 1.0);
        }
    }

    public static void displayClientMessage(Player player, String message) {
        player.m_5661_((Component)Component.m_237113_((String)message), true);
    }

    public static void sendSystemMessage(Player player, String message) {
        player.m_213846_((Component)Component.m_237113_((String)message));
    }

    public static void playSound(Level level, double x, double y, double z, SoundEvent soundEvent) {
        level.m_6263_(null, x, y, z, soundEvent, SoundSource.PLAYERS, 20.0f, 0.95f + SOUND_RNG.nextFloat() * 0.1f);
    }

    public static void playSound(Level level, Player player, SoundEvent soundEvent) {
        HomeboundUtil.playSound(level, player.m_20185_(), player.m_20186_(), player.m_20189_(), soundEvent);
    }

    public static String formatDimension(String dimString) {
        int indexOfColon = dimString.indexOf(":");
        if (indexOfColon != -1) {
            String dimName = dimString.substring(indexOfColon + 1);
            CharSequence[] dimWords = dimName.split("_");
            for (int i = 0; i < dimWords.length; ++i) {
                dimWords[i] = ((String)dimWords[i]).substring(0, 1).toUpperCase() + ((String)dimWords[i]).substring(1).toLowerCase();
            }
            return String.join((CharSequence)" ", dimWords);
        }
        return dimString;
    }

    public static String formatTime(int seconds) {
        if (seconds < 0) {
            return "Invalid input";
        }
        int hours = seconds / 3600;
        int remainingSeconds = seconds % 3600;
        int minutes = remainingSeconds / 60;
        int remainingSecs = remainingSeconds % 60;
        return String.format("%02d:%02d:%02d", hours, minutes, remainingSecs);
    }

    public static String timeFromTicks(float ticks, int decimalPlaces) {
        float ticks_to_seconds = 20.0f;
        float seconds_to_minutes = 60.0f;
        String affix = "s";
        float time = ticks / ticks_to_seconds;
        if (time > seconds_to_minutes) {
            time /= seconds_to_minutes;
            affix = "m";
        }
        return HomeboundUtil.stringTruncation(time, decimalPlaces) + affix;
    }

    public static String stringTruncation(double f, int decimalPlaces) {
        if (f == Math.floor(f)) {
            return Integer.toString((int)f);
        }
        double multiplier = Math.pow(10.0, decimalPlaces);
        double truncatedValue = Math.floor(f * multiplier) / multiplier;
        String result = Double.toString(truncatedValue);
        result = (result = result.replaceAll("0*$", "")).endsWith(".") ? result.substring(0, result.length() - 1) : result;
        return result;
    }
}

