/*
 * Decompiled with CFR 0.152.
 */
package com.mr_toad.gpu_booster.core;

import com.google.common.collect.Queues;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mr_toad.gpu_booster.core.config.DSAMode;
import com.mr_toad.gpu_booster.core.config.GBConfig;
import com.mr_toad.gpu_booster.util.FramebufferFixer;
import com.mr_toad.lib.api.client.utils.graphics.GraphicsException;
import com.mr_toad.lib.api.config.ToadConfig;
import com.mr_toad.lib.api.config.ToadConfigs;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.loader.api.FabricLoader;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GPUBooster
implements ClientModInitializer {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"GPUBooster");
    public static final String MODID = "gpu_booster";
    public static final GBConfig CONFIG = new GBConfig();
    public static final ConcurrentLinkedQueue<FramebufferFixer> FIXERS = Queues.newConcurrentLinkedQueue();
    public static boolean NV_BINDLESS;
    public static boolean ARB_BINDLESS;
    public static boolean GL45;
    public static boolean DSA;
    public static boolean BUFFER_STORAGE;
    public static boolean FRAMEBUFFER_DSA;

    public void onInitializeClient() {
        RenderSystem.recordRenderCall(() -> {
            GLCapabilities caps = GL.getCapabilities();
            GL45 = caps.OpenGL45;
            NV_BINDLESS = caps.GL_NV_bindless_texture;
            ARB_BINDLESS = caps.GL_ARB_bindless_texture;
            DSA = caps.GL_ARB_direct_state_access || GL45;
            BUFFER_STORAGE = caps.GL_ARB_buffer_storage || GL45;
            boolean bl = FRAMEBUFFER_DSA = caps.GL_ARB_framebuffer_no_attachments || caps.OpenGL43;
            if (CONFIG.hasDSA(DSAMode.VBO)) {
                // empty if block
            }
        });
        ToadConfigs.create((String)MODID, (ToadConfig)CONFIG);
        System.setProperty("joml.fastmath", ((Boolean)GPUBooster.CONFIG.fastMath.get()).toString());
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (CONFIG.hasDSA(DSAMode.VBO)) {
                // empty if block
            }
            try {
                boolean done = false;
                int counter = 0;
                while (!FIXERS.isEmpty() && counter++ < 20) {
                    FramebufferFixer fixer = FIXERS.poll();
                    if (fixer == null) continue;
                    if (!done) {
                        fixer.destroy();
                        done = true;
                    }
                    fixer.release();
                }
            }
            catch (Exception e) {
                throw new GraphicsException("Error during cleaning framebuffer", GraphicsException.In.GL, (Throwable)e);
            }
        });
    }

    public static boolean isVulkan() {
        return FabricLoader.getInstance().isModLoaded("vulkanmod");
    }
}

