/*
 * Decompiled with CFR 0.152.
 */
package com.mr_toad.gpu_booster.core.mixin;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mr_toad.gpu_booster.core.GPUBooster;
import com.mr_toad.gpu_booster.core.config.BindlessTextureType;
import com.mr_toad.gpu_booster.util.BindlessTextures;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GlStateManager.class})
public abstract class GlStateManagerMixin {
    @Inject(method={"_bindTexture"}, at={@At(value="HEAD")}, cancellable=true)
    private static void bindBindless(int texture, CallbackInfo ci) {
        long handle;
        BindlessTextureType type = GPUBooster.CONFIG.getBindlessTextureType();
        if (type != null && texture > 0 && (handle = BindlessTextures.getOrCreateBindless(type, texture)) != 0L) {
            BindlessTextures.bind(type, handle);
            ci.cancel();
        }
    }

    @Inject(method={"_deleteTexture"}, at={@At(value="HEAD")}, cancellable=true)
    private static void deleteBindless(int texture, CallbackInfo ci) {
        if (GPUBooster.CONFIG.getBindlessTextureType() != null && texture > 0 && BindlessTextures.containsHandleOf(texture)) {
            BindlessTextures.unbind(GPUBooster.CONFIG.getBindlessTextureType(), texture);
            ci.cancel();
        }
    }

    @Inject(method={"_deleteTextures"}, at={@At(value="HEAD")}, cancellable=true)
    private static void deleteBindless0(int[] textures, CallbackInfo ci) {
        if (GPUBooster.CONFIG.getBindlessTextureType() != null) {
            for (int texture : textures) {
                if (texture <= 0 || !BindlessTextures.containsHandleOf(texture)) continue;
                BindlessTextures.unbind(GPUBooster.CONFIG.getBindlessTextureType(), texture);
            }
            ci.cancel();
        }
    }
}

