/*
 * Decompiled with CFR 0.152.
 */
package com.mr_toad.gpu_booster.core.mixin;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mr_toad.gpu_booster.core.GPUBooster;
import com.mr_toad.gpu_booster.core.config.BindlessTextureType;
import com.mr_toad.gpu_booster.util.BindlessTextures;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={RenderSystem.class})
public abstract class RenderSystemMixin {
    @Inject(method={"_setShaderTexture(II)V"}, at={@At(value="HEAD")}, cancellable=true)
    private static void setBindlessTextures(int texture, int glId, CallbackInfo ci) {
        BindlessTextureType type = GPUBooster.CONFIG.getBindlessTextureType();
        if (type != null && texture < 0) {
            if (glId > 0) {
                BindlessTextures.getOrCreateBindless(type, glId);
            } else {
                int prevTex = RenderSystem.getShaderTexture((int)texture);
                if (prevTex > 0) {
                    BindlessTextures.unbind(type, prevTex);
                }
            }
            ci.cancel();
        }
    }
}

