/*
 * Decompiled with CFR 0.152.
 */
package com.mr_toad.gpu_booster.core.mixin.framebuffer;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.TextureUtil;
import com.mr_toad.gpu_booster.core.GPUBooster;
import com.mr_toad.gpu_booster.core.config.BindlessTextureType;
import com.mr_toad.gpu_booster.util.BindlessTextures;
import com.mr_toad.gpu_booster.util.FramebufferConnector;
import com.mr_toad.gpu_booster.util.gl.GBGL;
import net.minecraft.class_276;
import net.minecraft.class_5944;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_276.class})
public abstract class FramebufferMixin
implements FramebufferConnector {
    @Mutable
    @Shadow
    @Final
    public boolean field_1478;
    @Shadow
    protected int field_1475;
    @Shadow
    protected int field_1474;
    @Unique
    private int gb$depthRenderBuffer = -1;
    @Unique
    private long gb$bindlessHandle = 0L;
    @Unique
    private boolean gb$useDepth = false;
    @Unique
    private boolean gb$bindlessResident = false;
    @Unique
    private boolean gb$usedBindless = false;

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void blockReplace(boolean useDepth, CallbackInfo ci) {
        this.field_1478 = false;
        this.gb$useDepth = useDepth;
    }

    @Inject(method={"initFbo"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/platform/TextureUtil;generateTextureId()I", ordinal=0, shift=At.Shift.AFTER)})
    public void initRBO(int width, int height, boolean getError, CallbackInfo ci) {
        if (this.gb$useDepth) {
            if (GPUBooster.CONFIG.canCreateRenderbuffer()) {
                this.field_1474 = -1;
                this.gb$depthRenderBuffer = GBGL.createRBO();
                GBGL.bindRBO(this.gb$depthRenderBuffer);
                GBGL.storageRBO(width, height);
            } else {
                this.field_1474 = TextureUtil.generateTextureId();
                GlStateManager._bindTexture((int)this.field_1474);
                GlStateManager._texParameter((int)3553, (int)10241, (int)9728);
                GlStateManager._texParameter((int)3553, (int)10240, (int)9728);
                GlStateManager._texParameter((int)3553, (int)34892, (int)0);
                GlStateManager._texParameter((int)3553, (int)10242, (int)33071);
                GlStateManager._texParameter((int)3553, (int)10243, (int)33071);
                GlStateManager._texImage2D((int)3553, (int)0, (int)6402, (int)width, (int)height, (int)0, (int)6402, (int)5126, null);
            }
        }
    }

    @Inject(method={"initFbo"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/platform/GlStateManager;_glFramebufferTexture2D(IIIII)V", ordinal=0)})
    public void addToFBO(int width, int height, boolean getError, CallbackInfo ci) {
        if (this.gb$useDepth) {
            if (GPUBooster.CONFIG.canCreateRenderbuffer()) {
                GBGL.framebufferRBO(this.gb$depthRenderBuffer);
            } else {
                GlStateManager._glFramebufferTexture2D((int)36160, (int)36096, (int)3553, (int)this.field_1474, (int)0);
            }
        }
    }

    @Inject(method={"initFbo"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gl/Framebuffer;setTexFilter(IZ)V", shift=At.Shift.AFTER)})
    public void initBT(int width, int height, boolean getError, CallbackInfo ci) {
        GBGL.orRecord(this::initBindless);
    }

    @Redirect(method={"drawInternal"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gl/ShaderProgram;addSampler(Ljava/lang/String;Ljava/lang/Object;)V"))
    public void addBindless(class_5944 instance, String name, Object sampler) {
        this.gb$usedBindless = false;
        BindlessTextureType type = GPUBooster.CONFIG.getBindlessTextureType();
        if (this.gb$bindlessResident && type != null) {
            try {
                this.gb$usedBindless = BindlessTextures.handle(type, instance.method_1270(), "DiffuseSampler", this.gb$bindlessHandle);
            }
            catch (Throwable t) {
                GPUBooster.LOGGER.debug("Bindless set failed: {}", (Object)t.toString());
                this.gb$usedBindless = false;
            }
        }
        if (!this.gb$usedBindless) {
            instance.method_34583("DiffuseSampler", (Object)this.field_1475);
        }
    }

    @Inject(method={"drawInternal"}, at={@At(value="TAIL")})
    public void releaseUnit(int width, int height, boolean disableBlend, CallbackInfo ci) {
        if (this.gb$usedBindless) {
            GBGL.zeroUnit();
        }
    }

    @Inject(method={"delete"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gl/Framebuffer;endWrite()V")})
    public void deleteRBOBT(CallbackInfo ci) {
        if (this.gb$depthRenderBuffer > -1) {
            GBGL.unbindRBO();
            GBGL.deleteRBO(this.gb$depthRenderBuffer);
            this.gb$depthRenderBuffer = -1;
        }
        this.makeBindlessNonResident();
    }

    @Override
    public void initBindless() {
        BindlessTextureType type = GPUBooster.CONFIG.getBindlessTextureType();
        if (type != null && this.field_1475 > 0) {
            try {
                this.gb$bindlessHandle = BindlessTextures.getOrCreateBindless(type, this.field_1475);
                this.gb$bindlessResident = true;
                BindlessTextures.bind(type, this.gb$bindlessHandle);
            }
            catch (Throwable t) {
                this.gb$bindlessHandle = 0L;
                this.gb$bindlessResident = false;
            }
        } else {
            this.gb$bindlessHandle = 0L;
            this.gb$bindlessResident = false;
        }
    }

    @Override
    public void makeBindlessNonResident() {
        if (!this.gb$bindlessResident || this.gb$bindlessHandle == 0L) {
            return;
        }
        try {
            BindlessTextureType type = GPUBooster.CONFIG.getBindlessTextureType();
            if (type != null) {
                BindlessTextures.unbind(type, this.field_1475);
            }
        }
        catch (Throwable throwable) {
        }
        finally {
            this.gb$bindlessResident = false;
            this.gb$bindlessHandle = 0L;
        }
    }

    @Override
    public int getDepthRBO() {
        return this.gb$depthRenderBuffer;
    }

    @Override
    public void setDepthRBO(int rbo) {
        this.gb$depthRenderBuffer = rbo;
    }

    @Override
    public boolean isBindlessResident() {
        return this.gb$bindlessResident;
    }
}

