/*
 * Decompiled with CFR 0.152.
 */
package com.mr_toad.gpu_booster.core.mixin.framebuffer;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.TextureUtil;
import com.mr_toad.gpu_booster.core.GPUBooster;
import com.mr_toad.gpu_booster.core.config.BindlessTextureType;
import com.mr_toad.gpu_booster.core.config.DSAMode;
import com.mr_toad.gpu_booster.util.FramebufferConnector;
import com.mr_toad.gpu_booster.util.gl.GBGL;
import com.mr_toad.lib.api.client.utils.graphics.GraphicsException;
import com.mr_toad.lib.api.client.utils.graphics.gl.GLU;
import net.minecraft.class_276;
import net.minecraft.class_6364;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_6364.class})
public abstract class WindowFramebufferMixin
extends class_276 {
    @Shadow
    protected abstract class_6364.class_6366 method_36804(int var1, int var2);

    public WindowFramebufferMixin(boolean useDepth) {
        super(useDepth);
    }

    @Inject(method={"init"}, at={@At(value="HEAD")}, cancellable=true)
    public void init(int w, int h, CallbackInfo ci) {
        FramebufferConnector connector = (FramebufferConnector)((Object)this);
        if (connector.isBindlessResident()) {
            connector.makeBindlessNonResident();
        }
        class_6364.class_6366 size = this.method_36804(w, h);
        if (GPUBooster.CONFIG.hasDSA(DSAMode.FBO)) {
            this.field_1476 = GBGL.createFBO();
            this.initCommon(connector, size.field_33733, size.field_33734, true);
        } else {
            this.field_1476 = GlStateManager.glGenFramebuffers();
            this.initCommon(connector, size.field_33733, size.field_33734, false);
        }
        GlStateManager._bindTexture((int)0);
        this.field_1480 = size.field_33733;
        this.field_1477 = size.field_33734;
        this.field_1482 = size.field_33733;
        this.field_1481 = size.field_33734;
        if (!GPUBooster.CONFIG.hasDSA(DSAMode.FBO)) {
            GlStateManager._glBindFramebuffer((int)36160, (int)0);
        }
        int i = GBGL.checkNamedFramebuffer(this.field_1476);
        if (GLU.checkErrors((boolean)false)) {
            throw new GraphicsException("Crashed with '" + i + "'", GraphicsException.In.GL);
        }
        ci.cancel();
    }

    @Redirect(method={"findSuitableSize"}, at=@At(value="INVOKE", target="Lcom/mojang/blaze3d/platform/TextureUtil;generateTextureId()I", ordinal=1))
    public int generateOrSkip() {
        return GPUBooster.CONFIG.canCreateRenderbuffer() ? -1 : TextureUtil.generateTextureId();
    }

    @Unique
    private void initCommon(FramebufferConnector connector, int width, int height, boolean named) {
        GlStateManager._bindTexture((int)this.field_1475);
        GlStateManager._texParameter((int)3553, (int)10241, (int)9728);
        GlStateManager._texParameter((int)3553, (int)10240, (int)9728);
        GlStateManager._texParameter((int)3553, (int)10242, (int)33071);
        GlStateManager._texParameter((int)3553, (int)10243, (int)33071);
        BindlessTextureType type = GPUBooster.CONFIG.getBindlessTextureType();
        if (named) {
            GBGL.namedFramebufferTexture(this.field_1476, 36064, this.field_1475);
        } else {
            GlStateManager._glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)this.field_1475, (int)0);
        }
        if (GPUBooster.CONFIG.canCreateRenderbuffer()) {
            connector.setDepthRBO(GBGL.createRBO());
            if (named) {
                GBGL.storageNamedRBO(connector.getDepthRBO(), width, height);
                GBGL.framebufferNamedRBO(this.field_1476, connector.getDepthRBO());
            } else {
                GBGL.bindRBO(connector.getDepthRBO());
                GBGL.storageRBO(width, height);
                GBGL.framebufferRBO(connector.getDepthRBO());
            }
        } else {
            GlStateManager._bindTexture((int)this.field_1474);
            GlStateManager._texParameter((int)3553, (int)34892, (int)0);
            GlStateManager._texParameter((int)3553, (int)10241, (int)9728);
            GlStateManager._texParameter((int)3553, (int)10240, (int)9728);
            GlStateManager._texParameter((int)3553, (int)10242, (int)33071);
            GlStateManager._texParameter((int)3553, (int)10243, (int)33071);
            if (named) {
                GBGL.namedFramebufferTexture(this.field_1476, 36096, this.field_1474);
            } else {
                GlStateManager._glFramebufferTexture2D((int)36160, (int)36096, (int)3553, (int)this.field_1474, (int)0);
            }
        }
        if (type != null) {
            connector.initBindless();
        }
    }
}

