/*
 * Decompiled with CFR 0.152.
 */
package com.mr_toad.gpu_booster.core.mixin.math;

import com.mr_toad.gpu_booster.core.GPUBooster;
import net.minecraft.class_3532;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_3532.class})
public abstract class MathHelperMixin {
    @Inject(method={"floorMod(II)I"}, at={@At(value="HEAD")}, cancellable=true)
    private static void fastFM(int dividend, int divisor, CallbackInfoReturnable<Integer> cir) {
        if (((Boolean)GPUBooster.CONFIG.fastMath.get()).booleanValue()) {
            int m = dividend % divisor;
            if ((m ^ divisor) < 0) {
                m += divisor;
            }
            cir.setReturnValue((Object)m);
        }
    }

    @Inject(method={"floorMod(FF)F"}, at={@At(value="HEAD")}, cancellable=true)
    private static void fastFM(float dividend, float divisor, CallbackInfoReturnable<Float> cir) {
        if (((Boolean)GPUBooster.CONFIG.fastMath.get()).booleanValue()) {
            cir.setReturnValue((Object)Float.valueOf(dividend - (float)class_3532.method_15375((float)(dividend / divisor)) * divisor));
        }
    }

    @Inject(method={"floorMod(DD)D"}, at={@At(value="HEAD")}, cancellable=true)
    private static void fastFM(double dividend, double divisor, CallbackInfoReturnable<Double> cir) {
        if (((Boolean)GPUBooster.CONFIG.fastMath.get()).booleanValue()) {
            cir.setReturnValue((Object)(dividend - Math.floor(dividend / divisor) * divisor));
        }
    }

    @Inject(method={"ceilLog2"}, at={@At(value="HEAD")}, cancellable=true)
    private static void fastCL2(int value, CallbackInfoReturnable<Integer> cir) {
        if (((Boolean)GPUBooster.CONFIG.fastMath.get()).booleanValue()) {
            if (value <= 1) {
                cir.setReturnValue((Object)0);
            }
            cir.setReturnValue((Object)(32 - Integer.numberOfLeadingZeros(value - 1)));
        }
    }

    @Inject(method={"floorLog2"}, at={@At(value="HEAD")}, cancellable=true)
    private static void fastFL2(int value, CallbackInfoReturnable<Integer> cir) {
        if (((Boolean)GPUBooster.CONFIG.fastMath.get()).booleanValue()) {
            if (value <= 0) {
                throw new IllegalArgumentException("value must be > 0");
            }
            cir.setReturnValue((Object)(31 - Integer.numberOfLeadingZeros(value)));
        }
    }
}

