/*
 * Decompiled with CFR 0.152.
 */
package com.mr_toad.gpu_booster.util;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mr_toad.gpu_booster.core.GPUBooster;
import com.mr_toad.gpu_booster.core.config.BindlessTextureType;
import com.mr_toad.gpu_booster.util.gl.GBGL;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_5944;
import org.lwjgl.opengl.ARBBindlessTexture;
import org.lwjgl.opengl.NVBindlessTexture;

@Environment(value=EnvType.CLIENT)
public class BindlessTextures {
    private static final Int2ObjectMap<Resident> CACHE = new Int2ObjectOpenHashMap();

    public static boolean containsHandleOf(int textureId) {
        Resident e = (Resident)CACHE.get(textureId);
        return e != null && BindlessTextures.isBindlessAlive(e.id());
    }

    public static void upload(class_5944 program, int i) {
        BindlessTextures.handle(GPUBooster.CONFIG.getBindlessTextureType(), program.method_1270(), "Sampler" + i, i);
    }

    public static void bind(BindlessTextureType type, long res) {
        switch (type) {
            case ARB: {
                ARBBindlessTexture.glMakeTextureHandleResidentARB((long)res);
                break;
            }
            case NVIDIA: {
                NVBindlessTexture.glMakeTextureHandleResidentNV((long)res);
            }
        }
    }

    public static synchronized void unbind(BindlessTextureType type, int textureId) {
        RenderSystem.assertOnRenderThreadOrInit();
        Resident e = (Resident)CACHE.get(textureId);
        if (e == null) {
            return;
        }
        e.decreaseRefCount();
        if (e.refCount() <= 0) {
            long id = e.id();
            if (BindlessTextures.isBindlessAlive(id)) {
                BindlessTextures.unbind0(type, id);
            }
            CACHE.remove(textureId);
        }
    }

    public static synchronized void unbindAll(BindlessTextureType type) {
        RenderSystem.assertOnRenderThreadOrInit();
        for (Resident r : CACHE.values()) {
            try {
                if (!BindlessTextures.isBindlessAlive(r.id())) continue;
                BindlessTextures.unbind0(type, r.id());
            }
            catch (Throwable throwable) {}
        }
        CACHE.clear();
    }

    public static boolean handle(BindlessTextureType type, int program, String name, long resident) {
        int loc = GBGL.glGetUniformLocation(program, name);
        if (loc >= 0) {
            if (type == BindlessTextureType.ARB) {
                ARBBindlessTexture.glProgramUniformHandleui64ARB((int)program, (int)loc, (long)resident);
            } else {
                NVBindlessTexture.glProgramUniformHandleui64NV((int)program, (int)loc, (long)resident);
            }
            return true;
        }
        return false;
    }

    public static synchronized long getOrCreateBindless(BindlessTextureType type, int texture) {
        long handle;
        RenderSystem.assertOnRenderThreadOrInit();
        if (texture <= 0) {
            return 0L;
        }
        Resident entry = (Resident)CACHE.get(texture);
        if (entry != null) {
            if (BindlessTextures.isBindlessAlive(entry.id())) {
                entry.increaseRefCount();
                return entry.id();
            }
            CACHE.remove(texture);
        }
        if ((handle = BindlessTextures.createBindless0(type, texture)) == 0L) {
            return 0L;
        }
        CACHE.put(texture, (Object)new Resident(handle, 1));
        return handle;
    }

    public static boolean isBindlessAlive(long id) {
        RenderSystem.assertOnRenderThreadOrInit();
        return GPUBooster.CONFIG.bindlessTexture.get() == BindlessTextureType.NVIDIA ? NVBindlessTexture.glIsTextureHandleResidentNV((long)id) : ARBBindlessTexture.glIsTextureHandleResidentARB((long)id);
    }

    private static long createBindless0(BindlessTextureType type, int texture) {
        return switch (type) {
            case BindlessTextureType.ARB -> ARBBindlessTexture.glGetTextureHandleARB((int)texture);
            case BindlessTextureType.NVIDIA -> NVBindlessTexture.glGetTextureHandleNV((int)texture);
            default -> 0L;
        };
    }

    private static void unbind0(BindlessTextureType type, long res) {
        switch (type) {
            case ARB: {
                ARBBindlessTexture.glMakeTextureHandleNonResidentARB((long)res);
                break;
            }
            case NVIDIA: {
                NVBindlessTexture.glMakeTextureHandleNonResidentNV((long)res);
            }
        }
    }

    public static class Resident {
        private final long id;
        private int refCount;

        public Resident(long id, int refCount) {
            this.id = id;
            this.refCount = refCount;
        }

        public long id() {
            return this.id;
        }

        public int refCount() {
            return this.refCount;
        }

        public void increaseRefCount() {
            ++this.refCount;
        }

        public void decreaseRefCount() {
            --this.refCount;
        }
    }
}

