/*
 * Decompiled with CFR 0.152.
 */
package com.mr_toad.gpu_booster.util.gl;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mr_toad.gpu_booster.util.gl.VertexFormatCache;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.lang.ref.Cleaner;
import java.nio.ByteBuffer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_293;
import net.minecraft.class_4573;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;
import org.lwjgl.opengl.GL32;
import org.lwjgl.opengl.GL45;

@Environment(value=EnvType.CLIENT)
public class GBGL {
    public static final int MAX_DELETES = 8;
    public static final Cleaner FRAMEBUFFER_CLEANER = Cleaner.create();
    public static final ObjectList<UsedBuffer> TO_DELETE = new ObjectArrayList();
    public static ThreadLocal<class_293> CURRENT = ThreadLocal.withInitial(() -> null);

    public static void orRecord(class_4573 call) {
        if (RenderSystem.isOnRenderThreadOrInit()) {
            call.execute();
        } else {
            RenderSystem.recordRenderCall((class_4573)call);
        }
    }

    public static int getVAO(int vbo) {
        if (CURRENT.get() != null) {
            return VertexFormatCache.getOrCreateIDByFormat(vbo, CURRENT.get());
        }
        return GBGL.createVAO();
    }

    public static int createVAO() {
        return GL45.glCreateVertexArrays();
    }

    public static void addVAO2VBO(int vao, int binding, int vbo, long offset, int stride) {
        RenderSystem.assertOnRenderThread();
        GL45.glVertexArrayVertexBuffer((int)vao, (int)binding, (int)vbo, (long)offset, (int)stride);
    }

    public static void enableVAOAttrib(int vao, int index) {
        RenderSystem.assertOnRenderThread();
        GL45.glEnableVertexArrayAttrib((int)vao, (int)index);
    }

    public static void vaoFormat(int vao, int attrib, int size, int type, boolean norm, int relativeOffset) {
        RenderSystem.assertOnRenderThread();
        GL45.glVertexArrayAttribFormat((int)vao, (int)attrib, (int)size, (int)type, (boolean)norm, (int)relativeOffset);
    }

    public static void vaoFormat(int vao, int attrib, int size, int type, int relativeOffset) {
        RenderSystem.assertOnRenderThread();
        GL45.glVertexArrayAttribIFormat((int)vao, (int)attrib, (int)size, (int)type, (int)relativeOffset);
    }

    public static void bindVAOAttrib(int vao, int index, int bindIndex) {
        RenderSystem.assertOnRenderThread();
        GL45.glVertexArrayAttribBinding((int)vao, (int)index, (int)bindIndex);
    }

    public static int createVBO() {
        return GL45.glCreateBuffers();
    }

    public static void deleteVBO(int id) {
        RenderSystem.assertOnRenderThread();
        TO_DELETE.add((Object)new UsedBuffer(id, GL32.glFenceSync((int)37143, (int)0)));
    }

    public static void processDelete() {
        if (TO_DELETE.size() > 8) {
            for (int i = 0; i < 8; ++i) {
                UsedBuffer buffer = (UsedBuffer)TO_DELETE.get(i);
                if (buffer == null) continue;
                long sync = buffer.sync();
                int id = buffer.id();
                int res = GL32.glClientWaitSync((long)sync, (int)0, (long)0L);
                if (res != 37146 && res != 37148) continue;
                GL45.glDeleteBuffers((int)id);
                GL32.glDeleteSync((long)sync);
            }
        }
    }

    public static void namedBufferData(int id, ByteBuffer buffer, int usage) {
        RenderSystem.assertOnRenderThread();
        GL45.glNamedBufferData((int)id, (ByteBuffer)buffer, (int)usage);
    }

    public static void namedBufferData(int id, long size, int usage) {
        RenderSystem.assertOnRenderThread();
        GL45.glNamedBufferData((int)id, (long)size, (int)usage);
    }

    @Nullable
    public static ByteBuffer mapNamedBuffer(int vbo, long offset, long length, int flags) {
        RenderSystem.assertOnRenderThread();
        return GL45.glMapNamedBufferRange((int)vbo, (long)offset, (long)length, (int)flags);
    }

    public static void addEBO2VAO(int vao, int ebo) {
        RenderSystem.assertOnRenderThreadOrInit();
        GL45.glVertexArrayElementBuffer((int)vao, (int)ebo);
    }

    public static int createFBO() {
        RenderSystem.assertOnRenderThreadOrInit();
        return GL45.glCreateFramebuffers();
    }

    public static int checkNamedFramebuffer(int fbo) {
        RenderSystem.assertOnRenderThreadOrInit();
        return GL45.glCheckNamedFramebufferStatus((int)fbo, (int)36160);
    }

    public static void namedFramebufferTexture(int fbo, int attachment, int texture) {
        RenderSystem.assertOnRenderThreadOrInit();
        GL45.glNamedFramebufferTexture((int)fbo, (int)attachment, (int)texture, (int)0);
    }

    public static int createRBO() {
        RenderSystem.assertOnRenderThreadOrInit();
        return GL45.glCreateRenderbuffers();
    }

    public static void bindRBO(int id) {
        RenderSystem.assertOnRenderThreadOrInit();
        GL45.glBindRenderbuffer((int)36161, (int)id);
    }

    public static void unbindRBO() {
        RenderSystem.assertOnRenderThreadOrInit();
        GL45.glBindRenderbuffer((int)36161, (int)0);
    }

    public static void storageRBO(int w, int h) {
        RenderSystem.assertOnRenderThreadOrInit();
        GL45.glRenderbufferStorage((int)36161, (int)33190, (int)w, (int)h);
    }

    public static void storageNamedRBO(int rbo, int w, int h) {
        RenderSystem.assertOnRenderThreadOrInit();
        GL45.glNamedRenderbufferStorage((int)rbo, (int)33190, (int)w, (int)h);
    }

    public static void framebufferRBO(int rbo) {
        RenderSystem.assertOnRenderThreadOrInit();
        GL45.glFramebufferRenderbuffer((int)36160, (int)36096, (int)36161, (int)rbo);
    }

    public static void framebufferNamedRBO(int fbo, int rbo) {
        RenderSystem.assertOnRenderThreadOrInit();
        GL45.glNamedFramebufferRenderbuffer((int)fbo, (int)36096, (int)36161, (int)rbo);
    }

    public static void deleteRBO(int rbo) {
        RenderSystem.assertOnRenderThreadOrInit();
        GL30.glDeleteRenderbuffers((int)rbo);
    }

    public static void zeroUnit() {
        RenderSystem.assertOnRenderThreadOrInit();
        GL45.glBindTextureUnit((int)0, (int)0);
    }

    public static int glGetUniformLocation(int program, String name) {
        RenderSystem.assertOnRenderThread();
        return GL20.glGetUniformLocation((int)program, (CharSequence)name);
    }

    public record UsedBuffer(int id, long sync) {
    }
}

