/*
 * Decompiled with CFR 0.152.
 */
package com.mr_toad.gpu_booster.util.gl;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mr_toad.gpu_booster.core.GPUBooster;
import com.mr_toad.gpu_booster.util.gl.GBGL;
import java.nio.ByteBuffer;
import java.util.function.Function;
import java.util.function.IntConsumer;
import net.minecraft.class_156;
import net.minecraft.class_293;
import net.minecraft.class_3532;
import org.lwjgl.opengl.GL45;

public class NamedShapeIndexBuffer
extends RenderSystem.class_5590 {
    public static final Function<Integer, NamedShapeIndexBuffer> COMMON = class_156.method_34866(id -> new NamedShapeIndexBuffer((int)id, 1, 1, IntConsumer::accept));
    public static final Function<Integer, NamedShapeIndexBuffer> QUAD = class_156.method_34866(id -> new NamedShapeIndexBuffer((int)id, 4, 6, (indexConsumer, firstVertexIndex) -> {
        indexConsumer.accept(firstVertexIndex + 0);
        indexConsumer.accept(firstVertexIndex + 1);
        indexConsumer.accept(firstVertexIndex + 2);
        indexConsumer.accept(firstVertexIndex + 2);
        indexConsumer.accept(firstVertexIndex + 3);
        indexConsumer.accept(firstVertexIndex + 0);
    }));
    public static final Function<Integer, NamedShapeIndexBuffer> LINES = class_156.method_34866(id -> new NamedShapeIndexBuffer((int)id, 4, 6, (indexConsumer, firstVertexIndex) -> {
        indexConsumer.accept(firstVertexIndex + 0);
        indexConsumer.accept(firstVertexIndex + 1);
        indexConsumer.accept(firstVertexIndex + 2);
        indexConsumer.accept(firstVertexIndex + 3);
        indexConsumer.accept(firstVertexIndex + 2);
        indexConsumer.accept(firstVertexIndex + 1);
    }));
    private final int vaoID;

    public NamedShapeIndexBuffer(int vaoID, int vertexCountInShape, int vertexCountInTriangulated, RenderSystem.class_5590.class_5591 triangulator) {
        super(vertexCountInShape, vertexCountInTriangulated, triangulator);
        this.vaoID = vaoID;
    }

    public void method_43410(int requiredSize) {
        if (this.field_27335 == 0) {
            this.field_27335 = GBGL.createVBO();
        }
        this.growNamed(requiredSize);
    }

    private void growNamed(int requiredSize) {
        if (!this.method_43409(requiredSize)) {
            requiredSize = class_3532.method_28139((int)(requiredSize * 2), (int)this.field_27333);
            GPUBooster.LOGGER.debug("Growing IndexBuffer: Old limit {}, new limit {}.", (Object)this.field_27337, (Object)requiredSize);
            int i = requiredSize / this.field_27333;
            int j = i * this.field_27332;
            class_293.class_5595 indexType = class_293.class_5595.method_31972((int)j);
            int k = class_3532.method_28139((int)(requiredSize * indexType.field_27375), (int)4);
            GBGL.namedBufferData(this.field_27335, k, 35048);
            GBGL.addEBO2VAO(this.vaoID, this.field_27335);
            ByteBuffer byteBuffer = GBGL.mapNamedBuffer(this.field_27335, 0L, k, 42);
            if (byteBuffer == null) {
                throw new RuntimeException("Failed to map GL buffer");
            }
            this.field_27336 = indexType;
            it.unimi.dsi.fastutil.ints.IntConsumer intConsumer = this.method_31922(byteBuffer);
            for (int l = 0; l < requiredSize; l += this.field_27333) {
                this.field_27334.accept(intConsumer, l * this.field_27332 / this.field_27333);
            }
            GL45.glUnmapNamedBuffer((int)this.field_27335);
            this.field_27337 = requiredSize;
        }
    }
}

