/*
 * Decompiled with CFR 0.152.
 */
package com.mr_toad.gpu_booster.util.gl;

import com.google.common.collect.Queues;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mr_toad.gpu_booster.core.GPUBooster;
import com.mr_toad.gpu_booster.util.gl.GBGL;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Deque;
import net.minecraft.class_293;
import net.minecraft.class_296;

public class VertexFormatCache {
    private static final int VAO_POOL_SIZE = 512;
    private static final Object2IntMap<class_293> VAO_BY_FORMAT = new Object2IntOpenHashMap();
    private static final Deque<Integer> VAO_POOL = Queues.newArrayDeque();

    public static void preGenVAOs() {
        GPUBooster.LOGGER.warn("VAO pre-gen");
        for (int i = 0; i < 512; ++i) {
            VAO_POOL.add(GBGL.createVAO());
        }
    }

    public static int getOrCreateIDByFormat(int vbo, class_293 format) {
        RenderSystem.assertOnRenderThread();
        if (VAO_BY_FORMAT.containsKey((Object)format)) {
            return VAO_BY_FORMAT.getInt((Object)format);
        }
        Integer id = VAO_POOL.poll();
        if (id == null) {
            GPUBooster.LOGGER.warn("VAO not pre-generated! Native create");
            id = GBGL.createVAO();
        }
        GBGL.addVAO2VBO(id, 0, vbo, 0L, format.method_1362());
        VertexFormatCache.setupFormat(id, format);
        VAO_BY_FORMAT.put((Object)format, id.intValue());
        return id;
    }

    private static void setupFormat(int vaoID, class_293 format) {
        for (int j = 0; j < format.method_1357().size(); ++j) {
            class_296 element = (class_296)format.method_1357().get(j);
            int count = element.comp_2846();
            int type = element.comp_2844().method_1390();
            int offset = format.method_60835(element);
            boolean normalized = element.comp_2845() == class_296.class_298.field_1635 || element.comp_2845() == class_296.class_298.field_1632;
            GBGL.enableVAOAttrib(vaoID, j);
            if (element.comp_2845() == class_296.class_298.field_1636 && type != 5126) {
                GBGL.vaoFormat(vaoID, j, count, type, offset);
            } else {
                GBGL.vaoFormat(vaoID, j, count, type, normalized, offset);
            }
            GBGL.bindVAOAttrib(vaoID, j, 0);
        }
    }
}

