/*
 * Decompiled with CFR 0.152.
 */
package com.mr_toad.gpu_booster.util.math;

import com.mr_toad.lib.mtjava.math.MtMath;
import net.minecraft.class_3532;

public class GBFMath {
    public static final float SINGULAR = 1.0E-9f;
    public static final int MAGIC = 1597463007;
    public static final float NORMALIZE_EPSILON = 1.0E-12f;
    private static final int EXP_LUT_SIZE = 2048;
    private static final float EXP_LUT_SCALE = 256.0f;
    private static final float[] EXP_LUT = new float[2049];

    public static float invLen(float x, float y, float z) {
        return 1.0f / MtMath.length((float)x, (float)y, (float)z);
    }

    public static float invsqrt(float x) {
        if (Float.isNaN(x)) {
            return Float.NaN;
        }
        if (x == 0.0f) {
            return Float.POSITIVE_INFINITY;
        }
        if (x < 0.0f) {
            return Float.NaN;
        }
        if (Float.isInfinite(x)) {
            return 0.0f;
        }
        float y = Float.intBitsToFloat(1597463007 - (Float.floatToRawIntBits(x) >> 1));
        y *= 1.5f - 0.5f * x * y * y;
        y *= 1.5f - 0.5f * x * y * y;
        return y;
    }

    public static float cosFromSin(float sinHalf, float halfAngle) {
        if (Float.isNaN(sinHalf) || Float.isNaN(halfAngle)) {
            return Float.NaN;
        }
        float s = sinHalf;
        if (s > 1.0f) {
            s = 1.0f;
        } else if (s < -1.0f) {
            s = -1.0f;
        }
        float t = 1.0f - s * s;
        if (t <= 0.0f) {
            return Math.copySign(0.0f, halfAngle);
        }
        float cosAbs = t * GBFMath.invsqrt(t);
        return Math.copySign(cosAbs, class_3532.method_15362((float)halfAngle));
    }

    public static float fastLog(float x) {
        return (float)(Float.floatToRawIntBits(x) - 1064866805) * 9.015944E-5f;
    }

    public static float fastExp(float x) {
        if (x <= -8.0f) {
            return 0.0f;
        }
        if (x >= 8.0f) {
            return (float)Math.exp(8.0);
        }
        float fx = (x + 8.0f) * 256.0f;
        int ix = (int)fx;
        float t = fx - (float)ix;
        return EXP_LUT[ix] + t * (EXP_LUT[ix + 1] - EXP_LUT[ix]);
    }

    static {
        for (int i = 0; i <= 2048; ++i) {
            GBFMath.EXP_LUT[i] = (float)Math.exp((float)i / 256.0f - 8.0f);
        }
    }
}

