/*
 * Decompiled with CFR 0.152.
 */
package com.mr_toad.gpu_tape.client;

import com.google.common.collect.Queues;
import com.mr_toad.gpu_tape.client.util.CleanException;
import com.mr_toad.gpu_tape.client.util.FramebufferFixer;
import java.lang.ref.Cleaner;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Supplier;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.loader.api.FabricLoader;

public class GpuTape
implements ClientModInitializer {
    public static final ConcurrentLinkedQueue<FramebufferFixer> FIXERS = Queues.newConcurrentLinkedQueue();
    public static final Supplier<Cleaner> CLEANER = Cleaner::create;

    public void onInitializeClient() {
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            try {
                boolean done = false;
                int counter = 0;
                while (!FIXERS.isEmpty() && counter++ < 20) {
                    FramebufferFixer fixer = FIXERS.poll();
                    if (fixer == null) continue;
                    if (!done) {
                        fixer.destroy();
                        done = true;
                    }
                    fixer.release();
                }
            }
            catch (Exception e) {
                throw new CleanException("", e);
            }
        });
    }

    public static boolean isVulkan() {
        return FabricLoader.getInstance().isModLoaded("vulkanmod");
    }
}

