/*
 * Decompiled with CFR 0.152.
 */
package com.winss.dustlab;

import com.winss.dustlab.commands.DustLabCommand;
import com.winss.dustlab.config.DustLabConfig;
import com.winss.dustlab.managers.ParticleModelManager;
import com.winss.dustlab.media.MediaProcessor;
import com.winss.dustlab.monitoring.PerformanceMonitor;
import org.bukkit.command.CommandExecutor;
import org.bukkit.plugin.java.JavaPlugin;

public final class DustLab
extends JavaPlugin {
    private ParticleModelManager particleModelManager;
    private DustLabConfig dustLabConfig;
    private PerformanceMonitor performanceMonitor;

    public void onEnable() {
        this.getLogger().info("Starting up...");
        this.dustLabConfig = new DustLabConfig(this);
        this.particleModelManager = new ParticleModelManager(this, this.dustLabConfig);
        this.performanceMonitor = new PerformanceMonitor(this);
        this.performanceMonitor.start();
        this.getCommand("dustlab").setExecutor((CommandExecutor)new DustLabCommand(this));
        this.particleModelManager.loadModels();
        this.getLogger().info("Enabled.");
    }

    public void onDisable() {
        this.getLogger().info("Shutting down...");
        if (this.particleModelManager != null) {
            this.particleModelManager.cleanup();
        }
        if (this.performanceMonitor != null) {
            this.performanceMonitor.stop();
        }
        MediaProcessor.shutdown();
        this.getLogger().info("Disabled.");
    }

    public ParticleModelManager getParticleModelManager() {
        return this.particleModelManager;
    }

    public DustLabConfig getDustLabConfig() {
        return this.dustLabConfig;
    }

    public PerformanceMonitor getPerformanceMonitor() {
        return this.performanceMonitor;
    }
}

