/*
 * Decompiled with CFR 0.152.
 */
package com.winss.dustlab.commands;

import com.winss.dustlab.DustLab;
import com.winss.dustlab.effects.ParticleEffects;
import com.winss.dustlab.managers.ParticleModelManager;
import com.winss.dustlab.media.AnimatedModel;
import com.winss.dustlab.media.FrameData;
import com.winss.dustlab.media.MediaProcessor;
import com.winss.dustlab.models.ParticleData;
import com.winss.dustlab.models.ParticleModel;
import com.winss.dustlab.monitoring.PerformanceMonitor;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.time.Instant;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import javax.imageio.ImageIO;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class DustLabCommand
implements CommandExecutor,
TabCompleter {
    private final DustLab plugin;
    private static final UUID CONSOLE_UUID = new UUID(0L, 0L);
    private final Map<UUID, Deque<MediaRequest>> mediaQueues = new ConcurrentHashMap<UUID, Deque<MediaRequest>>();
    private final Set<UUID> mediaActive = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<String> mediaNamesRunningOrQueued = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Map<UUID, PendingDeletion> pendingDeletions = new ConcurrentHashMap<UUID, PendingDeletion>();

    public DustLabCommand(DustLab plugin) {
        this.plugin = plugin;
    }

    private int parseLifetime(String lifetimeArg) {
        if (lifetimeArg == null || lifetimeArg.trim().isEmpty()) {
            return 0;
        }
        if ((lifetimeArg = lifetimeArg.trim().toLowerCase()).equals("infinite") || lifetimeArg.equals("loop")) {
            return -1;
        }
        if (lifetimeArg.equals("one-time") || lifetimeArg.equals("onetime")) {
            return 0;
        }
        if (lifetimeArg.endsWith("s")) {
            try {
                String numberPart = lifetimeArg.substring(0, lifetimeArg.length() - 1);
                int seconds = Integer.parseInt(numberPart);
                return Math.max(0, seconds);
            }
            catch (NumberFormatException e) {
                return -2;
            }
        }
        if (lifetimeArg.endsWith("m")) {
            try {
                String numberPart = lifetimeArg.substring(0, lifetimeArg.length() - 1);
                int minutes = Integer.parseInt(numberPart);
                return Math.max(0, minutes * 60);
            }
            catch (NumberFormatException e) {
                return -2;
            }
        }
        if (lifetimeArg.endsWith("h")) {
            try {
                String numberPart = lifetimeArg.substring(0, lifetimeArg.length() - 1);
                int hours = Integer.parseInt(numberPart);
                return Math.max(0, hours * 3600);
            }
            catch (NumberFormatException e) {
                return -2;
            }
        }
        try {
            int seconds = Integer.parseInt(lifetimeArg);
            return Math.max(0, seconds);
        }
        catch (NumberFormatException e) {
            return -2;
        }
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String subCommand;
        if (args.length == 0) {
            this.sendHelp(sender);
            return true;
        }
        switch (subCommand = args[0].toLowerCase()) {
            case "load": {
                return this.handleLoad(sender, args);
            }
            case "loadfx": {
                return this.handleLoadWithEffects(sender, args);
            }
            case "playerload": {
                return this.handlePlayerLoad(sender, args);
            }
            case "create": {
                return this.handleCreate(sender, args);
            }
            case "delete": {
                return this.handleDelete(sender, args);
            }
            case "confirm": {
                return this.handleConfirm(sender, args);
            }
            case "unload": {
                return this.handleUnload(sender, args);
            }
            case "move": {
                return this.handleMove(sender, args);
            }
            case "list": {
                return this.handleList(sender);
            }
            case "active": {
                return this.handleActive(sender);
            }
            case "info": {
                return this.handleInfo(sender, args);
            }
            case "reload": {
                return this.handleReload(sender);
            }
            case "stats": {
                return this.handleStats(sender);
            }
            case "help": {
                return this.handleHelp(sender, args);
            }
            case "website": {
                return this.handleWebsite(sender);
            }
        }
        this.sendHelp(sender);
        return true;
    }

    private boolean handleLoad(CommandSender sender, String[] args) {
        boolean hasCoordinates;
        if (!sender.hasPermission("dustlab.load")) {
            sender.sendMessage("\u00a79DustLab \u00a7c\u00bb \u00a77You don't have permission to load particle models (dustlab.load).");
            return true;
        }
        if (args.length < 2) {
            sender.sendMessage("\u00a79DustLab \u00a7c\u00bb \u00a77Usage: /dustlab load <model_name> [x y z] [lifetime] [force/normal]");
            sender.sendMessage("\u00a79DustLab \u00a77\u00bb \u00a77Coords: Optional coordinates (if not provided, uses your location)");
            sender.sendMessage("\u00a79DustLab \u00a77\u00bb \u00a77Lifetime: \u00a7b<number>\u00a77[\u00a7bs\u00a77|\u00a7bm\u00a77|\u00a7bh\u00a77], \u00a7binfinite\u00a77, or \u00a7bone-time\u00a77 (e.g., 30s, 5m, 2h)");
            sender.sendMessage("\u00a79DustLab \u00a77\u00bb \u00a77Persistence: Automatic for long-running effects (>1 minute) and infinite loops");
            sender.sendMessage("\u00a79DustLab \u00a77\u00bb \u00a77Force: \u00a7bforce\u00a77 or \u00a7bnormal\u00a77 (force bypasses view permissions)");
            return true;
        }
        boolean bl = hasCoordinates = args.length >= 5;
        if (hasCoordinates && args.length >= 5) {
            try {
                Double.parseDouble(args[2]);
                Double.parseDouble(args[3]);
                Double.parseDouble(args[4]);
            }
            catch (NumberFormatException e) {
                hasCoordinates = false;
            }
        }
        if (!(sender instanceof Player) && !hasCoordinates) {
            sender.sendMessage("\u00a79DustLab \u00a74\u00bb \u00a77Console must provide coordinates: /dustlab load <model_name> <x> <y> <z> [lifetime] [force/normal]");
            return true;
        }
        Player player = sender instanceof Player ? (Player)sender : null;
        String modelName = args[1];
        if (!this.plugin.getParticleModelManager().hasModel(modelName)) {
            if (this.plugin.getParticleModelManager().isModelLoading(modelName)) {
                this.plugin.getParticleModelManager().subscribeToLoading(modelName, sender);
                int pct = this.plugin.getParticleModelManager().getModelLoadingPercent(modelName);
                sender.sendMessage("\u00a79DustLab \u00a7e\u00bb \u00a77Model '\u00a7f" + modelName + "\u00a77' is still loading \u00a7e" + pct + "%\u00a77. You'll be notified when it's ready. Try again after completion.");
                return true;
            }
            sender.sendMessage("\u00a79DustLab \u00a74\u00bb \u00a77Model '\u00a7f" + modelName + "\u00a77' not found.");
            return true;
        }
        Location location = null;
        location = player != null ? player.getLocation() : new Location((World)this.plugin.getServer().getWorlds().get(0), 0.0, 100.0, 0.0);
        int lifetimeSeconds = 0;
        boolean force = false;
        int argIndex = 2;
        if (args.length >= 5 && argIndex + 2 < args.length) {
            try {
                double x = Double.parseDouble(args[argIndex]);
                double y = Double.parseDouble(args[argIndex + 1]);
                double z = Double.parseDouble(args[argIndex + 2]);
                location = new Location(player != null ? player.getWorld() : (World)this.plugin.getServer().getWorlds().get(0), x, y, z);
                argIndex += 3;
            }
            catch (NumberFormatException x) {
                // empty catch block
            }
        }
        if (argIndex < args.length) {
            String lifetimeArg = args[argIndex];
            int parsedLifetime = this.parseLifetime(lifetimeArg);
            if (parsedLifetime == -2) {
                sender.sendMessage("\u00a79DustLab \u00a7c\u00bb \u00a77Invalid lifetime '\u00a7f" + lifetimeArg + "\u00a77'. Use format: 30s, 5m, 2h, infinite, or one-time");
                return true;
            }
            if (parsedLifetime >= -1) {
                lifetimeSeconds = parsedLifetime;
                ++argIndex;
            }
        }
        if (argIndex < args.length) {
            String arg = args[argIndex];
            if (arg.equalsIgnoreCase("force")) {
                force = true;
            } else if (arg.equalsIgnoreCase("normal")) {
                force = false;
            }
        }
        if (!this.plugin.getParticleModelManager().hasViewPermission(sender, modelName, force)) {
            if (!sender.hasPermission("dustlab.view")) {
                sender.sendMessage("\u00a79DustLab \u00a7c\u00bb \u00a77You don't have permission to view DustLab particles (dustlab.view).");
            } else {
                sender.sendMessage("\u00a79DustLab \u00a7c\u00bb \u00a77You don't have permission to view model '\u00a7f" + modelName + "\u00a77' (dustlab.view." + modelName.toLowerCase() + ").");
                sender.sendMessage("\u00a79DustLab \u00a77\u00bb \u00a77Add \u00a7bforce\u00a77 to bypass permissions if you have dustlab.force permission.");
            }
            return true;
        }
        int effectId = this.plugin.getParticleModelManager().playModel(modelName, location, lifetimeSeconds);
        if (effectId == -1) {
            sender.sendMessage("\u00a79DustLab \u00a7c\u00bb \u00a77Failed to load model '\u00a7f" + modelName + "\u00a77'.");
            return true;
        }
        String lifetimeText = this.getLifetimeDisplayText(lifetimeSeconds);
        String forceText = force ? " \u00a7c(forced)" : "";
        sender.sendMessage("\u00a79DustLab \u00a7b\u00bb \u00a77Loaded model '\u00a7f" + modelName + "\u00a77' at " + String.format("\u00a7b%.1f\u00a77, \u00a7b%.1f\u00a77, \u00a7b%.1f", location.getX(), location.getY(), location.getZ()) + lifetimeText + forceText + " \u00a77(ID: \u00a7f#" + effectId + "\u00a77)");
        return true;
    }

    private String getLifetimeDisplayText(int lifetimeSeconds) {
        if (lifetimeSeconds == -1) {
            return " \u00a7b(infinite)";
        }
        if (lifetimeSeconds == 0) {
            return " \u00a77(one-time)";
        }
        return " \u00a7e(" + lifetimeSeconds + "s)";
    }

    private boolean isValidEffectType(String effectType) {
        return Arrays.asList("rotate", "rotate-x", "rotate-y", "rotate-z", "rotate-xy", "rotate-xz", "rotate-yz", "rotate-xyz", "oscillate", "pulse", "bounce", "flow", "swirl", "wave", "orbit", "spiral").contains(effectType);
    }

    private boolean handleLoadWithEffects(CommandSender sender, String[] args) {
        int effectId;
        boolean hasCoordinates;
        if (!sender.hasPermission("dustlab.loadfx")) {
            sender.sendMessage("\u00a79DustLab \u00a7c\u00bb \u00a77You don't have permission to load particle models with effects (dustlab.loadfx).");
            return true;
        }
        if (args.length < 3) {
            sender.sendMessage("\u00a79DustLab \u00a7c\u00bb \u00a77Usage: /dustlab loadfx <model_name> <effect_type> [x y z] [lifetime] [speed] [force/normal]");
            sender.sendMessage("\u00a79DustLab \u00a77\u00bb \u00a77Effects: \u00a7brotate\u00a77, \u00a7brotate-x\u00a77, \u00a7brotate-y\u00a77, \u00a7brotate-z\u00a77, \u00a7brotate-xy\u00a77, \u00a7brotate-xyz\u00a77");
            sender.sendMessage("\u00a79DustLab \u00a77\u00bb \u00a77Effects: \u00a7boscillate\u00a77, \u00a7bpulse\u00a77, \u00a7bbounce\u00a77, \u00a7bflow\u00a77, \u00a7bswirl\u00a77, \u00a7bwave\u00a77, \u00a7borbit\u00a77, \u00a7bspiral\u00a77");
            sender.sendMessage("\u00a79DustLab \u00a77\u00bb \u00a77Coords: Optional coordinates (if not provided, uses your location)");
            sender.sendMessage("\u00a79DustLab \u00a77\u00bb \u00a77Lifetime: \u00a7b<number>\u00a77[\u00a7bs\u00a77|\u00a7bm\u00a77|\u00a7bh\u00a77], \u00a7binfinite\u00a77, or \u00a7bone-time\u00a77 (e.g., 30s, 5m, 2h)");
            sender.sendMessage("\u00a79DustLab \u00a77\u00bb \u00a77Persistence: Automatic for long-running effects (>1 minute) and infinite loops");
            sender.sendMessage("\u00a79DustLab \u00a77\u00bb \u00a77Speed: \u00a7b<number>\u00a77 (effect speed multiplier)");
            sender.sendMessage("\u00a79DustLab \u00a77\u00bb \u00a77Force: \u00a7bforce\u00a77 or \u00a7bnormal\u00a77 (force bypasses view permissions)");
            return true;
        }
        boolean bl = hasCoordinates = args.length >= 6;
        if (hasCoordinates && args.length >= 6) {
            try {
                Double.parseDouble(args[3]);
                Double.parseDouble(args[4]);
                Double.parseDouble(args[5]);
            }
            catch (NumberFormatException e) {
                hasCoordinates = false;
            }
        }
        if (!(sender instanceof Player) && !hasCoordinates) {
            sender.sendMessage("\u00a79DustLab \u00a7c\u00bb \u00a77Console must provide coordinates: /dustlab loadfx <model_name> <effect_type> <x> <y> <z> [lifetime] [speed] [force/normal]");
            return true;
        }
        Player player = sender instanceof Player ? (Player)sender : null;
        String modelName = args[1];
        String effectType = args[2].toLowerCase();
        if (!this.plugin.getParticleModelManager().hasModel(modelName)) {
            sender.sendMessage("\u00a79DustLab \u00a7c\u00bb \u00a77Model '\u00a7f" + modelName + "\u00a77' not found.");
            return true;
        }
        if (!this.isValidEffectType(effectType)) {
            sender.sendMessage("\u00a79DustLab \u00a7c\u00bb \u00a77Invalid effect type '\u00a7f" + effectType + "\u00a77'. Valid types:");
            sender.sendMessage("\u00a79DustLab \u00a77\u00bb \u00a7brotate\u00a77, \u00a7brotate-x\u00a77, \u00a7brotate-y\u00a77, \u00a7brotate-z\u00a77, \u00a7brotate-xy\u00a77, \u00a7brotate-xyz\u00a77");
            sender.sendMessage("\u00a79DustLab \u00a77\u00bb \u00a7boscillate\u00a77, \u00a7bpulse\u00a77, \u00a7bbounce\u00a77, \u00a7bflow\u00a77, \u00a7bswirl\u00a77, \u00a7bwave\u00a77, \u00a7borbit\u00a77, \u00a7bspiral\u00a77");
            return true;
        }
        Location location = null;
        location = player != null ? player.getLocation() : new Location((World)this.plugin.getServer().getWorlds().get(0), 0.0, 100.0, 0.0);
        int lifetimeSeconds = 0;
        double speed = 1.0;
        boolean force = false;
        int argIndex = 3;
        if (args.length >= 6 && argIndex + 2 < args.length) {
            try {
                double x = Double.parseDouble(args[argIndex]);
                double y = Double.parseDouble(args[argIndex + 1]);
                double z = Double.parseDouble(args[argIndex + 2]);
                location = new Location(player != null ? player.getWorld() : (World)this.plugin.getServer().getWorlds().get(0), x, y, z);
                argIndex += 3;
            }
            catch (NumberFormatException x) {
                // empty catch block
            }
        }
        if (argIndex < args.length) {
            String lifetimeArg = args[argIndex];
            int parsedLifetime = this.parseLifetime(lifetimeArg);
            if (parsedLifetime == -2) {
                sender.sendMessage("\u00a79DustLab \u00a7c\u00bb \u00a77Invalid lifetime '\u00a7f" + lifetimeArg + "\u00a77'. Use format: 30s, 5m, 2h, infinite, or one-time");
                return true;
            }
            if (parsedLifetime >= -1) {
                lifetimeSeconds = parsedLifetime;
                ++argIndex;
            }
        }
        if (argIndex < args.length) {
            try {
                double speedValue = Double.parseDouble(args[argIndex]);
                if (speedValue >= 0.1 && speedValue <= 10.0) {
                    speed = speedValue;
                    ++argIndex;
                }
            }
            catch (NumberFormatException speedValue) {
                // empty catch block
            }
        }
        if (argIndex < args.length) {
            String forceArg = args[argIndex];
            if (forceArg.equalsIgnoreCase("force")) {
                force = true;
            } else if (forceArg.equalsIgnoreCase("normal")) {
                force = false;
            }
        }
        if (!this.plugin.getParticleModelManager().hasViewPermission(sender, modelName, force)) {
            if (!sender.hasPermission("dustlab.view")) {
                sender.sendMessage("\u00a79DustLab \u00a7c\u00bb \u00a77You don't have permission to view DustLab particles (dustlab.view).");
            } else {
                sender.sendMessage("\u00a79DustLab \u00a7c\u00bb \u00a77You don't have permission to view model '\u00a7f" + modelName + "\u00a77' (dustlab.view." + modelName.toLowerCase() + ").");
                sender.sendMessage("\u00a79DustLab \u00a77\u00bb \u00a77Add \u00a7bforce\u00a77 to bypass permissions if you have dustlab.force permission.");
            }
            return true;
        }
        ParticleEffects.EffectSettings effects = null;
        effects = ParticleEffects.EffectSettings.parseEffect(effectType);
        if (effects == null) {
            sender.sendMessage("\u00a79DustLab \u00a7c\u00bb \u00a77Invalid effect type '\u00a7f" + effectType + "\u00a77'. Valid types:");
            sender.sendMessage("\u00a79DustLab \u00a77\u00bb \u00a7brotate\u00a77, \u00a7brotate-x\u00a77, \u00a7brotate-y\u00a77, \u00a7brotate-z\u00a77, \u00a7brotate-xy\u00a77, \u00a7brotate-xyz\u00a77");
            sender.sendMessage("\u00a79DustLab \u00a77\u00bb \u00a7boscillate\u00a77, \u00a7bpulse\u00a77, \u00a7bbounce\u00a77, \u00a7bflow\u00a77, \u00a7bswirl\u00a77, \u00a7bwave\u00a77, \u00a7borbit\u00a77, \u00a7bspiral\u00a77");
            return true;
        }
        if (speed != 1.0) {
            effects.rotationSpeed *= speed;
            effects.oscillationSpeed *= speed;
            effects.pulseSpeed *= speed;
            effects.bounceSpeed *= speed;
            effects.flowSpeed *= speed;
            effects.swirlSpeed *= speed;
            effects.waveSpeed *= speed;
            effects.orbitSpeed *= speed;
            effects.spiralSpeed *= speed;
        }
        if ((effectId = this.plugin.getParticleModelManager().playModelWithEffects(modelName, location, lifetimeSeconds, effects)) == -1) {
            sender.sendMessage("\u00a79DustLab \u00a7c\u00bb \u00a77Failed to load model '\u00a7f" + modelName + "\u00a77' with effects.");
            return true;
        }
        String lifetimeText = this.getLifetimeDisplayText(lifetimeSeconds);
        String forceText = force ? " \u00a7c(forced)" : "";
        String speedText = speed != 1.0 ? " \u00a7d(speed: " + String.format("%.1f", speed) + "x)" : "";
        sender.sendMessage("\u00a79DustLab \u00a7b\u00bb \u00a77Loaded model '\u00a7f" + modelName + "\u00a77' with \u00a7b" + effectType + "\u00a77 effect at " + String.format("\u00a7b%.1f\u00a77, \u00a7b%.1f\u00a77, \u00a7b%.1f", location.getX(), location.getY(), location.getZ()) + lifetimeText + forceText + speedText + " \u00a77(ID: \u00a7f#" + effectId + "\u00a77)");
        return true;
    }

    private boolean handlePlayerLoad(CommandSender sender, String[] args) {
        if (!sender.hasPermission("dustlab.playerload")) {
            sender.sendMessage("\u00a79DustLab \u00a7c\u00bb \u00a77You don't have permission to attach models to players (dustlab.playerload).");
            return true;
        }
        if (args.length < 5) {
            sender.sendMessage("\u00a79DustLab \u00a7c\u00bb \u00a77Usage: /dustlab playerload <player> <model_name> <lifetime> <effect/none> [whenstill/always] [force/normal]");
            sender.sendMessage("\u00a79DustLab \u00a77\u00bb \u00a77Player: Target player name");
            sender.sendMessage("\u00a79DustLab \u00a77\u00bb \u00a77Model: Name of the particle model to attach");
            sender.sendMessage("\u00a79DustLab \u00a77\u00bb \u00a77Lifetime: \u00a7b<number>\u00a77[\u00a7bs\u00a77|\u00a7bm\u00a77|\u00a7bh\u00a77], \u00a7binfinite\u00a77, or \u00a7bone-time\u00a77 (e.g., 30s, 5m, 2h)");
            sender.sendMessage("\u00a79DustLab \u00a77\u00bb \u00a77Effect: \u00a7brotate\u00a77, \u00a7brotate-x\u00a77, \u00a7brotate-y\u00a77, \u00a7brotate-z\u00a77, \u00a7brotate-xy\u00a77, \u00a7brotate-xyz\u00a77");
            sender.sendMessage("\u00a79DustLab \u00a77\u00bb \u00a77Effect: \u00a7boscillate\u00a77, \u00a7bpulse\u00a77, \u00a7bbounce\u00a77, \u00a7bflow\u00a77, \u00a7bswirl\u00a77, \u00a7bwave\u00a77, \u00a7borbit\u00a77, \u00a7bspiral\u00a77, or \u00a7bnone\u00a77");
            sender.sendMessage("\u00a79DustLab \u00a77\u00bb \u00a77Movement: \u00a7bwhenstill\u00a77 (only when not moving) or \u00a7balways\u00a77 (always visible)");
            sender.sendMessage("\u00a79DustLab \u00a77\u00bb \u00a77Force: \u00a7bforce\u00a77 or \u00a7bnormal\u00a77 (force bypasses view permissions)");
            return true;
        }
        String targetPlayerName = args[1];
        String modelName = args[2];
        String lifetimeArg = args[3];
        String effectArg = args[4];
        Player targetPlayer = this.plugin.getServer().getPlayer(targetPlayerName);
        if (targetPlayer == null || !targetPlayer.isOnline()) {
            sender.sendMessage("\u00a79DustLab \u00a7c\u00bb \u00a77Player '\u00a7f" + targetPlayerName + "\u00a77' not found or not online.");
            return true;
        }
        if (!this.plugin.getParticleModelManager().hasModel(modelName)) {
            sender.sendMessage("\u00a79DustLab \u00a7c\u00bb \u00a77Model '\u00a7f" + modelName + "\u00a77' not found.");
            return true;
        }
        int lifetimeSeconds = this.parseLifetime(lifetimeArg);
        if (lifetimeSeconds == -2) {
            sender.sendMessage("\u00a79DustLab \u00a7c\u00bb \u00a77Invalid lifetime '\u00a7f" + lifetimeArg + "\u00a77'. Use format: 30s, 5m, 2h, infinite, or one-time");
            return true;
        }
        ParticleEffects.EffectSettings effects = null;
        if (!effectArg.equalsIgnoreCase("none") && (effects = ParticleEffects.EffectSettings.parseEffect(effectArg)) == null) {
            sender.sendMessage("\u00a79DustLab \u00a7c\u00bb \u00a77Invalid effect '\u00a7f" + effectArg + "\u00a77'. Valid effects:");
            sender.sendMessage("\u00a79DustLab \u00a77\u00bb \u00a7brotate\u00a77, \u00a7brotate-x\u00a77, \u00a7brotate-y\u00a77, \u00a7brotate-z\u00a77, \u00a7brotate-xy\u00a77, \u00a7brotate-xyz\u00a77");
            sender.sendMessage("\u00a79DustLab \u00a77\u00bb \u00a7boscillate\u00a77, \u00a7bpulse\u00a77, \u00a7bbounce\u00a77, \u00a7bflow\u00a77, \u00a7bswirl\u00a77");
            sender.sendMessage("\u00a79DustLab \u00a77\u00bb \u00a7bwave\u00a77, \u00a7borbit\u00a77, \u00a7bspiral\u00a77, \u00a7bnone\u00a77");
            return true;
        }
        boolean onlyWhenStill = false;
        boolean force = false;
        if (args.length > 5) {
            String movementArg = args[5].toLowerCase();
            if (movementArg.equals("whenstill")) {
                onlyWhenStill = true;
            } else if (movementArg.equals("always")) {
                onlyWhenStill = false;
            }
        }
        if (args.length > 6) {
            String forceArg = args[6].toLowerCase();
            if (forceArg.equals("force")) {
                force = true;
            } else if (forceArg.equals("normal")) {
                force = false;
            }
        }
        if (args.length > 5 && !args[5].equalsIgnoreCase("whenstill") && !args[5].equalsIgnoreCase("always")) {
            String possibleForceArg = args[5].toLowerCase();
            if (possibleForceArg.equals("force")) {
                force = true;
            } else if (possibleForceArg.equals("normal")) {
                force = false;
            }
        }
        if (!this.plugin.getParticleModelManager().hasViewPermission(sender, modelName, force)) {
            if (!sender.hasPermission("dustlab.view")) {
                sender.sendMessage("\u00a79DustLab \u00a7c\u00bb \u00a77You don't have permission to view DustLab particles (dustlab.view).");
            } else {
                sender.sendMessage("\u00a79DustLab \u00a7c\u00bb \u00a77You don't have permission to view model '\u00a7f" + modelName + "\u00a77' (dustlab.view." + modelName.toLowerCase() + ").");
                sender.sendMessage("\u00a79DustLab \u00a77\u00bb \u00a77Add \u00a7bforce\u00a77 to bypass permissions if you have dustlab.force permission.");
            }
            return true;
        }
        int effectId = this.plugin.getParticleModelManager().playModelOnPlayer(modelName, targetPlayer, lifetimeSeconds, effects, onlyWhenStill, force);
        if (effectId == -1) {
            sender.sendMessage("\u00a79DustLab \u00a7c\u00bb \u00a77Failed to attach model '\u00a7f" + modelName + "\u00a77' to player '\u00a7f" + targetPlayerName + "\u00a77'.");
            return true;
        }
        String lifetimeText = this.getLifetimeDisplayText(lifetimeSeconds);
        String stillText = onlyWhenStill ? " \u00a7e(only when still)" : " \u00a7a(always visible)";
        String forceText = force ? " \u00a7c(forced)" : "";
        Object effectText = effects != null ? " \u00a7d(effect: " + effectArg + ")" : "";
        sender.sendMessage("\u00a79DustLab \u00a7b\u00bb \u00a77Attached model '\u00a7f" + modelName + "\u00a77' to player '\u00a7f" + targetPlayerName + "\u00a77'" + lifetimeText + (String)effectText + stillText + forceText + " \u00a77(ID: \u00a7f#" + effectId + "\u00a77)");
        if (!sender.equals(targetPlayer)) {
            String notifyLifetime = lifetimeSeconds == -1 ? "infinite" : (lifetimeSeconds == 0 ? "one-time" : lifetimeSeconds + " seconds");
            Object notifyEffect = effects != null ? " with " + effectArg + " effect" : "";
            targetPlayer.sendMessage("\u00a79DustLab \u00a7b\u00bb \u00a77Model '\u00a7f" + modelName + "\u00a77' has been attached to you for " + notifyLifetime + (String)notifyEffect + ".");
        }
        return true;
    }

    private boolean handleUnload(CommandSender sender, String[] args) {
        if (!sender.hasPermission("dustlab.unload")) {
            sender.sendMessage("\u00a79DustLab \u00a7c\u00bb \u00a77You don't have permission to unload particle effects (dustlab.unload).");
            return true;
        }
        if (args.length < 2) {
            sender.sendMessage("\u00a79DustLab \u00a7c\u00bb \u00a77Usage: /dustlab unload <effect_id>");
            return true;
        }
        try {
            int effectId = Integer.parseInt(args[1]);
            ParticleModelManager.EffectInfo effectInfo = this.plugin.getParticleModelManager().getEffectInfo(effectId);
            if (effectInfo == null) {
                sender.sendMessage("\u00a79DustLab \u00a7c\u00bb \u00a77Effect with ID \u00a7f#" + effectId + " \u00a77not found.");
                return true;
            }
            boolean success = this.plugin.getParticleModelManager().stopEffect(effectId);
            if (success) {
                sender.sendMessage("\u00a79DustLab \u00a7b\u00bb \u00a77Unloaded effect \u00a7f#" + effectId + " \u00a77(model: \u00a7f" + effectInfo.modelName + "\u00a77)");
            } else {
                sender.sendMessage("\u00a79DustLab \u00a7c\u00bb \u00a77Failed to unload effect \u00a7f#" + effectId + "\u00a77.");
            }
        }
        catch (NumberFormatException e) {
            sender.sendMessage("\u00a79DustLab \u00a7c\u00bb \u00a77Invalid effect ID. Use a number like: /dustlab unload 1");
        }
        return true;
    }

    private boolean handleMove(CommandSender sender, String[] args) {
        if (!sender.hasPermission("dustlab.move")) {
            sender.sendMessage("\u00a79DustLab \u00a7c\u00bb \u00a77You don't have permission to move particle effects (dustlab.move).");
            return true;
        }
        if (!(sender instanceof Player)) {
            sender.sendMessage("\u00a79DustLab \u00a7c\u00bb \u00a77Only players can move particle effects.");
            return true;
        }
        if (args.length < 2) {
            sender.sendMessage("\u00a79DustLab \u00a7c\u00bb \u00a77Usage: /dustlab move <effect_id> [x y z]");
            sender.sendMessage("\u00a79DustLab \u00a77\u00bb \u00a77If coordinates are not provided, uses your current location");
            return true;
        }
        Player player = (Player)sender;
        try {
            Location newLocation;
            int effectId = Integer.parseInt(args[1]);
            ParticleModelManager.EffectInfo effectInfo = this.plugin.getParticleModelManager().getEffectInfo(effectId);
            if (effectInfo == null) {
                sender.sendMessage("\u00a79DustLab \u00a7c\u00bb \u00a77Effect with ID \u00a7f#" + effectId + " \u00a77not found.");
                return true;
            }
            if (args.length >= 5) {
                try {
                    double x = Double.parseDouble(args[2]);
                    double y = Double.parseDouble(args[3]);
                    double z = Double.parseDouble(args[4]);
                    newLocation = new Location(player.getWorld(), x, y, z);
                }
                catch (NumberFormatException e) {
                    sender.sendMessage("\u00a79DustLab \u00a7c\u00bb \u00a77Invalid coordinates. Use numbers like: /dustlab move 1 100 65 200");
                    return true;
                }
            } else {
                newLocation = player.getLocation();
            }
            boolean success = this.plugin.getParticleModelManager().moveEffect(effectId, newLocation);
            if (success) {
                sender.sendMessage("\u00a79DustLab \u00a7b\u00bb \u00a77Moved effect \u00a7f#" + effectId + " \u00a77(model: \u00a7f" + effectInfo.modelName + "\u00a77) to " + String.format("\u00a7b%.1f\u00a77, \u00a7b%.1f\u00a77, \u00a7b%.1f", newLocation.getX(), newLocation.getY(), newLocation.getZ()));
            } else {
                sender.sendMessage("\u00a79DustLab \u00a7c\u00bb \u00a77Failed to move effect \u00a7f#" + effectId + "\u00a77.");
            }
        }
        catch (NumberFormatException e) {
            sender.sendMessage("\u00a79DustLab \u00a7c\u00bb \u00a77Invalid effect ID. Use a number like: /dustlab move 1");
        }
        return true;
    }

    private boolean handleList(CommandSender sender) {
        if (!sender.hasPermission("dustlab.list")) {
            sender.sendMessage("\u00a79DustLab \u00a7c\u00bb \u00a77You don't have permission to list particle models (dustlab.list).");
            return true;
        }
        Map<String, ParticleModel> models = this.plugin.getParticleModelManager().getLoadedModels();
        if (models.isEmpty()) {
            sender.sendMessage("\u00a79DustLab \u00a7b\u00bb \u00a77No particle models loaded.");
            return true;
        }
        sender.sendMessage("\u00a79DustLab \u00a7b\u00bb \u00a77Available Models:");
        boolean hasVisibleModels = false;
        for (String modelName : models.keySet()) {
            if (!this.plugin.getParticleModelManager().hasViewPermission(sender, modelName, false)) continue;
            ParticleModel model = models.get(modelName);
            sender.sendMessage("  \u00a7b\u2022 \u00a7f" + modelName + " \u00a77(" + model.getParticleCount() + " particles, " + model.getDuration() + " ticks)");
            hasVisibleModels = true;
        }
        if (!hasVisibleModels) {
            sender.sendMessage("\u00a79DustLab \u00a77\u00bb \u00a77No models available - you need \u00a7bdustlab.view\u00a77 and model-specific permissions.");
        }
        return true;
    }

    private boolean handleActive(CommandSender sender) {
        if (!sender.hasPermission("dustlab.active")) {
            sender.sendMessage("\u00a79DustLab \u00a7c\u00bb \u00a77You don't have permission to use this command.");
            return true;
        }
        Map<String, ParticleModelManager.EffectInfo> activeEffects = this.plugin.getParticleModelManager().getActiveEffects();
        if (activeEffects.isEmpty()) {
            sender.sendMessage("\u00a79DustLab \u00a7b\u00bb \u00a77No active particle effects.");
            return true;
        }
        sender.sendMessage("\u00a79DustLab \u00a7b\u00bb \u00a77Active Effects:");
        for (Map.Entry<String, ParticleModelManager.EffectInfo> entry : activeEffects.entrySet()) {
            String loopText;
            ParticleModelManager.EffectInfo info = entry.getValue();
            String duration = String.format("%.1fs", (double)(System.currentTimeMillis() - info.startTime) / 1000.0);
            String string = loopText = info.isLooping ? " \u00a7b(looping)" : "";
            if (info.attachedPlayer != null) {
                Object playerName = info.attachedPlayer.isOnline() ? info.attachedPlayer.getName() : info.attachedPlayer.getName() + " \u00a7c(offline)";
                String stillText = info.onlyWhenStill ? " \u00a7e(when still)" : "";
                String forceText = info.forceVisible ? " \u00a7c(forced)" : "";
                sender.sendMessage("  \u00a7b\u2022 \u00a7f#" + info.id + " \u00a77- \u00a7f" + info.modelName + " \u00a77attached to \u00a7b" + (String)playerName + " \u00a77(running " + duration + ")" + loopText + stillText + forceText);
                continue;
            }
            sender.sendMessage("  \u00a7b\u2022 \u00a7f#" + info.id + " \u00a77- \u00a7f" + info.modelName + " \u00a77at " + String.format("\u00a7b%.1f\u00a77, \u00a7b%.1f\u00a77, \u00a7b%.1f", info.location.getX(), info.location.getY(), info.location.getZ()) + " \u00a77(running " + duration + ")" + loopText);
        }
        return true;
    }

    private boolean handleInfo(CommandSender sender, String[] args) {
        if (!sender.hasPermission("dustlab.info")) {
            sender.sendMessage("\u00a79DustLab \u00a7c\u00bb \u00a77You don't have permission to use this command.");
            return true;
        }
        if (args.length < 2) {
            sender.sendMessage("\u00a79DustLab \u00a7c\u00bb \u00a77Usage: /dustlab info <model_name>");
            return true;
        }
        String modelName = args[1];
        ParticleModel model = this.plugin.getParticleModelManager().getModel(modelName);
        if (model == null) {
            sender.sendMessage("\u00a79DustLab \u00a7c\u00bb \u00a77Model '\u00a7f" + modelName + "\u00a77' not found.");
            return true;
        }
        sender.sendMessage("\u00a79\u00a7l\u2756 Model Info: \u00a7f" + modelName + " \u00a79\u2756");
        sender.sendMessage("");
        if (model.getMetadata() != null) {
            sender.sendMessage("\u00a7bGenerated By: \u00a7f" + (model.getGeneratedBy() != null ? model.getGeneratedBy() : "Unknown"));
            sender.sendMessage("\u00a79Website: \u00a7f" + (model.getWebsite() != null ? model.getWebsite() : "Unknown"));
            sender.sendMessage("\u00a7bGenerated On: \u00a7f" + (model.getGeneratedOn() != null ? model.getGeneratedOn() : "Unknown"));
            sender.sendMessage("\u00a79Source File: \u00a7f" + (model.getSourceFile() != null ? model.getSourceFile() : "Unknown"));
            sender.sendMessage("\u00a7bParticle Count: \u00a7f" + model.getParticleCount());
            Map<String, Object> settings = model.getSettings();
            if (settings != null) {
                sender.sendMessage("");
                sender.sendMessage("\u00a7bSettings:");
                for (Map.Entry<String, Object> entry : settings.entrySet()) {
                    sender.sendMessage("  \u00a77" + entry.getKey() + ": \u00a7f" + entry.getValue());
                }
            }
        } else {
            sender.sendMessage("\u00a77No metadata available for this model.");
            sender.sendMessage("\u00a7bParticle Count: \u00a7f" + model.getParticleCount());
            sender.sendMessage("\u00a7bDuration: \u00a7f" + model.getDuration() + " ticks");
        }
        return true;
    }

    private boolean handleReload(CommandSender sender) {
        if (!sender.hasPermission("dustlab.reload")) {
            sender.sendMessage("\u00a79DustLab \u00a7c\u00bb \u00a77You don't have permission to reload the plugin (dustlab.reload).");
            return true;
        }
        sender.sendMessage("\u00a79DustLab \u00a7b\u00bb \u00a77Reloading configuration and particle models...");
        try {
            this.plugin.getDustLabConfig().reloadConfig();
            sender.sendMessage("\u00a79DustLab \u00a7a\u00bb \u00a77Configuration reloaded.");
        }
        catch (Exception e) {
            sender.sendMessage("\u00a79DustLab \u00a7c\u00bb \u00a77Failed to reload configuration: " + e.getMessage());
            this.plugin.getLogger().warning("Config reload failed: " + e.getMessage());
        }
        this.plugin.getParticleModelManager().forceSave();
        this.plugin.getParticleModelManager().reloadModels();
        int count = this.plugin.getParticleModelManager().getLoadedModels().size();
        sender.sendMessage("\u00a79DustLab \u00a7b\u00bb \u00a77Reloaded \u00a7b" + count + "\u00a77 particle models.");
        return true;
    }

    private boolean handleStats(CommandSender sender) {
        if (!sender.hasPermission("dustlab.stats")) {
            sender.sendMessage("\u00a79DustLab \u00a7c\u00bb \u00a77You don't have permission to view plugin statistics (dustlab.stats).");
            return true;
        }
        sender.sendMessage("\u00a79\u00a7l\u2756 DustLab Statistics \u2756");
        sender.sendMessage("\u00a77\u00a7m\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501");
        ParticleModelManager manager = this.plugin.getParticleModelManager();
        int totalModels = manager.getAllModels().size();
        sender.sendMessage("\u00a7a\u25b8 Total Loaded Models: \u00a7f" + totalModels);
        ParticleModelManager.MemoryUsageReport memory = manager.estimateMemoryUsage();
        sender.sendMessage("\u00a77    \u00a78\u2022 \u00a7bAnimated: \u00a7f" + memory.animatedModelCount() + " \u00a77models \u00a78(\u00a7f" + this.formatCount(memory.animationFrameCount()) + "\u00a77 frames\u00a78)");
        sender.sendMessage("\u00a77    \u00a78\u2022 \u00a79Static: \u00a7f" + memory.staticModelCount() + " \u00a77models");
        double totalMb = (double)memory.totalBytes() / 1048576.0;
        double packedMb = (double)memory.packedBytes() / 1048576.0;
        double legacyMb = (double)memory.legacyBytes() / 1048576.0;
        double optimizerMb = (double)memory.optimizerBytes() / 1048576.0;
        sender.sendMessage("\u00a7b\u25b8 \u00a77Plugin Heap Footprint: \u00a7f" + this.formatMb(totalMb) + " \u00a77MB");
        sender.sendMessage("\u00a77    \u00a78\u2022 \u00a79Packed model data: \u00a7f" + this.formatMb(packedMb) + " \u00a77MB \u00a78(\u00a7f" + this.formatCount(memory.packedParticleCount()) + "\u00a77 particles\u00a78)");
        if (memory.legacyBytes() > 0L) {
            sender.sendMessage("\u00a77    \u00a78\u2022 \u00a71Legacy particle lists: \u00a7f" + this.formatMb(legacyMb) + " \u00a77MB \u00a78(\u00a7f" + this.formatCount(memory.legacyParticleCount()) + "\u00a77 particles\u00a78)");
        }
        sender.sendMessage("\u00a77    \u00a78\u2022 \u00a79Optimizer cache: \u00a7f" + this.formatMb(optimizerMb) + " \u00a77MB \u00a78(\u00a7f" + this.formatCount(memory.optimizerTrackedParticles()) + "\u00a77 tracked\u00a78)");
        sender.sendMessage("\u00a7a\u25b8 Active Effects: \u00a7f" + this.formatCount(memory.activeEffectCount()) + " \u00a77(optimizer tracking \u00a7f" + this.formatCount(memory.optimizerTrackedEffects()) + "\u00a77 effects)");
        PerformanceMonitor monitor = this.plugin.getPerformanceMonitor();
        if (monitor != null) {
            PerformanceMonitor.PerformanceSnapshot snapshot = monitor.snapshot();
            sender.sendMessage("\u00a7b\u25b8 \u00a77Process Usage:");
            this.sendPerformanceWindow(sender, "Last 10s", snapshot.tenSeconds());
            this.sendPerformanceWindow(sender, "Last 1m", snapshot.oneMinute());
            this.sendPerformanceWindow(sender, "Last 5m", snapshot.fiveMinutes());
        } else {
            sender.sendMessage("\u00a7c\u25b8 \u00a77Performance data not available.");
        }
        sender.sendMessage("\u00a77\u00a7m\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501");
        return true;
    }

    private void sendPerformanceWindow(CommandSender sender, String label, PerformanceMonitor.WindowAverages window) {
        if (window.samples() <= 0) {
            sender.sendMessage("\u00a77  \u00a78- \u00a7b" + label + " \u00a78\u00bb \u00a77Collecting data...");
            return;
        }
        String cpuText = window.hasCpuData() ? String.format(Locale.US, "\u00a7f%.1f\u00a77%%", window.cpuPercent()) : "\u00a7cN/A";
        String ramText = String.format(Locale.US, "\u00a7f%.1f \u00a77MB", window.ramMb());
        sender.sendMessage("\u00a77  \u00a78- \u00a7b" + label + " \u00a78\u00bb \u00a79CPU: " + cpuText + " \u00a78| \u00a71RAM: " + ramText + " \u00a78(\u00a77" + window.samples() + " samples\u00a78)");
    }

    private String formatMb(double value) {
        return String.format(Locale.US, "%.2f", value);
    }

    private String formatCount(long value) {
        return String.format(Locale.US, "%,d", value);
    }

    private boolean handleHelp(CommandSender sender, String[] args) {
        if (!sender.hasPermission("dustlab.help")) {
            sender.sendMessage("\u00a79DustLab \u00a7c\u00bb \u00a77You don't have permission to view command help (dustlab.help).");
            return true;
        }
        if (args.length >= 2) {
            return this.showDetailedHelp(sender, args[1].toLowerCase());
        }
        this.sendHelp(sender);
        return true;
    }

    private boolean handleWebsite(CommandSender sender) {
        if (!sender.hasPermission("dustlab.website")) {
            sender.sendMessage("\u00a79DustLab \u00a7c\u00bb check the site out at https://winss.xyz/dustlab");
            return true;
        }
        sender.sendMessage("\u00a79\u00a7l\u2756 DustLab Web \u2756");
        sender.sendMessage("");
        sender.sendMessage("\u00a77Create and design particle models online:");
        if (sender instanceof Player) {
            Player player = (Player)sender;
            Component message = ((TextComponent)Component.text((String)"\u00a7b\u00a7n https://winss.xyz/dustlab").clickEvent(ClickEvent.openUrl((String)"https://winss.xyz/dustlab"))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"\u00a77Click to open the DustLab web interface")));
            player.sendMessage(message);
        } else {
            sender.sendMessage("\u00a7b\u00a7nhttps://winss.xyz/dustlab");
        }
        sender.sendMessage("");
        sender.sendMessage("\u00a78  \u2022 \u00a77Visual editor");
        sender.sendMessage("\u00a78  \u2022 \u00a77Images & 3D models to particle models");
        sender.sendMessage("\u00a78  \u2022 \u00a77Support for animated models (delay and batching)");
        return true;
    }

    private boolean showDetailedHelp(CommandSender sender, String command) {
        switch (command) {
            case "load": {
                sender.sendMessage("\u00a79\u00a7l\u2756 DustLab - Load Command \u2756");
                sender.sendMessage("");
                sender.sendMessage("\u00a7b/dustlab load <model> [x y z] [lifetime] [force/normal]");
                sender.sendMessage("");
                sender.sendMessage("\u00a77Load a particle model at the specified location with optional parameters.");
                sender.sendMessage("");
                sender.sendMessage("\u00a7bParameters:");
                sender.sendMessage("\u00a77  \u00a7bmodel\u00a77: Name of the model to load");
                sender.sendMessage("\u00a77  \u00a7b[x y z]\u00a77: Optional coordinates (uses your location if not provided)");
                sender.sendMessage("\u00a77  \u00a7b[lifetime]\u00a77: \u00a7b<number>\u00a77[\u00a7bs\u00a77|\u00a7bm\u00a77|\u00a7bh\u00a77], \u00a7binfinite\u00a77, or \u00a7bone-time\u00a77 (e.g., 30s, 5m, 2h)");
                if (sender.hasPermission("dustlab.force")) {
                    sender.sendMessage("\u00a77  \u00a7b[force]\u00a77: \u00a7bforce\u00a77 or \u00a7bnormal\u00a77 (force bypasses view permissions)");
                }
                sender.sendMessage("");
                sender.sendMessage("\u00a7bExamples:");
                sender.sendMessage("\u00a77  \u00a7f/dl load heart_shape");
                sender.sendMessage("\u00a77  \u00a7f/dl load star_shape 10 64 -5 infinite");
                sender.sendMessage("\u00a77  \u00a7f/dl load magic_circle 30s");
                sender.sendMessage("\u00a77  \u00a7f/dl load aurora 5m");
                return true;
            }
            case "loadfx": {
                sender.sendMessage("\u00a79\u00a7l\u2756 DustLab - LoadFX Command \u2756");
                sender.sendMessage("");
                sender.sendMessage("\u00a7b/dustlab loadfx <model> <effect> [x y z] [lifetime] [speed] [force/normal]");
                sender.sendMessage("");
                sender.sendMessage("\u00a77Load a particle model with dynamic effects applied.");
                sender.sendMessage("");
                sender.sendMessage("\u00a7bEffect Types:");
                sender.sendMessage("\u00a77  \u00a7bRotation:\u00a77 rotate, rotate-x, rotate-y, rotate-z, rotate-xy, rotate-xyz");
                sender.sendMessage("\u00a77  \u00a7bMotion:\u00a77 oscillate, pulse, bounce, flow, swirl, wave, orbit, spiral");
                sender.sendMessage("");
                sender.sendMessage("\u00a7bParameters:");
                sender.sendMessage("\u00a77  \u00a7bspeed\u00a77: Effect animation speed (0.1-5.0, default: 1.0)");
                sender.sendMessage("");
                sender.sendMessage("\u00a7bExamples:");
                sender.sendMessage("\u00a77  \u00a7f/dl loadfx dragon_breath rotate-xyz");
                sender.sendMessage("\u00a77  \u00a7f/dl loadfx spiral_galaxy swirl 0 70 0 infinite 2.0");
                sender.sendMessage("\u00a77  \u00a7f/dl loadfx heart_shape pulse 30s");
                sender.sendMessage("\u00a77  \u00a7f/dl loadfx star_shape rotate 2m");
                return true;
            }
            case "create": {
                sender.sendMessage("\u00a79\u00a7l\u2756 DustLab - Create Commands \u2756");
                sender.sendMessage("");
                sender.sendMessage("\u00a7bPlayer Models:");
                sender.sendMessage("\u00a77  \u00a7f/dl create player_avatar <name> <player> <resolution> <scale> [normal/temp]");
                sender.sendMessage("\u00a77  \u00a7f/dl create player_body <name> <player> <resolution> <scale> [normal/temp]");
                sender.sendMessage("");
                sender.sendMessage("\u00a7bAnimated Media: \u00a7c\u00a7lExperimental!");
                sender.sendMessage("\u00a77  \u00a7f/dl create media <name> <url> <width> <height> <maxparticles> [skip] [normal/temp]");
                sender.sendMessage("");
                sender.sendMessage("\u00a7bParameters:");
                sender.sendMessage("\u00a77  \u00a7bresolution\u00a77: Image resolution (8-512 pixels)");
                sender.sendMessage("\u00a77  \u00a7bscale\u00a77: Model size in blocks (0.1-50.0)");
                sender.sendMessage("\u00a77  \u00a7bskip\u00a77: Frame skip factor (2=every 2nd frame, 3=every 3rd, etc.)");
                sender.sendMessage("\u00a77  \u00a7bwidth/height\u00a77: Model dimensions in blocks");
                sender.sendMessage("\u00a77  \u00a7bmaxparticles\u00a77: Maximum particles per frame");
                sender.sendMessage("");
                sender.sendMessage("\u00a7bExamples:");
                sender.sendMessage("\u00a77  \u00a7f/dl create player_avatar steve_head Steve 64 5.0");
                sender.sendMessage("\u00a77  \u00a7f/dl create media my_gif https://example.com/animation.gif 20 20 5000 2 temp");
                return true;
            }
            case "playerload": {
                if (!sender.hasPermission("dustlab.playerload")) {
                    sender.sendMessage("\u00a79DustLab \u00a7c\u00bb \u00a77You don't have permission to view this command.");
                    return true;
                }
                sender.sendMessage("\u00a79\u00a7l\u2756 DustLab - PlayerLoad Command \u2756");
                sender.sendMessage("");
                sender.sendMessage("\u00a7b/dustlab playerload <player> <model> <lifetime> <effect/none> [whenstill/always] [force/normal]");
                sender.sendMessage("");
                sender.sendMessage("\u00a77Attach a particle model to a player that follows them around.");
                sender.sendMessage("");
                sender.sendMessage("\u00a7bParameters:");
                sender.sendMessage("\u00a77  \u00a7bplayer\u00a77: Target player name");
                sender.sendMessage("\u00a77  \u00a7bmodel\u00a77: Name of the model to attach");
                sender.sendMessage("\u00a77  \u00a7blifetime\u00a77: Duration in seconds, \u00a7binfinite\u00a77, or \u00a7bone-time");
                sender.sendMessage("\u00a77  \u00a7beffect\u00a77: Animation effect or \u00a7bnone");
                sender.sendMessage("\u00a77  \u00a7bmovement\u00a77: \u00a7bwhenstill\u00a77 (only when not moving) or \u00a7balways\u00a77");
                sender.sendMessage("");
                sender.sendMessage("\u00a7bExamples:");
                sender.sendMessage("\u00a77  \u00a7f/dl playerload Steve heart_shape infinite pulse whenstill");
                return true;
            }
            case "unload": {
                sender.sendMessage("\u00a79\u00a7l\u2756 DustLab - Unload Command \u2756");
                sender.sendMessage("");
                sender.sendMessage("\u00a7b/dustlab unload <id>");
                sender.sendMessage("");
                sender.sendMessage("\u00a77Remove a specific active particle effect by its ID.");
                sender.sendMessage("\u00a77Use \u00a7f/dl active\u00a77 to see effect IDs.");
                sender.sendMessage("");
                sender.sendMessage("\u00a7bExample:");
                sender.sendMessage("\u00a77  \u00a7f/dl unload 12345");
                return true;
            }
            case "move": {
                sender.sendMessage("\u00a79\u00a7l\u2756 DustLab - Move Command \u2756");
                sender.sendMessage("");
                sender.sendMessage("\u00a7b/dustlab move <id> [x y z]");
                sender.sendMessage("");
                sender.sendMessage("\u00a77Move an active particle effect to new coordinates.");
                sender.sendMessage("\u00a77If coordinates are not provided, moves to your current location.");
                sender.sendMessage("");
                sender.sendMessage("\u00a7bExample:");
                sender.sendMessage("\u00a77  \u00a7f/dl move 12345 10 64 -5");
                return true;
            }
            case "list": {
                sender.sendMessage("\u00a79\u00a7l\u2756 DustLab - List Command \u2756");
                sender.sendMessage("");
                sender.sendMessage("\u00a7b/dustlab list");
                sender.sendMessage("");
                sender.sendMessage("\u00a77Display all available particle models that can be loaded.");
                return true;
            }
            case "active": {
                if (!sender.hasPermission("dustlab.active")) {
                    sender.sendMessage("\u00a79DustLab \u00a7c\u00bb \u00a77You don't have permission to view this command.");
                    return true;
                }
                sender.sendMessage("\u00a79\u00a7l\u2756 DustLab - Active Command \u2756");
                sender.sendMessage("");
                sender.sendMessage("\u00a7b/dustlab active");
                sender.sendMessage("");
                sender.sendMessage("\u00a77Show all currently running particle effects with their IDs and details.");
                return true;
            }
            case "info": {
                if (!sender.hasPermission("dustlab.info")) {
                    sender.sendMessage("\u00a79DustLab \u00a7c\u00bb \u00a77You don't have permission to view this command.");
                    return true;
                }
                sender.sendMessage("\u00a79\u00a7l\u2756 DustLab - Info Command \u2756");
                sender.sendMessage("");
                sender.sendMessage("\u00a7b/dustlab info <model>");
                sender.sendMessage("");
                sender.sendMessage("\u00a77Display detailed metadata and statistics about a specific model.");
                sender.sendMessage("");
                sender.sendMessage("\u00a7bExample:");
                sender.sendMessage("\u00a77  \u00a7f/dl info heart_shape");
                return true;
            }
            case "delete": {
                if (!sender.hasPermission("dustlab.admin")) {
                    sender.sendMessage("\u00a79DustLab \u00a7c\u00bb \u00a77You don't have permission to view this command.");
                    return true;
                }
                sender.sendMessage("\u00a79\u00a7l\u2756 DustLab - Delete Command \u2756");
                sender.sendMessage("");
                sender.sendMessage("\u00a7b/dustlab delete <model>");
                sender.sendMessage("");
                sender.sendMessage("\u00a7c\u00a7lWARNING: \u00a77This permanently deletes the model file!");
                sender.sendMessage("\u00a77After running delete, confirm with \u00a7f/dl confirm\u00a77 within the time window.");
                sender.sendMessage("");
                sender.sendMessage("\u00a7bExample:");
                sender.sendMessage("\u00a77  \u00a7f/dl delete old_model");
                sender.sendMessage("\u00a77  \u00a7f/dl confirm");
                return true;
            }
            case "reload": {
                if (!sender.hasPermission("dustlab.admin")) {
                    sender.sendMessage("\u00a79DustLab \u00a7c\u00bb \u00a77You don't have permission to view this command.");
                    return true;
                }
                sender.sendMessage("\u00a79\u00a7l\u2756 DustLab - Reload Command \u2756");
                sender.sendMessage("");
                sender.sendMessage("\u00a7b/dustlab reload");
                sender.sendMessage("");
                sender.sendMessage("\u00a77Reload all particle models from disk. Active effects are preserved.");
                return true;
            }
            case "stats": {
                if (!sender.hasPermission("dustlab.admin")) {
                    sender.sendMessage("\u00a79DustLab \u00a7c\u00bb \u00a77You don't have permission to view this command.");
                    return true;
                }
                sender.sendMessage("\u00a79\u00a7l\u2756 DustLab - Stats Command \u2756");
                sender.sendMessage("");
                sender.sendMessage("\u00a7b/dustlab stats");
                sender.sendMessage("");
                sender.sendMessage("\u00a77Display particle system statistics including optimization metrics.");
                sender.sendMessage("\u00a77Shows active effects, tracked particles, and memory usage.");
                sender.sendMessage("");
                sender.sendMessage("\u00a7bOptimization Info:");
                sender.sendMessage("\u00a77The system optimizes animated models by only updating particles");
                sender.sendMessage("\u00a77when their color changes by more than 2%, reducing client lag.");
                return true;
            }
            case "website": {
                sender.sendMessage("\u00a79\u00a7l\u2756 DustLab - Website Command \u2756");
                sender.sendMessage("");
                sender.sendMessage("\u00a7b/dustlab website");
                sender.sendMessage("");
                sender.sendMessage("\u00a77Opens the DustLab web interface where you can:");
                sender.sendMessage("\u00a78  \u2022 \u00a77Visual editor");
                sender.sendMessage("\u00a78  \u2022 \u00a77Images & 3D models to particle models");
                sender.sendMessage("\u00a78  \u2022 \u00a77Support for animated models (delay and batching)");
                sender.sendMessage("");
                sender.sendMessage("\u00a77The web interface provides an easy way to create models");
                return true;
            }
        }
        sender.sendMessage("\u00a79DustLab \u00a7c\u00bb \u00a77Unknown command: \u00a7f" + command);
        sender.sendMessage("\u00a77Use \u00a7b/dl help\u00a77 to see all available commands.");
        return true;
    }

    private void sendClickableCommand(CommandSender sender, String command, String description) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            Component commandText = ((TextComponent)Component.text((String)"  ").append(((TextComponent)((TextComponent)((TextComponent)Component.text((String)("/dl " + command)).color((TextColor)NamedTextColor.AQUA)).decoration(TextDecoration.UNDERLINED, false)).clickEvent(ClickEvent.runCommand((String)("/dl help " + command)))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"Click for more info on this command!"))))).append(Component.text((String)(" - " + description)).color((TextColor)NamedTextColor.GRAY));
            player.sendMessage(commandText);
        } else {
            sender.sendMessage("  \u00a7b/dl " + command + "\u00a77 - " + description);
        }
    }

    private void sendClickableCreateCommand(CommandSender sender, String fullCommand, String description) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            Component commandText = ((TextComponent)Component.text((String)"  ").append(((TextComponent)((TextComponent)((TextComponent)Component.text((String)("/dl " + fullCommand)).color((TextColor)NamedTextColor.AQUA)).decoration(TextDecoration.UNDERLINED, false)).clickEvent(ClickEvent.runCommand((String)"/dl help create"))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"Click for create command help"))))).append(Component.text((String)(" - " + description)).color((TextColor)NamedTextColor.GRAY));
            player.sendMessage(commandText);
        } else {
            sender.sendMessage("  \u00a7b/dl " + fullCommand + "\u00a77 - " + description);
        }
    }

    private void sendHelp(CommandSender sender) {
        sender.sendMessage("\u00a79\u00a7l\u2756 \u00a7b\u00a7lDustLab Commands \u00a79\u00a7l\u2756");
        sender.sendMessage("");
        boolean hasCoreCommands = false;
        StringBuilder coreHelp = new StringBuilder();
        if ((sender.hasPermission("dustlab.load") || sender.hasPermission("dustlab.loadfx") || sender.hasPermission("dustlab.playerload") || sender.hasPermission("dustlab.unload") || sender.hasPermission("dustlab.move") || sender.hasPermission("dustlab.delete") || sender.hasPermission("dustlab.reload")) && !hasCoreCommands) {
            coreHelp.append("\u00a77\u00a7l\u25b8 Core Commands:\n");
            hasCoreCommands = true;
        }
        if (hasCoreCommands) {
            sender.sendMessage("\u00a77\u00a7l\u25b8 Core Commands:");
            if (sender.hasPermission("dustlab.load")) {
                this.sendClickableCommand(sender, "load", "Load particle models");
            }
            if (sender.hasPermission("dustlab.loadfx")) {
                this.sendClickableCommand(sender, "loadfx", "Load models with effects");
            }
            if (sender.hasPermission("dustlab.playerload")) {
                this.sendClickableCommand(sender, "playerload", "Attach models to players");
            }
            if (sender.hasPermission("dustlab.unload")) {
                this.sendClickableCommand(sender, "unload", "Remove active effects");
            }
            if (sender.hasPermission("dustlab.move")) {
                this.sendClickableCommand(sender, "move", "Move active effects");
            }
            if (sender.hasPermission("dustlab.delete")) {
                this.sendClickableCommand(sender, "delete", "Delete models permanently");
            }
            if (sender.hasPermission("dustlab.reload")) {
                this.sendClickableCommand(sender, "reload", "Reload all models");
            }
        }
        if (sender.hasPermission("dustlab.create")) {
            if (hasCoreCommands) {
                sender.sendMessage("");
            }
            sender.sendMessage("\u00a77\u00a7l\u25b8 Creation Commands:");
            this.sendClickableCreateCommand(sender, "create player_avatar", "Create player head models");
            this.sendClickableCreateCommand(sender, "create player_body", "Create player body models");
            if (sender instanceof Player) {
                Player player = (Player)sender;
                Component mediaCommand = ((TextComponent)((TextComponent)Component.text((String)"  ").append(((TextComponent)((TextComponent)((TextComponent)Component.text((String)"/dl create media").color((TextColor)NamedTextColor.AQUA)).decoration(TextDecoration.UNDERLINED, false)).clickEvent(ClickEvent.runCommand((String)"/dl help create"))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"Click for create command help"))))).append(((TextComponent)((TextComponent)Component.text((String)" ").color((TextColor)NamedTextColor.RED)).decoration(TextDecoration.BOLD, true)).append(((TextComponent)Component.text((String)"Experimental!").color((TextColor)NamedTextColor.RED)).decoration(TextDecoration.BOLD, true)))).append(Component.text((String)" - Create animated models").color((TextColor)NamedTextColor.GRAY));
                player.sendMessage(mediaCommand);
            } else {
                sender.sendMessage("  \u00a7b/dl create media !\u00a77 - Create animated models \u00a7c\u00a7lExperimental");
            }
        }
        if (sender.hasPermission("dustlab.list") || sender.hasPermission("dustlab.active") || sender.hasPermission("dustlab.info") || sender.hasPermission("dustlab.stats")) {
            if (hasCoreCommands || sender.hasPermission("dustlab.create")) {
                sender.sendMessage("");
            }
            sender.sendMessage("\u00a77\u00a7l\u25b8 Information Commands:");
            if (sender.hasPermission("dustlab.list")) {
                this.sendClickableCommand(sender, "list", "List available models");
            }
            if (sender.hasPermission("dustlab.active")) {
                this.sendClickableCommand(sender, "active", "Show active effects");
            }
            if (sender.hasPermission("dustlab.info")) {
                this.sendClickableCommand(sender, "info", "Show model details");
            }
            if (sender.hasPermission("dustlab.stats")) {
                this.sendClickableCommand(sender, "stats", "Show system statistics");
            }
            if (sender.hasPermission("dustlab.website")) {
                this.sendClickableCommand(sender, "website", "Open DustLab web interface");
            }
        }
        sender.sendMessage("");
        if (sender.hasPermission("dustlab.help")) {
            sender.sendMessage("\u00a77Use \u00a7b/dl help <command>\u00a77 for detailed information about a specific command.");
        }
        sender.sendMessage("\u00a77Plugin by \u00a7bWinss \u00a77| Version \u00a7f" + this.plugin.getPluginMeta().getVersion());
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            ArrayList<String> subCommands = new ArrayList<String>();
            if (sender.hasPermission("dustlab.load")) {
                subCommands.add("load");
            }
            if (sender.hasPermission("dustlab.loadfx")) {
                subCommands.add("loadfx");
            }
            if (sender.hasPermission("dustlab.playerload")) {
                subCommands.add("playerload");
            }
            if (sender.hasPermission("dustlab.create")) {
                subCommands.add("create");
            }
            if (sender.hasPermission("dustlab.delete")) {
                subCommands.add("delete");
            }
            if (sender.hasPermission("dustlab.delete")) {
                subCommands.add("confirm");
            }
            if (sender.hasPermission("dustlab.unload")) {
                subCommands.add("unload");
            }
            if (sender.hasPermission("dustlab.move")) {
                subCommands.add("move");
            }
            if (sender.hasPermission("dustlab.reload")) {
                subCommands.add("reload");
            }
            if (sender.hasPermission("dustlab.stats")) {
                subCommands.add("stats");
            }
            if (sender.hasPermission("dustlab.list")) {
                subCommands.add("list");
            }
            if (sender.hasPermission("dustlab.active")) {
                subCommands.add("active");
            }
            if (sender.hasPermission("dustlab.info")) {
                subCommands.add("info");
            }
            if (sender.hasPermission("dustlab.help")) {
                subCommands.add("help");
            }
            if (sender.hasPermission("dustlab.website")) {
                subCommands.add("website");
            }
            for (String subCommand : subCommands) {
                if (!subCommand.toLowerCase().startsWith(args[0].toLowerCase())) continue;
                completions.add(subCommand);
            }
        } else if (args.length == 2 && args[0].equalsIgnoreCase("playerload")) {
            for (Player player : this.plugin.getServer().getOnlinePlayers()) {
                if (!player.getName().toLowerCase().startsWith(args[1].toLowerCase())) continue;
                completions.add(player.getName());
            }
        } else if (args.length == 3 && args[0].equalsIgnoreCase("playerload")) {
            for (String modelName : this.plugin.getParticleModelManager().getLoadedModels().keySet()) {
                if (!modelName.toLowerCase().startsWith(args[2].toLowerCase()) || !this.plugin.getParticleModelManager().hasViewPermission(sender, modelName, sender.hasPermission("dustlab.force"))) continue;
                completions.add(modelName);
            }
        } else if (args.length == 4 && args[0].equalsIgnoreCase("playerload")) {
            List<String> lifetimeOptions = Arrays.asList("infinite", "one-time", "30", "60", "300", "600");
            for (String option : lifetimeOptions) {
                if (!option.toLowerCase().startsWith(args[3].toLowerCase())) continue;
                completions.add(option);
            }
        } else if (args.length == 5 && args[0].equalsIgnoreCase("playerload")) {
            List<String> effectOptions = Arrays.asList("rotate", "rotate-x", "rotate-y", "rotate-z", "rotate-xy", "rotate-xz", "rotate-yz", "rotate-xyz", "oscillate", "pulse", "bounce", "flow", "swirl", "wave", "orbit", "spiral", "none");
            for (String option : effectOptions) {
                if (!option.toLowerCase().startsWith(args[4].toLowerCase())) continue;
                completions.add(option);
            }
        } else if (args.length == 6 && args[0].equalsIgnoreCase("playerload")) {
            List<String> movementOptions = Arrays.asList("whenstill", "always");
            for (String option : movementOptions) {
                if (!option.toLowerCase().startsWith(args[5].toLowerCase())) continue;
                completions.add(option);
            }
        } else if (args.length == 7 && args[0].equalsIgnoreCase("playerload")) {
            if (sender.hasPermission("dustlab.force")) {
                List<String> forceOptions = Arrays.asList("force", "normal");
                for (String option : forceOptions) {
                    if (!option.toLowerCase().startsWith(args[6].toLowerCase())) continue;
                    completions.add(option);
                }
            } else {
                this.addIfMatches(completions, args[6], "normal");
            }
        } else if (args.length == 2 && args[0].equalsIgnoreCase("help")) {
            List<String> helpCommands = Arrays.asList("load", "loadfx", "playerload", "create", "unload", "move", "list", "active", "info", "delete", "reload");
            for (String cmdName : helpCommands) {
                if (!cmdName.toLowerCase().startsWith(args[1].toLowerCase())) continue;
                completions.add(cmdName);
            }
        } else if (args.length == 2 && (args[0].equalsIgnoreCase("load") || args[0].equalsIgnoreCase("loadfx") || args[0].equalsIgnoreCase("info") || args[0].equalsIgnoreCase("delete"))) {
            for (String modelName : this.plugin.getParticleModelManager().getLoadedModels().keySet()) {
                if (!modelName.toLowerCase().startsWith(args[1].toLowerCase())) continue;
                if (args[0].equalsIgnoreCase("load") || args[0].equalsIgnoreCase("loadfx") || args[0].equalsIgnoreCase("info")) {
                    if (!this.plugin.getParticleModelManager().hasViewPermission(sender, modelName, sender.hasPermission("dustlab.force"))) continue;
                    completions.add(modelName);
                    continue;
                }
                if (!args[0].equalsIgnoreCase("delete")) continue;
                completions.add(modelName);
            }
        } else if (args.length == 3 && args[0].equalsIgnoreCase("loadfx")) {
            List<String> effectTypes = Arrays.asList("rotate", "rotate-x", "rotate-y", "rotate-z", "rotate-xy", "rotate-xz", "rotate-yz", "rotate-xyz", "oscillate", "pulse", "bounce", "flow", "swirl", "wave", "orbit", "spiral");
            for (String effectType : effectTypes) {
                if (!effectType.toLowerCase().startsWith(args[2].toLowerCase())) continue;
                completions.add(effectType);
            }
        } else if (args.length == 2 && (args[0].equalsIgnoreCase("unload") || args[0].equalsIgnoreCase("move"))) {
            Map<String, ParticleModelManager.EffectInfo> activeEffects = this.plugin.getParticleModelManager().getActiveEffects();
            for (ParticleModelManager.EffectInfo info : activeEffects.values()) {
                String idStr = String.valueOf(info.id);
                if (!idStr.startsWith(args[1])) continue;
                completions.add(idStr);
            }
        } else {
            if (args[0].equalsIgnoreCase("create") && args.length >= 2) {
                return this.getCreateTabCompletion(sender, args);
            }
            if (args[0].equalsIgnoreCase("load") && args.length >= 3) {
                return this.getLoadTabCompletion(sender, args);
            }
            if (args[0].equalsIgnoreCase("loadfx") && args.length >= 4) {
                return this.getLoadFxTabCompletion(sender, args);
            }
        }
        return completions;
    }

    private List<String> getLoadTabCompletion(CommandSender sender, String[] args) {
        int currentParam;
        ArrayList<String> completions = new ArrayList<String>();
        int paramIndex = args.length - 1;
        int startIndex = 2;
        if (args.length >= 5) {
            try {
                Double.parseDouble(args[2]);
                Double.parseDouble(args[3]);
                Double.parseDouble(args[4]);
                startIndex = 5;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((currentParam = paramIndex - startIndex + 1) == 1) {
            this.addIfMatches(completions, args[paramIndex], "infinite", "one-time", "30", "60", "300");
        } else if (currentParam == 2) {
            if (sender.hasPermission("dustlab.force")) {
                this.addIfMatches(completions, args[paramIndex], "force", "normal");
            } else {
                this.addIfMatches(completions, args[paramIndex], "normal");
            }
        }
        return completions;
    }

    private List<String> getLoadFxTabCompletion(CommandSender sender, String[] args) {
        int currentParam;
        ArrayList<String> completions = new ArrayList<String>();
        int paramIndex = args.length - 1;
        int startIndex = 3;
        if (args.length >= 6) {
            try {
                Double.parseDouble(args[3]);
                Double.parseDouble(args[4]);
                Double.parseDouble(args[5]);
                startIndex = 6;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((currentParam = paramIndex - startIndex + 1) == 1) {
            this.addIfMatches(completions, args[paramIndex], "infinite", "one-time", "30", "60", "300");
        } else if (currentParam == 2) {
            this.addIfMatches(completions, args[paramIndex], "0.5", "1.0", "2.0", "3.0");
        } else if (currentParam == 3) {
            if (sender.hasPermission("dustlab.force")) {
                this.addIfMatches(completions, args[paramIndex], "force", "normal");
            } else {
                this.addIfMatches(completions, args[paramIndex], "normal");
            }
        }
        return completions;
    }

    private void addIfMatches(List<String> completions, String input, String ... options) {
        for (String option : options) {
            if (!option.toLowerCase().startsWith(input.toLowerCase())) continue;
            completions.add(option);
        }
    }

    private List<String> getCreateTabCompletion(CommandSender sender, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 2) {
            this.addIfMatches(completions, args[1], "player_avatar", "player_body", "media");
        } else {
            if (args.length == 3) {
                return completions;
            }
            if (args.length >= 4) {
                String type = args[1].toLowerCase();
                if (type.equals("player_avatar") || type.equals("player_body")) {
                    return this.getCreatePlayerTabCompletion(sender, args);
                }
                if (type.equals("media")) {
                    return this.getCreateMediaTabCompletion(sender, args);
                }
            }
        }
        return completions;
    }

    private List<String> getCreatePlayerTabCompletion(CommandSender sender, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 4) {
            for (Player player : this.plugin.getServer().getOnlinePlayers()) {
                if (!player.getName().toLowerCase().startsWith(args[3].toLowerCase())) continue;
                completions.add(player.getName());
            }
        } else if (args.length == 5) {
            this.addIfMatches(completions, args[4], "16", "32", "64", "128", "256");
        } else if (args.length == 6) {
            this.addIfMatches(completions, args[5], "1", "2", "3", "5", "10");
        } else if (args.length == 7) {
            this.addIfMatches(completions, args[6], "normal", "temp");
        }
        return completions;
    }

    private List<String> getCreateMediaTabCompletion(CommandSender sender, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 4) {
            return completions;
        }
        if (args.length == 5) {
            this.addIfMatches(completions, args[4], "5", "10", "15", "20", "25", "30");
        } else if (args.length == 6) {
            this.addIfMatches(completions, args[5], "5", "10", "15", "20", "25", "30");
        } else if (args.length == 7) {
            this.addIfMatches(completions, args[6], "500", "1000", "2000", "5000", "10000");
        } else if (args.length == 8) {
            this.addIfMatches(completions, args[7], "2", "3", "4", "5", "normal", "temp");
        } else if (args.length == 9) {
            this.addIfMatches(completions, args[8], "normal", "temp");
        }
        return completions;
    }

    private boolean handleCreate(CommandSender sender, String[] args) {
        String type;
        if (!sender.hasPermission("dustlab.create")) {
            sender.sendMessage("\u00a79DustLab \u00a7c\u00bb \u00a77You don't have permission to create particle models (dustlab.create).");
            return true;
        }
        if (args.length < 2) {
            sender.sendMessage("\u00a79DustLab \u00a7c\u00bb \u00a77Usage:");
            sender.sendMessage("\u00a79DustLab \u00a77\u00bb \u00a7b/dustlab create player_avatar <modelName> <playerName> <resolution> <scale> [normal/temp]");
            sender.sendMessage("\u00a79DustLab \u00a77\u00bb \u00a7b/dustlab create player_body <modelName> <playerName> <resolution> <scale> [normal/temp]");
            sender.sendMessage("\u00a79DustLab \u00a77\u00bb \u00a7b/dustlab create media <modelName> <url> <blockwidth> <blockheight> <maxparticles> [skip] [normal/temp] [gzip] \u00a7c\u00a7lExperimental!");
            sender.sendMessage("");
            sender.sendMessage("\u00a7e\u00a7l\ud83d\udca1\u00a77 Use \u00a7b/dl website\u00a77 to access the \u00a79DustLab\u00a77 web app for model creation!");
            return true;
        }
        switch (type = args[1].toLowerCase()) {
            case "player_avatar": 
            case "player_body": {
                return this.handleCreatePlayer(sender, args);
            }
            case "media": {
                return this.handleCreateMedia(sender, args);
            }
        }
        sender.sendMessage("\u00a79DustLab \u00a7c\u00bb \u00a77Invalid creation type. Use \u00a7bplayer_avatar\u00a77, \u00a7bplayer_body\u00a77, or \u00a7bmedia\u00a77.");
        return true;
    }

    private boolean handleCreatePlayer(CommandSender sender, String[] args) {
        double scale;
        int resolution;
        String persistence;
        if (args.length < 6) {
            sender.sendMessage("\u00a79DustLab \u00a7c\u00bb \u00a77Usage: /dustlab create <type> <modelName> <playerName> <resolution> <scale> [normal/temp]");
            sender.sendMessage("\u00a79DustLab \u00a77\u00bb \u00a77Type: \u00a7bplayer_avatar\u00a77 or \u00a7bplayer_body &7or \u00a7bmedia");
            sender.sendMessage("\u00a79DustLab \u00a77\u00bb \u00a77ModelName: \u00a7bName for the generated model");
            sender.sendMessage("\u00a79DustLab \u00a77\u00bb \u00a77PlayerName: \u00a7bMinecraft player name");
            sender.sendMessage("\u00a79DustLab \u00a77\u00bb \u00a77Resolution: \u00a7b32\u00a77, \u00a7b64\u00a77, \u00a7b128\u00a77, etc.");
            sender.sendMessage("\u00a79DustLab \u00a77\u00bb \u00a77Scale: \u00a7bMax blocks for image size (e.g., 5)");
            return true;
        }
        String type = args[1].toLowerCase();
        String modelName = args[2];
        String playerName = args[3];
        String resolutionStr = args[4];
        String scaleStr = args[5];
        String string = persistence = args.length > 6 ? args[6].toLowerCase() : "normal";
        if (!type.equals("player_avatar") && !type.equals("player_body")) {
            sender.sendMessage("\u00a79DustLab \u00a7c\u00bb \u00a77Invalid type. Use \u00a7bplayer_avatar\u00a77 or \u00a7bplayer_body\u00a77.");
            return true;
        }
        try {
            resolution = Integer.parseInt(resolutionStr);
            if (resolution < 8 || resolution > 512) {
                sender.sendMessage("\u00a79DustLab \u00a7c\u00bb \u00a77Resolution must be between 8 and 512.");
                return true;
            }
        }
        catch (NumberFormatException e) {
            sender.sendMessage("\u00a79DustLab \u00a7c\u00bb \u00a77Invalid resolution. Must be a number (e.g., 64).");
            return true;
        }
        try {
            scale = Double.parseDouble(scaleStr);
            if (scale < 0.1 || scale > 50.0) {
                sender.sendMessage("\u00a79DustLab \u00a7c\u00bb \u00a77Scale must be between 0.1 and 50.0 blocks.");
                return true;
            }
        }
        catch (NumberFormatException e) {
            sender.sendMessage("\u00a79DustLab \u00a7c\u00bb \u00a77Invalid scale. Must be a number (e.g., 5.0).");
            return true;
        }
        boolean isTemporary = persistence.equals("temp");
        if (this.plugin.getParticleModelManager().hasModel(modelName)) {
            sender.sendMessage("\u00a79DustLab \u00a7c\u00bb \u00a77Model '\u00a7f" + modelName + "\u00a77' already exists.");
            return true;
        }
        sender.sendMessage("\u00a79DustLab \u00a77\u00bb \u00a77Creating \u00a7b" + type + "\u00a77 model for player \u00a7b" + playerName + "\u00a77...");
        MediaProcessor.submitAsync(() -> {
            try {
                this.createPlayerModel(sender, type, modelName, playerName, resolution, scale, isTemporary);
            }
            catch (Exception e) {
                this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> {
                    sender.sendMessage("\u00a79DustLab \u00a7c\u00bb \u00a77Failed to create model: " + e.getMessage());
                    this.plugin.getLogger().warning("Failed to create player model: " + e.getMessage());
                });
            }
        });
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handleCreateMedia(CommandSender sender, String[] args) {
        int maxParticles;
        int blockHeight;
        int blockWidth;
        boolean gzip;
        String persistence;
        int frameSkip;
        String maxParticlesStr;
        String blockHeightStr;
        String blockWidthStr;
        String url;
        String modelName;
        block27: {
            if (args.length < 7) {
                sender.sendMessage("\u00a79DustLab \u00a7c\u00bb \u00a7c\u00a7lExperimental! \u00a77Usage: /dustlab create media <modelName> <url> <blockwidth> <blockheight> <maxparticles> [skip] [normal/temp] [gzip]");
                sender.sendMessage("\u00a79DustLab \u00a77\u00bb \u00a77ModelName: \u00a7bName for the animated model");
                int maxFramesHelp = this.plugin.getDustLabConfig().getMediaMaxFrames();
                int maxMbHelp = this.plugin.getDustLabConfig().getMediaMaxFileSizeMB();
                sender.sendMessage("\u00a79DustLab \u00a77\u00bb \u00a77URL: \u00a7bDirect link to GIF/WebP/APNG (max " + maxMbHelp + "MB, " + maxFramesHelp + " frames)");
                sender.sendMessage("\u00a79DustLab \u00a77\u00bb \u00a77BlockWidth: \u00a7bWidth in blocks (1-32)");
                sender.sendMessage("\u00a79DustLab \u00a77\u00bb \u00a77BlockHeight: \u00a7bHeight in blocks (1-32)");
                sender.sendMessage("\u00a79DustLab \u00a77\u00bb \u00a77MaxParticles: \u00a7bMaximum particles per frame (100-50000)");
                sender.sendMessage("\u00a79DustLab \u00a77\u00bb \u00a77Skip: \u00a7bOptional frame skip (1=all frames, 2=every 2nd, etc.)");
                sender.sendMessage("\u00a79DustLab \u00a77\u00bb \u00a77Persistence: \u00a7bnormal\u00a77 (permanent) or \u00a7btemp\u00a77 (temporary)");
                sender.sendMessage("\u00a79DustLab \u00a77\u00bb \u00a77Compression: optional \u00a7bgzip\u00a77 to save as .json.gz (default: " + (this.plugin.getDustLabConfig().isMediaDefaultGzipEnabled() ? "\u00a7aON" : "\u00a7cOFF") + "\u00a77)");
                return true;
            }
            modelName = args[2];
            url = args[3];
            blockWidthStr = args[4];
            blockHeightStr = args[5];
            maxParticlesStr = args[6];
            frameSkip = 1;
            persistence = "normal";
            gzip = this.plugin.getDustLabConfig().isMediaDefaultGzipEnabled();
            if (args.length > 7) {
                try {
                    frameSkip = Integer.parseInt(args[7]);
                    if (frameSkip < 1 || frameSkip > 50) {
                        sender.sendMessage("\u00a79DustLab \u00a7c\u00bb \u00a77Frame skip must be between 1 and 50.");
                        return true;
                    }
                    if (args.length > 8) {
                        persistence = args[8].toLowerCase();
                        if (args.length > 9) {
                            gzip = "gzip".equalsIgnoreCase(args[9]);
                        }
                    }
                }
                catch (NumberFormatException e) {
                    persistence = args[7].toLowerCase();
                    if (args.length <= 8) break block27;
                    gzip = "gzip".equalsIgnoreCase(args[8]);
                }
            }
        }
        try {
            blockWidth = Integer.parseInt(blockWidthStr);
            if (blockWidth < 1 || blockWidth > 32) {
                sender.sendMessage("\u00a79DustLab \u00a7c\u00bb \u00a77Block width must be between 1 and 32.");
                return true;
            }
        }
        catch (NumberFormatException e) {
            sender.sendMessage("\u00a79DustLab \u00a7c\u00bb \u00a77Invalid block width. Must be a number.");
            return true;
        }
        try {
            blockHeight = Integer.parseInt(blockHeightStr);
            if (blockHeight < 1 || blockHeight > 32) {
                sender.sendMessage("\u00a79DustLab \u00a7c\u00bb \u00a77Block height must be between 1 and 32.");
                return true;
            }
        }
        catch (NumberFormatException e) {
            sender.sendMessage("\u00a79DustLab \u00a7c\u00bb \u00a77Invalid block height. Must be a number.");
            return true;
        }
        try {
            maxParticles = Integer.parseInt(maxParticlesStr);
            if (maxParticles < 100 || maxParticles > 50000) {
                sender.sendMessage("\u00a79DustLab \u00a7c\u00bb \u00a77Max particles must be between 100 and 50000.");
                return true;
            }
        }
        catch (NumberFormatException e) {
            sender.sendMessage("\u00a79DustLab \u00a7c\u00bb \u00a77Invalid max particles. Must be a number.");
            return true;
        }
        boolean isTemporary = persistence.equals("temp");
        if (this.plugin.getParticleModelManager().hasModel(modelName)) {
            sender.sendMessage("\u00a79DustLab \u00a7c\u00bb \u00a77Model '\u00a7f" + modelName + "\u00a77' already exists.");
            return true;
        }
        if (!this.isValidMediaUrl(url)) {
            sender.sendMessage("\u00a79DustLab \u00a7c\u00bb \u00a77Invalid URL. Must be a direct link to an image/animation file.");
            return true;
        }
        String nameKey = modelName.toLowerCase();
        if (this.mediaNamesRunningOrQueued.contains(nameKey)) {
            sender.sendMessage("\u00a79DustLab \u00a7c\u00bb \u00a77A media creation task with the name '\u00a7f" + modelName + "\u00a77' is already running or queued.");
            return true;
        }
        UUID ownerId = sender instanceof Player ? ((Player)sender).getUniqueId() : CONSOLE_UUID;
        Deque queue = this.mediaQueues.computeIfAbsent(ownerId, id -> new ArrayDeque());
        MediaRequest request = new MediaRequest(sender, modelName, url, blockWidth, blockHeight, maxParticles, frameSkip, isTemporary, gzip);
        boolean isConsole = ownerId.equals(CONSOLE_UUID);
        if (!isConsole && this.mediaActive.contains(ownerId)) {
            int position;
            Deque deque = queue;
            synchronized (deque) {
                queue.addLast(request);
            }
            this.mediaNamesRunningOrQueued.add(nameKey);
            Deque deque2 = queue;
            synchronized (deque2) {
                position = queue.size();
            }
            sender.sendMessage("\u00a79DustLab \u00a7b\u00bb \u00a77Your media task '\u00a7f" + modelName + "\u00a77' has been queued (position \u00a7b" + position + "\u00a77). Only one active media task per player.");
            return true;
        }
        if (!isConsole) {
            this.mediaActive.add(ownerId);
        }
        this.mediaNamesRunningOrQueued.add(nameKey);
        this.startMediaProcessing(ownerId, request);
        return true;
    }

    private void startMediaProcessing(UUID ownerId, MediaRequest req) {
        CommandSender sender = req.sender;
        String modelName = req.modelName;
        String url = req.url;
        int blockWidth = req.blockWidth;
        int blockHeight = req.blockHeight;
        int maxParticles = req.maxParticles;
        int frameSkip = req.frameSkip;
        boolean isTemporary = req.isTemporary;
        boolean gzip = req.gzip;
        boolean isConsole = ownerId.equals(CONSOLE_UUID);
        if (!isConsole) {
            this.mediaActive.add(ownerId);
        }
        this.mediaNamesRunningOrQueued.add(modelName.toLowerCase());
        sender.sendMessage("\u00a79DustLab \u00a77\u00bb \u00a7c\u00a7lExperimental! \u00a77Creating animated model \u00a7b" + modelName + "\u00a77 from: \u00a7f" + url);
        sender.sendMessage("\u00a79DustLab \u00a77\u00bb \u00a77Dimensions: \u00a7b" + blockWidth + "x" + blockHeight + "\u00a77 blocks, max \u00a7b" + maxParticles + "\u00a77 particles per frame");
        sender.sendMessage("\u00a79DustLab \u00a77\u00bb \u00a77Particle scale: \u00a7b" + this.plugin.getDustLabConfig().getMediaParticleScale() + "\u00a77 (configurable in config)");
        if (frameSkip > 1) {
            sender.sendMessage("\u00a79DustLab \u00a77\u00bb \u00a77Frame skip: \u00a7b" + frameSkip + "\u00a77 (using every " + frameSkip + " frames)");
        }
        int maxFrames = this.plugin.getDustLabConfig().getMediaMaxFrames();
        int maxMb = this.plugin.getDustLabConfig().getMediaMaxFileSizeMB();
        sender.sendMessage("\u00a79DustLab \u00a77\u00bb \u00a77Processing limits: \u00a7b" + maxMb + "MB file size, " + maxFrames + " frame maximum");
        sender.sendMessage("\u00a79DustLab \u00a77\u00bb \u00a77Starting download and processing... This may take a moment.");
        if (gzip) {
            sender.sendMessage("\u00a79DustLab \u00a77\u00bb \u00a77Saving with compression: \u00a7bgzip\u00a77 (.json.gz)");
        }
        MediaProcessor processor = new MediaProcessor((Plugin)this.plugin);
        ((CompletableFuture)processor.processMediaUrl(url, modelName, blockWidth, blockHeight, maxParticles, !isTemporary, frameSkip).thenAccept(animatedModel -> {
            if (!this.plugin.isEnabled()) {
                this.onMediaProcessingComplete(ownerId, modelName);
                return;
            }
            this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> {
                if (!this.plugin.isEnabled()) {
                    this.onMediaProcessingComplete(ownerId, modelName);
                    return;
                }
                try {
                    Map<String, Object> md = animatedModel.getMetadata();
                    if (md == null) {
                        md = new HashMap<String, Object>();
                    }
                    md.put("compressed", gzip);
                    animatedModel.setMetadata(md);
                    this.plugin.getParticleModelManager().registerAnimatedModel((AnimatedModel)animatedModel, !isTemporary);
                    long totalMs = 0L;
                    for (FrameData f : animatedModel.getFrames()) {
                        totalMs += (long)Math.max(0, f.getDelayMs());
                    }
                    long totalSeconds = Math.max(1L, totalMs / 1000L);
                    sender.sendMessage("\u00a79DustLab \u00a7b\u00bb \u00a77Successfully created animated model \u00a7b" + modelName + "\u00a77!");
                    sender.sendMessage("\u00a79DustLab \u00a77\u00bb \u00a77Frames: \u00a7b" + animatedModel.getTotalFrames() + "\u00a77, Total particles: \u00a7b" + animatedModel.getTotalParticleCount() + "\u00a77, Playtime: \u00a7b" + totalSeconds + "s");
                    if (isTemporary) {
                        sender.sendMessage("\u00a79DustLab \u00a77\u00bb \u00a77Model will be automatically removed after configured time.");
                    } else {
                        sender.sendMessage("\u00a79DustLab \u00a77\u00bb \u00a77Model saved successfully!");
                    }
                }
                catch (Exception e) {
                    sender.sendMessage("\u00a79DustLab \u00a7c\u00bb \u00a77Failed to register animated model: " + e.getMessage());
                    this.plugin.getLogger().severe("Failed to register animated model: " + e.getMessage());
                }
                finally {
                    this.onMediaProcessingComplete(ownerId, modelName);
                }
            });
        })).exceptionally(throwable -> {
            if (!this.plugin.isEnabled()) {
                return null;
            }
            this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> {
                if (!this.plugin.isEnabled()) {
                    return;
                }
                sender.sendMessage("\u00a79DustLab \u00a7c\u00bb \u00a77Failed to create animated model: " + throwable.getMessage());
                this.onMediaProcessingComplete(ownerId, modelName);
            });
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onMediaProcessingComplete(UUID ownerId, String modelName) {
        String nameKey = modelName.toLowerCase();
        this.mediaNamesRunningOrQueued.remove(nameKey);
        Deque<MediaRequest> queue = this.mediaQueues.get(ownerId);
        MediaRequest next = null;
        if (queue != null) {
            Deque<MediaRequest> deque = queue;
            synchronized (deque) {
                next = queue.pollFirst();
            }
        }
        if (next != null) {
            this.startMediaProcessing(ownerId, next);
        } else {
            this.mediaActive.remove(ownerId);
        }
    }

    private boolean isValidMediaUrl(String url) {
        if (url == null || url.trim().isEmpty()) {
            return false;
        }
        return (url = url.toLowerCase()).startsWith("http://") || url.startsWith("https://");
    }

    private void createPlayerModel(CommandSender sender, String type, String modelName, String playerName, int resolution, double scale, boolean isTemporary) {
        try {
            String imageUrl = type.equals("player_avatar") ? "https://minotar.net/avatar/" + playerName + "/" + resolution : "https://minotar.net/armor/body/" + playerName + "/" + resolution + ".png";
            URL url = new URL(imageUrl);
            BufferedImage image = ImageIO.read(url);
            if (image == null) {
                this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> sender.sendMessage("\u00a79DustLab \u00a7c\u00bb \u00a77Failed to download image for player \u00a7f" + playerName + "\u00a77."));
                return;
            }
            List<ParticleData> particles = this.convertImageToParticles(image, scale);
            ParticleModel model = new ParticleModel();
            model.setName(modelName);
            model.setParticles(particles);
            HashMap<String, Object> metadata = new HashMap<String, Object>();
            metadata.put("generatedBy", "DustLab v1.1");
            metadata.put("website", "https://winss.xyz/dustlab");
            metadata.put("generatedOn", Instant.now().toString());
            metadata.put("sourceFile", imageUrl);
            metadata.put("particleCount", particles.size());
            HashMap<String, Object> settings = new HashMap<String, Object>();
            settings.put("outputWidth", (int)((double)image.getWidth() * scale / (double)Math.max(image.getWidth(), image.getHeight())));
            settings.put("outputHeight", (int)((double)image.getHeight() * scale / (double)Math.max(image.getWidth(), image.getHeight())));
            settings.put("particleScale", scale);
            settings.put("coordinateMode", "local");
            settings.put("coordinateAxis", "X-Y");
            settings.put("rotation", 0);
            settings.put("version", "1.20.4+");
            settings.put("colorFixed", false);
            settings.put("animationType", type);
            settings.put("playerName", playerName);
            settings.put("resolution", resolution);
            metadata.put("settings", settings);
            model.setMetadata(metadata);
            this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> {
                try {
                    this.plugin.getParticleModelManager().saveModel(model, isTemporary);
                    sender.sendMessage("\u00a79DustLab \u00a7b\u00bb \u00a77Successfully created model \u00a7b" + modelName + "\u00a77 with \u00a7b" + particles.size() + "\u00a77 particles!");
                    if (isTemporary) {
                        sender.sendMessage("\u00a79DustLab \u00a77\u00bb \u00a77Model will be automatically removed after configured time.");
                    }
                }
                catch (Exception e) {
                    sender.sendMessage("\u00a79DustLab \u00a7c\u00bb \u00a77Failed to save model: " + e.getMessage());
                }
            });
        }
        catch (IOException e) {
            this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> sender.sendMessage("\u00a79DustLab \u00a7c\u00bb \u00a77Failed to download player skin. Check if player name is valid."));
        }
    }

    private List<ParticleData> convertImageToParticles(BufferedImage image, double scale) {
        ArrayList<ParticleData> particles = new ArrayList<ParticleData>();
        int width = image.getWidth();
        int height = image.getHeight();
        double particleSpacing = scale / (double)Math.max(width, height);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int rgb = image.getRGB(x, y);
                int alpha = rgb >> 24 & 0xFF;
                int red = rgb >> 16 & 0xFF;
                int green = rgb >> 8 & 0xFF;
                int blue = rgb & 0xFF;
                if (alpha < 128) continue;
                double particleX = (double)x * particleSpacing - (double)width * particleSpacing / 2.0;
                double particleY = (double)(height - 1 - y) * particleSpacing - (double)height * particleSpacing / 2.0;
                double particleZ = 0.0;
                ParticleData particle = new ParticleData();
                particle.setX(particleX);
                particle.setY(particleY);
                particle.setZ(particleZ);
                particle.setR((double)red / 255.0);
                particle.setG((double)green / 255.0);
                particle.setB((double)blue / 255.0);
                particle.setDelay(0);
                particles.add(particle);
            }
        }
        return particles;
    }

    private boolean handleDelete(CommandSender sender, String[] args) {
        if (!sender.hasPermission("dustlab.delete")) {
            sender.sendMessage("\u00a79DustLab \u00a7c\u00bb \u00a77You don't have permission to delete models (dustlab.delete).");
            return true;
        }
        if (args.length < 2) {
            sender.sendMessage("\u00a79DustLab \u00a7c\u00bb \u00a77Usage: /dl delete <modelName>");
            return true;
        }
        String modelName = args[1];
        if (!this.plugin.getParticleModelManager().hasModel(modelName)) {
            sender.sendMessage("\u00a79DustLab \u00a7c\u00bb \u00a77Model '\u00a7f" + modelName + "\u00a77' not found.");
            return true;
        }
        if (args.length > 2 && args[2].equalsIgnoreCase("confirm")) {
            sender.sendMessage("\u00a79DustLab \u00a7e\u00bb \u00a77Inline confirmation is no longer supported. Please run \u00a7b/dl confirm\u00a77.");
        }
        UUID who = sender instanceof Player ? ((Player)sender).getUniqueId() : CONSOLE_UUID;
        int timeoutSec = this.plugin.getDustLabConfig().getDeleteConfirmTimeoutSeconds();
        long expiresAt = System.currentTimeMillis() + (long)timeoutSec * 1000L;
        this.pendingDeletions.put(who, new PendingDeletion(modelName, expiresAt));
        sender.sendMessage("\u00a79DustLab \u00a7c\u00bb \u00a77Are you sure you want to delete '\u00a7f" + modelName + "\u00a77'? Run \u00a7b/dl confirm\u00a77 within \u00a7b" + timeoutSec + "\u00a77 seconds to proceed.");
        this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            PendingDeletion pd = this.pendingDeletions.get(who);
            if (pd != null && System.currentTimeMillis() >= pd.expiresAtMillis) {
                this.pendingDeletions.remove(who);
            }
        }, (long)timeoutSec * 20L);
        return true;
    }

    private boolean handleConfirm(CommandSender sender, String[] args) {
        if (!sender.hasPermission("dustlab.delete")) {
            sender.sendMessage("\u00a79DustLab \u00a7c\u00bb \u00a77You don't have permission to confirm deletions (dustlab.delete).");
            return true;
        }
        UUID who = sender instanceof Player ? ((Player)sender).getUniqueId() : CONSOLE_UUID;
        PendingDeletion pd = this.pendingDeletions.get(who);
        if (pd == null) {
            sender.sendMessage("\u00a79DustLab \u00a7e\u00bb \u00a77You have no pending deletions. Run \u00a7b/dl delete <model>\u00a77 first.");
            return true;
        }
        if (System.currentTimeMillis() > pd.expiresAtMillis) {
            this.pendingDeletions.remove(who);
            sender.sendMessage("\u00a79DustLab \u00a7e\u00bb \u00a77Your deletion request expired. Run \u00a7b/dl delete <model>\u00a77 again.");
            return true;
        }
        String modelName = pd.modelName;
        this.pendingDeletions.remove(who);
        if (!this.plugin.getParticleModelManager().hasModel(modelName)) {
            sender.sendMessage("\u00a79DustLab \u00a7c\u00bb \u00a77Model '\u00a7f" + modelName + "\u00a77' not found.");
            return true;
        }
        boolean success = this.plugin.getParticleModelManager().deleteModel(modelName);
        if (success) {
            sender.sendMessage("\u00a79DustLab \u00a7b\u00bb \u00a77Successfully deleted model '\u00a7f" + modelName + "\u00a77'.");
        } else {
            sender.sendMessage("\u00a79DustLab \u00a7c\u00bb \u00a77Failed to delete model '\u00a7f" + modelName + "\u00a77'. Check console for details.");
        }
        return true;
    }

    private static class MediaRequest {
        final CommandSender sender;
        final String modelName;
        final String url;
        final int blockWidth;
        final int blockHeight;
        final int maxParticles;
        final int frameSkip;
        final boolean isTemporary;
        final boolean gzip;

        MediaRequest(CommandSender sender, String modelName, String url, int blockWidth, int blockHeight, int maxParticles, int frameSkip, boolean isTemporary, boolean gzip) {
            this.sender = sender;
            this.modelName = modelName;
            this.url = url;
            this.blockWidth = blockWidth;
            this.blockHeight = blockHeight;
            this.maxParticles = maxParticles;
            this.frameSkip = frameSkip;
            this.isTemporary = isTemporary;
            this.gzip = gzip;
        }
    }

    private static class PendingDeletion {
        final String modelName;
        final long expiresAtMillis;

        PendingDeletion(String modelName, long expiresAtMillis) {
            this.modelName = modelName;
            this.expiresAtMillis = expiresAtMillis;
        }
    }
}

