/*
 * Decompiled with CFR 0.152.
 */
package com.winss.dustlab.config;

import com.winss.dustlab.DustLab;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class DustLabConfig {
    private final DustLab plugin;
    private File configFile;
    private FileConfiguration config;
    private int maxParticlesPerTickPerModel = 250;
    private int tempModelLifetimeMinutes = 30;
    private int largeModelThreshold = 4500;
    private int veryLargeModelThreshold = 15000;
    private int particlesPerBatch = 500;
    private boolean progressiveLoadingEnabled = true;
    private int progressiveLargeModelThreshold = 50000;
    private int progressiveParseBatchSize = 5000;
    private int progressiveApplyBatchPerTick = 2500;
    private int progressiveProgressLogPercent = 10;
    private int progressiveMaxConcurrent = 2;
    private double maxRenderDistance = 48.0;
    private boolean enableAutoSave = true;
    private int autoSaveIntervalMinutes = 30;
    private boolean enableAntiEpilepsy = true;
    private int fadeInDurationTicks = 40;
    private float mediaParticleScale = 1.25f;
    private AnimatedParticleMode animatedParticleMode = AnimatedParticleMode.REDSTONE;
    private int mediaParticleLifespanTicks = 1;
    private int mediaMaxFrames = 150;
    private int mediaMaxFileSizeMB = 25;
    private boolean mediaDefaultGzip = false;
    private String messagePrefix = "&9DustLab &b\u00bb";
    private boolean consoleUseColors = false;
    private boolean consoleCleanOutput = true;
    private boolean verboseLogging = false;
    private int deleteConfirmTimeoutSeconds = 30;

    public DustLabConfig(DustLab plugin) {
        this.plugin = plugin;
        this.configFile = new File(plugin.getDataFolder(), "dustlab-config.yml");
        this.loadConfig();
    }

    private void loadConfig() {
        if (!this.configFile.exists()) {
            this.createDefaultConfig();
        }
        this.config = YamlConfiguration.loadConfiguration((File)this.configFile);
        this.maxParticlesPerTickPerModel = this.config.getInt("performance.max-particles-per-tick-per-model", 250);
        this.tempModelLifetimeMinutes = this.config.getInt("temp-models.lifetime-minutes", 30);
        this.largeModelThreshold = this.config.getInt("performance.large-model-threshold", 4500);
        this.veryLargeModelThreshold = this.config.getInt("performance.very-large-model-threshold", 15000);
        this.particlesPerBatch = this.config.getInt("performance.particles-per-batch", 500);
        this.progressiveLoadingEnabled = this.config.getBoolean("progressive.enabled", true);
        this.progressiveLargeModelThreshold = this.config.getInt("progressive.large-model-threshold", 50000);
        this.progressiveParseBatchSize = this.config.getInt("progressive.parse-batch-size", 5000);
        this.progressiveApplyBatchPerTick = this.config.getInt("progressive.apply-batch-per-tick", 2500);
        this.progressiveProgressLogPercent = this.config.getInt("progressive.progress-log-interval-percent", 10);
        this.progressiveMaxConcurrent = Math.max(1, this.config.getInt("progressive.max-async-loads", 2));
        this.maxRenderDistance = this.config.getDouble("performance.max-render-distance", 48.0);
        this.enableAutoSave = this.config.getBoolean("persistence.enable-auto-save", true);
        this.autoSaveIntervalMinutes = this.config.getInt("persistence.auto-save-interval-minutes", 30);
        this.enableAntiEpilepsy = this.config.getBoolean("safety.enable-anti-epilepsy", true);
        this.fadeInDurationTicks = this.config.getInt("safety.fade-in-duration-ticks", 40);
        this.mediaParticleScale = (float)this.config.getDouble("media.particle-scale", 1.25);
        try {
            String modeStr = this.config.getString("media.animated-particle-mode", "REDSTONE");
            this.animatedParticleMode = AnimatedParticleMode.valueOf(modeStr.toUpperCase());
        }
        catch (Exception e) {
            this.animatedParticleMode = AnimatedParticleMode.REDSTONE;
        }
        this.mediaParticleLifespanTicks = this.config.getInt("media.particle-lifespan-ticks", 1);
        this.mediaMaxFrames = this.config.getInt("media.max-frames", 150);
        this.mediaMaxFileSizeMB = this.config.getInt("media.max-file-size-mb", 25);
        this.mediaDefaultGzip = this.config.getBoolean("media.default-gzip", false);
        this.deleteConfirmTimeoutSeconds = this.config.getInt("delete.confirm-timeout-seconds", 30);
        this.messagePrefix = this.config.getString("messages.prefix", "&9DustLab &b\u00bb");
        this.consoleUseColors = this.config.getBoolean("messages.console.use-colors", false);
        this.consoleCleanOutput = this.config.getBoolean("messages.console.clean-output", true);
        this.verboseLogging = this.config.getBoolean("messages.console.verbose-logging", false);
        this.plugin.getLogger().info("Configuration loaded successfully");
    }

    private void createDefaultConfig() {
        try {
            this.configFile.getParentFile().mkdirs();
            this.configFile.createNewFile();
            this.config = new YamlConfiguration();
            this.config.set("performance.max-particles-per-tick-per-model", (Object)250);
            this.config.set("performance.large-model-threshold", (Object)4500);
            this.config.set("performance.very-large-model-threshold", (Object)15000);
            this.config.set("performance.particles-per-batch", (Object)500);
            this.config.set("progressive.enabled", (Object)true);
            this.config.set("progressive.large-model-threshold", (Object)50000);
            this.config.set("progressive.parse-batch-size", (Object)5000);
            this.config.set("progressive.apply-batch-per-tick", (Object)2500);
            this.config.set("progressive.progress-log-interval-percent", (Object)10);
            this.config.set("progressive.max-async-loads", (Object)2);
            this.config.set("performance.max-render-distance", (Object)48.0);
            this.config.set("temp-models.lifetime-minutes", (Object)30);
            this.config.set("temp-models.cleanup-on-startup", (Object)true);
            this.config.set("persistence.enable-auto-save", (Object)true);
            this.config.set("persistence.auto-save-interval-minutes", (Object)30);
            this.config.set("persistence.backup-before-save", (Object)false);
            this.config.set("safety.enable-anti-epilepsy", (Object)true);
            this.config.set("safety.fade-in-duration-ticks", (Object)40);
            this.config.set("safety.max-concurrent-models", (Object)10);
            this.config.set("model-creation.max-resolution", (Object)512);
            this.config.set("model-creation.min-resolution", (Object)8);
            this.config.set("model-creation.max-scale", (Object)50.0);
            this.config.set("model-creation.default-scale", (Object)5.0);
            this.config.set("media.particle-scale", (Object)1.25);
            this.config.set("media.animated-particle-mode", (Object)"REDSTONE");
            this.config.set("media.particle-lifespan-ticks", (Object)1);
            this.config.set("media.max-frames", (Object)150);
            this.config.set("media.max-file-size-mb", (Object)25);
            this.config.set("media.default-gzip", (Object)false);
            this.config.set("delete.confirm-timeout-seconds", (Object)30);
            this.config.set("messages.prefix", (Object)"&9DustLab &b\u00bb");
            this.config.set("messages.console.use-colors", (Object)false);
            this.config.set("messages.console.clean-output", (Object)true);
            this.config.set("messages.console.verbose-logging", (Object)false);
            this.config.set("colors.primary", (Object)"&9");
            this.config.set("colors.accent", (Object)"&b");
            this.config.set("colors.text", (Object)"&f");
            this.config.set("colors.secondary", (Object)"&7");
            this.config.set("colors.success", (Object)"&a");
            this.config.set("colors.error", (Object)"&c");
            this.config.set("colors.warning", (Object)"&e");
            this.config.setComments("safety", Arrays.asList("Safety settings for rapid flashing prevention and performance protection (you do not want to know why it was named like that)", "enable-anti-epilepsy: Enables fade-in effects and limits rapid flashing (default: true)", "fade-in-duration-ticks: Duration of fade-in effect in ticks (default: 40 = 2 seconds)", "max-concurrent-models: Maximum number of models that can play simultaneously (default: 10)"));
            this.config.setComments("persistence", Arrays.asList("Settings for model saving and auto-save functionality", "enable-auto-save: Whether to automatically save models periodically (default: true)", "auto-save-interval-minutes: Minutes between automatic saves (default: 30)", "backup-before-save: Whether to create backup before saving (default: false)"));
            this.config.setComments("model-creation", Arrays.asList("Limits and defaults for creating new particle models", "max-resolution: Maximum image resolution allowed for media models (default: 512)", "min-resolution: Minimum image resolution required (default: 8)", "max-scale: Maximum scale multiplier allowed (default: 50.0)", "default-scale: Default scale when none specified (default: 5.0)"));
            this.config.setComments("media", Arrays.asList("Settings specific to media (image/GIF) processing", "particle-scale: Scale multiplier for media-based particles (default: 1.25)", "animated-particle-mode: Particle type for animated frames: REDSTONE or TRANSITION (default: REDSTONE)", "max-frames: Maximum number of frames to import from media (default: 150)", "max-file-size-mb: Maximum download size for media files in megabytes (default: 25)", "default-gzip: If true, '/dl create media' saves models as .json.gz unless the user explicitly omits it"));
            this.config.setComments("media", Arrays.asList("Media processing settings", "particle-scale: Scale factor for particles when creating models from images/GIFs (default: 1.25)"));
            this.config.setComments("messages", Arrays.asList("Message and UI configuration", "prefix: Chat prefix for player messages (supports color codes with &)", "console.use-colors: Whether to use ANSI colors in console output (default: false)", "console.clean-output: Whether to strip color codes from console messages (default: true)", "console.verbose-logging: Show detailed operational messages in console (default: false)"));
            this.config.setComments("delete", Arrays.asList("Delete confirmation settings", "confirm-timeout-seconds: Time window for '/dl confirm' after '/dl delete <model>' (default: 30)"));
            this.config.save(this.configFile);
            this.plugin.getLogger().info("Created default configuration file");
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("DustLab: Failed to create config file: " + e.getMessage());
        }
    }

    public void reloadConfig() {
        this.loadConfig();
    }

    public void saveConfig() {
        try {
            this.config.save(this.configFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("DustLab: Failed to save config file: " + e.getMessage());
        }
    }

    public int getMaxParticlesPerTickPerModel() {
        return this.maxParticlesPerTickPerModel;
    }

    public int getTempModelLifetimeMinutes() {
        return this.tempModelLifetimeMinutes;
    }

    public int getLargeModelThreshold() {
        return this.largeModelThreshold;
    }

    public int getVeryLargeModelThreshold() {
        return this.veryLargeModelThreshold;
    }

    public int getParticlesPerBatch() {
        return this.particlesPerBatch;
    }

    public double getMaxRenderDistance() {
        return this.maxRenderDistance;
    }

    public boolean isProgressiveLoadingEnabled() {
        return this.progressiveLoadingEnabled;
    }

    public int getProgressiveLargeModelThreshold() {
        return this.progressiveLargeModelThreshold;
    }

    public int getProgressiveParseBatchSize() {
        return this.progressiveParseBatchSize;
    }

    public int getProgressiveApplyBatchPerTick() {
        return this.progressiveApplyBatchPerTick;
    }

    public int getProgressiveProgressLogPercent() {
        return this.progressiveProgressLogPercent;
    }

    public int getProgressiveMaxConcurrent() {
        return this.progressiveMaxConcurrent;
    }

    public boolean isAutoSaveEnabled() {
        return this.enableAutoSave;
    }

    public int getAutoSaveIntervalMinutes() {
        return this.autoSaveIntervalMinutes;
    }

    public boolean isAntiEpilepsyEnabled() {
        return this.enableAntiEpilepsy;
    }

    public int getFadeInDurationTicks() {
        return this.fadeInDurationTicks;
    }

    public float getMediaParticleScale() {
        return this.mediaParticleScale;
    }

    public AnimatedParticleMode getAnimatedParticleMode() {
        return this.animatedParticleMode;
    }

    public int getMediaParticleLifespanTicks() {
        return this.mediaParticleLifespanTicks;
    }

    public int getMediaMaxFrames() {
        return this.mediaMaxFrames;
    }

    public int getMediaMaxFileSizeMB() {
        return this.mediaMaxFileSizeMB;
    }

    public long getMediaMaxFileSizeBytes() {
        return (long)this.mediaMaxFileSizeMB * 1024L * 1024L;
    }

    public boolean isMediaDefaultGzipEnabled() {
        return this.mediaDefaultGzip;
    }

    public int getDeleteConfirmTimeoutSeconds() {
        return this.deleteConfirmTimeoutSeconds;
    }

    public String getMessagePrefix() {
        return this.messagePrefix;
    }

    public boolean isConsoleUseColors() {
        return this.consoleUseColors;
    }

    public boolean isConsoleCleanOutput() {
        return this.consoleCleanOutput;
    }

    public boolean isVerboseLogging() {
        return this.verboseLogging;
    }

    public long getTempModelLifetimeTicks() {
        return (long)(this.tempModelLifetimeMinutes * 60) * 20L;
    }

    public double getMaxRenderDistanceSquared() {
        return this.maxRenderDistance * this.maxRenderDistance;
    }

    public static enum AnimatedParticleMode {
        REDSTONE,
        TRANSITION;

    }
}

