/*
 * Decompiled with CFR 0.152.
 */
package com.winss.dustlab.effects;

import com.winss.dustlab.models.ParticleData;
import org.bukkit.Location;
import org.bukkit.util.Vector;

public class ParticleEffects {
    public static Location applyRotation(ParticleData particle, Location baseLocation, double rotationAngle, boolean rotateX, boolean rotateY, boolean rotateZ) {
        double newX;
        double newZ;
        double x = particle.getX();
        double y = particle.getY();
        double z = particle.getZ();
        if (rotateX) {
            double cosX = Math.cos(rotationAngle);
            double sinX = Math.sin(rotationAngle);
            double newY = y * cosX - z * sinX;
            newZ = y * sinX + z * cosX;
            y = newY;
            z = newZ;
        }
        if (rotateY) {
            double cosY = Math.cos(rotationAngle);
            double sinY = Math.sin(rotationAngle);
            newX = x * cosY - z * sinY;
            newZ = x * sinY + z * cosY;
            x = newX;
            z = newZ;
        }
        if (rotateZ) {
            double cosZ = Math.cos(rotationAngle);
            double sinZ = Math.sin(rotationAngle);
            newX = x * cosZ - y * sinZ;
            double newY = x * sinZ + y * cosZ;
            x = newX;
            y = newY;
        }
        return baseLocation.clone().add(x, y, z);
    }

    public static Location applyRotation(ParticleData particle, Location baseLocation, double rotationAngle) {
        return ParticleEffects.applyRotation(particle, baseLocation, rotationAngle, false, true, false);
    }

    public static Location applyOscillation(ParticleData particle, Location baseLocation, double oscillationPhase, double amplitude) {
        double oscillationValue = 1.0 + Math.sin(oscillationPhase) * amplitude;
        double x = particle.getX() * oscillationValue;
        double y = particle.getY() * oscillationValue;
        double z = particle.getZ() * oscillationValue;
        return baseLocation.clone().add(x, y, z);
    }

    public static Location applyPulse(ParticleData particle, Location baseLocation, double pulsePhase, double pulseAmplitude) {
        double pulseValue = 1.0 + Math.sin(pulsePhase * 2.0) * pulseAmplitude;
        double x = particle.getX() * pulseValue;
        double y = particle.getY() * pulseValue;
        double z = particle.getZ() * pulseValue;
        return baseLocation.clone().add(x, y, z);
    }

    public static Location applyBounce(ParticleData particle, Location baseLocation, double bouncePhase, double bounceHeight) {
        double bounceOffset = Math.abs(Math.sin(bouncePhase)) * bounceHeight;
        return baseLocation.clone().add(particle.getX(), particle.getY() + bounceOffset, particle.getZ());
    }

    public static Location applyFlow(ParticleData particle, Location baseLocation, double flowPhase, double flowSpeed) {
        double flowOffset = Math.sin(flowPhase) * flowSpeed;
        return baseLocation.clone().add(particle.getX() + flowOffset, particle.getY(), particle.getZ());
    }

    public static Location applySwirl(ParticleData particle, Location baseLocation, double swirlPhase, double swirlRadius) {
        double distance = Math.sqrt(particle.getX() * particle.getX() + particle.getZ() * particle.getZ());
        double angle = Math.atan2(particle.getZ(), particle.getX()) + swirlPhase * distance;
        double x = distance * Math.cos(angle);
        double z = distance * Math.sin(angle);
        return baseLocation.clone().add(x, particle.getY(), z);
    }

    public static Location applyWaveEffect(ParticleData particle, Location baseLocation, double wavePhase, double waveAmplitude) {
        double distance = Math.sqrt(particle.getX() * particle.getX() + particle.getZ() * particle.getZ());
        double waveOffset = Math.sin(wavePhase + distance * 0.5) * waveAmplitude;
        return baseLocation.clone().add(particle.getX(), particle.getY() + waveOffset, particle.getZ());
    }

    public static Location applyOrbit(ParticleData particle, Location baseLocation, double orbitAngle, double orbitRadius) {
        Location particlePos = baseLocation.clone().add(particle.getX(), particle.getY(), particle.getZ());
        double orbitX = Math.cos(orbitAngle) * orbitRadius;
        double orbitZ = Math.sin(orbitAngle) * orbitRadius;
        return particlePos.add(orbitX, 0.0, orbitZ);
    }

    public static Location applySpiralEffect(ParticleData particle, Location baseLocation, double spiralPhase, double spiralExpansion) {
        double distance = Math.sqrt(particle.getX() * particle.getX() + particle.getZ() * particle.getZ());
        double angle = Math.atan2(particle.getZ(), particle.getX()) + spiralPhase;
        double newDistance = distance + spiralExpansion;
        double newX = Math.cos(angle) * newDistance;
        double newZ = Math.sin(angle) * newDistance;
        return baseLocation.clone().add(newX, particle.getY(), newZ);
    }

    public static Location applyTwirl(Location baseLocation, Location currentLocation, double twirlPhase, double radiusOffset, double heightAmplitude) {
        Vector offset = currentLocation.clone().subtract(baseLocation).toVector();
        double distance = Math.sqrt(offset.getX() * offset.getX() + offset.getZ() * offset.getZ());
        double angle = Math.atan2(offset.getZ(), offset.getX()) + twirlPhase;
        double adjustedRadius = Math.max(0.0, distance + Math.sin(twirlPhase) * radiusOffset);
        double y = offset.getY() + Math.sin(twirlPhase + distance) * heightAmplitude;
        double x = Math.cos(angle) * adjustedRadius;
        double z = Math.sin(angle) * adjustedRadius;
        return baseLocation.clone().add(x, y, z);
    }

    public static Location applyWobble(Location baseLocation, Location currentLocation, double wobblePhase, double amplitude) {
        if (amplitude == 0.0) {
            return currentLocation;
        }
        Vector offset = currentLocation.clone().subtract(baseLocation).toVector();
        double wobbleX = Math.sin(wobblePhase + offset.getY()) * amplitude;
        double wobbleZ = Math.cos(wobblePhase + offset.getX()) * amplitude;
        double wobbleY = Math.sin(wobblePhase * 0.5 + offset.length()) * amplitude * 0.5;
        offset.add(new Vector(wobbleX, wobbleY, wobbleZ));
        return baseLocation.clone().add(offset);
    }

    public static Location applyBurst(Location baseLocation, Location currentLocation, double burstPhase, double amplitude) {
        if (amplitude == 0.0) {
            return currentLocation;
        }
        Vector offset = currentLocation.clone().subtract(baseLocation).toVector();
        double scale = 1.0 + Math.sin(burstPhase) * amplitude;
        offset.multiply(scale);
        return baseLocation.clone().add(offset);
    }

    public static Location applyEffects(ParticleData particle, Location baseLocation, EffectSettings settings, long tickTime) {
        Location result = baseLocation.clone().add(particle.getX(), particle.getY(), particle.getZ());
        if (settings.rotationSpeed != 0.0) {
            double rotationAngle = (double)tickTime * settings.rotationSpeed % (Math.PI * 2);
            result = ParticleEffects.applyRotation(particle, baseLocation, rotationAngle, settings.rotateX, settings.rotateY, settings.rotateZ);
        }
        if (settings.oscillationAmplitude > 0.0) {
            double oscillationPhase = (double)tickTime * settings.oscillationSpeed;
            result = ParticleEffects.applyOscillation(particle, result.subtract(baseLocation), oscillationPhase, settings.oscillationAmplitude);
            result = baseLocation.clone().add(result.getX(), result.getY(), result.getZ());
        }
        if (settings.pulseAmplitude > 0.0) {
            double pulsePhase = (double)tickTime * settings.pulseSpeed;
            result = ParticleEffects.applyPulse(particle, baseLocation, pulsePhase, settings.pulseAmplitude);
        }
        if (settings.bounceHeight > 0.0) {
            double bouncePhase = (double)tickTime * settings.bounceSpeed;
            result = ParticleEffects.applyBounce(particle, result, bouncePhase, settings.bounceHeight);
        }
        if (settings.flowAmplitude > 0.0) {
            double flowPhase = (double)tickTime * settings.flowSpeed;
            result = ParticleEffects.applyFlow(particle, result, flowPhase, settings.flowAmplitude);
        }
        if (settings.swirlRadius > 0.0) {
            double swirlPhase = (double)tickTime * settings.swirlSpeed;
            result = ParticleEffects.applySwirl(particle, baseLocation, swirlPhase, settings.swirlRadius);
        }
        if (settings.waveAmplitude > 0.0) {
            double wavePhase = (double)tickTime * settings.waveSpeed;
            result = ParticleEffects.applyWaveEffect(particle, baseLocation, wavePhase, settings.waveAmplitude);
        }
        if (settings.twirlRadiusOffset != 0.0 || settings.twirlHeightAmplitude != 0.0) {
            double twirlPhase = (double)tickTime * settings.twirlSpeed;
            result = ParticleEffects.applyTwirl(baseLocation, result, twirlPhase, settings.twirlRadiusOffset, settings.twirlHeightAmplitude);
        }
        if (settings.wobbleAmplitude > 0.0) {
            double wobblePhase = (double)tickTime * settings.wobbleSpeed;
            result = ParticleEffects.applyWobble(baseLocation, result, wobblePhase, settings.wobbleAmplitude);
        }
        if (settings.orbitRadius > 0.0) {
            double orbitAngle = (double)tickTime * settings.orbitSpeed;
            result = ParticleEffects.applyOrbit(particle, result, orbitAngle, settings.orbitRadius);
        }
        if (settings.burstAmplitude > 0.0) {
            double burstPhase = (double)tickTime * settings.burstSpeed;
            result = ParticleEffects.applyBurst(baseLocation, result, burstPhase, settings.burstAmplitude);
        }
        if (settings.spiralExpansion != 0.0) {
            double spiralPhase = (double)tickTime * settings.spiralSpeed;
            result = ParticleEffects.applySpiralEffect(particle, baseLocation, spiralPhase, settings.spiralExpansion);
        }
        return result;
    }

    public static class EffectSettings {
        public double rotationSpeed = 0.0;
        public boolean rotateX = false;
        public boolean rotateY = true;
        public boolean rotateZ = false;
        public double oscillationSpeed = 0.1;
        public double oscillationAmplitude = 0.0;
        public double pulseSpeed = 0.2;
        public double pulseAmplitude = 0.0;
        public double bounceSpeed = 0.15;
        public double bounceHeight = 0.0;
        public double flowSpeed = 0.1;
        public double flowAmplitude = 0.0;
        public double swirlSpeed = 0.05;
        public double swirlRadius = 0.0;
        public double waveSpeed = 0.1;
        public double waveAmplitude = 0.0;
        public double twirlSpeed = 0.05;
        public double twirlRadiusOffset = 0.0;
        public double twirlHeightAmplitude = 0.0;
        public double wobbleSpeed = 0.12;
        public double wobbleAmplitude = 0.0;
        public double orbitSpeed = 0.05;
        public double orbitRadius = 0.0;
        public double burstSpeed = 0.08;
        public double burstAmplitude = 0.0;
        public double spiralSpeed = 0.02;
        public double spiralExpansion = 0.0;

        public boolean hasEffects() {
            return this.rotationSpeed != 0.0 || this.oscillationAmplitude != 0.0 || this.pulseAmplitude != 0.0 || this.bounceHeight != 0.0 || this.flowAmplitude != 0.0 || this.swirlRadius != 0.0 || this.waveAmplitude != 0.0 || this.twirlRadiusOffset != 0.0 || this.twirlHeightAmplitude != 0.0 || this.wobbleAmplitude != 0.0 || this.orbitRadius != 0.0 || this.burstAmplitude != 0.0 || this.spiralExpansion != 0.0;
        }

        public static EffectSettings createRotation(double speed, String axes) {
            EffectSettings settings = new EffectSettings();
            settings.rotationSpeed = speed * 0.05;
            settings.rotateX = axes.toLowerCase().contains("x");
            settings.rotateY = axes.toLowerCase().contains("y");
            settings.rotateZ = axes.toLowerCase().contains("z");
            if (!(settings.rotateX || settings.rotateY || settings.rotateZ)) {
                settings.rotateY = true;
            }
            return settings;
        }

        public static EffectSettings createRotation(double speed) {
            return EffectSettings.createRotation(speed, "y");
        }

        public static EffectSettings createOscillation(double speed) {
            EffectSettings settings = new EffectSettings();
            settings.oscillationSpeed = speed * 0.1;
            settings.oscillationAmplitude = 0.3;
            return settings;
        }

        public static EffectSettings createPulse(double speed) {
            EffectSettings settings = new EffectSettings();
            settings.pulseSpeed = speed * 0.2;
            settings.pulseAmplitude = 0.4;
            return settings;
        }

        public static EffectSettings createBounce(double speed) {
            EffectSettings settings = new EffectSettings();
            settings.bounceSpeed = speed * 0.15;
            settings.bounceHeight = 1.5;
            return settings;
        }

        public static EffectSettings createFlow(double speed) {
            EffectSettings settings = new EffectSettings();
            settings.flowSpeed = speed * 0.1;
            settings.flowAmplitude = 2.0;
            return settings;
        }

        public static EffectSettings createSwirl(double speed) {
            EffectSettings settings = new EffectSettings();
            settings.swirlSpeed = speed * 0.05;
            settings.swirlRadius = 1.0;
            return settings;
        }

        public static EffectSettings createWave(double speed) {
            EffectSettings settings = new EffectSettings();
            settings.waveSpeed = speed * 0.1;
            settings.waveAmplitude = 1.0;
            return settings;
        }

        public static EffectSettings createTwirl(double speed) {
            EffectSettings settings = new EffectSettings();
            settings.twirlSpeed = speed * 0.05;
            settings.twirlRadiusOffset = 0.4;
            settings.twirlHeightAmplitude = 0.25;
            return settings;
        }

        public static EffectSettings createWobble(double speed) {
            EffectSettings settings = new EffectSettings();
            settings.wobbleSpeed = speed * 0.12;
            settings.wobbleAmplitude = 0.35;
            return settings;
        }

        public static EffectSettings createOrbit(double speed) {
            EffectSettings settings = new EffectSettings();
            settings.orbitSpeed = speed * 0.05;
            settings.orbitRadius = 2.0;
            return settings;
        }

        public static EffectSettings createBurst(double speed) {
            EffectSettings settings = new EffectSettings();
            settings.burstSpeed = speed * 0.08;
            settings.burstAmplitude = 0.3;
            return settings;
        }

        public static EffectSettings createSpiral(double speed) {
            EffectSettings settings = new EffectSettings();
            settings.spiralSpeed = speed * 0.02;
            settings.spiralExpansion = 0.01;
            return settings;
        }

        public static EffectSettings rotate(double speed) {
            return EffectSettings.createRotation(speed);
        }

        public static EffectSettings breathe(double amplitude) {
            EffectSettings settings = new EffectSettings();
            settings.oscillationAmplitude = amplitude;
            return settings;
        }

        public static EffectSettings wave(double amplitude) {
            EffectSettings settings = new EffectSettings();
            settings.waveAmplitude = amplitude;
            return settings;
        }

        public static EffectSettings twirl(double radiusOffset, double heightAmplitude) {
            EffectSettings settings = new EffectSettings();
            settings.twirlRadiusOffset = radiusOffset;
            settings.twirlHeightAmplitude = heightAmplitude;
            return settings;
        }

        public static EffectSettings wobble(double amplitude) {
            EffectSettings settings = new EffectSettings();
            settings.wobbleAmplitude = amplitude;
            return settings;
        }

        public static EffectSettings orbit(double radius) {
            EffectSettings settings = new EffectSettings();
            settings.orbitRadius = radius;
            return settings;
        }

        public static EffectSettings burst(double amplitude) {
            EffectSettings settings = new EffectSettings();
            settings.burstAmplitude = amplitude;
            return settings;
        }

        public static EffectSettings spiral(double expansion) {
            EffectSettings settings = new EffectSettings();
            settings.spiralExpansion = expansion;
            return settings;
        }

        public static EffectSettings parseEffect(String effectString) {
            if (effectString == null || effectString.trim().isEmpty()) {
                return null;
            }
            String effect = effectString.toLowerCase().trim();
            if (effect.startsWith("rotate")) {
                String[] parts;
                if (effect.contains("-") && (parts = effect.split("-", 2)).length == 2) {
                    String axes = parts[1];
                    return EffectSettings.createRotation(1.0, axes);
                }
                return EffectSettings.createRotation(1.0);
            }
            switch (effect) {
                case "oscillate": 
                case "breathe": {
                    return EffectSettings.createOscillation(1.0);
                }
                case "pulse": {
                    return EffectSettings.createPulse(1.0);
                }
                case "bounce": {
                    return EffectSettings.createBounce(1.0);
                }
                case "flow": {
                    return EffectSettings.createFlow(1.0);
                }
                case "swirl": {
                    return EffectSettings.createSwirl(1.0);
                }
                case "wave": {
                    return EffectSettings.createWave(1.0);
                }
                case "twirl": {
                    return EffectSettings.createTwirl(1.0);
                }
                case "wobble": {
                    return EffectSettings.createWobble(1.0);
                }
                case "orbit": {
                    return EffectSettings.createOrbit(1.0);
                }
                case "burst": {
                    return EffectSettings.createBurst(1.0);
                }
                case "spiral": {
                    return EffectSettings.createSpiral(1.0);
                }
            }
            return null;
        }
    }
}

