/*
 * Decompiled with CFR 0.152.
 */
package com.winss.dustlab.effects;

import com.winss.dustlab.models.ParticleData;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Color;

public class ParticleOptimizer {
    private static final double COLOR_DIFF_THRESHOLD = 0.02;
    private static final double ANIMATION_COLOR_DIFF_THRESHOLD = 0.01;
    private final Map<String, Map<String, ParticleState>> particleStates = new ConcurrentHashMap<String, Map<String, ParticleState>>();

    public boolean shouldUpdateParticle(String effectId, ParticleData particle, long currentTick) {
        String positionKey = this.getPositionKey(particle);
        Map effectStates = this.particleStates.computeIfAbsent(effectId, k -> new ConcurrentHashMap());
        Color particleColor = this.getParticleColor(particle);
        ParticleState state = (ParticleState)effectStates.get(positionKey);
        if (state == null) {
            state = new ParticleState(particleColor, currentTick);
            effectStates.put(positionKey, state);
            return true;
        }
        boolean shouldUpdate = state.shouldUpdate(particleColor, currentTick, this);
        if (shouldUpdate) {
            state.update(particleColor, currentTick);
        }
        return shouldUpdate;
    }

    public void cleanupEffect(String effectId, long currentTick, long maxAge) {
        Map<String, ParticleState> effectStates = this.particleStates.get(effectId);
        if (effectStates != null) {
            effectStates.entrySet().removeIf(entry -> currentTick - ((ParticleState)entry.getValue()).getLastUpdateTick() > maxAge);
            if (effectStates.isEmpty()) {
                this.particleStates.remove(effectId);
            }
        }
    }

    public void removeEffect(String effectId) {
        this.particleStates.remove(effectId);
    }

    public int getActiveEffectCount() {
        return this.particleStates.size();
    }

    public int getTotalParticleCount() {
        return this.particleStates.values().stream().mapToInt(Map::size).sum();
    }

    public long estimateMemoryBytes() {
        long effectOverhead = (long)this.particleStates.size() * 96L;
        long stateCount = this.getTotalParticleCount();
        long stateOverhead = stateCount * 112L;
        return effectOverhead + stateOverhead;
    }

    public void forceUpdateEffect(String effectId) {
        Map<String, ParticleState> effectStates = this.particleStates.get(effectId);
        if (effectStates != null) {
            effectStates.values().forEach(state -> {
                state.needsUpdate = true;
            });
        }
    }

    private String getPositionKey(ParticleData particle) {
        int x = (int)Math.round(particle.getX() * 100.0);
        int y = (int)Math.round(particle.getY() * 100.0);
        int z = (int)Math.round(particle.getZ() * 100.0);
        return x + "," + y + "," + z;
    }

    private Color getParticleColor(ParticleData particle) {
        return particle.getColor();
    }

    private double calculateColorDifference(Color color1, Color color2) {
        if (color1 == null || color2 == null) {
            return color1 != color2 ? 1.0 : 0.0;
        }
        double rDiff = (double)(color1.getRed() - color2.getRed()) / 255.0;
        double gDiff = (double)(color1.getGreen() - color2.getGreen()) / 255.0;
        double bDiff = (double)(color1.getBlue() - color2.getBlue()) / 255.0;
        return Math.sqrt(rDiff * rDiff + gDiff * gDiff + bDiff * bDiff) / Math.sqrt(3.0);
    }

    private static class ParticleState {
        private Color lastColor;
        private long lastUpdateTick;
        private boolean needsUpdate;

        public ParticleState(Color color, long tick) {
            this.lastColor = color;
            this.lastUpdateTick = tick;
            this.needsUpdate = true;
        }

        public boolean shouldUpdate(Color newColor, long currentTick, ParticleOptimizer optimizer) {
            if (this.needsUpdate) {
                this.needsUpdate = false;
                return true;
            }
            if (this.lastColor == null && newColor != null) {
                return true;
            }
            if (this.lastColor != null && newColor == null) {
                return true;
            }
            if (this.lastColor == null && newColor == null) {
                return false;
            }
            double colorDiff = optimizer.calculateColorDifference(this.lastColor, newColor);
            return colorDiff > 0.02;
        }

        public void update(Color newColor, long currentTick) {
            this.lastColor = newColor;
            this.lastUpdateTick = currentTick;
        }

        public long getLastUpdateTick() {
            return this.lastUpdateTick;
        }
    }
}

