/*
 * Decompiled with CFR 0.152.
 */
package com.winss.dustlab.managers;

import com.winss.dustlab.DustLab;
import com.winss.dustlab.config.DustLabConfig;
import com.winss.dustlab.effects.ParticleEffects;
import com.winss.dustlab.effects.ParticleOptimizer;
import com.winss.dustlab.libs.gson.Gson;
import com.winss.dustlab.libs.gson.GsonBuilder;
import com.winss.dustlab.libs.gson.JsonArray;
import com.winss.dustlab.libs.gson.JsonElement;
import com.winss.dustlab.libs.gson.JsonNull;
import com.winss.dustlab.libs.gson.JsonObject;
import com.winss.dustlab.libs.gson.JsonPrimitive;
import com.winss.dustlab.libs.gson.reflect.TypeToken;
import com.winss.dustlab.libs.gson.stream.JsonReader;
import com.winss.dustlab.libs.gson.stream.JsonWriter;
import com.winss.dustlab.media.AnimatedModel;
import com.winss.dustlab.media.FrameData;
import com.winss.dustlab.media.MediaProcessor;
import com.winss.dustlab.models.ParticleData;
import com.winss.dustlab.models.ParticleModel;
import com.winss.dustlab.packed.PackedParticleArray;
import com.winss.dustlab.utils.MessageUtils;
import java.awt.Color;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.lang.constant.Constable;
import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.security.MessageDigest;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.LongConsumer;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class ParticleModelManager {
    private static final int SMALL_MODEL_THRESHOLD = 100;
    private static final int MEDIUM_MODEL_THRESHOLD = 1000;
    private static final int LARGE_MODEL_THRESHOLD = 15000;
    private static final int ANIMATION_TICK_RATE = 1;
    private static final int STATIC_TICK_RATE = 3;
    private static final int LARGE_MODEL_TICK_RATE = 4;
    private static final int PARTICLES_PER_BATCH = 500;
    private static final int MAX_PARTICLES_PER_TICK = 200;
    private static final int LARGE_MODEL_THRESHOLD_STRICT = 4500;
    private static final double CLOSE_DISTANCE = 20.0;
    private static final double MEDIUM_DISTANCE = 50.0;
    private static final double FAR_DISTANCE = 100.0;
    private static final double MAX_RENDER_DISTANCE_SQUARED = 2304.0;
    private static final double MAX_RENDER_DISTANCE = Math.sqrt(2304.0);
    private final DustLab plugin;
    private final DustLabConfig config;
    private final Gson gson;
    private final Map<String, ParticleModel> loadedModels;
    private final Map<String, BukkitTask> activeEffects;
    private final Map<String, EffectInfo> activeEffectInfo;
    private final Map<Integer, String> effectIdMap;
    private final ParticleOptimizer particleOptimizer;
    private int nextEffectId = 1;
    private final Set<Integer> usedEffectIds = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<Integer> reservedForRestoreIds = Collections.newSetFromMap(new ConcurrentHashMap());
    private long lastSaveLogTime = 0L;
    private final Map<String, LoadJob> loadingJobs = new ConcurrentHashMap<String, LoadJob>();
    private final Semaphore loadConcurrency;
    private BukkitTask autoSaveTask;
    private BukkitTask optimizerCleanupTask;
    private volatile boolean shuttingDown = false;
    private final List<Future<?>> parseFutures = new CopyOnWriteArrayList();
    private final AtomicInteger scheduledLoadCount = new AtomicInteger(0);
    private final AtomicInteger completedLoadCount = new AtomicInteger(0);
    private final AtomicInteger loadWarningCount = new AtomicInteger(0);
    private BukkitTask loadWatcherTask;
    private List<Map<String, Object>> pendingPersistentInstances;
    private final List<Future<?>> saveFutures = new CopyOnWriteArrayList();

    private static String sha1String(String input) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            byte[] bytes = md.digest(input.getBytes(StandardCharsets.UTF_8));
            StringBuilder sb = new StringBuilder(bytes.length * 2);
            for (byte b : bytes) {
                sb.append(String.format("%02x", b));
            }
            return sb.toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    private static String canonicalJsonString(Map<String, Object> map) {
        try {
            Gson g = new GsonBuilder().serializeNulls().disableHtmlEscaping().create();
            JsonElement el = g.toJsonTree(map);
            JsonElement can = ParticleModelManager.canonicalizeJson(el);
            return g.toJson(can);
        }
        catch (Exception ex) {
            return new Gson().toJson(map);
        }
    }

    private static JsonElement canonicalizeJson(JsonElement el) {
        if (el == null || el.isJsonNull()) {
            return JsonNull.INSTANCE;
        }
        if (el.isJsonObject()) {
            JsonObject obj = el.getAsJsonObject();
            ArrayList<String> keys = new ArrayList<String>();
            for (Map.Entry<String, JsonElement> entry : obj.entrySet()) {
                keys.add(entry.getKey());
            }
            Collections.sort(keys);
            JsonObject out = new JsonObject();
            for (String k : keys) {
                out.add(k, ParticleModelManager.canonicalizeJson(obj.get(k)));
            }
            return out;
        }
        if (el.isJsonArray()) {
            JsonArray arr = el.getAsJsonArray();
            JsonArray out = new JsonArray();
            for (JsonElement jsonElement : arr) {
                out.add(ParticleModelManager.canonicalizeJson(jsonElement));
            }
            return out;
        }
        if (el.isJsonPrimitive()) {
            JsonPrimitive p = el.getAsJsonPrimitive();
            if (p.isNumber()) {
                try {
                    BigDecimal bd = new BigDecimal(p.getAsString());
                    bd = bd.stripTrailingZeros();
                    return new JsonPrimitive(bd);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return p;
        }
        return el;
    }

    private static String stripGzExtension(String name) {
        String lower = name.toLowerCase();
        if (lower.endsWith(".json.gz")) {
            return name.substring(0, name.length() - 3);
        }
        return name;
    }

    public ParticleModelManager(DustLab plugin, DustLabConfig config) {
        this.plugin = plugin;
        this.config = config;
        this.gson = new GsonBuilder().setPrettyPrinting().create();
        this.loadedModels = new ConcurrentHashMap<String, ParticleModel>();
        this.activeEffects = new ConcurrentHashMap<String, BukkitTask>();
        this.activeEffectInfo = new ConcurrentHashMap<String, EffectInfo>();
        this.effectIdMap = new ConcurrentHashMap<Integer, String>();
        this.particleOptimizer = new ParticleOptimizer();
        this.loadConcurrency = new Semaphore(Math.max(1, config != null ? config.getProgressiveMaxConcurrent() : 2));
        File modelsDir = new File(plugin.getDataFolder(), "models");
        if (!modelsDir.exists()) {
            modelsDir.mkdirs();
            plugin.getLogger().info("Created models directory at: " + modelsDir.getPath());
        }
        this.loadPersistedModels();
        this.autoSaveTask = Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)plugin, () -> this.savePersistedModels(true), 36000L, 36000L);
        this.optimizerCleanupTask = Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)plugin, () -> {
            long currentTick = plugin.getServer().getCurrentTick();
            for (String effectKey : this.activeEffectInfo.keySet()) {
                this.particleOptimizer.cleanupEffect(effectKey, currentTick, 12000L);
            }
        }, 6000L, 6000L);
        try {
            this.recoverOrQuarantineTempFiles();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private int getMaxParticlesPerTick() {
        return this.config != null ? this.config.getMaxParticlesPerTickPerModel() : 200;
    }

    private int getParticlesPerBatch() {
        return this.config != null ? this.config.getParticlesPerBatch() : 500;
    }

    private int getLargeModelThreshold() {
        return this.config != null ? this.config.getLargeModelThreshold() : 4500;
    }

    private int getVeryLargeModelThreshold() {
        return this.config != null ? this.config.getVeryLargeModelThreshold() : 15000;
    }

    public void loadModels() {
        File modelsDir = new File(this.plugin.getDataFolder(), "models");
        File[] jsonFiles = modelsDir.listFiles((dir, name) -> {
            String n = name.toLowerCase();
            return n.endsWith(".json") || n.endsWith(".json.gz");
        });
        if (jsonFiles == null || jsonFiles.length == 0) {
            this.plugin.getLogger().info("No particle models found in models directory.");
            this.copyBundledModels();
            jsonFiles = modelsDir.listFiles((dir, name) -> {
                String n = name.toLowerCase();
                return n.endsWith(".json") || n.endsWith(".json.gz");
            });
            if (jsonFiles == null || jsonFiles.length == 0) {
                this.createExampleModel();
                return;
            }
        }
        this.scheduledLoadCount.set(0);
        this.completedLoadCount.set(0);
        this.loadWarningCount.set(0);
        int scheduled = 0;
        for (File jsonFile : jsonFiles) {
            try {
                this.startLoadJob(jsonFile, null);
                ++scheduled;
            }
            catch (Exception e) {
                this.loadWarningCount.incrementAndGet();
                this.plugin.getLogger().warning("Failed to schedule load for " + jsonFile.getName() + ": " + e.getMessage());
            }
        }
        this.scheduledLoadCount.set(scheduled);
        this.plugin.getLogger().info("Scheduled loading for " + scheduled + " particle models (async).");
        this.startLoadWatcher();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadModel(File file) throws IOException {
        boolean gz = file.getName().toLowerCase().endsWith(".json.gz");
        InputStreamReader reader = null;
        try {
            if (gz) {
                GZIPInputStream gis = new GZIPInputStream(new FileInputStream(file));
                reader = new InputStreamReader((InputStream)gis, StandardCharsets.UTF_8);
            } else {
                reader = new FileReader(file);
            }
            JsonElement jsonElement = this.gson.fromJson((Reader)reader, JsonElement.class);
            if (jsonElement != null && jsonElement.isJsonObject()) {
                JsonObject jsonObject = jsonElement.getAsJsonObject();
                if (jsonObject.has("frames")) {
                    AnimatedModel animatedModel = this.parseAnimatedModel(jsonObject, file.getName());
                    if (animatedModel != null) {
                        if (animatedModel.getName() == null || animatedModel.getName().isEmpty()) {
                            String fileName = file.getName();
                            String base = fileName.endsWith(".json.gz") ? fileName.substring(0, fileName.length() - 8) : fileName.substring(0, fileName.lastIndexOf(46));
                            animatedModel.setName(base);
                        }
                        this.loadedModels.put(animatedModel.getName().toLowerCase(), animatedModel);
                        this.plugin.getLogger().info("Loaded animated model: " + animatedModel.getName() + " with " + animatedModel.getTotalFrames() + " frames");
                    }
                } else {
                    ParticleModel model = this.gson.fromJson(jsonElement, ParticleModel.class);
                    if (model != null) {
                        if (model.getName() == null || model.getName().isEmpty()) {
                            String fileName = file.getName();
                            String base = fileName.endsWith(".json.gz") ? fileName.substring(0, fileName.length() - 8) : fileName.substring(0, fileName.lastIndexOf(46));
                            model.setName(base);
                        }
                        this.loadedModels.put(model.getName().toLowerCase(), model);
                    }
                }
            }
        }
        finally {
            if (reader != null) {
                try {
                    ((Reader)reader).close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public boolean isModelLoading(String name) {
        return this.loadingJobs.containsKey(name.toLowerCase());
    }

    private synchronized int allocateEffectId() {
        if (!this.usedEffectIds.isEmpty() || !this.reservedForRestoreIds.isEmpty()) {
            int max = this.nextEffectId;
            for (int id : this.usedEffectIds) {
                if (id <= max) continue;
                max = id;
            }
            for (int id : this.reservedForRestoreIds) {
                if (id <= max) continue;
                max = id;
            }
            if (max >= this.nextEffectId) {
                this.nextEffectId = max + 1;
            }
        }
        int id = this.nextEffectId++;
        while (this.usedEffectIds.contains(id) || this.reservedForRestoreIds.contains(id)) {
            ++this.nextEffectId;
        }
        this.usedEffectIds.add(id);
        return id;
    }

    private synchronized int reserveSpecificEffectId(int desiredId) {
        if (desiredId > 0) {
            if (this.usedEffectIds.contains(desiredId)) {
                int newId = this.allocateEffectId();
                this.plugin.getLogger().warning("Persistent effect ID conflict for id=" + desiredId + ", assigned new id=" + newId);
                return newId;
            }
            if (this.reservedForRestoreIds.contains(desiredId)) {
                this.reservedForRestoreIds.remove(desiredId);
                this.usedEffectIds.add(desiredId);
                if (desiredId >= this.nextEffectId) {
                    this.nextEffectId = desiredId + 1;
                }
                return desiredId;
            }
            this.usedEffectIds.add(desiredId);
            if (desiredId >= this.nextEffectId) {
                this.nextEffectId = desiredId + 1;
            }
            return desiredId;
        }
        return this.allocateEffectId();
    }

    public int getModelLoadingPercent(String name) {
        LoadJob job = this.loadingJobs.get(name.toLowerCase());
        if (job == null) {
            return 100;
        }
        if (job.totalParticles > 0) {
            return Math.min(99, (int)Math.floor((double)job.parsedParticles * 100.0 / (double)job.totalParticles));
        }
        if (job.fileSize > 0L) {
            return Math.min(99, (int)Math.floor((double)job.bytesRead * 100.0 / (double)job.fileSize));
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribeToLoading(String name, CommandSender sender) {
        LoadJob job = this.loadingJobs.get(name.toLowerCase());
        if (job != null) {
            Set<CommandSender> set = job.subscribers;
            synchronized (set) {
                job.subscribers.add(sender);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onModelReady(String name, Runnable callback) {
        LoadJob job = this.loadingJobs.get(name.toLowerCase());
        if (job == null) {
            Bukkit.getScheduler().runTask((Plugin)this.plugin, callback);
            return;
        }
        List<Runnable> list = job.readyCallbacks;
        synchronized (list) {
            job.readyCallbacks.add(callback);
        }
    }

    private void startLoadJob(File file, CommandSender subscriber) {
        if (this.shuttingDown || !this.plugin.isEnabled()) {
            return;
        }
        LoadJob job = new LoadJob(file);
        if (subscriber != null) {
            job.subscribers.add(subscriber);
        }
        this.loadingJobs.put(job.fileBaseName.toLowerCase(), job);
        Future<?> f = MediaProcessor.submitAsyncFuture(() -> {
            try {
                this.loadConcurrency.acquire();
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                this.loadingJobs.remove(job.fileBaseName.toLowerCase());
                return;
            }
            try {
                this.parseModelStreaming(job);
            }
            finally {
                this.loadConcurrency.release();
            }
        });
        this.parseFutures.add(f);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parseModelStreaming(LoadJob job) {
        try {
            block99: {
                fis = new FileInputStream(job.file);
                is = job.gz != false ? new GZIPInputStream(fis) : fis;
                isr = new InputStreamReader(is, StandardCharsets.UTF_8);
                countingReader = new CountingReader(isr, (LongConsumer)LambdaMetafactory.metafactory(null, null, null, (J)V, lambda$parseModelStreaming$5(com.winss.dustlab.managers.ParticleModelManager$LoadJob long ), (J)V)((LoadJob)job));
                reader = new JsonReader(countingReader);
                reader.beginObject();
                detectedName = null;
                metadata = null;
                metadataChecksumStored = null;
                duration = null;
                particleCountFromMeta = null;
                looping = null;
                sourceUrl = "";
                blockWidth = 1;
                blockHeight = 1;
                maxParticleCount = 10000;
                animatedFrames = null;
lbl24:
                // 2 sources

                while (true) {
                    if (reader.hasNext()) {
                        if (job.canceled != false) return;
                        if (this.shuttingDown) {
                            return;
                        }
                        key = reader.nextName();
                        if (key.equals("name")) {
                            detectedName = this.safeReadString(reader);
                            continue;
                        }
                        if (key.equals("frames")) {
                            animatedFrames = this.parseFramesArray(reader);
                            continue;
                        }
                        if (key.equals("metadataChecksumSha1")) {
                            try {
                                metadataChecksumStored = reader.nextString();
                            }
                            catch (Exception e) {
                                reader.skipValue();
                            }
                            continue;
                        }
                        if (key.equals("metadata")) {
                            try {
                                mapType = new TypeToken<Map<String, Object>>(){}.getType();
                                metadata = (Map)this.gson.fromJson(reader, mapType);
                                if (metadata != null && metadata.containsKey("particleCount") && (pc = metadata.get("particleCount")) instanceof Number) {
                                    particleCountFromMeta = ((Number)pc).intValue();
                                }
                                if (metadata == null || metadataChecksumStored == null) continue;
                                try {
                                    ParticleModelManager.sha1String(ParticleModelManager.canonicalJsonString(metadata));
                                }
                                catch (Exception pc) {}
                            }
                            catch (Exception ex) {
                                reader.skipValue();
                            }
                            continue;
                        }
                        if (key.equals("duration")) {
                            try {
                                duration = reader.nextInt();
                            }
                            catch (Exception e) {
                                reader.skipValue();
                            }
                            continue;
                        }
                        if (key.equals("looping")) {
                            try {
                                looping = reader.nextBoolean();
                            }
                            catch (Exception e) {
                                reader.skipValue();
                            }
                            continue;
                        }
                        if (key.equals("sourceUrl")) {
                            v = this.safeReadString(reader);
                            if (v == null) continue;
                            sourceUrl = v;
                            continue;
                        }
                        if (key.equals("blockWidth")) {
                            try {
                                blockWidth = reader.nextInt();
                            }
                            catch (Exception e) {
                                reader.skipValue();
                            }
                            continue;
                        }
                        if (key.equals("blockHeight")) {
                            try {
                                blockHeight = reader.nextInt();
                            }
                            catch (Exception e) {
                                reader.skipValue();
                            }
                            continue;
                        }
                        if (key.equals("maxParticleCount")) {
                            try {
                                maxParticleCount = reader.nextInt();
                            }
                            catch (Exception e) {
                                reader.skipValue();
                            }
                            continue;
                        }
                        if (key.equals("particles")) {
                            job.modelName = modelName = detectedName != null ? detectedName : job.fileBaseName;
                            job.totalParticles = particleCountFromMeta != null ? particleCountFromMeta : -1;
                            placeholder = new ParticleModel();
                            placeholder.setName(modelName);
                            if (metadata != null) {
                                placeholder.setMetadata(metadata);
                            }
                            if (duration != null) {
                                placeholder.setDuration(duration);
                            }
                            if (this.shuttingDown) {
                                return;
                            }
                            Bukkit.getScheduler().runTask((Plugin)this.plugin, (Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$parseModelStreaming$6(java.lang.String com.winss.dustlab.models.ParticleModel ), ()V)((ParticleModelManager)this, (String)modelName, (ParticleModel)placeholder));
                            expected = job.totalParticles > 0 ? job.totalParticles : 1024;
                            builder = PackedParticleArray.builder(expected);
                            reader.beginArray();
                            break block99;
                        } else {
                            reader.skipValue();
                            continue;
                        }
                    }
                    reader.endObject();
                    if (animatedFrames == null) return;
                    modelName = detectedName != null ? detectedName : job.fileBaseName;
                    animated = new AnimatedModel(modelName, animatedFrames, looping != null ? looping : false, sourceUrl, blockWidth != null ? blockWidth : 1, blockHeight != null ? blockHeight : 1, maxParticleCount != null ? maxParticleCount : 10000);
                    if (duration != null && duration > 0) {
                        animated.setDuration(duration);
                    }
                    if (metadata != null) {
                        animated.setMetadata(metadata);
                    }
                    if (this.shuttingDown) {
                        return;
                    }
                    Bukkit.getScheduler().runTask((Plugin)this.plugin, (Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$parseModelStreaming$8(com.winss.dustlab.media.AnimatedModel com.winss.dustlab.managers.ParticleModelManager$LoadJob ), ()V)((ParticleModelManager)this, (AnimatedModel)animated, (LoadJob)job));
                    return;
                }
                finally {
                    reader.close();
                }
                finally {
                    countingReader.close();
                }
                finally {
                    isr.close();
                }
                finally {
                    if (is != null) {
                        is.close();
                    }
                }
                finally {
                    fis.close();
                }
            }
            while (reader.hasNext()) {
                if (job.canceled || this.shuttingDown) {
                    reader.skipValue();
                    continue;
                }
                pd = this.parseParticle(reader);
                builder.add(pd);
                ++job.parsedParticles;
            }
            reader.endArray();
            packed = builder.build();
            job.parsedParticles = packed.size();
            if (this.shuttingDown) {
                return;
            }
            Bukkit.getScheduler().runTask((Plugin)this.plugin, (Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$parseModelStreaming$7(com.winss.dustlab.models.ParticleModel com.winss.dustlab.packed.PackedParticleArray com.winss.dustlab.managers.ParticleModelManager$LoadJob java.lang.String ), ()V)((ParticleModelManager)this, (ParticleModel)placeholder, (PackedParticleArray)packed, (LoadJob)job, (String)modelName));
            ** continue;
        }
        catch (Exception ex) {
            name = job.modelName != null ? job.modelName : job.fileBaseName;
            msg = ex.getMessage() != null ? ex.getMessage() : ex.getClass().getSimpleName();
            zlibEof = msg.contains("Unexpected end of ZLIB input stream");
            if (job.canceled || this.shuttingDown) {
                this.plugin.getLogger().info("Streaming canceled for '" + name + "'" + (this.shuttingDown != false ? " during shutdown." : "."));
            } else {
                if (job.gz) {
                    this.loadWarningCount.incrementAndGet();
                    this.plugin.getLogger().warning("Failed to load compressed model '" + name + "' (" + msg + ") \u2014 attempting .json fallback.");
                    fallbackStarted = this.attemptJsonFallback(job);
                    if (fallbackStarted) {
                        return;
                    }
                    try {
                        bad = job.file;
                        if (bad.exists()) {
                            quarantineDir = new File(this.plugin.getDataFolder(), "quarantine");
                            if (!quarantineDir.exists()) {
                                quarantineDir.mkdirs();
                            }
                            ts = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMdd-HHmmss"));
                            target = new File(quarantineDir, bad.getName().replaceFirst("\\.json\\.gz$", "") + "." + ts + ".json.gz");
                            Files.move(bad.toPath(), target.toPath(), new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
                            this.plugin.getLogger().warning("Quarantined corrupted compressed model to '" + target.getName() + "'.");
                        }
                    }
                    catch (Exception qex) {
                        this.plugin.getLogger().warning("Failed to quarantine corrupted model '" + name + "': " + qex.getMessage());
                    }
                }
                if (zlibEof) {
                    this.loadWarningCount.incrementAndGet();
                    this.plugin.getLogger().warning("Model '" + name + "' appears to be a truncated/corrupted .json.gz (" + msg + ").");
                } else {
                    this.loadWarningCount.incrementAndGet();
                    this.plugin.getLogger().warning("Failed to load model (streaming) from " + job.file.getName() + ": " + msg);
                }
            }
            this.loadingJobs.remove(name.toLowerCase());
        }
    }

    private void startLoadWatcher() {
        if (this.loadWatcherTask != null) {
            try {
                this.loadWatcherTask.cancel();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.loadWatcherTask = Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, () -> {
            boolean anyLoading;
            if (this.shuttingDown) {
                try {
                    this.loadWatcherTask.cancel();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return;
            }
            int scheduled = this.scheduledLoadCount.get();
            int completed = this.completedLoadCount.get();
            boolean bl = anyLoading = !this.loadingJobs.isEmpty();
            if (scheduled >= 0 && completed >= scheduled && !anyLoading) {
                try {
                    this.loadWatcherTask.cancel();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                int issues = this.loadWarningCount.get();
                if (scheduled > 0) {
                    if (issues > 0) {
                        this.plugin.getLogger().info("Loaded " + completed + " particle models (" + issues + " warnings).");
                    } else {
                        this.plugin.getLogger().info("Loaded " + completed + " particle models.");
                    }
                }
                if (this.pendingPersistentInstances != null && !this.pendingPersistentInstances.isEmpty()) {
                    this.restorePersistentInstances(this.pendingPersistentInstances);
                    this.pendingPersistentInstances = null;
                }
            }
        }, 20L, 20L);
    }

    private boolean attemptJsonFallback(LoadJob gzJob) {
        try {
            File json = new File(gzJob.file.getParentFile(), gzJob.fileBaseName + ".json");
            if (!json.exists()) {
                return false;
            }
            LoadJob jsonJob = new LoadJob(json);
            jsonJob.subscribers.addAll(gzJob.subscribers);
            this.parseModelStreaming(jsonJob);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void cancelAllLoadJobs() {
        for (Map.Entry<String, LoadJob> entry : this.loadingJobs.entrySet()) {
            LoadJob job = entry.getValue();
            job.canceled = true;
        }
        for (Future future : this.parseFutures) {
            try {
                future.cancel(true);
            }
            catch (Exception exception) {}
        }
        this.parseFutures.clear();
        this.loadingJobs.clear();
    }

    private String safeReadString(JsonReader reader) throws IOException {
        try {
            return reader.nextString();
        }
        catch (Exception e) {
            reader.skipValue();
            return null;
        }
    }

    private ParticleData parseParticle(JsonReader r) throws IOException {
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        int delay = 0;
        double rC = 1.0;
        double gC = 0.0;
        double bC = 0.0;
        float scale = 1.0f;
        r.beginObject();
        block25: while (r.hasNext()) {
            String k;
            switch (k = r.nextName()) {
                case "x": {
                    x = this.safeReadDouble(r);
                    continue block25;
                }
                case "y": {
                    y = this.safeReadDouble(r);
                    continue block25;
                }
                case "z": {
                    z = this.safeReadDouble(r);
                    continue block25;
                }
                case "delay": {
                    delay = this.safeReadInt(r);
                    continue block25;
                }
                case "scale": {
                    scale = (float)this.safeReadDouble(r);
                    continue block25;
                }
                case "r": 
                case "red": {
                    rC = this.normalizeColor(this.safeReadDouble(r));
                    continue block25;
                }
                case "g": 
                case "green": {
                    gC = this.normalizeColor(this.safeReadDouble(r));
                    continue block25;
                }
                case "b": 
                case "blue": {
                    bC = this.normalizeColor(this.safeReadDouble(r));
                    continue block25;
                }
                case "dustOptions": {
                    r.beginObject();
                    while (r.hasNext()) {
                        String dk = r.nextName();
                        if (dk.equals("red")) {
                            rC = this.normalizeColor(this.safeReadDouble(r));
                            continue;
                        }
                        if (dk.equals("green")) {
                            gC = this.normalizeColor(this.safeReadDouble(r));
                            continue;
                        }
                        if (dk.equals("blue")) {
                            bC = this.normalizeColor(this.safeReadDouble(r));
                            continue;
                        }
                        if (dk.equals("size")) {
                            scale = (float)this.safeReadDouble(r);
                            continue;
                        }
                        r.skipValue();
                    }
                    r.endObject();
                    continue block25;
                }
            }
            r.skipValue();
        }
        r.endObject();
        ParticleData pd = new ParticleData(x, y, z, rC, gC, bC);
        pd.setDelay(delay);
        pd.setScale(scale);
        return pd;
    }

    private double normalizeColor(double v) {
        return v > 1.0 ? Math.max(0.0, Math.min(1.0, v / 255.0)) : Math.max(0.0, Math.min(1.0, v));
    }

    private double safeReadDouble(JsonReader r) throws IOException {
        try {
            return r.nextDouble();
        }
        catch (Exception e) {
            r.skipValue();
            return 0.0;
        }
    }

    private int safeReadInt(JsonReader r) throws IOException {
        try {
            return r.nextInt();
        }
        catch (Exception e) {
            r.skipValue();
            return 0;
        }
    }

    private List<FrameData> parseFramesArray(JsonReader reader) throws IOException {
        ArrayList<FrameData> frames = new ArrayList<FrameData>();
        reader.beginArray();
        while (reader.hasNext()) {
            reader.beginObject();
            int frameIndex = frames.size();
            int delayMs = 50;
            PackedParticleArray.Builder frameBuilder = PackedParticleArray.builder();
            while (reader.hasNext()) {
                String k = reader.nextName();
                if (k.equals("frameIndex")) {
                    try {
                        frameIndex = reader.nextInt();
                    }
                    catch (Exception e) {
                        reader.skipValue();
                    }
                    continue;
                }
                if (k.equals("delayMs")) {
                    try {
                        delayMs = reader.nextInt();
                    }
                    catch (Exception e) {
                        reader.skipValue();
                    }
                    continue;
                }
                if (k.equals("particles")) {
                    reader.beginArray();
                    while (reader.hasNext()) {
                        ParticleData parsed = this.parseParticle(reader);
                        frameBuilder.add(parsed);
                    }
                    reader.endArray();
                    continue;
                }
                reader.skipValue();
            }
            reader.endObject();
            PackedParticleArray packed = frameBuilder.build();
            frames.add(new FrameData(packed, frameIndex, delayMs));
        }
        reader.endArray();
        return frames;
    }

    private AnimatedModel parseAnimatedModel(JsonObject root, String fileName) {
        try {
            JsonObject md;
            String name = root.has("name") ? root.get("name").getAsString() : null;
            boolean looping = root.has("looping") && root.get("looping").getAsBoolean();
            String sourceUrl = root.has("sourceUrl") ? root.get("sourceUrl").getAsString() : "";
            int blockWidth = root.has("blockWidth") ? root.get("blockWidth").getAsInt() : 1;
            int blockHeight = root.has("blockHeight") ? root.get("blockHeight").getAsInt() : 1;
            int maxParticleCount = root.has("maxParticleCount") ? root.get("maxParticleCount").getAsInt() : 10000;
            double globalSize = 1.0;
            if (root.has("metadata") && root.get("metadata").isJsonObject() && (md = root.getAsJsonObject("metadata")).has("globalParticleSize")) {
                try {
                    globalSize = md.get("globalParticleSize").getAsDouble();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ArrayList<FrameData> frames = new ArrayList<FrameData>();
            JsonElement framesEl = root.get("frames");
            if (framesEl != null && framesEl.isJsonArray()) {
                for (JsonElement fe : framesEl.getAsJsonArray()) {
                    if (!fe.isJsonObject()) continue;
                    JsonObject fo = fe.getAsJsonObject();
                    int frameIndex = fo.has("frameIndex") ? fo.get("frameIndex").getAsInt() : frames.size();
                    int delayMs = fo.has("delayMs") ? fo.get("delayMs").getAsInt() : 50;
                    PackedParticleArray.Builder frameBuilder = PackedParticleArray.builder();
                    JsonElement pel = fo.get("particles");
                    if (pel != null && pel.isJsonArray()) {
                        for (JsonElement pe : pel.getAsJsonArray()) {
                            JsonObject po;
                            ParticleData pd;
                            if (!pe.isJsonObject() || (pd = this.parseParticle(po = pe.getAsJsonObject(), globalSize)) == null) continue;
                            frameBuilder.add(pd);
                        }
                    }
                    frames.add(new FrameData(frameBuilder.build(), frameIndex, delayMs));
                }
            }
            AnimatedModel model = new AnimatedModel(name != null ? name : fileName, frames, looping, sourceUrl, blockWidth, blockHeight, maxParticleCount);
            model.setDuration(root.has("duration") ? root.get("duration").getAsInt() : model.getDuration());
            if (root.has("metadata") && root.get("metadata").isJsonObject()) {
                Type mapType = new TypeToken<Map<String, Object>>(){}.getType();
                Map metaMap = (Map)this.gson.fromJson(root.get("metadata"), mapType);
                model.setMetadata(metaMap);
            }
            if (root.has("particles") && root.get("particles").isJsonArray()) {
                PackedParticleArray.Builder baseBuilder = PackedParticleArray.builder();
                for (JsonElement pe : root.get("particles").getAsJsonArray()) {
                    ParticleData pd;
                    if (!pe.isJsonObject() || (pd = this.parseParticle(pe.getAsJsonObject(), globalSize)) == null) continue;
                    baseBuilder.add(pd);
                }
                PackedParticleArray packedBase = baseBuilder.build();
                model.setPackedParticles(packedBase);
            } else if (!frames.isEmpty()) {
                PackedParticleArray packedFallback = ((FrameData)frames.get(0)).getPackedParticles();
                if (packedFallback != null) {
                    model.setPackedParticles(packedFallback);
                } else {
                    model.setParticles(((FrameData)frames.get(0)).getParticles());
                }
            }
            return model;
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Failed to parse animated model: " + e.getMessage());
            return null;
        }
    }

    private ParticleData parseParticle(JsonObject po, double globalSize) {
        try {
            double x = po.has("x") ? po.get("x").getAsDouble() : 0.0;
            double y = po.has("y") ? po.get("y").getAsDouble() : 0.0;
            double z = po.has("z") ? po.get("z").getAsDouble() : 0.0;
            int delay = po.has("delay") ? po.get("delay").getAsInt() : 0;
            double r = 1.0;
            double g = 0.0;
            double b = 0.0;
            float scale = (float)globalSize;
            if (po.has("dustOptions") && po.get("dustOptions").isJsonObject()) {
                JsonObject d = po.getAsJsonObject("dustOptions");
                double red = this.getNormalizedColor(d, "red");
                double green = this.getNormalizedColor(d, "green");
                double blue = this.getNormalizedColor(d, "blue");
                r = red;
                g = green;
                b = blue;
                if (d.has("size")) {
                    try {
                        scale = (float)d.get("size").getAsDouble();
                    }
                    catch (Exception exception) {}
                }
            } else {
                if (po.has("r") || po.has("red")) {
                    r = this.getNormalizedColor(po, "r", "red");
                }
                if (po.has("g") || po.has("green")) {
                    g = this.getNormalizedColor(po, "g", "green");
                }
                if (po.has("b") || po.has("blue")) {
                    b = this.getNormalizedColor(po, "b", "blue");
                }
                if (po.has("scale")) {
                    try {
                        scale = (float)po.get("scale").getAsDouble();
                    }
                    catch (Exception d) {
                        // empty catch block
                    }
                }
            }
            ParticleData pd = new ParticleData(x, y, z, r, g, b);
            pd.setDelay(delay);
            pd.setScale(scale);
            return pd;
        }
        catch (Exception e) {
            return null;
        }
    }

    private double getNormalizedColor(JsonObject obj, String ... keys) {
        for (String k : keys) {
            if (!obj.has(k)) continue;
            try {
                double v = obj.get(k).getAsDouble();
                if (v > 1.0) {
                    return Math.max(0.0, Math.min(1.0, v / 255.0));
                }
                return Math.max(0.0, Math.min(1.0, v));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 1.0;
    }

    private void copyBundledModels() {
        File modelsDir = new File(this.plugin.getDataFolder(), "models");
        String[] bundledModels = new String[]{"animated_checkerboard.json", "animated_wave.json", "animated_ripple.json", "animated_spiral.json", "animated_rainbow_circle.json", "aurora.json", "dragon_breath.json", "glowlights.json", "heart_shape.json", "iris.json", "lightning_bolt.json", "magic_circle.json", "prismatic_burst.json", "spellcast.json", "spiral_galaxy.json", "star_shape.json", "test_scale.json"};
        int copiedCount = 0;
        for (String modelFile : bundledModels) {
            try {
                InputStream inputStream = this.plugin.getResource("models/" + modelFile);
                if (inputStream != null) {
                    File targetFile = new File(modelsDir, modelFile);
                    try (FileOutputStream outputStream = new FileOutputStream(targetFile);){
                        int length;
                        byte[] buffer = new byte[1024];
                        while ((length = inputStream.read(buffer)) > 0) {
                            outputStream.write(buffer, 0, length);
                        }
                        ++copiedCount;
                    }
                    inputStream.close();
                    continue;
                }
                this.plugin.getLogger().warning("Bundled model not found in JAR: " + modelFile);
            }
            catch (IOException e) {
                this.plugin.getLogger().warning("Failed to copy bundled model " + modelFile + ": " + e.getMessage());
            }
        }
        if (copiedCount > 0) {
            this.plugin.getLogger().info("Successfully copied " + copiedCount + " bundled models to server.");
        }
    }

    private void createExampleModel() {
        File modelsDir = new File(this.plugin.getDataFolder(), "models");
        File exampleFile = new File(modelsDir, "example.json");
        try {
            ParticleModel example = new ParticleModel();
            example.setName("example");
            example.setDuration(60);
            HashMap<String, Object> metadata = new HashMap<String, Object>();
            metadata.put("generatedBy", "DustLab v1.0.0");
            metadata.put("website", "https://winss.xyz/dustlab");
            metadata.put("generatedOn", Instant.now().toString());
            metadata.put("sourceFile", "example_generated.internal");
            metadata.put("particleCount", 16);
            HashMap<String, Object> settings = new HashMap<String, Object>();
            settings.put("outputWidth", 4);
            settings.put("outputHeight", 4);
            settings.put("coordinateMode", "local");
            settings.put("coordinateAxis", "X-Z");
            settings.put("rotation", 0);
            settings.put("version", "1.20.4+");
            settings.put("colorFixed", false);
            settings.put("fixedColor", null);
            metadata.put("settings", settings);
            example.setMetadata(metadata);
            ArrayList<ParticleData> particles = new ArrayList<ParticleData>();
            for (int i = 0; i < 16; ++i) {
                double angle = Math.PI * 2 * (double)i / 16.0;
                double x = Math.cos(angle) * 2.0;
                double z = Math.sin(angle) * 2.0;
                float hue = (float)i / 16.0f;
                Color awtColor = Color.getHSBColor(hue, 1.0f, 1.0f);
                ParticleData particle = new ParticleData(x, 0.0, z, (double)awtColor.getRed() / 255.0, (double)awtColor.getGreen() / 255.0, (double)awtColor.getBlue() / 255.0);
                particle.setDelay(i * 2);
                particles.add(particle);
            }
            example.setParticles(particles);
            try (FileWriter writer = new FileWriter(exampleFile);){
                this.gson.toJson((Object)example, (Appendable)writer);
            }
            this.plugin.getLogger().info("Created example model at: " + exampleFile.getPath());
            this.loadedModels.put("example", example);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Failed to create example model: " + e.getMessage());
        }
    }

    public boolean hasModel(String name) {
        return this.loadedModels.containsKey(name.toLowerCase());
    }

    public ParticleModel getModel(String name) {
        return this.loadedModels.get(name.toLowerCase());
    }

    public boolean hasViewPermission(CommandSender sender, String modelName, boolean force) {
        if (force && sender.hasPermission("dustlab.force")) {
            return true;
        }
        if (!sender.hasPermission("dustlab.view")) {
            return false;
        }
        String modelPermission = "dustlab.view." + modelName.toLowerCase();
        return sender.hasPermission(modelPermission);
    }

    public boolean canSeeParticles(Player player) {
        return player.hasPermission("dustlab.view");
    }

    private boolean shouldBePersistent(int lifetimeSeconds) {
        if (lifetimeSeconds == -1) {
            return true;
        }
        if (lifetimeSeconds == 0) {
            return false;
        }
        return lifetimeSeconds > 60;
    }

    public int playModel(String modelName, Location location, boolean loop) {
        int lifetimeSeconds = loop ? -1 : 0;
        return this.playModel(modelName, location, lifetimeSeconds, this.shouldBePersistent(lifetimeSeconds));
    }

    public int playModel(String modelName, Location location, boolean loop, boolean persistent) {
        return this.playModel(modelName, location, loop ? -1 : 0, persistent);
    }

    public int playModel(String modelName, Location location, int lifetimeSeconds) {
        return this.playModelWithEffects(modelName, location, lifetimeSeconds, this.shouldBePersistent(lifetimeSeconds), null);
    }

    public int playModel(String modelName, Location location, int lifetimeSeconds, boolean persistent) {
        return this.playModelWithEffects(modelName, location, lifetimeSeconds, persistent, null);
    }

    public int playModelWithEffects(String modelName, Location location, boolean loop, ParticleEffects.EffectSettings effects) {
        int lifetimeSeconds = loop ? -1 : 0;
        return this.playModelWithEffects(modelName, location, lifetimeSeconds, this.shouldBePersistent(lifetimeSeconds), effects);
    }

    public int playModelWithEffects(String modelName, Location location, boolean loop, boolean persistent, ParticleEffects.EffectSettings effects) {
        return this.playModelWithEffects(modelName, location, loop ? -1 : 0, persistent, effects);
    }

    public int playModelWithEffects(String modelName, Location location, int lifetimeSeconds, ParticleEffects.EffectSettings effects) {
        return this.playModelOnLocationWithEffects(modelName, location, lifetimeSeconds, this.shouldBePersistent(lifetimeSeconds), effects);
    }

    public int playModelWithEffects(String modelName, Location location, int lifetimeSeconds, boolean persistent, ParticleEffects.EffectSettings effects) {
        return this.playModelOnLocationWithEffects(modelName, location, lifetimeSeconds, persistent, effects);
    }

    public int playModelWithTickOffset(String modelName, Location location, int lifetimeSeconds, boolean persistent, long tickOffset) {
        return this.playModelOnLocationWithEffectsAndTickOffset(modelName, location, lifetimeSeconds, persistent, null, tickOffset);
    }

    public int playModelWithEffectsAndTickOffset(String modelName, Location location, int lifetimeSeconds, boolean persistent, ParticleEffects.EffectSettings effects, long tickOffset) {
        return this.playModelOnLocationWithEffectsAndTickOffset(modelName, location, lifetimeSeconds, persistent, effects, tickOffset);
    }

    public int playModelOnPlayer(String modelName, Player player, int lifetimeSeconds, boolean onlyWhenStill, boolean forceVisible) {
        return this.playModelOnPlayer(modelName, player, lifetimeSeconds, null, onlyWhenStill, forceVisible);
    }

    public int playModelOnPlayer(String modelName, final Player player, final int lifetimeSeconds, final ParticleEffects.EffectSettings effects, final boolean onlyWhenStill, final boolean forceVisible) {
        final ParticleModel model = this.getModel(modelName);
        if (model == null) {
            this.plugin.getLogger().warning("Model not found: " + modelName);
            return -1;
        }
        if (player == null || !player.isOnline()) {
            this.plugin.getLogger().warning("Invalid or offline player for model: " + modelName);
            return -1;
        }
        if (model.getParticles() == null || model.getParticles().isEmpty()) {
            this.plugin.getLogger().warning("Model has no particles: " + modelName);
            return -1;
        }
        final int effectId = this.allocateEffectId();
        final String effectKey = modelName + "_player_" + player.getName() + "_" + effectId + "_" + System.currentTimeMillis();
        this.activeEffectInfo.put(effectKey, new EffectInfo(effectId, modelName, player, lifetimeSeconds, onlyWhenStill, forceVisible, effects));
        this.effectIdMap.put(effectId, effectKey);
        final Location[] lastLocation = new Location[]{player.getLocation().clone()};
        BukkitTask task = Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, new Runnable(){
            private int tick = 0;
            private final int maxTicks = Math.max(model.getDuration(), ParticleModelManager.this.getMaxParticleDelay(model) + 60);
            private final boolean isAnimatedModel = model instanceof AnimatedModel;
            private long startMs = System.currentTimeMillis();
            private int lastFrameIndex = -1;
            private int lastFrameChangeTick = 0;

            @Override
            public void run() {
                List<ParticleData> currentParticles;
                EffectInfo currentEffect = ParticleModelManager.this.activeEffectInfo.get(effectKey);
                if (currentEffect == null) {
                    BukkitTask currentTask = ParticleModelManager.this.activeEffects.remove(effectKey);
                    if (currentTask != null) {
                        currentTask.cancel();
                    }
                    return;
                }
                if (!player.isOnline()) {
                    BukkitTask currentTask = ParticleModelManager.this.activeEffects.remove(effectKey);
                    ParticleModelManager.this.activeEffectInfo.remove(effectKey);
                    ParticleModelManager.this.effectIdMap.remove(effectId);
                    if (currentTask != null) {
                        currentTask.cancel();
                    }
                    return;
                }
                if (currentEffect.hasExpired()) {
                    BukkitTask currentTask = ParticleModelManager.this.activeEffects.remove(effectKey);
                    ParticleModelManager.this.activeEffectInfo.remove(effectKey);
                    ParticleModelManager.this.effectIdMap.remove(effectId);
                    if (currentTask != null) {
                        currentTask.cancel();
                    }
                    return;
                }
                if (this.tick >= this.maxTicks && lifetimeSeconds == 0) {
                    BukkitTask currentTask = ParticleModelManager.this.activeEffects.remove(effectKey);
                    ParticleModelManager.this.activeEffectInfo.remove(effectKey);
                    ParticleModelManager.this.effectIdMap.remove(effectId);
                    if (currentTask != null) {
                        currentTask.cancel();
                    }
                    return;
                }
                Location currentLocation = player.getLocation();
                boolean shouldShow = true;
                boolean isMoving = false;
                if (onlyWhenStill) {
                    distance = lastLocation[0].distance(currentLocation);
                    shouldShow = distance < 0.1;
                    isMoving = distance >= 0.05;
                } else {
                    distance = lastLocation[0].distance(currentLocation);
                    isMoving = distance >= 0.05;
                }
                lastLocation[0] = currentLocation.clone();
                PackedParticleArray currentPacked = null;
                boolean emitThisTick = true;
                if (this.isAnimatedModel) {
                    FrameData currentFrame;
                    AnimatedModel animatedModel = (AnimatedModel)model;
                    FrameData frameData = currentFrame = animatedModel.isTickAligned() ? animatedModel.getFrameAtTick(this.tick) : animatedModel.getFrameAtTime(System.currentTimeMillis() - this.startMs);
                    if (currentFrame != null) {
                        int frameIndex = currentFrame.getFrameIndex();
                        if (frameIndex != this.lastFrameIndex) {
                            this.lastFrameIndex = frameIndex;
                            this.lastFrameChangeTick = this.tick;
                            emitThisTick = true;
                        } else {
                            int lifespan = Math.max(1, ParticleModelManager.this.config.getMediaParticleLifespanTicks());
                            emitThisTick = this.tick - this.lastFrameChangeTick < lifespan;
                        }
                        currentParticles = currentFrame.getParticles();
                        currentPacked = currentFrame.getPackedParticles();
                    } else {
                        currentParticles = Collections.emptyList();
                        emitThisTick = false;
                    }
                } else {
                    List<ParticleData> list = currentParticles = model.getParticles() != null ? model.getParticles() : Collections.emptyList();
                    if (model.hasPackedParticles()) {
                        currentPacked = model.getPackedParticles();
                    }
                }
                if (shouldShow && emitThisTick && !currentParticles.isEmpty()) {
                    boolean shouldSpawnThisTick = true;
                    if (isMoving) {
                        boolean bl = shouldSpawnThisTick = this.tick % 2 == 0;
                    }
                    if (shouldSpawnThisTick) {
                        ParticleModelManager.this.processParticlesForPlayer(currentParticles, currentPacked, player, currentLocation, effects, this.tick, lifetimeSeconds, this.maxTicks, forceVisible, effectKey, this.isAnimatedModel);
                    }
                }
                ++this.tick;
            }
        }, 0L, 1L);
        this.activeEffects.put(effectKey, task);
        return effectId;
    }

    private int playModelOnPlayerWithId(String modelName, final Player player, final int lifetimeSeconds, final ParticleEffects.EffectSettings effects, final boolean onlyWhenStill, final boolean forceVisible, int desiredId) {
        final ParticleModel model = this.getModel(modelName);
        if (model == null) {
            this.plugin.getLogger().warning("Model not found: " + modelName);
            return -1;
        }
        if (player == null || !player.isOnline()) {
            this.plugin.getLogger().warning("Invalid or offline player for model: " + modelName);
            return -1;
        }
        if (model.getParticles() == null || model.getParticles().isEmpty()) {
            this.plugin.getLogger().warning("Model has no particles: " + modelName);
            return -1;
        }
        final int effectId = this.reserveSpecificEffectId(desiredId);
        if (effectId != desiredId) {
            this.plugin.getLogger().warning("Effect ID conflict for restore: requested " + desiredId + ", assigned " + effectId + ".");
        }
        final String effectKey = modelName + "_player_" + player.getName() + "_" + effectId + "_" + System.currentTimeMillis();
        this.activeEffectInfo.put(effectKey, new EffectInfo(effectId, modelName, player, lifetimeSeconds, onlyWhenStill, forceVisible, effects));
        this.effectIdMap.put(effectId, effectKey);
        final Location[] lastLocation = new Location[]{player.getLocation().clone()};
        BukkitTask task = Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, new Runnable(){
            private int tick = 0;
            private final int maxTicks = Math.max(model.getDuration(), ParticleModelManager.this.getMaxParticleDelay(model) + 60);
            private final boolean isAnimatedModel = model instanceof AnimatedModel;
            private long startMs = System.currentTimeMillis();
            private int lastFrameIndex = -1;
            private int lastFrameChangeTick = 0;

            @Override
            public void run() {
                List<ParticleData> currentParticles;
                EffectInfo currentEffect = ParticleModelManager.this.activeEffectInfo.get(effectKey);
                if (currentEffect == null) {
                    BukkitTask currentTask = ParticleModelManager.this.activeEffects.remove(effectKey);
                    if (currentTask != null) {
                        currentTask.cancel();
                    }
                    return;
                }
                if (!player.isOnline()) {
                    BukkitTask currentTask = ParticleModelManager.this.activeEffects.remove(effectKey);
                    ParticleModelManager.this.activeEffectInfo.remove(effectKey);
                    ParticleModelManager.this.effectIdMap.remove(effectId);
                    if (currentTask != null) {
                        currentTask.cancel();
                    }
                    return;
                }
                if (currentEffect.hasExpired()) {
                    BukkitTask currentTask = ParticleModelManager.this.activeEffects.remove(effectKey);
                    ParticleModelManager.this.activeEffectInfo.remove(effectKey);
                    ParticleModelManager.this.effectIdMap.remove(effectId);
                    if (currentTask != null) {
                        currentTask.cancel();
                    }
                    return;
                }
                if (this.tick >= this.maxTicks && lifetimeSeconds == 0) {
                    BukkitTask currentTask = ParticleModelManager.this.activeEffects.remove(effectKey);
                    ParticleModelManager.this.activeEffectInfo.remove(effectKey);
                    ParticleModelManager.this.effectIdMap.remove(effectId);
                    if (currentTask != null) {
                        currentTask.cancel();
                    }
                    return;
                }
                Location currentLocation = player.getLocation();
                boolean shouldShow = true;
                boolean isMoving = false;
                if (onlyWhenStill) {
                    distance = lastLocation[0].distance(currentLocation);
                    shouldShow = distance < 0.1;
                    isMoving = distance >= 0.05;
                } else {
                    distance = lastLocation[0].distance(currentLocation);
                    isMoving = distance >= 0.05;
                }
                lastLocation[0] = currentLocation.clone();
                PackedParticleArray currentPacked = null;
                boolean emitThisTick = true;
                if (this.isAnimatedModel) {
                    FrameData currentFrame;
                    AnimatedModel animatedModel = (AnimatedModel)model;
                    FrameData frameData = currentFrame = animatedModel.isTickAligned() ? animatedModel.getFrameAtTick(this.tick) : animatedModel.getFrameAtTime(System.currentTimeMillis() - this.startMs);
                    if (currentFrame != null) {
                        int frameIndex = currentFrame.getFrameIndex();
                        if (frameIndex != this.lastFrameIndex) {
                            this.lastFrameIndex = frameIndex;
                            this.lastFrameChangeTick = this.tick;
                            emitThisTick = true;
                        } else {
                            int lifespan = Math.max(1, ParticleModelManager.this.config.getMediaParticleLifespanTicks());
                            emitThisTick = this.tick - this.lastFrameChangeTick < lifespan;
                        }
                        currentParticles = currentFrame.getParticles();
                        currentPacked = currentFrame.getPackedParticles();
                    } else {
                        currentParticles = Collections.emptyList();
                        emitThisTick = false;
                    }
                } else {
                    List<ParticleData> list = currentParticles = model.getParticles() != null ? model.getParticles() : Collections.emptyList();
                    if (model.hasPackedParticles()) {
                        currentPacked = model.getPackedParticles();
                    }
                }
                if (shouldShow && emitThisTick && !currentParticles.isEmpty()) {
                    boolean shouldSpawnThisTick = true;
                    if (isMoving) {
                        boolean bl = shouldSpawnThisTick = this.tick % 2 == 0;
                    }
                    if (shouldSpawnThisTick) {
                        ParticleModelManager.this.processParticlesForPlayer(currentParticles, currentPacked, player, currentLocation, effects, this.tick, lifetimeSeconds, this.maxTicks, forceVisible, effectKey, this.isAnimatedModel);
                    }
                }
                ++this.tick;
            }
        }, 0L, 1L);
        this.activeEffects.put(effectKey, task);
        return effectId;
    }

    private int playModelOnLocationWithEffects(String modelName, final Location location, final int lifetimeSeconds, boolean persistent, final ParticleEffects.EffectSettings effects) {
        boolean isLargeModel;
        final ParticleModel model = this.getModel(modelName);
        if (model == null) {
            this.plugin.getLogger().warning("Model not found: " + modelName);
            return -1;
        }
        if (location == null || location.getWorld() == null) {
            this.plugin.getLogger().warning("Invalid location for model: " + modelName);
            return -1;
        }
        if (model.getParticles() == null || model.getParticles().isEmpty()) {
            this.plugin.getLogger().warning("Model has no particles: " + modelName);
            return -1;
        }
        final int effectId = this.allocateEffectId();
        final String effectKey = modelName + "_" + effectId + "_" + System.currentTimeMillis();
        this.activeEffectInfo.put(effectKey, new EffectInfo(effectId, modelName, location.clone(), lifetimeSeconds, persistent, effects));
        this.effectIdMap.put(effectId, effectKey);
        int tickRate = 1;
        boolean bl = isLargeModel = model.getParticles() != null && model.getParticles().size() > 4500;
        if (isLargeModel) {
            int particleCount = model.getParticles().size();
            if (particleCount > 10000) {
                MessageUtils.logVerbose((Plugin)this.plugin, this.config, "Loading very large model '" + modelName + "' (" + particleCount + " particles) - using sectioned rendering with persistent outline");
            } else {
                MessageUtils.logVerbose((Plugin)this.plugin, this.config, "Loading large model '" + modelName + "' (" + particleCount + " particles) - using persistence overlap rendering");
            }
        }
        BukkitTask task = Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, new Runnable(){
            private int tick = 0;
            private final int maxTicks = Math.max(model.getDuration(), ParticleModelManager.this.getMaxParticleDelay(model) + 60);
            private final int particleCount = model.getParticles() != null ? model.getParticles().size() : 0;
            private final boolean isAnimatedModel = model instanceof AnimatedModel;
            private long startMs = System.currentTimeMillis();
            private int lastFrameIndex = -1;

            @Override
            public void run() {
                List<ParticleData> currentParticles;
                EffectInfo currentEffect = ParticleModelManager.this.activeEffectInfo.get(effectKey);
                if (currentEffect == null) {
                    BukkitTask currentTask = ParticleModelManager.this.activeEffects.remove(effectKey);
                    if (currentTask != null) {
                        currentTask.cancel();
                    }
                    return;
                }
                if (currentEffect.hasExpired()) {
                    BukkitTask currentTask = ParticleModelManager.this.activeEffects.remove(effectKey);
                    ParticleModelManager.this.activeEffectInfo.remove(effectKey);
                    ParticleModelManager.this.effectIdMap.remove(effectId);
                    if (currentTask != null) {
                        currentTask.cancel();
                    }
                    return;
                }
                if (this.tick >= this.maxTicks && lifetimeSeconds == 0) {
                    BukkitTask currentTask = ParticleModelManager.this.activeEffects.remove(effectKey);
                    ParticleModelManager.this.activeEffectInfo.remove(effectKey);
                    ParticleModelManager.this.effectIdMap.remove(effectId);
                    if (currentTask != null) {
                        currentTask.cancel();
                    }
                    return;
                }
                PackedParticleArray currentPacked = null;
                if (this.isAnimatedModel) {
                    FrameData currentFrame;
                    AnimatedModel animatedModel = (AnimatedModel)model;
                    FrameData frameData = currentFrame = animatedModel.isTickAligned() ? animatedModel.getFrameAtTick(this.tick) : animatedModel.getFrameAtTime(System.currentTimeMillis() - this.startMs);
                    if (currentFrame != null) {
                        int frameIndex = currentFrame.getFrameIndex();
                        if (frameIndex == this.lastFrameIndex) {
                            ++this.tick;
                            return;
                        }
                        this.lastFrameIndex = frameIndex;
                        currentParticles = currentFrame.getParticles();
                        currentPacked = currentFrame.getPackedParticles();
                    } else {
                        currentParticles = Collections.emptyList();
                    }
                } else {
                    List<ParticleData> list = currentParticles = model.getParticles() != null ? model.getParticles() : Collections.emptyList();
                    if (model.hasPackedParticles()) {
                        currentPacked = model.getPackedParticles();
                    }
                }
                if (!currentParticles.isEmpty()) {
                    ParticleModelManager.this.processParticlesSimple(currentParticles, currentPacked, null, location, effects, this.tick, lifetimeSeconds, this.maxTicks, effectKey, this.isAnimatedModel);
                }
                ++this.tick;
            }
        }, 0L, (long)tickRate);
        this.activeEffects.put(effectKey, task);
        return effectId;
    }

    private int playModelOnLocationWithEffectsWithId(String modelName, final Location location, final int lifetimeSeconds, boolean persistent, final ParticleEffects.EffectSettings effects, int desiredId) {
        boolean isLargeModel;
        final ParticleModel model = this.getModel(modelName);
        if (model == null) {
            this.plugin.getLogger().warning("Model not found: " + modelName);
            return -1;
        }
        if (location == null || location.getWorld() == null) {
            this.plugin.getLogger().warning("Invalid location for model: " + modelName);
            return -1;
        }
        if (model.getParticles() == null || model.getParticles().isEmpty()) {
            this.plugin.getLogger().warning("Model has no particles: " + modelName);
            return -1;
        }
        final int effectId = this.reserveSpecificEffectId(desiredId);
        if (effectId != desiredId) {
            this.plugin.getLogger().warning("Effect ID conflict for restore: requested " + desiredId + ", assigned " + effectId + ".");
        }
        final String effectKey = modelName + "_" + effectId + "_" + System.currentTimeMillis();
        this.activeEffectInfo.put(effectKey, new EffectInfo(effectId, modelName, location.clone(), lifetimeSeconds, persistent, effects));
        this.effectIdMap.put(effectId, effectKey);
        int tickRate = 1;
        boolean bl = isLargeModel = model.getParticles() != null && model.getParticles().size() > 4500;
        if (isLargeModel) {
            int particleCount = model.getParticles().size();
            if (particleCount > 10000) {
                MessageUtils.logVerbose((Plugin)this.plugin, this.config, "Loading very large model '" + modelName + "' (" + particleCount + " particles) - using sectioned rendering with persistent outline");
            } else {
                MessageUtils.logVerbose((Plugin)this.plugin, this.config, "Loading large model '" + modelName + "' (" + particleCount + " particles) - using persistence overlap rendering");
            }
        }
        BukkitTask task = Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, new Runnable(){
            private int tick = 0;
            private final int maxTicks = Math.max(model.getDuration(), ParticleModelManager.this.getMaxParticleDelay(model) + 60);
            private final int particleCount = model.getParticles() != null ? model.getParticles().size() : 0;
            private final boolean isAnimatedModel = model instanceof AnimatedModel;
            private long startMs = System.currentTimeMillis();
            private int lastFrameIndex = -1;

            @Override
            public void run() {
                List<Object> currentParticles;
                EffectInfo currentEffect = ParticleModelManager.this.activeEffectInfo.get(effectKey);
                if (currentEffect == null) {
                    BukkitTask currentTask = ParticleModelManager.this.activeEffects.remove(effectKey);
                    if (currentTask != null) {
                        currentTask.cancel();
                    }
                    return;
                }
                if (currentEffect.hasExpired()) {
                    BukkitTask currentTask = ParticleModelManager.this.activeEffects.remove(effectKey);
                    ParticleModelManager.this.activeEffectInfo.remove(effectKey);
                    ParticleModelManager.this.effectIdMap.remove(effectId);
                    if (currentTask != null) {
                        currentTask.cancel();
                    }
                    return;
                }
                if (this.tick >= this.maxTicks && lifetimeSeconds == 0) {
                    BukkitTask currentTask = ParticleModelManager.this.activeEffects.remove(effectKey);
                    ParticleModelManager.this.activeEffectInfo.remove(effectKey);
                    ParticleModelManager.this.effectIdMap.remove(effectId);
                    if (currentTask != null) {
                        currentTask.cancel();
                    }
                    return;
                }
                if (this.isAnimatedModel) {
                    FrameData currentFrame;
                    AnimatedModel animatedModel = (AnimatedModel)model;
                    FrameData frameData = currentFrame = animatedModel.isTickAligned() ? animatedModel.getFrameAtTick(this.tick) : animatedModel.getFrameAtTime(System.currentTimeMillis() - this.startMs);
                    if (currentFrame != null) {
                        int frameIndex = currentFrame.getFrameIndex();
                        if (frameIndex == this.lastFrameIndex) {
                            ++this.tick;
                            return;
                        }
                        this.lastFrameIndex = frameIndex;
                        currentParticles = currentFrame.getParticles();
                    } else {
                        currentParticles = new ArrayList();
                    }
                } else {
                    List<Object> list = currentParticles = model.getParticles() != null ? model.getParticles() : new ArrayList();
                }
                if (!currentParticles.isEmpty()) {
                    ParticleModelManager.this.processParticlesSimple(currentParticles, null, location, effects, this.tick, lifetimeSeconds, this.maxTicks, effectKey, this.isAnimatedModel);
                }
                ++this.tick;
            }
        }, 0L, (long)tickRate);
        this.activeEffects.put(effectKey, task);
        return effectId;
    }

    private int playModelOnLocationWithEffectsWithExistingId(String modelName, final Location location, final int lifetimeSeconds, boolean persistent, final ParticleEffects.EffectSettings effects, int existingId) {
        boolean isLargeModel;
        final ParticleModel model = this.getModel(modelName);
        if (model == null) {
            this.plugin.getLogger().warning("Model not found: " + modelName);
            return -1;
        }
        if (location == null || location.getWorld() == null) {
            this.plugin.getLogger().warning("Invalid location for model: " + modelName);
            return -1;
        }
        if (model.getParticles() == null || model.getParticles().isEmpty()) {
            this.plugin.getLogger().warning("Model has no particles: " + modelName);
            return -1;
        }
        final int effectId = existingId;
        final String effectKey = modelName + "_" + effectId + "_" + System.currentTimeMillis();
        this.activeEffectInfo.put(effectKey, new EffectInfo(effectId, modelName, location.clone(), lifetimeSeconds, persistent, effects));
        this.effectIdMap.put(effectId, effectKey);
        int tickRate = 1;
        boolean bl = isLargeModel = model.getParticles() != null && model.getParticles().size() > 4500;
        if (isLargeModel) {
            int particleCount = model.getParticles().size();
            if (particleCount > 10000) {
                MessageUtils.logVerbose((Plugin)this.plugin, this.config, "Loading very large model '" + modelName + "' (" + particleCount + " particles) - using sectioned rendering with persistent outline");
            } else {
                MessageUtils.logVerbose((Plugin)this.plugin, this.config, "Loading large model '" + modelName + "' (" + particleCount + " particles) - using persistence overlap rendering");
            }
        }
        BukkitTask task = Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, new Runnable(){
            private int tick = 0;
            private final int maxTicks = Math.max(model.getDuration(), ParticleModelManager.this.getMaxParticleDelay(model) + 60);
            private final int particleCount = model.getParticles() != null ? model.getParticles().size() : 0;
            private final boolean isAnimatedModel = model instanceof AnimatedModel;
            private long startMs = System.currentTimeMillis();
            private int lastFrameIndex = -1;

            @Override
            public void run() {
                List<Object> currentParticles;
                EffectInfo currentEffect = ParticleModelManager.this.activeEffectInfo.get(effectKey);
                if (currentEffect == null) {
                    BukkitTask currentTask = ParticleModelManager.this.activeEffects.remove(effectKey);
                    if (currentTask != null) {
                        currentTask.cancel();
                    }
                    return;
                }
                if (currentEffect.hasExpired()) {
                    BukkitTask currentTask = ParticleModelManager.this.activeEffects.remove(effectKey);
                    ParticleModelManager.this.activeEffectInfo.remove(effectKey);
                    ParticleModelManager.this.effectIdMap.remove(effectId);
                    if (currentTask != null) {
                        currentTask.cancel();
                    }
                    return;
                }
                if (this.tick >= this.maxTicks && lifetimeSeconds == 0) {
                    BukkitTask currentTask = ParticleModelManager.this.activeEffects.remove(effectKey);
                    ParticleModelManager.this.activeEffectInfo.remove(effectKey);
                    ParticleModelManager.this.effectIdMap.remove(effectId);
                    if (currentTask != null) {
                        currentTask.cancel();
                    }
                    return;
                }
                if (this.isAnimatedModel) {
                    FrameData currentFrame;
                    AnimatedModel animatedModel = (AnimatedModel)model;
                    FrameData frameData = currentFrame = animatedModel.isTickAligned() ? animatedModel.getFrameAtTick(this.tick) : animatedModel.getFrameAtTime(System.currentTimeMillis() - this.startMs);
                    if (currentFrame != null) {
                        int frameIndex = currentFrame.getFrameIndex();
                        if (frameIndex == this.lastFrameIndex) {
                            ++this.tick;
                            return;
                        }
                        this.lastFrameIndex = frameIndex;
                        currentParticles = currentFrame.getParticles();
                    } else {
                        currentParticles = new ArrayList();
                    }
                } else {
                    List<Object> list = currentParticles = model.getParticles() != null ? model.getParticles() : new ArrayList();
                }
                if (!currentParticles.isEmpty()) {
                    ParticleModelManager.this.processParticlesSimple(currentParticles, null, location, effects, this.tick, lifetimeSeconds, this.maxTicks, effectKey, this.isAnimatedModel);
                }
                ++this.tick;
            }
        }, 0L, (long)tickRate);
        this.activeEffects.put(effectKey, task);
        return effectId;
    }

    private int playModelOnLocationWithEffectsAndTickOffset(String modelName, final Location location, final int lifetimeSeconds, boolean persistent, final ParticleEffects.EffectSettings effects, final long initialTickOffset) {
        boolean isLargeModel;
        final ParticleModel model = this.getModel(modelName);
        if (model == null) {
            this.plugin.getLogger().warning("DustLab: Model not found: " + modelName);
            return -1;
        }
        if (location == null || location.getWorld() == null) {
            this.plugin.getLogger().warning("DustLab: Invalid location for model: " + modelName);
            return -1;
        }
        if (model.getParticles() == null || model.getParticles().isEmpty()) {
            this.plugin.getLogger().warning("DustLab: Model has no particles: " + modelName);
            return -1;
        }
        final int effectId = this.allocateEffectId();
        final String effectKey = modelName + "_" + effectId + "_" + System.currentTimeMillis();
        this.activeEffectInfo.put(effectKey, new EffectInfo(effectId, modelName, location.clone(), lifetimeSeconds, persistent, effects));
        this.effectIdMap.put(effectId, effectKey);
        int tickRate = 1;
        boolean bl = isLargeModel = model.getParticles() != null && model.getParticles().size() > 4500;
        if (isLargeModel) {
            int particleCount = model.getParticles().size();
            if (particleCount > 10000) {
                MessageUtils.logVerbose((Plugin)this.plugin, this.config, "Loading very large model '" + modelName + "' (" + particleCount + " particles) - using sectioned rendering with persistent outline");
            } else {
                MessageUtils.logVerbose((Plugin)this.plugin, this.config, "Loading large model '" + modelName + "' (" + particleCount + " particles) - using persistence overlap rendering");
            }
        }
        BukkitTask task = Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, new Runnable(){
            private int tick;
            private final int maxTicks;
            private final int particleCount;
            private final boolean isAnimatedModel;
            private long startMs;
            private int lastFrameIndex;
            {
                this.tick = (int)initialTickOffset;
                this.maxTicks = Math.max(model.getDuration(), ParticleModelManager.this.getMaxParticleDelay(model) + 60);
                this.particleCount = model.getParticles() != null ? model.getParticles().size() : 0;
                this.isAnimatedModel = model instanceof AnimatedModel;
                this.startMs = System.currentTimeMillis() - initialTickOffset * 50L;
                this.lastFrameIndex = -1;
            }

            @Override
            public void run() {
                List<ParticleData> currentParticles;
                EffectInfo currentEffect = ParticleModelManager.this.activeEffectInfo.get(effectKey);
                if (currentEffect == null) {
                    BukkitTask currentTask = ParticleModelManager.this.activeEffects.remove(effectKey);
                    if (currentTask != null) {
                        currentTask.cancel();
                    }
                    return;
                }
                if (currentEffect.hasExpired()) {
                    BukkitTask currentTask = ParticleModelManager.this.activeEffects.remove(effectKey);
                    ParticleModelManager.this.activeEffectInfo.remove(effectKey);
                    ParticleModelManager.this.effectIdMap.remove(effectId);
                    if (currentTask != null) {
                        currentTask.cancel();
                    }
                    return;
                }
                if (this.tick >= this.maxTicks && lifetimeSeconds == 0) {
                    BukkitTask currentTask = ParticleModelManager.this.activeEffects.remove(effectKey);
                    ParticleModelManager.this.activeEffectInfo.remove(effectKey);
                    ParticleModelManager.this.effectIdMap.remove(effectId);
                    if (currentTask != null) {
                        currentTask.cancel();
                    }
                    return;
                }
                PackedParticleArray currentPacked = null;
                if (this.isAnimatedModel) {
                    FrameData currentFrame;
                    AnimatedModel animatedModel = (AnimatedModel)model;
                    FrameData frameData = currentFrame = animatedModel.isTickAligned() ? animatedModel.getFrameAtTick(this.tick) : animatedModel.getFrameAtTime(System.currentTimeMillis() - this.startMs);
                    if (currentFrame != null) {
                        int frameIndex = currentFrame.getFrameIndex();
                        if (frameIndex == this.lastFrameIndex) {
                            ++this.tick;
                            return;
                        }
                        this.lastFrameIndex = frameIndex;
                        currentParticles = currentFrame.getParticles();
                        currentPacked = currentFrame.getPackedParticles();
                    } else {
                        currentParticles = Collections.emptyList();
                    }
                } else {
                    List<ParticleData> list = currentParticles = model.getParticles() != null ? model.getParticles() : Collections.emptyList();
                    if (model.hasPackedParticles()) {
                        currentPacked = model.getPackedParticles();
                    }
                }
                if (!currentParticles.isEmpty()) {
                    ParticleModelManager.this.processParticlesSimple(currentParticles, currentPacked, null, location, effects, this.tick, lifetimeSeconds, this.maxTicks, effectKey, this.isAnimatedModel);
                }
                ++this.tick;
            }
        }, 0L, (long)tickRate);
        this.activeEffects.put(effectKey, task);
        return effectId;
    }

    private int playModelOnLocationWithEffectsAndTickOffsetWithId(String modelName, final Location location, final int lifetimeSeconds, boolean persistent, final ParticleEffects.EffectSettings effects, final long initialTickOffset, int desiredId) {
        boolean isLargeModel;
        final ParticleModel model = this.getModel(modelName);
        if (model == null) {
            this.plugin.getLogger().warning("DustLab: Model not found: " + modelName);
            return -1;
        }
        if (location == null || location.getWorld() == null) {
            this.plugin.getLogger().warning("DustLab: Invalid location for model: " + modelName);
            return -1;
        }
        if (model.getParticles() == null || model.getParticles().isEmpty()) {
            this.plugin.getLogger().warning("DustLab: Model has no particles: " + modelName);
            return -1;
        }
        final int effectId = this.reserveSpecificEffectId(desiredId);
        if (effectId != desiredId) {
            this.plugin.getLogger().warning("Effect ID conflict for restore: requested " + desiredId + ", assigned " + effectId + ".");
        }
        final String effectKey = modelName + "_" + effectId + "_" + System.currentTimeMillis();
        this.activeEffectInfo.put(effectKey, new EffectInfo(effectId, modelName, location.clone(), lifetimeSeconds, persistent, effects));
        this.effectIdMap.put(effectId, effectKey);
        int tickRate = 1;
        boolean bl = isLargeModel = model.getParticles() != null && model.getParticles().size() > 4500;
        if (isLargeModel) {
            int particleCount = model.getParticles().size();
            if (particleCount > 10000) {
                MessageUtils.logVerbose((Plugin)this.plugin, this.config, "Loading very large model '" + modelName + "' (" + particleCount + " particles) - using sectioned rendering with persistent outline");
            } else {
                MessageUtils.logVerbose((Plugin)this.plugin, this.config, "Loading large model '" + modelName + "' (" + particleCount + " particles) - using persistence overlap rendering");
            }
        }
        BukkitTask task = Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, new Runnable(){
            private int tick;
            private final int maxTicks;
            private final int particleCount;
            private final boolean isAnimatedModel;
            private long startMs;
            private int lastFrameIndex;
            {
                this.tick = (int)initialTickOffset;
                this.maxTicks = Math.max(model.getDuration(), ParticleModelManager.this.getMaxParticleDelay(model) + 60);
                this.particleCount = model.getParticles() != null ? model.getParticles().size() : 0;
                this.isAnimatedModel = model instanceof AnimatedModel;
                this.startMs = System.currentTimeMillis() - initialTickOffset * 50L;
                this.lastFrameIndex = -1;
            }

            @Override
            public void run() {
                List<Object> currentParticles;
                EffectInfo currentEffect = ParticleModelManager.this.activeEffectInfo.get(effectKey);
                if (currentEffect == null) {
                    BukkitTask currentTask = ParticleModelManager.this.activeEffects.remove(effectKey);
                    if (currentTask != null) {
                        currentTask.cancel();
                    }
                    return;
                }
                if (currentEffect.hasExpired()) {
                    BukkitTask currentTask = ParticleModelManager.this.activeEffects.remove(effectKey);
                    ParticleModelManager.this.activeEffectInfo.remove(effectKey);
                    ParticleModelManager.this.effectIdMap.remove(effectId);
                    if (currentTask != null) {
                        currentTask.cancel();
                    }
                    return;
                }
                if (this.tick >= this.maxTicks && lifetimeSeconds == 0) {
                    BukkitTask currentTask = ParticleModelManager.this.activeEffects.remove(effectKey);
                    ParticleModelManager.this.activeEffectInfo.remove(effectKey);
                    ParticleModelManager.this.effectIdMap.remove(effectId);
                    if (currentTask != null) {
                        currentTask.cancel();
                    }
                    return;
                }
                if (this.isAnimatedModel) {
                    FrameData currentFrame;
                    AnimatedModel animatedModel = (AnimatedModel)model;
                    FrameData frameData = currentFrame = animatedModel.isTickAligned() ? animatedModel.getFrameAtTick(this.tick) : animatedModel.getFrameAtTime(System.currentTimeMillis() - this.startMs);
                    if (currentFrame != null) {
                        int frameIndex = currentFrame.getFrameIndex();
                        if (frameIndex == this.lastFrameIndex) {
                            ++this.tick;
                            return;
                        }
                        this.lastFrameIndex = frameIndex;
                        currentParticles = currentFrame.getParticles();
                    } else {
                        currentParticles = new ArrayList();
                    }
                } else {
                    List<Object> list = currentParticles = model.getParticles() != null ? model.getParticles() : new ArrayList();
                }
                if (!currentParticles.isEmpty()) {
                    ParticleModelManager.this.processParticlesSimple(currentParticles, null, location, effects, this.tick, lifetimeSeconds, this.maxTicks, effectKey, this.isAnimatedModel);
                }
                ++this.tick;
            }
        }, 0L, (long)tickRate);
        this.activeEffects.put(effectKey, task);
        return effectId;
    }

    private void processParticlesSimple(List<ParticleData> particles, List<ParticleData> previousParticles, Location baseLocation, ParticleEffects.EffectSettings effects, int tick, int lifetimeSeconds, int maxTicks, String effectId, boolean isAnimated) {
        this.processParticlesSimple(particles, null, previousParticles, baseLocation, effects, tick, lifetimeSeconds, maxTicks, effectId, isAnimated);
    }

    private void processParticlesSimple(List<ParticleData> particles, PackedParticleArray packedParticles, List<ParticleData> previousParticles, Location baseLocation, ParticleEffects.EffectSettings effects, int tick, int lifetimeSeconds, int maxTicks, String effectId, boolean isAnimated) {
        int particleCount;
        Collection<Player> viewers = this.collectViewers(baseLocation, false);
        if (viewers.isEmpty()) {
            return;
        }
        int n = particleCount = packedParticles != null ? packedParticles.size() : particles.size();
        if (particleCount == 0) {
            return;
        }
        ParticleData reusableParticle = packedParticles != null ? new ParticleData() : null;
        int veryLargeThreshold = this.getVeryLargeModelThreshold();
        int largeThreshold = this.getLargeModelThreshold();
        if (!isAnimated) {
            if (particleCount > veryLargeThreshold) {
                this.processVeryLargeModel(particles, packedParticles, baseLocation, viewers, effects, tick, lifetimeSeconds, maxTicks);
                return;
            }
            if (particleCount > largeThreshold) {
                this.processLargeModelWithPersistence(particles, packedParticles, baseLocation, viewers, effects, tick, lifetimeSeconds, maxTicks);
                return;
            }
        }
        if (isAnimated) {
            for (int i = 0; i < particleCount; ++i) {
                ParticleData particle;
                if (packedParticles != null) {
                    packedParticles.copyInto(i, reusableParticle);
                    particle = reusableParticle;
                } else {
                    particle = particles.get(i);
                }
                if (particle == null) continue;
                ParticleData prev = previousParticles != null && i < previousParticles.size() ? previousParticles.get(i) : null;
                this.spawnParticleWithEffects(particle, prev, baseLocation, viewers, effects, tick, true);
            }
            return;
        }
        for (int i = 0; i < particleCount; ++i) {
            ParticleData particle;
            if (packedParticles != null) {
                packedParticles.copyInto(i, reusableParticle);
                particle = reusableParticle;
            } else {
                particle = particles.get(i);
            }
            if (particle == null) continue;
            boolean shouldSpawn = false;
            if (lifetimeSeconds == -1) {
                int cycleLength = Math.max(maxTicks, 100);
                int cycleTick = tick % cycleLength;
                if (cycleTick >= particle.getDelay()) {
                    int spawnInterval;
                    int n2 = spawnInterval = effects != null ? 1 : 3;
                    if ((cycleTick - particle.getDelay()) % spawnInterval == 0) {
                        shouldSpawn = true;
                    }
                }
            } else if (tick >= particle.getDelay() && (lifetimeSeconds > 0 || tick < maxTicks)) {
                int spawnInterval;
                int n3 = spawnInterval = effects != null ? 1 : 3;
                if ((tick - particle.getDelay()) % spawnInterval == 0) {
                    shouldSpawn = true;
                }
            }
            if (!shouldSpawn) continue;
            this.spawnParticleWithEffects(particle, baseLocation, viewers, effects, tick);
        }
    }

    private void processLargeModelWithPersistence(List<ParticleData> particles, PackedParticleArray packedParticles, Location baseLocation, Collection<Player> viewers, ParticleEffects.EffectSettings effects, int tick, int lifetimeSeconds, int maxTicks) {
        int particleCount = packedParticles != null ? packedParticles.size() : particles.size();
        ParticleData reusable = packedParticles != null ? new ParticleData() : null;
        int fadeInDuration = 60;
        int particlesPerTick = Math.max(1, particleCount / fadeInDuration);
        int maxVisibleParticles = Math.min(particleCount, (tick + 1) * particlesPerTick);
        int baseOutlineInterval = Math.max(1, particleCount / 100);
        for (int i = 0; i < particleCount; ++i) {
            boolean isWithinFadeIn;
            ParticleData particle;
            if (packedParticles != null) {
                packedParticles.copyInto(i, reusable);
                particle = reusable;
            } else {
                particle = particles.get(i);
            }
            if (particle == null) continue;
            boolean shouldSpawn = false;
            boolean isBaseOutline = i % baseOutlineInterval == 0;
            boolean bl = isWithinFadeIn = i < maxVisibleParticles;
            if (lifetimeSeconds == -1) {
                int cycleLength = Math.max(maxTicks, 100);
                int cycleTick = tick % cycleLength;
                if (cycleTick >= particle.getDelay()) {
                    if (isBaseOutline) {
                        shouldSpawn = true;
                    } else if (isWithinFadeIn && tick % 2 == 0) {
                        shouldSpawn = true;
                    }
                }
            } else if (tick >= particle.getDelay() && (lifetimeSeconds > 0 || tick < maxTicks)) {
                if (isBaseOutline) {
                    shouldSpawn = true;
                } else if (isWithinFadeIn && tick % 2 == 0) {
                    shouldSpawn = true;
                }
            }
            if (!shouldSpawn) continue;
            this.spawnParticleWithEffects(particle, baseLocation, viewers, effects, tick);
        }
    }

    private void processVeryLargeModel(List<ParticleData> particles, PackedParticleArray packedParticles, Location baseLocation, Collection<Player> viewers, ParticleEffects.EffectSettings effects, int tick, int lifetimeSeconds, int maxTicks) {
        int particleCount = packedParticles != null ? packedParticles.size() : particles.size();
        ParticleData reusable = packedParticles != null ? new ParticleData() : null;
        int maxParticlesPerSection = 2000;
        int totalSections = (int)Math.ceil((double)particleCount / (double)maxParticlesPerSection);
        int sectionRotationSpeed = 8;
        int currentSection = tick / sectionRotationSpeed % totalSections;
        int transitionTicks = 4;
        int tickInCycle = tick % sectionRotationSpeed;
        boolean isInTransition = tickInCycle >= sectionRotationSpeed - transitionTicks;
        int nextSection = (currentSection + 1) % totalSections;
        int currentSectionStart = currentSection * maxParticlesPerSection;
        int currentSectionEnd = Math.min(currentSectionStart + maxParticlesPerSection, particleCount);
        int nextSectionStart = nextSection * maxParticlesPerSection;
        int nextSectionEnd = Math.min(nextSectionStart + maxParticlesPerSection, particleCount);
        int persistentInterval = Math.max(1, particleCount / 150);
        for (int i = 0; i < particleCount; ++i) {
            boolean isPersistentParticle;
            ParticleData particle;
            if (packedParticles != null) {
                packedParticles.copyInto(i, reusable);
                particle = reusable;
            } else {
                particle = particles.get(i);
            }
            if (particle == null) continue;
            boolean shouldSpawn = false;
            boolean isInCurrentSection = i >= currentSectionStart && i < currentSectionEnd;
            boolean isInNextSection = i >= nextSectionStart && i < nextSectionEnd;
            boolean bl = isPersistentParticle = i % persistentInterval == 0;
            if (lifetimeSeconds == -1) {
                int cycleLength = Math.max(maxTicks, 100);
                int cycleTick = tick % cycleLength;
                if (cycleTick >= particle.getDelay()) {
                    if (isPersistentParticle) {
                        shouldSpawn = true;
                    } else if (isInCurrentSection) {
                        shouldSpawn = true;
                    } else if (isInTransition && isInNextSection && tick % 3 == 0) {
                        shouldSpawn = true;
                    }
                }
            } else if (tick >= particle.getDelay() && (lifetimeSeconds > 0 || tick < maxTicks)) {
                if (isPersistentParticle) {
                    shouldSpawn = true;
                } else if (isInCurrentSection) {
                    shouldSpawn = true;
                } else if (isInTransition && isInNextSection && tick % 3 == 0) {
                    shouldSpawn = true;
                }
            }
            if (!shouldSpawn) continue;
            this.spawnParticleWithEffects(particle, baseLocation, viewers, effects, tick);
        }
    }

    private Collection<Player> collectViewers(Location origin, boolean forceVisible) {
        return this.collectViewers(origin, MAX_RENDER_DISTANCE, forceVisible);
    }

    private Collection<Player> collectViewers(Location origin, double radius, boolean forceVisible) {
        if (origin == null) {
            return Collections.emptyList();
        }
        World world = origin.getWorld();
        if (world == null) {
            return Collections.emptyList();
        }
        Collection nearby = world.getNearbyPlayers(origin, radius);
        if (nearby.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Player> viewers = new ArrayList<Player>(nearby.size());
        for (Player viewer : nearby) {
            if (!forceVisible && !this.canSeeParticles(viewer)) continue;
            viewers.add(viewer);
        }
        return viewers;
    }

    public int playModel(String modelName, Location location) {
        return this.playModel(modelName, location, false);
    }

    private int getMaxParticleDelay(ParticleModel model) {
        int maxDelay = 0;
        if (model.getParticles() != null) {
            for (ParticleData particle : model.getParticles()) {
                if (particle == null || particle.getDelay() <= maxDelay) continue;
                maxDelay = particle.getDelay();
            }
        }
        return maxDelay;
    }

    private void spawnParticleWithEffects(ParticleData particle, Location baseLocation, Collection<Player> viewers, ParticleEffects.EffectSettings effects, long tick, boolean isAnimated) {
        if (viewers.isEmpty()) {
            return;
        }
        try {
            Location particleLocation;
            World world = baseLocation.getWorld();
            if (world == null) {
                return;
            }
            if (effects != null) {
                particleLocation = ParticleEffects.applyEffects(particle, baseLocation, effects, tick);
            } else {
                double x = particle.getX();
                double y = particle.getY();
                double z = particle.getZ();
                particleLocation = baseLocation.clone().add(x, y, z);
            }
            Particle.DustOptions dustOptions = particle.getDustOptions();
            int particleCount = 1;
            double offsetX = 0.0;
            double offsetY = 0.0;
            double offsetZ = 0.0;
            double extra = 0.0;
            if (effects != null && (effects.rotationSpeed != 0.0 || effects.orbitRadius > 0.0 || effects.spiralExpansion != 0.0)) {
                offsetX = 0.01;
                offsetY = 0.01;
                offsetZ = 0.01;
                extra = 0.0;
                if (tick % 2L != 0L) {
                    return;
                }
            }
            for (Player player : viewers) {
                this.spawnParticleForViewer(player, particleLocation, dustOptions, null, particleCount, offsetX, offsetY, offsetZ, extra, isAnimated);
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Error spawning particle: " + e.getMessage());
        }
    }

    private void spawnParticleWithEffects(ParticleData particle, ParticleData previous, Location baseLocation, Collection<Player> viewers, ParticleEffects.EffectSettings effects, long tick, boolean isAnimated) {
        if (viewers.isEmpty()) {
            return;
        }
        try {
            Location particleLocation;
            World world = baseLocation.getWorld();
            if (world == null) {
                return;
            }
            if (effects != null) {
                particleLocation = ParticleEffects.applyEffects(particle, baseLocation, effects, tick);
            } else {
                double x = particle.getX();
                double y = particle.getY();
                double z = particle.getZ();
                particleLocation = baseLocation.clone().add(x, y, z);
            }
            Particle.DustOptions dustOptions = particle.getDustOptions();
            Particle.DustOptions prevDust = previous != null ? previous.getDustOptions() : null;
            int particleCount = 1;
            double offsetX = 0.0;
            double offsetY = 0.0;
            double offsetZ = 0.0;
            double extra = 0.0;
            if (effects != null && (effects.rotationSpeed != 0.0 || effects.orbitRadius > 0.0 || effects.spiralExpansion != 0.0)) {
                offsetX = 0.01;
                offsetY = 0.01;
                offsetZ = 0.01;
                extra = 0.0;
                if (tick % 2L != 0L) {
                    return;
                }
            }
            for (Player player : viewers) {
                this.spawnParticleForViewer(player, particleLocation, dustOptions, prevDust, particleCount, offsetX, offsetY, offsetZ, extra, isAnimated);
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Error spawning particle: " + e.getMessage());
        }
    }

    private void spawnParticleWithEffects(ParticleData particle, Location baseLocation, Collection<Player> viewers, ParticleEffects.EffectSettings effects, long tick) {
        this.spawnParticleWithEffects(particle, baseLocation, viewers, effects, tick, false);
    }

    private void processParticlesForPlayer(List<ParticleData> particles, Player player, Location playerLocation, ParticleEffects.EffectSettings effects, int tick, int lifetimeSeconds, int maxTicks, boolean forceVisible, String effectId, boolean isAnimated) {
        this.processParticlesForPlayer(particles, null, player, playerLocation, effects, tick, lifetimeSeconds, maxTicks, forceVisible, effectId, isAnimated);
    }

    private void processParticlesForPlayer(List<ParticleData> particles, PackedParticleArray packedParticles, Player player, Location playerLocation, ParticleEffects.EffectSettings effects, int tick, int lifetimeSeconds, int maxTicks, boolean forceVisible, String effectId, boolean isAnimated) {
        int spawnInterval;
        int processLimit;
        int particleCount;
        int n = particleCount = packedParticles != null ? packedParticles.size() : particles.size();
        if (particleCount == 0) {
            return;
        }
        ParticleData reusable = packedParticles != null ? new ParticleData() : null;
        Location currentPlayerLocation = player.getLocation();
        Collection<Player> viewers = this.collectViewers(currentPlayerLocation, MAX_RENDER_DISTANCE * 0.8, forceVisible);
        if (viewers.isEmpty()) {
            return;
        }
        double movementDistance = 0.0;
        if (playerLocation != null) {
            movementDistance = playerLocation.distance(currentPlayerLocation);
        }
        if (isAnimated) {
            processLimit = particleCount;
            spawnInterval = 1;
        } else if (movementDistance > 0.1) {
            processLimit = Math.min(particleCount / 3, this.getMaxParticlesPerTick() / 2);
            spawnInterval = 2;
        } else if (movementDistance > 0.05) {
            processLimit = Math.min(particleCount / 2, this.getMaxParticlesPerTick());
            spawnInterval = 1;
        } else {
            processLimit = Math.min(particleCount, this.getMaxParticlesPerTick());
            spawnInterval = 1;
        }
        int batchSize = Math.min(processLimit, this.getParticlesPerBatch());
        int totalToProcess = Math.min(particleCount, processLimit);
        int iStart = 0;
        int iStep = 1;
        int i = iStart;
        for (int processed = 0; i < particleCount && processed < totalToProcess; i += iStep, ++processed) {
            ParticleData particle;
            if (packedParticles != null) {
                packedParticles.copyInto(i, reusable);
                particle = reusable;
            } else {
                particle = particles.get(i);
            }
            if (particle == null) continue;
            boolean shouldSpawn = false;
            if (isAnimated) {
                shouldSpawn = true;
            } else if (lifetimeSeconds == -1) {
                int cycleLength = Math.max(maxTicks, 100);
                int cycleTick = tick % cycleLength;
                if (cycleTick >= particle.getDelay() && (cycleTick - particle.getDelay()) % spawnInterval == 0) {
                    shouldSpawn = true;
                }
            } else if (tick >= particle.getDelay() && (lifetimeSeconds > 0 || tick < maxTicks) && (tick - particle.getDelay()) % spawnInterval == 0) {
                shouldSpawn = true;
            }
            if (shouldSpawn) {
                this.spawnParticleForPlayer(particle, currentPlayerLocation, player, viewers, effects, tick, isAnimated);
            }
            if (!isAnimated && i % (batchSize + (movementDistance > 0.05 ? batchSize : 0)) == 0 && i > 0) break;
        }
    }

    private void spawnParticleForPlayer(ParticleData particle, Location playerLocation, Player attachedPlayer, Collection<Player> viewers, ParticleEffects.EffectSettings effects, long tick, boolean isAnimated) {
        try {
            Location particleLocation;
            World world = playerLocation.getWorld();
            if (world == null || !attachedPlayer.isOnline() || viewers.isEmpty()) {
                return;
            }
            if (effects != null) {
                particleLocation = ParticleEffects.applyEffects(particle, playerLocation, effects, tick);
            } else {
                double x = particle.getX();
                double y = particle.getY();
                double z = particle.getZ();
                particleLocation = playerLocation.clone().add(x, y, z);
            }
            Particle.DustOptions dustOptions = particle.getDustOptions();
            int particleCount = 1;
            double offsetX = 0.0;
            double offsetY = 0.0;
            double offsetZ = 0.0;
            double extra = 0.0;
            for (Player viewer : viewers) {
                this.spawnParticleForViewer(viewer, particleLocation, dustOptions, null, particleCount, offsetX, offsetY, offsetZ, extra, isAnimated);
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Failed to spawn player particle: " + e.getMessage());
        }
    }

    private void spawnParticleForViewer(Player viewer, Location location, Particle.DustOptions dustOptions, Particle.DustOptions previousDust, int count, double offsetX, double offsetY, double offsetZ, double extra, boolean isAnimated) {
        if (isAnimated) {
            DustLabConfig.AnimatedParticleMode mode = this.config.getAnimatedParticleMode();
            count = 1;
            offsetX = 0.0;
            offsetY = 0.0;
            offsetZ = 0.0;
            extra = 0.0;
            if (mode == DustLabConfig.AnimatedParticleMode.TRANSITION) {
                try {
                    Particle.DustTransition dustTransition = new Particle.DustTransition(dustOptions.getColor(), dustOptions.getColor(), dustOptions.getSize());
                    viewer.spawnParticle(Particle.DUST_COLOR_TRANSITION, location, count, offsetX, offsetY, offsetZ, extra, (Object)dustTransition);
                }
                catch (Exception e) {
                    viewer.spawnParticle(Particle.REDSTONE, location, count, offsetX, offsetY, offsetZ, extra, (Object)dustOptions);
                }
            } else {
                viewer.spawnParticle(Particle.REDSTONE, location, count, offsetX, offsetY, offsetZ, extra, (Object)dustOptions);
            }
        } else {
            try {
                Particle.DustTransition dustTransition = new Particle.DustTransition(dustOptions.getColor(), dustOptions.getColor(), dustOptions.getSize());
                viewer.spawnParticle(Particle.DUST_COLOR_TRANSITION, location, count, offsetX, offsetY, offsetZ, extra, (Object)dustTransition);
            }
            catch (Exception e) {
                viewer.spawnParticle(Particle.REDSTONE, location, count, offsetX, offsetY, offsetZ, extra, (Object)dustOptions);
            }
        }
    }

    private void spawnParticle(ParticleData particle, Location baseLocation) {
        Collection<Player> viewers = this.collectViewers(baseLocation, false);
        if (viewers.isEmpty()) {
            return;
        }
        this.spawnParticleWithEffects(particle, baseLocation, viewers, null, 0L);
    }

    public void stopAllEffects() {
        for (BukkitTask task : this.activeEffects.values()) {
            task.cancel();
        }
        this.activeEffects.clear();
        this.effectIdMap.clear();
    }

    public void stopAllEffectsAndClearMemory() {
        for (BukkitTask task : this.activeEffects.values()) {
            task.cancel();
        }
        this.activeEffects.clear();
        this.activeEffectInfo.clear();
        this.effectIdMap.clear();
    }

    public boolean stopEffect(int effectId) {
        String effectKey = this.effectIdMap.get(effectId);
        if (effectKey == null) {
            return false;
        }
        BukkitTask task = this.activeEffects.remove(effectKey);
        this.activeEffectInfo.remove(effectKey);
        this.effectIdMap.remove(effectId);
        this.particleOptimizer.removeEffect(effectKey);
        if (task != null) {
            task.cancel();
            return true;
        }
        return false;
    }

    public boolean moveEffect(int effectId, Location newLocation) {
        String effectKey = this.effectIdMap.get(effectId);
        if (effectKey == null) {
            return false;
        }
        EffectInfo oldInfo = this.activeEffectInfo.get(effectKey);
        if (oldInfo == null) {
            return false;
        }
        BukkitTask task = this.activeEffects.remove(effectKey);
        if (task != null) {
            task.cancel();
        }
        this.activeEffectInfo.remove(effectKey);
        this.effectIdMap.remove(effectId);
        int respawnedId = this.playModelOnLocationWithEffectsWithExistingId(oldInfo.modelName, newLocation, oldInfo.lifetimeSeconds, oldInfo.isPersistent, oldInfo.effectSettings, effectId);
        return respawnedId == effectId;
    }

    public EffectInfo getEffectInfo(int effectId) {
        String effectKey = this.effectIdMap.get(effectId);
        if (effectKey == null) {
            return null;
        }
        return this.activeEffectInfo.get(effectKey);
    }

    private void savePersistedModels() {
        this.savePersistedModels(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void savePersistedModels(boolean forceLog) {
        File persistentFile = new File(this.plugin.getDataFolder(), "persistent_instances.json");
        File tempFile = new File(this.plugin.getDataFolder(), "persistent_instances.json.tmp");
        try {
            ArrayList instances;
            block34: {
                HashMap<String, Cloneable> persistentData = new HashMap<String, Cloneable>();
                instances = new ArrayList();
                for (Map.Entry<String, EffectInfo> entry : this.activeEffectInfo.entrySet()) {
                    EffectInfo effect = entry.getValue();
                    if (!effect.isPersistent()) continue;
                    HashMap<String, Object> instance = new HashMap<String, Object>();
                    instance.put("model", effect.modelName);
                    HashMap<String, Object> coordinates = new HashMap<String, Object>();
                    coordinates.put("world", effect.location.getWorld().getName());
                    coordinates.put("x", (double)Math.round(effect.location.getX() * 1000.0) / 1000.0);
                    coordinates.put("y", (double)Math.round(effect.location.getY() * 1000.0) / 1000.0);
                    coordinates.put("z", (double)Math.round(effect.location.getZ() * 1000.0) / 1000.0);
                    instance.put("coordinates", coordinates);
                    HashMap<String, Object> lifespan = new HashMap<String, Object>();
                    lifespan.put("duration_seconds", effect.lifetimeSeconds);
                    lifespan.put("type", effect.lifetimeSeconds == -1 ? "infinite" : (effect.lifetimeSeconds == 0 ? "one-time" : "timed"));
                    lifespan.put("started_at", effect.startTime);
                    ParticleModel model = this.getModel(effect.modelName);
                    if (model instanceof AnimatedModel) {
                        lifespan.put("animation_start_time", effect.startTime);
                        lifespan.put("is_animated", true);
                    } else {
                        lifespan.put("is_animated", false);
                    }
                    if (effect.lifetimeSeconds > 0) {
                        long stopTime = effect.startTime + (long)effect.lifetimeSeconds * 1000L;
                        lifespan.put("stops_at", stopTime);
                        lifespan.put("remaining_seconds", Math.max(0L, (stopTime - System.currentTimeMillis()) / 1000L));
                    } else if (effect.lifetimeSeconds == -1) {
                        lifespan.put("stops_at", "never");
                        lifespan.put("remaining_seconds", "infinite");
                    }
                    instance.put("lifespan", lifespan);
                    HashMap<String, Object> effectsInfo = new HashMap<String, Object>();
                    if (effect.effectSettings != null && effect.effectSettings.hasEffects()) {
                        if (effect.effectSettings.rotationSpeed > 0.0) {
                            effectsInfo.put("type", "rotation");
                            effectsInfo.put("speed", effect.effectSettings.rotationSpeed);
                        } else if (effect.effectSettings.oscillationSpeed > 0.0) {
                            effectsInfo.put("type", "oscillation");
                            effectsInfo.put("speed", effect.effectSettings.oscillationSpeed);
                        } else if (effect.effectSettings.waveSpeed > 0.0) {
                            effectsInfo.put("type", "wave");
                            effectsInfo.put("speed", effect.effectSettings.waveSpeed);
                        } else if (effect.effectSettings.orbitSpeed > 0.0) {
                            effectsInfo.put("type", "orbit");
                            effectsInfo.put("speed", effect.effectSettings.orbitSpeed);
                        } else if (effect.effectSettings.spiralSpeed > 0.0) {
                            effectsInfo.put("type", "spiral");
                            effectsInfo.put("speed", effect.effectSettings.spiralSpeed);
                        } else {
                            effectsInfo.put("type", "none");
                            effectsInfo.put("speed", 1.0);
                        }
                    } else {
                        effectsInfo.put("type", "none");
                        effectsInfo.put("speed", 1.0);
                    }
                    instance.put("effects", effectsInfo);
                    HashMap<String, Constable> metadata = new HashMap<String, Constable>();
                    metadata.put("effect_id", Integer.valueOf(effect.id));
                    metadata.put("is_persistent", Boolean.valueOf(effect.isPersistent()));
                    metadata.put("is_infinite", Boolean.valueOf(effect.isInfinite()));
                    metadata.put("has_expired", Boolean.valueOf(effect.hasExpired()));
                    metadata.put("force_loaded", Boolean.valueOf(false));
                    instance.put("metadata", metadata);
                    instances.add(instance);
                }
                persistentData.put("persistent_instances", instances);
                HashMap<String, Object> fileMetadata = new HashMap<String, Object>();
                fileMetadata.put("saved_at", System.currentTimeMillis());
                fileMetadata.put("saved_date", Instant.now().toString());
                fileMetadata.put("format_version", "2.0");
                fileMetadata.put("plugin_version", "DustLab 1.1");
                fileMetadata.put("total_persistent_effects", instances.size());
                fileMetadata.put("description", "Persistent particle effects saved by the plugin");
                persistentData.put("metadata", fileMetadata);
                try (FileWriter writer = new FileWriter(tempFile);){
                    this.gson.toJson(persistentData, (Appendable)writer);
                    writer.flush();
                }
                try {
                    Files.move(tempFile.toPath(), persistentFile.toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
                }
                catch (Exception moveEx) {
                    if (tempFile.renameTo(persistentFile)) break block34;
                    throw new IOException("Failed to move persistent_instances.json.tmp into place: " + moveEx.getMessage(), moveEx);
                }
            }
            long currentTime = System.currentTimeMillis();
            if (instances.size() > 0 && (forceLog || currentTime - this.lastSaveLogTime >= 1800000L)) {
                this.plugin.getLogger().info("Saved " + instances.size() + " persistent model instances to storage.");
                this.lastSaveLogTime = currentTime;
            }
        }
        catch (IOException e) {
            this.plugin.getLogger().warning("Failed to save persistent instances: " + e.getMessage());
            try {
                Files.deleteIfExists(tempFile.toPath());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        finally {
            this.reservedForRestoreIds.clear();
        }
    }

    private void loadPersistedModels() {
        File persistentFile = new File(this.plugin.getDataFolder(), "persistent_instances.json");
        if (persistentFile.exists()) {
            this.loadPersistentInstances();
        }
    }

    private void loadPersistentInstances() {
        File persistentFile = new File(this.plugin.getDataFolder(), "persistent_instances.json");
        try (FileReader reader = new FileReader(persistentFile);){
            Map persistentData = this.gson.fromJson((Reader)reader, Map.class);
            if (persistentData == null || !persistentData.containsKey("persistent_instances")) {
                return;
            }
            List instances = (List)persistentData.get("persistent_instances");
            if (instances.isEmpty()) {
                return;
            }
            this.plugin.getLogger().info("Found " + instances.size() + " persistent instance(s); queuing restore after models load.");
            int maxId = this.nextEffectId;
            for (Map inst : instances) {
                try {
                    int id;
                    Map md;
                    Object idObj;
                    if (!inst.containsKey("metadata") || !((idObj = (md = (Map)inst.get("metadata")).get("effect_id")) instanceof Number) || (id = ((Number)idObj).intValue()) <= 0) continue;
                    this.reservedForRestoreIds.add(id);
                    if (id <= maxId) continue;
                    maxId = id;
                }
                catch (Exception exception) {}
            }
            if (maxId >= this.nextEffectId) {
                this.nextEffectId = maxId + 1;
            }
            this.pendingPersistentInstances = instances;
        }
        catch (IOException e) {
            this.plugin.getLogger().warning("Failed to load persistent instances: " + e.getMessage());
        }
    }

    private void restorePersistentInstances(List<Map<String, Object>> instances) {
        int restoredCount = 0;
        int restoredInfinite = 0;
        int restoredTimed = 0;
        for (Map<String, Object> instance : instances) {
            try {
                int lifetimeSeconds;
                Double z;
                Double y;
                Double x;
                String worldName;
                String modelId;
                int desiredEffectId = -1;
                boolean markedExpired = false;
                if (instance.containsKey("model")) {
                    modelId = (String)instance.get("model");
                    Map coordinates = (Map)instance.get("coordinates");
                    worldName = (String)coordinates.get("world");
                    x = ((Number)coordinates.get("x")).doubleValue();
                    y = ((Number)coordinates.get("y")).doubleValue();
                    z = ((Number)coordinates.get("z")).doubleValue();
                    Map lifespan = (Map)instance.get("lifespan");
                    lifetimeSeconds = ((Number)lifespan.get("duration_seconds")).intValue();
                    if (instance.containsKey("metadata")) {
                        Object expiredObj;
                        Map metadata = (Map)instance.get("metadata");
                        Object idObj = metadata.get("effect_id");
                        if (idObj instanceof Number) {
                            desiredEffectId = ((Number)idObj).intValue();
                        }
                        if ((expiredObj = metadata.get("has_expired")) instanceof Boolean) {
                            markedExpired = (Boolean)expiredObj;
                        }
                    }
                } else {
                    Object lifetimeObj;
                    modelId = (String)instance.get("model_id");
                    worldName = (String)instance.get("world");
                    x = (Double)instance.get("x");
                    y = (Double)instance.get("y");
                    z = (Double)instance.get("z");
                    lifetimeSeconds = -1;
                    if (instance.containsKey("lifetime_seconds") && (lifetimeObj = instance.get("lifetime_seconds")) instanceof Number) {
                        lifetimeSeconds = ((Number)lifetimeObj).intValue();
                    }
                }
                if (!this.hasModel(modelId)) {
                    this.plugin.getLogger().warning("Cannot restore persistent instance: model '" + modelId + "' not found in models folder");
                    continue;
                }
                World world = Bukkit.getWorld((String)worldName);
                if (world == null) {
                    this.plugin.getLogger().warning("Cannot restore persistent instance: world '" + worldName + "' not found");
                    continue;
                }
                Location location = new Location(world, x.doubleValue(), y.doubleValue(), z.doubleValue());
                ParticleEffects.EffectSettings effects = null;
                String effectType = "none";
                double speed = 1.0;
                if (instance.containsKey("effects")) {
                    Map effectsInfo = (Map)instance.get("effects");
                    effectType = (String)effectsInfo.get("type");
                    speed = ((Number)effectsInfo.get("speed")).doubleValue();
                } else {
                    Object speedObj;
                    effectType = (String)instance.getOrDefault("effect", "none");
                    if (instance.containsKey("speed") && (speedObj = instance.get("speed")) instanceof Number) {
                        speed = ((Number)speedObj).doubleValue();
                    }
                }
                if (!"none".equals(effectType)) {
                    effects = new ParticleEffects.EffectSettings();
                    switch (effectType) {
                        case "rotate": 
                        case "rotation": {
                            effects.rotationSpeed = speed;
                            break;
                        }
                        case "oscillate": 
                        case "oscillation": {
                            effects.oscillationSpeed = speed;
                            break;
                        }
                        case "wave": {
                            effects.waveSpeed = speed;
                            break;
                        }
                        case "orbit": {
                            effects.orbitSpeed = speed;
                            break;
                        }
                        case "spiral": {
                            effects.spiralSpeed = speed;
                        }
                    }
                }
                long animationStartTime = -1L;
                boolean isAnimated = false;
                long stopsAt = -1L;
                if (instance.containsKey("lifespan")) {
                    Object stopsAtObj;
                    Object startTimeObj;
                    Map lifespanInfo = (Map)instance.get("lifespan");
                    if (lifespanInfo.containsKey("is_animated")) {
                        isAnimated = (Boolean)lifespanInfo.get("is_animated");
                    }
                    if (lifespanInfo.containsKey("animation_start_time") && (startTimeObj = lifespanInfo.get("animation_start_time")) instanceof Number) {
                        animationStartTime = ((Number)startTimeObj).longValue();
                    }
                    if ((stopsAtObj = lifespanInfo.get("stops_at")) instanceof Number) {
                        stopsAt = ((Number)stopsAtObj).longValue();
                    }
                }
                if (markedExpired) continue;
                if (lifetimeSeconds > 0) {
                    long now = System.currentTimeMillis();
                    if (stopsAt > 0L) {
                        long remaining = Math.max(0L, (stopsAt - now) / 1000L);
                        if (remaining <= 0L) continue;
                        lifetimeSeconds = (int)Math.min(Integer.MAX_VALUE, remaining);
                    }
                }
                if (isAnimated && animationStartTime != -1L) {
                    long currentTime = System.currentTimeMillis();
                    long elapsedMs = currentTime - animationStartTime;
                    long tickOffset = elapsedMs / 50L;
                    if (effects != null) {
                        this.playModelOnLocationWithEffectsAndTickOffsetWithId(modelId, location, lifetimeSeconds, true, effects, tickOffset, desiredEffectId);
                    } else {
                        this.playModelOnLocationWithEffectsAndTickOffsetWithId(modelId, location, lifetimeSeconds, true, null, tickOffset, desiredEffectId);
                    }
                } else if (effects != null) {
                    this.playModelOnLocationWithEffectsWithId(modelId, location, lifetimeSeconds, true, effects, desiredEffectId);
                } else {
                    this.playModelOnLocationWithEffectsWithId(modelId, location, lifetimeSeconds, true, null, desiredEffectId);
                }
                ++restoredCount;
                if (lifetimeSeconds == -1) {
                    ++restoredInfinite;
                } else if (lifetimeSeconds > 0) {
                    ++restoredTimed;
                }
                String worldN = location.getWorld() != null ? location.getWorld().getName() : "unknown";
                this.plugin.getLogger().info("Restored persistent effect #" + (Serializable)(desiredEffectId > 0 ? Integer.valueOf(desiredEffectId) : "?") + " (model=" + modelId + ", world=" + worldN + ", x=" + String.format(Locale.US, "%.3f", location.getX()) + ", y=" + String.format(Locale.US, "%.3f", location.getY()) + ", z=" + String.format(Locale.US, "%.3f", location.getZ()) + ")");
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Failed to restore persistent instance: " + e.getMessage());
            }
        }
        if (restoredCount > 0) {
            this.plugin.getLogger().info("Restored " + restoredCount + " persistent effects (" + restoredTimed + " active, " + restoredInfinite + " infinite).");
            this.savePersistedModels(true);
        }
    }

    public void cleanup() {
        this.shuttingDown = true;
        this.savePersistedModels();
        this.stopAllEffectsAndClearMemory();
        this.cancelAllLoadJobs();
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException ignored) {
            Thread.currentThread().interrupt();
        }
        for (Future<?> f : this.saveFutures) {
            boolean done = false;
            while (!done) {
                try {
                    f.get();
                    done = true;
                }
                catch (CancellationException cancelEx) {
                    done = true;
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    return;
                }
                catch (ExecutionException execEx) {
                    this.plugin.getLogger().warning("Async save task failed during shutdown: " + execEx.getCause().getMessage());
                    done = true;
                }
            }
        }
        this.saveFutures.clear();
        try {
            if (this.autoSaveTask != null) {
                this.autoSaveTask.cancel();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.optimizerCleanupTask != null) {
                this.optimizerCleanupTask.cancel();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.plugin.getServer().getScheduler().cancelTasks((Plugin)this.plugin);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void recoverOrQuarantineTempFiles() {
        block100: {
            File modelsDir = new File(this.plugin.getDataFolder(), "models");
            if (!modelsDir.exists()) {
                return;
            }
            File[] temps = modelsDir.listFiles((dir, name) -> name.endsWith(".json.gz.tmp") || name.endsWith(".json.tmp"));
            if (temps == null) {
                return;
            }
            for (File tmp : temps) {
                String name2 = tmp.getName();
                boolean gz = name2.endsWith(".json.gz.tmp");
                String finalName = name2.substring(0, name2.length() - 4);
                File finalFile = new File(modelsDir, finalName);
                try {
                    File quarantine;
                    block99: {
                        if (finalFile.exists()) {
                            if (!tmp.delete()) continue;
                            this.plugin.getLogger().info("Removed leftover temp file '" + name2 + "'.");
                            continue;
                        }
                        boolean valid = false;
                        if (gz) {
                            try (GZIPInputStream gis = new GZIPInputStream(new FileInputStream(tmp));
                                 InputStreamReader isr = new InputStreamReader((InputStream)gis, StandardCharsets.UTF_8);
                                 JsonReader jr = new JsonReader(isr);){
                                jr.setLenient(true);
                                jr.beginObject();
                                while (jr.hasNext()) {
                                    jr.nextName();
                                    jr.skipValue();
                                }
                                jr.endObject();
                                byte[] buf = new byte[4096];
                                while (gis.read(buf) != -1) {
                                }
                                valid = true;
                            }
                            catch (Exception ex) {
                                valid = false;
                            }
                        } else {
                            try (FileReader fr = new FileReader(tmp);
                                 JsonReader jr = new JsonReader(fr);){
                                jr.setLenient(true);
                                jr.beginObject();
                                while (jr.hasNext()) {
                                    jr.nextName();
                                    jr.skipValue();
                                }
                                jr.endObject();
                                valid = true;
                            }
                            catch (Exception ex) {
                                valid = false;
                            }
                        }
                        if (valid) {
                            block98: {
                                try {
                                    Files.move(tmp.toPath(), finalFile.toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
                                }
                                catch (Exception ex) {
                                    if (tmp.renameTo(finalFile)) break block98;
                                    throw ex;
                                }
                            }
                            this.plugin.getLogger().info("Recovered model from temp file -> '" + finalFile.getName() + "'.");
                            continue;
                        }
                        quarantine = new File(modelsDir, finalName + ".corrupt");
                        try {
                            Files.move(tmp.toPath(), quarantine.toPath(), StandardCopyOption.REPLACE_EXISTING);
                        }
                        catch (Exception ex2) {
                            if (tmp.renameTo(quarantine)) break block99;
                            this.plugin.getLogger().warning("Could not quarantine temp file '" + name2 + "'.");
                        }
                    }
                    this.plugin.getLogger().warning("Detected leftover temp model '" + name2 + "'. It did not finish saving previously and was quarantined as '" + quarantine.getName() + "'.");
                }
                catch (Exception e) {
                    this.plugin.getLogger().warning("Error handling temp model '" + name2 + "': " + e.getMessage());
                }
            }
            try {
                File[] orphanTemps;
                File tempDir = new File(this.plugin.getDataFolder(), "tmp-saving");
                if (!tempDir.exists() || (orphanTemps = tempDir.listFiles((d, n) -> n.endsWith(".tmp"))) == null) break block100;
                for (File tmp : orphanTemps) {
                    File quarantine;
                    String n2;
                    block103: {
                        n2 = tmp.getName();
                        String finalName = null;
                        int idxGz = n2.indexOf(".json.gz.");
                        int idxJson = n2.indexOf(".json.");
                        boolean gz = false;
                        if (idxGz > 0) {
                            finalName = n2.substring(0, idxGz + ".json.gz".length());
                            gz = true;
                        } else if (idxJson > 0) {
                            finalName = n2.substring(0, idxJson + ".json".length());
                            gz = false;
                        }
                        if (finalName == null) {
                            try {
                                tmp.delete();
                            }
                            catch (Exception jr) {}
                            continue;
                        }
                        File finalFile = new File(modelsDir, finalName);
                        boolean valid = false;
                        if (gz) {
                            try (GZIPInputStream gis = new GZIPInputStream(new FileInputStream(tmp));
                                 InputStreamReader isr = new InputStreamReader((InputStream)gis, StandardCharsets.UTF_8);
                                 JsonReader jr = new JsonReader(isr);){
                                jr.setLenient(true);
                                jr.beginObject();
                                while (jr.hasNext()) {
                                    jr.nextName();
                                    jr.skipValue();
                                }
                                jr.endObject();
                                byte[] buf = new byte[4096];
                                while (gis.read(buf) != -1) {
                                }
                                valid = true;
                            }
                            catch (Exception ex) {
                                valid = false;
                            }
                        } else {
                            try (FileReader fr = new FileReader(tmp);
                                 JsonReader jr = new JsonReader(fr);){
                                jr.setLenient(true);
                                jr.beginObject();
                                while (jr.hasNext()) {
                                    jr.nextName();
                                    jr.skipValue();
                                }
                                jr.endObject();
                                valid = true;
                            }
                            catch (Exception ex) {
                                valid = false;
                            }
                        }
                        if (valid) {
                            block102: {
                                try {
                                    Files.move(tmp.toPath(), finalFile.toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
                                }
                                catch (Exception ex) {
                                    if (tmp.renameTo(finalFile)) break block102;
                                    try {
                                        Files.deleteIfExists(tmp.toPath());
                                    }
                                    catch (Exception jr) {
                                        // empty catch block
                                    }
                                }
                            }
                            this.plugin.getLogger().info("Recovered model from temp-saving -> '" + finalFile.getName() + "'.");
                            continue;
                        }
                        quarantine = new File(modelsDir, finalName + ".corrupt");
                        try {
                            Files.move(tmp.toPath(), quarantine.toPath(), StandardCopyOption.REPLACE_EXISTING);
                        }
                        catch (Exception ex2) {
                            if (tmp.renameTo(quarantine)) break block103;
                            try {
                                tmp.delete();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                    this.plugin.getLogger().warning("Detected leftover temp model '" + n2 + "' in tmp-saving. It did not finish saving previously and was quarantined as '" + quarantine.getName() + "'.");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void reloadModels() {
        HashMap<String, EffectInfo> savedEffects = new HashMap<String, EffectInfo>(this.activeEffectInfo);
        HashMap<String, BukkitTask> savedTasks = new HashMap<String, BukkitTask>(this.activeEffects);
        HashMap<Integer, String> savedIdMap = new HashMap<Integer, String>(this.effectIdMap);
        for (BukkitTask bukkitTask : this.activeEffects.values()) {
            bukkitTask.cancel();
        }
        this.activeEffects.clear();
        this.activeEffectInfo.clear();
        this.effectIdMap.clear();
        this.loadModels();
        for (Map.Entry entry : savedEffects.entrySet()) {
            final String effectKey = (String)entry.getKey();
            final EffectInfo effectInfo = (EffectInfo)entry.getValue();
            if (this.hasModel(effectInfo.modelName)) {
                this.activeEffectInfo.put(effectKey, effectInfo);
                this.effectIdMap.put(effectInfo.id, effectKey);
                final ParticleModel model = this.getModel(effectInfo.modelName);
                if (model == null) continue;
                BukkitTask task = Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, new Runnable(){
                    private int tick = 0;
                    private final int maxTicks = Math.max(model.getDuration(), ParticleModelManager.this.getMaxParticleDelay(model) + 60);

                    @Override
                    public void run() {
                        AnimatedModel animatedModel;
                        FrameData currentFrame;
                        if (this.tick >= this.maxTicks && !effectInfo.isLooping) {
                            BukkitTask currentTask = ParticleModelManager.this.activeEffects.remove(effectKey);
                            ParticleModelManager.this.activeEffectInfo.remove(effectKey);
                            ParticleModelManager.this.effectIdMap.remove(effectInfo.id);
                            if (currentTask != null) {
                                currentTask.cancel();
                            }
                            return;
                        }
                        boolean isAnimated = model instanceof AnimatedModel;
                        List<ParticleData> currentParticles = isAnimated ? ((currentFrame = (animatedModel = (AnimatedModel)model).getFrameAtTick(this.tick)) != null ? currentFrame.getParticles() : new ArrayList<ParticleData>()) : model.getParticles();
                        if (currentParticles != null) {
                            Collection<Player> viewers = ParticleModelManager.this.collectViewers(effectInfo.location, effectInfo.forceVisible);
                            if (viewers.isEmpty()) {
                                ++this.tick;
                                return;
                            }
                            for (ParticleData particle : currentParticles) {
                                if (particle == null) continue;
                                if (effectInfo.isLooping) {
                                    int cycleLength = Math.max(this.maxTicks, 100);
                                    int cycleTick = this.tick % cycleLength;
                                    if (cycleTick < particle.getDelay() || (cycleTick - particle.getDelay()) % 3 != 0) continue;
                                    ParticleModelManager.this.spawnParticleWithEffects(particle, effectInfo.location, viewers, effectInfo.effectSettings, this.tick, isAnimated);
                                    continue;
                                }
                                if (this.tick < particle.getDelay() || this.tick >= this.maxTicks || (this.tick - particle.getDelay()) % 3 != 0) continue;
                                ParticleModelManager.this.spawnParticleWithEffects(particle, effectInfo.location, viewers, effectInfo.effectSettings, this.tick, isAnimated);
                            }
                        }
                        ++this.tick;
                    }
                }, 0L, 1L);
                this.activeEffects.put(effectKey, task);
                continue;
            }
            this.plugin.getLogger().warning("Cannot restore effect for model '" + effectInfo.modelName + "' - model not found after reload");
        }
        this.plugin.getLogger().info("Reloaded models and restored " + this.activeEffects.size() + " active effects.");
    }

    public void forceSave() {
        this.savePersistedModels(true);
    }

    public void saveModel(ParticleModel model, boolean isTemporary) throws IOException {
        File modelFile;
        block11: {
            String fileName = model.getName() + ".json";
            File modelsDir = new File(this.plugin.getDataFolder(), "models");
            if (!modelsDir.exists()) {
                modelsDir.mkdirs();
            }
            modelFile = new File(modelsDir, fileName);
            File tempFile = new File(modelsDir, fileName + ".tmp");
            if (modelFile.exists()) {
                throw new IOException("Model file already exists: " + fileName);
            }
            try (FileWriter writer = new FileWriter(tempFile);){
                Gson gson = new GsonBuilder().create();
                gson.toJson((Object)model, (Appendable)writer);
                writer.flush();
            }
            try {
                Files.move(tempFile.toPath(), modelFile.toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
            }
            catch (Exception ex) {
                if (tempFile.renameTo(modelFile)) break block11;
                throw new IOException("Failed to move temp model file into place: " + ex.getMessage(), ex);
            }
        }
        this.loadedModels.put(model.getName().toLowerCase(), model);
        if (isTemporary) {
            this.scheduleTemporaryModelDeletion(model.getName(), modelFile);
        }
        MessageUtils.logVerbose((Plugin)this.plugin, this.config, "Saved new model '" + model.getName() + "' with " + model.getParticles().size() + " particles" + (isTemporary ? " (temporary)" : ""));
    }

    public void registerAnimatedModel(AnimatedModel animatedModel, boolean persistent) throws IOException {
        File modelFile;
        Object c;
        boolean compressed = false;
        if (animatedModel.getMetadata() != null && (c = animatedModel.getMetadata().get("compressed")) instanceof Boolean) {
            compressed = (Boolean)c;
        }
        String fileName = animatedModel.getName() + (compressed ? ".json.gz" : ".json");
        File modelsDir = new File(this.plugin.getDataFolder(), "models");
        if (!modelsDir.exists()) {
            modelsDir.mkdirs();
        }
        if ((modelFile = new File(modelsDir, fileName)).exists()) {
            throw new IOException("Model file already exists: " + fileName);
        }
        this.loadedModels.put(animatedModel.getName().toLowerCase(), animatedModel);
        Future<?> saveFuture = MediaProcessor.submitAsyncFuture(() -> {
            try {
                this.writeAnimatedModelStreaming(animatedModel, modelFile);
                if (this.shuttingDown || !this.plugin.isEnabled()) {
                    return;
                }
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                    if (!persistent) {
                        this.scheduleTemporaryModelDeletion(animatedModel.getName(), modelFile);
                    }
                    MessageUtils.logVerbose((Plugin)this.plugin, this.config, "Registered animated model '" + animatedModel.getName() + "' with " + animatedModel.getTotalFrames() + " frames, " + animatedModel.getTotalParticleCount() + " total particles" + (persistent ? " (persistent)" : " (temporary)"));
                });
            }
            catch (IOException e) {
                boolean interrupted = Thread.currentThread().isInterrupted();
                if (this.shuttingDown || !this.plugin.isEnabled()) {
                    if (interrupted) {
                        this.plugin.getLogger().warning("Save of animated model '" + animatedModel.getName() + "' was interrupted during shutdown; any partial file was discarded.");
                    }
                    return;
                }
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                    this.loadedModels.remove(animatedModel.getName());
                    if (interrupted) {
                        this.plugin.getLogger().warning("Save of animated model '" + animatedModel.getName() + "' was interrupted; please retry the media creation.");
                    } else {
                        this.plugin.getLogger().severe("Failed to save animated model '" + animatedModel.getName() + "': " + e.getMessage());
                    }
                });
            }
        });
        this.saveFutures.add(saveFuture);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeAnimatedModelStreaming(AnimatedModel animatedModel, File modelFile) throws IOException {
        block107: {
            boolean gz = modelFile.getName().toLowerCase().endsWith(".json.gz");
            File tempDir = new File(this.plugin.getDataFolder(), "tmp-saving");
            if (!tempDir.exists()) {
                tempDir.mkdirs();
            }
            File tempFile = File.createTempFile(modelFile.getName() + ".", ".tmp", tempDir);
            boolean promoted = false;
            if (Thread.currentThread().isInterrupted()) {
                throw new IOException("Interrupted before writing model data");
            }
            if (gz) {
                try (FileOutputStream fos = new FileOutputStream(tempFile);
                     BufferedOutputStream bos = new BufferedOutputStream(fos);
                     GZIPOutputStream gos = new GZIPOutputStream(bos);
                     OutputStreamWriter out = new OutputStreamWriter((OutputStream)gos, StandardCharsets.UTF_8);
                     JsonWriter writer = new JsonWriter(out);){
                    writer.setIndent("  ");
                    writer.beginObject();
                    writer.name("name").value(animatedModel.getName());
                    writer.name("totalFrames").value(animatedModel.getTotalFrames());
                    writer.name("looping").value(animatedModel.isLooping());
                    writer.name("sourceUrl").value(animatedModel.getSourceUrl());
                    writer.name("createdTime").value(animatedModel.getCreatedTime());
                    writer.name("blockWidth").value(animatedModel.getBlockWidth());
                    writer.name("blockHeight").value(animatedModel.getBlockHeight());
                    writer.name("maxParticleCount").value(animatedModel.getMaxParticleCount());
                    writer.name("duration").value(animatedModel.getDuration());
                    if (animatedModel.getMetadata() != null && !animatedModel.getMetadata().isEmpty()) {
                        String checksum = ParticleModelManager.sha1String(ParticleModelManager.canonicalJsonString(animatedModel.getMetadata()));
                        writer.name("metadataChecksumSha1").value(checksum);
                        writer.name("metadata");
                        new Gson().toJson((Object)animatedModel.getMetadata(), (Type)((Object)Map.class), writer);
                    }
                    writer.name("frames");
                    writer.beginArray();
                    int frameCount = animatedModel.getFrames().size();
                    int batchSize = Math.max(1, Math.min(50, frameCount / 10));
                    double globalSize = 1.0;
                    try {
                        Object gs;
                        if (animatedModel.getMetadata() != null && (gs = animatedModel.getMetadata().get("globalParticleSize")) instanceof Number) {
                            globalSize = ((Number)gs).doubleValue();
                        }
                    }
                    catch (Exception gs) {
                        // empty catch block
                    }
                    for (int i = 0; i < frameCount; i += batchSize) {
                        int endIndex = Math.min(i + batchSize, frameCount);
                        for (int frameIndex = i; frameIndex < endIndex; ++frameIndex) {
                            if (Thread.currentThread().isInterrupted()) {
                                throw new IOException("Interrupted during streaming write");
                            }
                            FrameData frame = animatedModel.getFrames().get(frameIndex);
                            writer.beginObject();
                            writer.name("frameIndex").value(frame.getFrameIndex());
                            writer.name("delayMs").value(frame.getDelayMs());
                            writer.name("particleCount").value(frame.getParticleCount());
                            writer.name("particles");
                            writer.beginArray();
                            for (ParticleData particle : frame.getParticles()) {
                                writer.beginObject();
                                writer.name("x").value(particle.getX());
                                writer.name("y").value(particle.getY());
                                writer.name("z").value(particle.getZ());
                                writer.name("delay").value(particle.getDelay());
                                Particle.DustOptions dustOptions = particle.getDustOptions();
                                writer.name("dustOptions");
                                writer.beginObject();
                                writer.name("red").value(dustOptions.getColor().getRed());
                                writer.name("green").value(dustOptions.getColor().getGreen());
                                writer.name("blue").value(dustOptions.getColor().getBlue());
                                if (Math.abs((double)particle.getScale() - globalSize) > 1.0E-6) {
                                    writer.name("size").value(dustOptions.getSize());
                                }
                                writer.endObject();
                                writer.endObject();
                            }
                            writer.endArray();
                            writer.endObject();
                        }
                        if (Thread.currentThread().isInterrupted()) {
                            throw new IOException("Interrupted during streaming write");
                        }
                        if (i % (batchSize * 5) != 0) continue;
                        try {
                            Thread.sleep(1L);
                            continue;
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            throw new IOException("Interrupted during streaming write", e);
                        }
                    }
                    writer.endArray();
                    if (!animatedModel.getFrames().isEmpty()) {
                        writer.name("particles");
                        writer.beginArray();
                        for (ParticleData particle : animatedModel.getParticles()) {
                            writer.beginObject();
                            writer.name("x").value(particle.getX());
                            writer.name("y").value(particle.getY());
                            writer.name("z").value(particle.getZ());
                            writer.name("delay").value(particle.getDelay());
                            Particle.DustOptions dustOptions = particle.getDustOptions();
                            writer.name("dustOptions");
                            writer.beginObject();
                            writer.name("red").value(dustOptions.getColor().getRed());
                            writer.name("green").value(dustOptions.getColor().getGreen());
                            writer.name("blue").value(dustOptions.getColor().getBlue());
                            writer.endObject();
                            writer.endObject();
                        }
                        writer.endArray();
                    }
                    writer.endObject();
                    writer.flush();
                    out.flush();
                    gos.finish();
                    bos.flush();
                    try {
                        fos.getFD().sync();
                    }
                    catch (Exception i) {
                        // empty catch block
                    }
                }
                if (Thread.currentThread().isInterrupted()) {
                    throw new IOException("Interrupted before verifying compressed model");
                }
                boolean ok = false;
                try (GZIPInputStream gis = new GZIPInputStream(new FileInputStream(tempFile));){
                    byte[] buf = new byte[8192];
                    while (gis.read(buf) != -1) {
                    }
                    ok = true;
                }
                catch (Exception verifyEx) {
                    ok = false;
                }
                if (!ok) {
                    try {
                        Files.deleteIfExists(tempFile.toPath());
                    }
                    catch (Exception verifyEx) {
                        // empty catch block
                    }
                    File jsonFallback = new File(modelFile.getParentFile(), ParticleModelManager.stripGzExtension(modelFile.getName()));
                    this.writeAnimatedModelStreaming(animatedModel, jsonFallback);
                    this.plugin.getLogger().warning("Compressed save failed pre-move verification; saved uncompressed model '" + jsonFallback.getName() + "' instead.");
                    return;
                }
            } else {
                try (FileOutputStream fos = new FileOutputStream(tempFile);
                     OutputStreamWriter out = new OutputStreamWriter((OutputStream)fos, StandardCharsets.UTF_8);
                     JsonWriter writer = new JsonWriter(out);){
                    writer.setIndent("  ");
                    writer.beginObject();
                    writer.name("name").value(animatedModel.getName());
                    writer.name("totalFrames").value(animatedModel.getTotalFrames());
                    writer.name("looping").value(animatedModel.isLooping());
                    writer.name("sourceUrl").value(animatedModel.getSourceUrl());
                    writer.name("createdTime").value(animatedModel.getCreatedTime());
                    writer.name("blockWidth").value(animatedModel.getBlockWidth());
                    writer.name("blockHeight").value(animatedModel.getBlockHeight());
                    writer.name("maxParticleCount").value(animatedModel.getMaxParticleCount());
                    writer.name("duration").value(animatedModel.getDuration());
                    if (animatedModel.getMetadata() != null && !animatedModel.getMetadata().isEmpty()) {
                        String checksum = ParticleModelManager.sha1String(ParticleModelManager.canonicalJsonString(animatedModel.getMetadata()));
                        writer.name("metadataChecksumSha1").value(checksum);
                        writer.name("metadata");
                        new Gson().toJson((Object)animatedModel.getMetadata(), (Type)((Object)Map.class), writer);
                    }
                    writer.name("frames");
                    writer.beginArray();
                    int frameCount = animatedModel.getFrames().size();
                    int batchSize = Math.max(1, Math.min(50, frameCount / 10));
                    double globalSize = 1.0;
                    try {
                        Object gs;
                        if (animatedModel.getMetadata() != null && (gs = animatedModel.getMetadata().get("globalParticleSize")) instanceof Number) {
                            globalSize = ((Number)gs).doubleValue();
                        }
                    }
                    catch (Exception gs) {
                        // empty catch block
                    }
                    for (int i = 0; i < frameCount; i += batchSize) {
                        int endIndex = Math.min(i + batchSize, frameCount);
                        for (int frameIndex = i; frameIndex < endIndex; ++frameIndex) {
                            if (Thread.currentThread().isInterrupted()) {
                                throw new IOException("Interrupted during streaming write");
                            }
                            FrameData frame = animatedModel.getFrames().get(frameIndex);
                            writer.beginObject();
                            writer.name("frameIndex").value(frame.getFrameIndex());
                            writer.name("delayMs").value(frame.getDelayMs());
                            writer.name("particleCount").value(frame.getParticleCount());
                            writer.name("particles");
                            writer.beginArray();
                            for (ParticleData particle : frame.getParticles()) {
                                writer.beginObject();
                                writer.name("x").value(particle.getX());
                                writer.name("y").value(particle.getY());
                                writer.name("z").value(particle.getZ());
                                writer.name("delay").value(particle.getDelay());
                                Particle.DustOptions dustOptions = particle.getDustOptions();
                                writer.name("dustOptions");
                                writer.beginObject();
                                writer.name("red").value(dustOptions.getColor().getRed());
                                writer.name("green").value(dustOptions.getColor().getGreen());
                                writer.name("blue").value(dustOptions.getColor().getBlue());
                                if (Math.abs((double)particle.getScale() - globalSize) > 1.0E-6) {
                                    writer.name("size").value(dustOptions.getSize());
                                }
                                writer.endObject();
                                writer.endObject();
                            }
                            writer.endArray();
                            writer.endObject();
                        }
                        if (Thread.currentThread().isInterrupted()) {
                            throw new IOException("Interrupted during streaming write");
                        }
                        if (i % (batchSize * 5) != 0) continue;
                        try {
                            Thread.sleep(1L);
                            continue;
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            throw new IOException("Interrupted during streaming write", e);
                        }
                    }
                    writer.endArray();
                    if (!animatedModel.getFrames().isEmpty()) {
                        writer.name("particles");
                        writer.beginArray();
                        for (ParticleData particle : animatedModel.getParticles()) {
                            writer.beginObject();
                            writer.name("x").value(particle.getX());
                            writer.name("y").value(particle.getY());
                            writer.name("z").value(particle.getZ());
                            writer.name("delay").value(particle.getDelay());
                            Particle.DustOptions dustOptions = particle.getDustOptions();
                            writer.name("dustOptions");
                            writer.beginObject();
                            writer.name("red").value(dustOptions.getColor().getRed());
                            writer.name("green").value(dustOptions.getColor().getGreen());
                            writer.name("blue").value(dustOptions.getColor().getBlue());
                            writer.endObject();
                            writer.endObject();
                        }
                        writer.endArray();
                    }
                    writer.endObject();
                    writer.flush();
                    out.flush();
                    try {
                        fos.getFD().sync();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            if (Thread.currentThread().isInterrupted()) {
                throw new IOException("Interrupted before promoting model file");
            }
            try {
                Files.move(tempFile.toPath(), modelFile.toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
                promoted = true;
            }
            catch (Exception ex) {
                if (tempFile.renameTo(modelFile)) {
                    promoted = true;
                    break block107;
                }
                try {
                    Files.deleteIfExists(tempFile.toPath());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new IOException("Failed to move temp model file into place: " + ex.getMessage(), ex);
            }
            finally {
                if (!promoted) {
                    try {
                        Files.deleteIfExists(tempFile.toPath());
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    private void scheduleTemporaryModelDeletion(String modelName, File modelFile) {
        long deletionDelay = this.config != null ? this.config.getTempModelLifetimeTicks() : 36000L;
        this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            this.loadedModels.remove(modelName);
            ArrayList<String> effectsToRemove = new ArrayList<String>();
            for (Map.Entry<String, EffectInfo> entry : this.activeEffectInfo.entrySet()) {
                if (!entry.getValue().modelName.equals(modelName)) continue;
                effectsToRemove.add(entry.getKey());
            }
            for (String effectKey : effectsToRemove) {
                BukkitTask task = this.activeEffects.get(effectKey);
                if (task != null) {
                    task.cancel();
                    this.activeEffects.remove(effectKey);
                }
                this.activeEffectInfo.remove(effectKey);
            }
            try {
                if (modelFile.exists()) {
                    String original;
                    int firstDot;
                    File archiveDir = new File(this.plugin.getDataFolder(), "temp-archive");
                    if (!archiveDir.exists()) {
                        archiveDir.mkdirs();
                    }
                    String base = (firstDot = (original = modelFile.getName()).indexOf(46)) > 0 ? original.substring(0, firstDot) : original;
                    String ext = firstDot > 0 ? original.substring(firstDot) : "";
                    String ts = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMdd-HHmmss"));
                    File target = new File(archiveDir, base + "." + ts + ext);
                    Files.move(modelFile.toPath(), target.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    this.plugin.getLogger().info("Archived temporary model '" + modelName + "' to '" + target.getName() + "'.");
                }
            }
            catch (Exception ex) {
                this.plugin.getLogger().warning("Failed to archive temporary model '" + modelName + "': " + ex.getMessage());
            }
        }, deletionDelay);
    }

    public Map<String, ParticleModel> getLoadedModels() {
        return new HashMap<String, ParticleModel>(this.loadedModels);
    }

    public Map<String, EffectInfo> getActiveEffects() {
        return new HashMap<String, EffectInfo>(this.activeEffectInfo);
    }

    public MemoryUsageReport estimateMemoryUsage() {
        IdentityHashMap<PackedParticleArray, Boolean> seenPacked = new IdentityHashMap<PackedParticleArray, Boolean>();
        long packedBytes = 0L;
        long packedParticles = 0L;
        long legacyBytes = 0L;
        long legacyParticles = 0L;
        long animationFrames = 0L;
        int animatedCount = 0;
        ArrayList<ParticleModel> modelsSnapshot = new ArrayList<ParticleModel>(this.loadedModels.values());
        for (ParticleModel model : modelsSnapshot) {
            if (model instanceof AnimatedModel) {
                AnimatedModel animated = (AnimatedModel)model;
                ++animatedCount;
                for (FrameData frame : animated.getFrames()) {
                    ++animationFrames;
                    PackedParticleArray packed = frame.getPackedParticles();
                    if (packed != null) {
                        if (seenPacked.containsKey(packed)) continue;
                        seenPacked.put(packed, Boolean.TRUE);
                        packedBytes += packed.approximateSizeBytes();
                        packedParticles += (long)packed.size();
                        continue;
                    }
                    List<ParticleData> particles = frame.getParticles();
                    legacyBytes += ParticleModelManager.estimateParticleListBytes(particles);
                    legacyParticles += particles != null ? (long)particles.size() : 0L;
                }
                continue;
            }
            PackedParticleArray packed = model.getPackedParticles();
            if (packed != null) {
                if (seenPacked.containsKey(packed)) continue;
                seenPacked.put(packed, Boolean.TRUE);
                packedBytes += packed.approximateSizeBytes();
                packedParticles += (long)packed.size();
                continue;
            }
            List<ParticleData> particles = model.getParticles();
            legacyBytes += ParticleModelManager.estimateParticleListBytes(particles);
            legacyParticles += particles != null ? (long)particles.size() : 0L;
        }
        long optimizerBytes = this.particleOptimizer != null ? this.particleOptimizer.estimateMemoryBytes() : 0L;
        int optimizerEffects = this.particleOptimizer != null ? this.particleOptimizer.getActiveEffectCount() : 0;
        long optimizerParticles = this.particleOptimizer != null ? (long)this.particleOptimizer.getTotalParticleCount() : 0L;
        return new MemoryUsageReport(modelsSnapshot.size(), animatedCount, animationFrames, packedBytes, legacyBytes, optimizerBytes, packedParticles, legacyParticles, optimizerEffects, optimizerParticles, this.activeEffectInfo.size());
    }

    private static long estimateParticleListBytes(List<ParticleData> particles) {
        if (particles == null || particles.isEmpty()) {
            return 0L;
        }
        long perParticleBytes = 96L;
        long listOverhead = 48L;
        return 48L + (long)particles.size() * 96L;
    }

    public boolean deleteModel(String modelName) {
        try {
            File modelFile;
            ArrayList<String> effectsToRemove = new ArrayList<String>();
            for (Map.Entry<String, EffectInfo> entry : this.activeEffectInfo.entrySet()) {
                if (!entry.getValue().modelName.equals(modelName)) continue;
                effectsToRemove.add(entry.getKey());
            }
            for (String effectKey : effectsToRemove) {
                EffectInfo effectInfo;
                BukkitTask task = this.activeEffects.get(effectKey);
                if (task != null) {
                    task.cancel();
                    this.activeEffects.remove(effectKey);
                }
                if ((effectInfo = this.activeEffectInfo.remove(effectKey)) == null) continue;
                this.effectIdMap.remove(effectInfo.id);
            }
            this.loadedModels.remove(modelName);
            File modelsDir = new File(this.plugin.getDataFolder(), "models");
            File modelFileJson = new File(modelsDir, modelName + ".json");
            File modelFileGz = new File(modelsDir, modelName + ".json.gz");
            File file = modelFile = modelFileJson.exists() ? modelFileJson : modelFileGz;
            if (!modelFile.exists()) {
                modelFile = modelFileJson;
            }
            if (modelFile.exists()) {
                boolean deleted = modelFile.delete();
                if (modelFile == modelFileJson && modelFileGz.exists()) {
                    modelFileGz.delete();
                }
                if (modelFile == modelFileGz && modelFileJson.exists()) {
                    modelFileJson.delete();
                }
                try {
                    String prefix;
                    File[] leftovers;
                    File tempDir = new File(this.plugin.getDataFolder(), "tmp-saving");
                    if (tempDir.exists() && (leftovers = tempDir.listFiles((arg_0, arg_1) -> ParticleModelManager.lambda$deleteModel$16(prefix = modelFile.getName() + ".", arg_0, arg_1))) != null) {
                        for (File lf : leftovers) {
                            try {
                                lf.delete();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (deleted) {
                    this.plugin.getLogger().info("Deleted model '" + modelName + "' (stopped " + effectsToRemove.size() + " active effects)");
                    this.savePersistedModels();
                    return true;
                }
                this.plugin.getLogger().warning("Failed to delete model file: " + modelFile.getPath());
                return false;
            }
            this.plugin.getLogger().warning("Model file not found: " + modelFile.getPath());
            return false;
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Error deleting model '" + modelName + "': " + e.getMessage());
            return false;
        }
    }

    public String getOptimizationStats() {
        int trackedEffects = this.particleOptimizer.getActiveEffectCount();
        int trackedParticles = this.particleOptimizer.getTotalParticleCount();
        int activeEffects = this.activeEffectInfo.size();
        return String.format("Particle Optimization Stats:\n- Active Effects: %d\n- Tracked Effects for Optimization: %d\n- Tracked Particles: %d\n- Memory Usage: Effects tracking %d particles", activeEffects, trackedEffects, trackedParticles, trackedParticles);
    }

    public Map<String, ParticleModel> getAllModels() {
        return this.getLoadedModels();
    }

    public int getActiveEffectCount() {
        return this.activeEffectInfo.size();
    }

    private static /* synthetic */ boolean lambda$deleteModel$16(String prefix, File d, String n) {
        return n.startsWith(prefix) && n.endsWith(".tmp");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ void lambda$parseModelStreaming$8(AnimatedModel animated, LoadJob job) {
        ArrayList<Runnable> toRun;
        this.loadedModels.put(animated.getName().toLowerCase(), animated);
        this.loadingJobs.remove(job.fileBaseName.toLowerCase());
        this.completedLoadCount.incrementAndGet();
        Set<CommandSender> set = job.readyCallbacks;
        synchronized (set) {
            toRun = new ArrayList<Runnable>(job.readyCallbacks);
            job.readyCallbacks.clear();
        }
        for (Runnable r : toRun) {
            try {
                Bukkit.getScheduler().runTask((Plugin)this.plugin, r);
            }
            catch (Exception exception) {}
        }
        set = job.subscribers;
        synchronized (set) {
            for (CommandSender s : job.subscribers) {
                try {
                    s.sendMessage("\u00a79DustLab \u00a7a\u00bb \u00a77Model '\u00a7f" + animated.getName() + "\u00a77' is ready (animated)");
                }
                catch (Exception exception) {}
            }
            job.subscribers.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ void lambda$parseModelStreaming$7(ParticleModel placeholder, PackedParticleArray packed, LoadJob job, String modelName) {
        ArrayList<Runnable> toRun;
        placeholder.setPackedParticles(packed);
        this.loadingJobs.remove(job.fileBaseName.toLowerCase());
        this.completedLoadCount.incrementAndGet();
        Set<CommandSender> set = job.readyCallbacks;
        synchronized (set) {
            toRun = new ArrayList<Runnable>(job.readyCallbacks);
            job.readyCallbacks.clear();
        }
        for (Runnable r : toRun) {
            try {
                Bukkit.getScheduler().runTask((Plugin)this.plugin, r);
            }
            catch (Exception exception) {}
        }
        set = job.subscribers;
        synchronized (set) {
            for (CommandSender s : job.subscribers) {
                try {
                    s.sendMessage("\u00a79DustLab \u00a7a\u00bb \u00a77Model '\u00a7f" + modelName + "\u00a77' is ready (" + packed.size() + " particles)");
                }
                catch (Exception exception) {}
            }
            job.subscribers.clear();
        }
    }

    private /* synthetic */ void lambda$parseModelStreaming$6(String modelName, ParticleModel placeholder) {
        this.loadedModels.put(modelName.toLowerCase(), placeholder);
    }

    private static /* synthetic */ void lambda$parseModelStreaming$5(LoadJob job, long c) {
        job.bytesRead = c;
    }

    private static class LoadJob {
        final File file;
        final boolean gz;
        final String fileBaseName;
        volatile boolean canceled = false;
        volatile int totalParticles = -1;
        volatile int parsedParticles = 0;
        volatile long bytesRead = 0L;
        volatile long fileSize = 0L;
        volatile String modelName;
        final Set<CommandSender> subscribers = new HashSet<CommandSender>();
        final List<Runnable> readyCallbacks = new ArrayList<Runnable>();

        LoadJob(File file) {
            this.file = file;
            this.gz = file.getName().toLowerCase().endsWith(".json.gz");
            String fname = file.getName();
            this.fileBaseName = fname.endsWith(".json.gz") ? fname.substring(0, fname.length() - 8) : fname.substring(0, fname.lastIndexOf(46));
            this.fileSize = file.length();
        }
    }

    private static class CountingReader
    extends Reader {
        private final Reader delegate;
        private long count = 0L;
        private final LongConsumer onUpdate;

        CountingReader(Reader delegate, LongConsumer onUpdate) {
            this.delegate = delegate;
            this.onUpdate = onUpdate;
        }

        @Override
        public int read(char[] cbuf, int off, int len) throws IOException {
            int n = this.delegate.read(cbuf, off, len);
            if (n > 0) {
                this.count += (long)n;
                this.onUpdate.accept(this.count);
            }
            return n;
        }

        @Override
        public void close() throws IOException {
            this.delegate.close();
        }
    }

    public static class EffectInfo {
        public final int id;
        public final String modelName;
        public final Location location;
        public final boolean isLooping;
        public final int lifetimeSeconds;
        public final boolean isPersistent;
        public final long startTime;
        public final ParticleEffects.EffectSettings effectSettings;
        public final Player attachedPlayer;
        public final boolean onlyWhenStill;
        public final boolean forceVisible;

        public EffectInfo(int id, String modelName, Location location, int lifetimeSeconds, boolean isPersistent, ParticleEffects.EffectSettings effectSettings) {
            this.id = id;
            this.modelName = modelName;
            this.location = location;
            this.lifetimeSeconds = lifetimeSeconds;
            this.isLooping = lifetimeSeconds == -1;
            this.isPersistent = isPersistent;
            this.startTime = System.currentTimeMillis();
            this.effectSettings = effectSettings != null ? effectSettings : new ParticleEffects.EffectSettings();
            this.attachedPlayer = null;
            this.onlyWhenStill = false;
            this.forceVisible = false;
        }

        public EffectInfo(int id, String modelName, Player attachedPlayer, int lifetimeSeconds, boolean onlyWhenStill, boolean forceVisible, ParticleEffects.EffectSettings effectSettings) {
            this.id = id;
            this.modelName = modelName;
            this.location = attachedPlayer.getLocation().clone();
            this.lifetimeSeconds = lifetimeSeconds;
            this.isLooping = lifetimeSeconds == -1;
            this.isPersistent = true;
            this.startTime = System.currentTimeMillis();
            this.effectSettings = effectSettings != null ? effectSettings : new ParticleEffects.EffectSettings();
            this.attachedPlayer = attachedPlayer;
            this.onlyWhenStill = onlyWhenStill;
            this.forceVisible = forceVisible;
        }

        public EffectInfo(int id, String modelName, Location location, boolean isLooping, boolean isPersistent, ParticleEffects.EffectSettings effectSettings) {
            this(id, modelName, location, isLooping ? -1 : 0, isPersistent, effectSettings);
        }

        public EffectInfo(int id, String modelName, Location location, boolean isLooping, ParticleEffects.EffectSettings effectSettings) {
            this(id, modelName, location, isLooping ? -1 : 0, isLooping, effectSettings);
        }

        public EffectInfo(int id, String modelName, Location location, boolean isLooping) {
            this(id, modelName, location, isLooping ? -1 : 0, isLooping, null);
        }

        public boolean isPersistent() {
            return this.isPersistent;
        }

        public ParticleEffects.EffectSettings getEffects() {
            return this.effectSettings;
        }

        public boolean isInfinite() {
            return this.lifetimeSeconds == -1;
        }

        public boolean hasExpired() {
            if (this.lifetimeSeconds <= 0) {
                return false;
            }
            long currentTime = System.currentTimeMillis();
            long elapsedSeconds = (currentTime - this.startTime) / 1000L;
            return elapsedSeconds >= (long)this.lifetimeSeconds;
        }

        public int getRemainingSeconds() {
            if (this.lifetimeSeconds <= 0) {
                return -1;
            }
            long currentTime = System.currentTimeMillis();
            long elapsedSeconds = (currentTime - this.startTime) / 1000L;
            return Math.max(0, this.lifetimeSeconds - (int)elapsedSeconds);
        }
    }

    public record MemoryUsageReport(int loadedModelCount, int animatedModelCount, long animationFrameCount, long packedBytes, long legacyBytes, long optimizerBytes, long packedParticleCount, long legacyParticleCount, int optimizerTrackedEffects, long optimizerTrackedParticles, int activeEffectCount) {
        public long totalBytes() {
            return this.packedBytes + this.legacyBytes + this.optimizerBytes;
        }

        public long totalParticleCount() {
            return this.packedParticleCount + this.legacyParticleCount;
        }

        public int staticModelCount() {
            return this.loadedModelCount - this.animatedModelCount;
        }
    }
}

