/*
 * Decompiled with CFR 0.152.
 */
package com.winss.dustlab.media;

import com.winss.dustlab.media.FrameData;
import com.winss.dustlab.models.ParticleModel;
import com.winss.dustlab.packed.PackedParticleArray;
import java.util.Collections;
import java.util.List;

public class AnimatedModel
extends ParticleModel {
    private final List<FrameData> frames;
    private final boolean looping;
    private final int totalFrames;
    private final String sourceUrl;
    private final long createdTime;
    private final int blockWidth;
    private final int blockHeight;
    private final int maxParticleCount;
    private final boolean tickAligned;

    public AnimatedModel(String name, List<FrameData> frames, boolean looping, String sourceUrl, int blockWidth, int blockHeight, int maxParticleCount) {
        this.setName(name);
        List<FrameData> safeFrames = frames != null ? frames : Collections.emptyList();
        this.frames = Collections.unmodifiableList(safeFrames);
        this.looping = looping;
        this.totalFrames = safeFrames.size();
        this.sourceUrl = sourceUrl;
        this.createdTime = System.currentTimeMillis();
        this.blockWidth = blockWidth;
        this.blockHeight = blockHeight;
        this.maxParticleCount = maxParticleCount;
        this.tickAligned = this.determineTickAligned(frames);
        if (!safeFrames.isEmpty()) {
            this.setDuration(this.calculateTotalDuration());
            FrameData first = safeFrames.get(0);
            PackedParticleArray packed = first.getPackedParticles();
            if (packed != null) {
                this.setPackedParticles(packed);
            } else {
                this.setParticles(first.getParticles());
            }
        }
    }

    public List<FrameData> getFrames() {
        return this.frames;
    }

    public FrameData getFrame(int frameIndex) {
        if (frameIndex < 0 || frameIndex >= this.frames.size()) {
            return null;
        }
        return this.frames.get(frameIndex);
    }

    public int getTotalFrames() {
        return this.totalFrames;
    }

    public boolean isLooping() {
        return this.looping;
    }

    public String getSourceUrl() {
        return this.sourceUrl;
    }

    public long getCreatedTime() {
        return this.createdTime;
    }

    public int getBlockWidth() {
        return this.blockWidth;
    }

    public int getBlockHeight() {
        return this.blockHeight;
    }

    public int getMaxParticleCount() {
        return this.maxParticleCount;
    }

    public boolean isAnimated() {
        return true;
    }

    public boolean isTickAligned() {
        return this.tickAligned;
    }

    private boolean determineTickAligned(List<FrameData> frames) {
        if (frames == null || frames.isEmpty()) {
            return false;
        }
        for (FrameData f : frames) {
            int ms = f.getDelayMs();
            if (ms >= 50 && ms % 50 == 0) continue;
            return false;
        }
        return true;
    }

    private int calculateTotalDuration() {
        if (this.tickAligned) {
            long totalTicks = this.frames.stream().mapToLong(f -> Math.max(1, f.getDelayMs() / 50)).sum();
            return Math.max(1, (int)totalTicks);
        }
        long totalMs = this.frames.stream().mapToLong(FrameData::getDelayMs).sum();
        return Math.max(1, (int)Math.round((double)totalMs / 50.0));
    }

    public FrameData getFrameAtTick(long currentTick) {
        if (this.frames.isEmpty()) {
            return null;
        }
        if (this.frames.size() == 1) {
            return this.frames.get(0);
        }
        long totalDurationTicks = this.tickAligned ? this.frames.stream().mapToLong(frame -> Math.max(1, frame.getDelayMs() / 50)).sum() : this.frames.stream().mapToLong(frame -> Math.max(1L, Math.round((double)frame.getDelayMs() / 50.0))).sum();
        if (totalDurationTicks <= 0L) {
            return this.frames.get(0);
        }
        long currentAnimationTick = currentTick;
        if (this.looping) {
            currentAnimationTick = currentTick % totalDurationTicks;
        }
        long accumulatedTicks = 0L;
        for (FrameData frame2 : this.frames) {
            long frameTickDuration = this.tickAligned ? (long)Math.max(1, frame2.getDelayMs() / 50) : Math.max(1L, Math.round((double)frame2.getDelayMs() / 50.0));
            long frameEndTick = accumulatedTicks + frameTickDuration;
            if (currentAnimationTick >= accumulatedTicks && currentAnimationTick < frameEndTick) {
                return frame2;
            }
            accumulatedTicks = frameEndTick;
        }
        return this.looping ? this.frames.get(0) : this.frames.get(this.frames.size() - 1);
    }

    public FrameData getFrameAtTime(long elapsedMs) {
        if (this.frames.isEmpty()) {
            return null;
        }
        if (this.frames.size() == 1) {
            return this.frames.get(0);
        }
        long totalDurationMs = this.frames.stream().mapToLong(FrameData::getDelayMs).sum();
        if (totalDurationMs <= 0L) {
            return this.frames.get(0);
        }
        long currentAnimationTime = elapsedMs;
        if (this.looping) {
            currentAnimationTime = elapsedMs % totalDurationMs;
        }
        long accumulatedTime = 0L;
        for (FrameData frame : this.frames) {
            long frameEndTime = accumulatedTime + (long)frame.getDelayMs();
            if (currentAnimationTime >= accumulatedTime && currentAnimationTime < frameEndTime) {
                return frame;
            }
            accumulatedTime = frameEndTime;
        }
        return this.looping ? this.frames.get(0) : this.frames.get(this.frames.size() - 1);
    }

    public int getTotalParticleCount() {
        return this.frames.stream().mapToInt(FrameData::getParticleCount).sum();
    }
}

