/*
 * Decompiled with CFR 0.152.
 */
package com.winss.dustlab.media;

import com.winss.dustlab.models.ParticleData;
import com.winss.dustlab.packed.PackedParticleArray;
import java.util.Collections;
import java.util.List;

public class FrameData {
    private final List<ParticleData> particles;
    private final PackedParticleArray packedParticles;
    private final int frameIndex;
    private final int delayMs;

    public FrameData(List<ParticleData> particles, int frameIndex, int delayMs) {
        this(particles, null, frameIndex, delayMs);
    }

    public FrameData(PackedParticleArray packedParticles, int frameIndex, int delayMs) {
        this(null, packedParticles, frameIndex, delayMs);
    }

    private FrameData(List<ParticleData> particles, PackedParticleArray packedParticles, int frameIndex, int delayMs) {
        this.particles = particles != null ? particles : (packedParticles != null ? packedParticles.toParticleDataList() : Collections.emptyList());
        this.packedParticles = packedParticles;
        this.frameIndex = frameIndex;
        this.delayMs = delayMs;
    }

    public List<ParticleData> getParticles() {
        return this.particles;
    }

    public PackedParticleArray getPackedParticles() {
        return this.packedParticles;
    }

    public int getFrameIndex() {
        return this.frameIndex;
    }

    public int getDelayMs() {
        return this.delayMs;
    }

    public int getParticleCount() {
        if (this.packedParticles != null) {
            return this.packedParticles.size();
        }
        return this.particles.size();
    }
}

