/*
 * Decompiled with CFR 0.152.
 */
package com.winss.dustlab.media;

import com.winss.dustlab.packed.PackedParticleArray;
import java.awt.image.BufferedImage;
import java.util.ArrayList;

public class PixelToParticleMapper {
    public static PackedParticleArray imageToParticlesOptimized(BufferedImage image, int blockWidth, int blockHeight, int maxParticles, float particleScale) {
        PackedParticleArray.Builder builder = PackedParticleArray.builder(maxParticles);
        int imgWidth = image.getWidth();
        int imgHeight = image.getHeight();
        if (imgWidth == 0 || imgHeight == 0) {
            return builder.build();
        }
        int[] rgbArray = new int[imgWidth * imgHeight];
        image.getRGB(0, 0, imgWidth, imgHeight, rgbArray, 0, imgWidth);
        int totalPixels = imgWidth * imgHeight;
        double density = (double)maxParticles / (double)totalPixels;
        int step = Math.max(1, (int)Math.ceil(Math.sqrt(1.0 / density)));
        double scaleX = (double)blockWidth / (double)imgWidth;
        double scaleY = (double)blockHeight / (double)imgHeight;
        ArrayList<double[]> recentPositions = new ArrayList<double[]>();
        double minDistance = Math.min(scaleX, scaleY) * 0.3;
        int maxRecentCheck = Math.min(100, maxParticles / 10);
        int particleCount = 0;
        for (int y = 0; y < imgHeight && particleCount < maxParticles; y += step) {
            for (int x = 0; x < imgWidth && particleCount < maxParticles; x += step) {
                int checkStart;
                int rgbIndex = y * imgWidth + x;
                int rgb = rgbArray[rgbIndex];
                int alpha = rgb >> 24 & 0xFF;
                if (alpha < 20) continue;
                double particleX = (double)x * scaleX - (double)blockWidth / 2.0;
                double particleY = (double)blockHeight / 2.0 - (double)y * scaleY;
                boolean tooClose = false;
                for (int i = checkStart = Math.max(0, recentPositions.size() - maxRecentCheck); i < recentPositions.size(); ++i) {
                    double dy;
                    double[] pos = (double[])recentPositions.get(i);
                    double dx = particleX - pos[0];
                    if (!(dx * dx + (dy = particleY - pos[1]) * dy < minDistance * minDistance)) continue;
                    tooClose = true;
                    break;
                }
                if (tooClose) continue;
                int red = rgb >> 16 & 0xFF;
                int green = rgb >> 8 & 0xFF;
                int blue = rgb & 0xFF;
                builder.add(particleX, particleY, 0.0, (double)red / 255.0, (double)green / 255.0, (double)blue / 255.0, 0, particleScale);
                recentPositions.add(new double[]{particleX, particleY});
                ++particleCount;
                if (recentPositions.size() <= maxRecentCheck * 2) continue;
                recentPositions = new ArrayList(recentPositions.subList(maxRecentCheck, recentPositions.size()));
            }
        }
        if ((double)particleCount < (double)maxParticles * 0.85 && step > 1) {
            int halfStep;
            for (int y = halfStep = step / 2; y < imgHeight && particleCount < maxParticles; y += step) {
                for (int x = halfStep; x < imgWidth && particleCount < maxParticles; x += step) {
                    int checkStart;
                    int rgbIndex = y * imgWidth + x;
                    int rgb = rgbArray[rgbIndex];
                    int alpha = rgb >> 24 & 0xFF;
                    if (alpha < 20) continue;
                    double offsetX = (Math.random() - 0.5) * scaleX * 0.3;
                    double offsetY = (Math.random() - 0.5) * scaleY * 0.3;
                    double particleX = (double)x * scaleX - (double)blockWidth / 2.0 + offsetX;
                    double particleY = (double)blockHeight / 2.0 - (double)y * scaleY + offsetY;
                    boolean tooClose = false;
                    for (int i = checkStart = Math.max(0, recentPositions.size() - maxRecentCheck); i < recentPositions.size(); ++i) {
                        double dy;
                        double[] pos = (double[])recentPositions.get(i);
                        double dx = particleX - pos[0];
                        if (!(dx * dx + (dy = particleY - pos[1]) * dy < minDistance * minDistance)) continue;
                        tooClose = true;
                        break;
                    }
                    if (tooClose) continue;
                    int red = rgb >> 16 & 0xFF;
                    int green = rgb >> 8 & 0xFF;
                    int blue = rgb & 0xFF;
                    builder.add(particleX, particleY, 0.0, (double)red / 255.0, (double)green / 255.0, (double)blue / 255.0, 0, particleScale);
                    recentPositions.add(new double[]{particleX, particleY});
                    ++particleCount;
                    if (recentPositions.size() <= maxRecentCheck * 2) continue;
                    recentPositions = new ArrayList(recentPositions.subList(maxRecentCheck, recentPositions.size()));
                }
            }
        }
        return builder.build();
    }
}

