/*
 * Decompiled with CFR 0.152.
 */
package com.winss.dustlab.models;

import com.winss.dustlab.libs.gson.annotations.SerializedName;
import org.bukkit.Color;
import org.bukkit.Particle;

public class ParticleData {
    @SerializedName(value="x")
    private double x = 0.0;
    @SerializedName(value="y")
    private double y = 0.0;
    @SerializedName(value="z")
    private double z = 0.0;
    @SerializedName(value="r", alternate={"red"})
    private double r = 1.0;
    @SerializedName(value="g", alternate={"green"})
    private double g = 0.0;
    @SerializedName(value="b", alternate={"blue"})
    private double b = 0.0;
    @SerializedName(value="delay")
    private int delay = 0;
    @SerializedName(value="scale")
    private float scale = 1.0f;

    public ParticleData() {
    }

    public ParticleData(double x, double y, double z, double r, double g, double b) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.r = r;
        this.g = g;
        this.b = b;
    }

    public double getX() {
        return this.x;
    }

    public void setX(double x) {
        this.x = x;
    }

    public double getY() {
        return this.y;
    }

    public void setY(double y) {
        this.y = y;
    }

    public double getZ() {
        return this.z;
    }

    public void setZ(double z) {
        this.z = z;
    }

    public double getR() {
        return this.r;
    }

    public void setR(double r) {
        this.r = Math.max(0.0, Math.min(1.0, r));
    }

    public double getG() {
        return this.g;
    }

    public void setG(double g) {
        this.g = Math.max(0.0, Math.min(1.0, g));
    }

    public double getB() {
        return this.b;
    }

    public void setB(double b) {
        this.b = Math.max(0.0, Math.min(1.0, b));
    }

    public int getDelay() {
        return this.delay;
    }

    public void setDelay(int delay) {
        this.delay = delay;
    }

    public float getScale() {
        return this.scale;
    }

    public void setScale(float scale) {
        this.scale = Math.max(0.1f, Math.min(5.0f, scale));
    }

    public Color getColor() {
        int red = (int)(this.r * 255.0);
        int green = (int)(this.g * 255.0);
        int blue = (int)(this.b * 255.0);
        return Color.fromRGB((int)red, (int)green, (int)blue);
    }

    public Particle.DustOptions getDustOptions() {
        return new Particle.DustOptions(this.getColor(), this.scale);
    }
}

