/*
 * Decompiled with CFR 0.152.
 */
package com.winss.dustlab.models;

import com.winss.dustlab.libs.gson.annotations.SerializedName;
import com.winss.dustlab.models.ParticleData;
import com.winss.dustlab.packed.PackedParticleArray;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class ParticleModel {
    @SerializedName(value="metadata")
    private Map<String, Object> metadata;
    @SerializedName(value="particles")
    private List<ParticleData> particles;
    private transient PackedParticleArray packedParticles;
    private transient List<ParticleData> packedAdapter;
    private transient String name;
    private transient int duration = 100;

    public ParticleModel() {
    }

    public ParticleModel(String name, List<ParticleData> particles) {
        this.name = name;
        this.particles = particles;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, Object> metadata) {
        this.metadata = metadata;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<ParticleData> getParticles() {
        if (this.particles != null) {
            return this.particles;
        }
        if (this.packedAdapter != null) {
            return this.packedAdapter;
        }
        if (this.packedParticles != null) {
            this.packedAdapter = this.packedParticles.toParticleDataList();
            return this.packedAdapter;
        }
        return Collections.emptyList();
    }

    public void setParticles(List<ParticleData> particles) {
        this.particles = particles;
        this.packedParticles = null;
        this.packedAdapter = null;
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public PackedParticleArray getPackedParticles() {
        return this.packedParticles;
    }

    public void setPackedParticles(PackedParticleArray packedParticles) {
        this.packedParticles = packedParticles;
        List<ParticleData> list = this.packedAdapter = packedParticles != null ? packedParticles.toParticleDataList() : null;
        if (packedParticles != null) {
            this.particles = this.packedAdapter;
        }
    }

    public boolean hasPackedParticles() {
        return this.packedParticles != null;
    }

    public <T> T getMetadataField(String key) {
        if (this.metadata == null) {
            return null;
        }
        return (T)this.metadata.get(key);
    }

    public int getParticleCount() {
        Object count;
        if (this.metadata != null && this.metadata.containsKey("particleCount") && (count = this.metadata.get("particleCount")) instanceof Number) {
            return ((Number)count).intValue();
        }
        return this.particles != null ? this.particles.size() : 0;
    }

    public String getGeneratedBy() {
        return (String)this.getMetadataField("generatedBy");
    }

    public String getWebsite() {
        return (String)this.getMetadataField("website");
    }

    public String getGeneratedOn() {
        return (String)this.getMetadataField("generatedOn");
    }

    public String getSourceFile() {
        return (String)this.getMetadataField("sourceFile");
    }

    public Map<String, Object> getSettings() {
        return (Map)this.getMetadataField("settings");
    }
}

