/*
 * Decompiled with CFR 0.152.
 */
package com.winss.dustlab.monitoring;

import com.sun.management.OperatingSystemMXBean;
import com.winss.dustlab.DustLab;
import com.winss.dustlab.managers.ParticleModelManager;
import java.lang.management.ManagementFactory;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class PerformanceMonitor {
    private static final long SAMPLE_PERIOD_TICKS = 20L;
    private static final long MAX_WINDOW_MILLIS = Duration.ofMinutes(5L).toMillis();
    private final DustLab plugin;
    private final Deque<MetricSample> samples = new ConcurrentLinkedDeque<MetricSample>();
    private final Runtime runtime = Runtime.getRuntime();
    private final OperatingSystemMXBean osBean;
    private BukkitTask task;

    public PerformanceMonitor(DustLab plugin) {
        this.plugin = plugin;
        this.osBean = ManagementFactory.getPlatformMXBean(OperatingSystemMXBean.class);
    }

    public synchronized void start() {
        if (this.task != null) {
            return;
        }
        this.task = Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, this::collectSample, 20L, 20L);
    }

    public synchronized void stop() {
        if (this.task != null) {
            this.task.cancel();
            this.task = null;
        }
        this.samples.clear();
    }

    public PerformanceSnapshot snapshot() {
        WindowAverages tenSeconds = this.computeWindow(Duration.ofSeconds(10L).toMillis());
        WindowAverages oneMinute = this.computeWindow(Duration.ofMinutes(1L).toMillis());
        WindowAverages fiveMinutes = this.computeWindow(Duration.ofMinutes(5L).toMillis());
        return new PerformanceSnapshot(tenSeconds, oneMinute, fiveMinutes);
    }

    private void collectSample() {
        long now = System.currentTimeMillis();
        double cpuPercent = this.sampleCpu();
        double ramMb = this.sampleHeapUsageMb();
        this.samples.addLast(new MetricSample(now, cpuPercent, ramMb));
        this.trimOldSamples(now);
    }

    private double sampleCpu() {
        if (this.osBean == null) {
            return -1.0;
        }
        double load = this.osBean.getProcessCpuLoad();
        if (Double.isNaN(load) || load < 0.0) {
            return -1.0;
        }
        return load * 100.0;
    }

    private double sampleHeapUsageMb() {
        ParticleModelManager manager = this.plugin.getParticleModelManager();
        if (manager != null) {
            ParticleModelManager.MemoryUsageReport report = manager.estimateMemoryUsage();
            return (double)report.totalBytes() / 1048576.0;
        }
        long usedBytes = this.runtime.totalMemory() - this.runtime.freeMemory();
        return (double)usedBytes / 1048576.0;
    }

    private void trimOldSamples(long now) {
        long cutoff = now - MAX_WINDOW_MILLIS;
        while (true) {
            MetricSample first;
            if ((first = this.samples.peekFirst()) == null) {
                return;
            }
            if (first.timestamp >= cutoff) break;
            this.samples.pollFirst();
        }
    }

    private WindowAverages computeWindow(long windowMillis) {
        long now = System.currentTimeMillis();
        long cutoff = Math.max(0L, now - windowMillis);
        double cpuSum = 0.0;
        int cpuCount = 0;
        double ramSum = 0.0;
        int ramCount = 0;
        Iterator<MetricSample> iterator = this.samples.descendingIterator();
        while (iterator.hasNext()) {
            MetricSample sample = iterator.next();
            if (sample.timestamp < cutoff) break;
            if (sample.cpuPercent >= 0.0) {
                cpuSum += sample.cpuPercent;
                ++cpuCount;
            }
            ramSum += sample.ramMb;
            ++ramCount;
        }
        double cpuAverage = cpuCount > 0 ? cpuSum / (double)cpuCount : -1.0;
        double ramAverage = ramCount > 0 ? ramSum / (double)ramCount : 0.0;
        return new WindowAverages(cpuAverage, ramAverage, ramCount);
    }

    public record WindowAverages(double cpuPercent, double ramMb, int samples) {
        public boolean hasCpuData() {
            return this.cpuPercent >= 0.0;
        }
    }

    public record PerformanceSnapshot(WindowAverages tenSeconds, WindowAverages oneMinute, WindowAverages fiveMinutes) {
        public Collection<WindowAverages> all() {
            ArrayList<WindowAverages> list = new ArrayList<WindowAverages>(3);
            list.add(this.tenSeconds);
            list.add(this.oneMinute);
            list.add(this.fiveMinutes);
            return list;
        }
    }

    private record MetricSample(long timestamp, double cpuPercent, double ramMb) {
    }
}

