/*
 * Decompiled with CFR 0.152.
 */
package com.winss.dustlab.packed;

import com.winss.dustlab.models.ParticleData;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.RandomAccess;

public final class PackedParticleArray {
    private final float[] x;
    private final float[] y;
    private final float[] z;
    private final float[] r;
    private final float[] g;
    private final float[] b;
    private final float[] scale;
    private final int[] delay;
    private final int size;

    private PackedParticleArray(float[] x, float[] y, float[] z, float[] r, float[] g, float[] b, float[] scale, int[] delay, int size) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.r = r;
        this.g = g;
        this.b = b;
        this.scale = scale;
        this.delay = delay;
        this.size = size;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public double getX(int index) {
        return this.x[index];
    }

    public double getY(int index) {
        return this.y[index];
    }

    public double getZ(int index) {
        return this.z[index];
    }

    public double getR(int index) {
        return this.r[index];
    }

    public double getG(int index) {
        return this.g[index];
    }

    public double getB(int index) {
        return this.b[index];
    }

    public float getScale(int index) {
        return this.scale[index];
    }

    public int getDelay(int index) {
        return this.delay[index];
    }

    public List<ParticleData> toParticleDataList() {
        if (this.isEmpty()) {
            return Collections.emptyList();
        }
        return new PackedParticleListView(this);
    }

    public void copyInto(int index, ParticleData reusable) {
        reusable.setX(this.getX(index));
        reusable.setY(this.getY(index));
        reusable.setZ(this.getZ(index));
        reusable.setR(this.getR(index));
        reusable.setG(this.getG(index));
        reusable.setB(this.getB(index));
        reusable.setDelay(this.getDelay(index));
        reusable.setScale(this.getScale(index));
    }

    public long approximateSizeBytes() {
        long componentBytes = (long)this.size * 32L;
        long arrayHeaders = 128L;
        return componentBytes + arrayHeaders;
    }

    public static Builder builder() {
        return new Builder(1024);
    }

    public static Builder builder(int expectedSize) {
        return new Builder(expectedSize);
    }

    private static final class PackedParticleListView
    extends AbstractList<ParticleData>
    implements RandomAccess {
        private final PackedParticleArray array;

        private PackedParticleListView(PackedParticleArray array) {
            this.array = array;
        }

        @Override
        public ParticleData get(int index) {
            if (index < 0 || index >= this.array.size) {
                throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.array.size);
            }
            ParticleData data = new ParticleData(this.array.getX(index), this.array.getY(index), this.array.getZ(index), this.array.getR(index), this.array.getG(index), this.array.getB(index));
            data.setDelay(this.array.getDelay(index));
            data.setScale(this.array.getScale(index));
            return data;
        }

        @Override
        public int size() {
            return this.array.size;
        }

        @Override
        public boolean isEmpty() {
            return this.array.isEmpty();
        }
    }

    public static final class Builder {
        private float[] x;
        private float[] y;
        private float[] z;
        private float[] r;
        private float[] g;
        private float[] b;
        private float[] scale;
        private int[] delay;
        private int size;

        private Builder(int expectedSize) {
            int initial = Math.max(0, expectedSize);
            this.x = new float[initial];
            this.y = new float[initial];
            this.z = new float[initial];
            this.r = new float[initial];
            this.g = new float[initial];
            this.b = new float[initial];
            this.scale = new float[initial];
            this.delay = new int[initial];
            this.size = 0;
        }

        private void ensureCapacity(int minCapacity) {
            if (minCapacity <= this.x.length) {
                return;
            }
            int newCapacity = Math.max(minCapacity, this.x.length == 0 ? 1024 : this.x.length * 2);
            this.x = Arrays.copyOf(this.x, newCapacity);
            this.y = Arrays.copyOf(this.y, newCapacity);
            this.z = Arrays.copyOf(this.z, newCapacity);
            this.r = Arrays.copyOf(this.r, newCapacity);
            this.g = Arrays.copyOf(this.g, newCapacity);
            this.b = Arrays.copyOf(this.b, newCapacity);
            this.scale = Arrays.copyOf(this.scale, newCapacity);
            this.delay = Arrays.copyOf(this.delay, newCapacity);
        }

        public Builder add(ParticleData data) {
            if (data == null) {
                return this;
            }
            return this.add(data.getX(), data.getY(), data.getZ(), data.getR(), data.getG(), data.getB(), data.getDelay(), data.getScale());
        }

        public Builder add(double x, double y, double z, double r, double g, double b, int delay, float scale) {
            this.ensureCapacity(this.size + 1);
            int idx = this.size++;
            this.x[idx] = (float)x;
            this.y[idx] = (float)y;
            this.z[idx] = (float)z;
            this.r[idx] = (float)r;
            this.g[idx] = (float)g;
            this.b[idx] = (float)b;
            this.scale[idx] = scale;
            this.delay[idx] = delay;
            return this;
        }

        public Builder add(double x, double y, double z, double r, double g, double b, int delay, double scale) {
            return this.add(x, y, z, r, g, b, delay, (float)scale);
        }

        public int size() {
            return this.size;
        }

        public PackedParticleArray build() {
            float[] fx = Arrays.copyOf(this.x, this.size);
            float[] fy = Arrays.copyOf(this.y, this.size);
            float[] fz = Arrays.copyOf(this.z, this.size);
            float[] fr = Arrays.copyOf(this.r, this.size);
            float[] fg = Arrays.copyOf(this.g, this.size);
            float[] fb = Arrays.copyOf(this.b, this.size);
            float[] fs = Arrays.copyOf(this.scale, this.size);
            int[] fd = Arrays.copyOf(this.delay, this.size);
            return new PackedParticleArray(fx, fy, fz, fr, fg, fb, fs, fd, this.size);
        }
    }
}

