/*
 * Decompiled with CFR 0.152.
 */
package com.winss.dustlab.utils;

import com.winss.dustlab.config.DustLabConfig;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.plugin.Plugin;

public class MessageUtils {
    public static final String PREFIX_COLOR = "&9";
    public static final String ACCENT_COLOR = "&b";
    public static final String TEXT_COLOR = "&f";
    public static final String SECONDARY_COLOR = "&7";
    public static final String ERROR_COLOR = "&c";
    public static final String SUCCESS_COLOR = "&a";
    private static final String PLAYER_PREFIX = MessageUtils.translateColors("&9DustLab &b\u00bb &f");

    public static void sendMessage(CommandSender sender, String message) {
        if (sender instanceof ConsoleCommandSender) {
            sender.sendMessage(MessageUtils.stripColors(message));
        } else {
            sender.sendMessage(PLAYER_PREFIX + MessageUtils.translateColors(message));
        }
    }

    public static String translateColors(String message) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }

    public static String stripColors(String message) {
        return ChatColor.stripColor((String)MessageUtils.translateColors(message));
    }

    public static String success(String message) {
        return SUCCESS_COLOR + message;
    }

    public static String error(String message) {
        return ERROR_COLOR + message;
    }

    public static String secondary(String message) {
        return SECONDARY_COLOR + message;
    }

    public static String accent(String message) {
        return ACCENT_COLOR + message;
    }

    public static String getPlayerPrefix() {
        return PLAYER_PREFIX;
    }

    public static void logVerbose(Plugin plugin, DustLabConfig config, String message) {
        if (config != null && config.isVerboseLogging()) {
            plugin.getLogger().info(MessageUtils.stripColors(message));
        }
    }
}

