/*
 * Decompiled with CFR 0.152.
 */
package me.justlime.betterTeamGUI.gui;

import com.booksaw.betterTeams.PlayerRank;
import com.booksaw.betterTeams.Team;
import com.booksaw.betterTeams.TeamPlayer;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.justlime.betterTeamGUI.config.Config;
import me.justlime.betterTeamGUI.gui.GUIHandler;
import me.justlime.betterTeamGUI.gui.GUIManager;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.PrepareAnvilEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u0013H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lme/justlime/betterTeamGUI/gui/TeamAllyGUI;", "Lme/justlime/betterTeamGUI/gui/GUIHandler;", "row", "", "title", "", "team", "Lcom/booksaw/betterTeams/Team;", "teamPlayer", "Lcom/booksaw/betterTeams/TeamPlayer;", "<init>", "(ILjava/lang/String;Lcom/booksaw/betterTeams/Team;Lcom/booksaw/betterTeams/TeamPlayer;)V", "getTitle", "()Ljava/lang/String;", "getTeam", "()Lcom/booksaw/betterTeams/Team;", "getTeamPlayer", "()Lcom/booksaw/betterTeams/TeamPlayer;", "inventory", "Lorg/bukkit/inventory/Inventory;", "loadInventory", "", "player", "Lorg/bukkit/entity/Player;", "onClick", "event", "Lorg/bukkit/event/inventory/InventoryClickEvent;", "onClose", "Lorg/bukkit/event/inventory/InventoryCloseEvent;", "getInventory", "BetterTeamGUI"})
@SourceDebugExtension(value={"SMAP\nTeamAllyGUI.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TeamAllyGUI.kt\nme/justlime/betterTeamGUI/gui/TeamAllyGUI\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,58:1\n1863#2,2:59\n*S KotlinDebug\n*F\n+ 1 TeamAllyGUI.kt\nme/justlime/betterTeamGUI/gui/TeamAllyGUI\n*L\n21#1:59,2\n*E\n"})
public final class TeamAllyGUI
implements GUIHandler {
    @NotNull
    private final String title;
    @NotNull
    private final Team team;
    @NotNull
    private final TeamPlayer teamPlayer;
    @NotNull
    private final Inventory inventory;

    public TeamAllyGUI(int row, @NotNull String title, @NotNull Team team, @NotNull TeamPlayer teamPlayer) {
        Intrinsics.checkNotNullParameter(title, "title");
        Intrinsics.checkNotNullParameter(team, "team");
        Intrinsics.checkNotNullParameter(teamPlayer, "teamPlayer");
        this.title = title;
        this.team = team;
        this.teamPlayer = teamPlayer;
        Inventory inventory = Bukkit.createInventory((InventoryHolder)this, (int)(row * 9), (String)this.title);
        Intrinsics.checkNotNullExpressionValue(inventory, "createInventory(...)");
        this.inventory = inventory;
    }

    @NotNull
    public final String getTitle() {
        return this.title;
    }

    @NotNull
    public final Team getTeam() {
        return this.team;
    }

    @NotNull
    public final TeamPlayer getTeamPlayer() {
        return this.teamPlayer;
    }

    @Override
    public void loadInventory(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        GUIManager.INSTANCE.insertBackground(this.inventory);
        Set allies = this.team.getAllies().get();
        Intrinsics.checkNotNull(allies);
        Iterable $this$forEach$iv = allies;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TeamPlayer owner;
            Team alliesTeam;
            UUID it = (UUID)element$iv;
            boolean bl = false;
            if (Team.getTeam((UUID)it) == null) continue;
            List list = alliesTeam.getMembers().getRank(PlayerRank.OWNER);
            Intrinsics.checkNotNullExpressionValue(list, "getRank(...)");
            if ((TeamPlayer)CollectionsKt.firstOrNull(list) == null) continue;
            OfflinePlayer offlinePlayer = owner.getPlayer();
            Intrinsics.checkNotNullExpressionValue(offlinePlayer, "getPlayer(...)");
            ItemStack item = GUIManager.createHeadItem$default(GUIManager.INSTANCE, alliesTeam, offlinePlayer, null, 4, null);
            ItemStack[] itemStackArray = new ItemStack[]{item};
            this.inventory.addItem(itemStackArray);
        }
        int backSlot = Config.TeamAllyView.INSTANCE.getBackSlot();
        List<Integer> backSlots = Config.TeamAllyView.INSTANCE.getBackSlots();
        ConfigurationSection backSection = Config.INSTANCE.getBackItem();
        GUIManager.loadItem$default(GUIManager.INSTANCE, backSection, this.inventory, this.team, backSlots.isEmpty() ? CollectionsKt.listOf(backSlot) : backSlots, this.teamPlayer, null, 32, null);
    }

    @Override
    public void onClick(@NotNull InventoryClickEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        event.setCancelled(true);
        HumanEntity humanEntity = event.getWhoClicked();
        Intrinsics.checkNotNull(humanEntity, "null cannot be cast to non-null type org.bukkit.entity.Player");
        Player player = (Player)humanEntity;
        int backSlot = Config.TeamAllyView.INSTANCE.getBackSlot();
        List<Integer> backSlots = Config.TeamAllyView.INSTANCE.getBackSlots();
        if (backSlots.contains(event.getSlot()) || event.getSlot() == backSlot) {
            GUIManager.INSTANCE.openTeamGUI(player);
            return;
        }
        ItemStack itemStack = event.getCurrentItem();
        if (itemStack == null) {
            return;
        }
        ItemStack item = itemStack;
        if (item.getType() != Material.PLAYER_HEAD) {
            return;
        }
        ItemMeta itemMeta = item.getItemMeta();
        SkullMeta skullMeta = itemMeta instanceof SkullMeta ? (SkullMeta)itemMeta : null;
        if (skullMeta == null || (skullMeta = skullMeta.getOwningPlayer()) == null) {
            return;
        }
        SkullMeta owner = skullMeta;
        Team team = Team.getTeam((OfflinePlayer)owner);
        if (team == null) {
            return;
        }
        Team alliesTeam = team;
        GUIManager.INSTANCE.openTeamOtherGUI(player, alliesTeam, this.teamPlayer);
    }

    @Override
    public void onClose(@NotNull InventoryCloseEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
    }

    @NotNull
    public Inventory getInventory() {
        return this.inventory;
    }

    @Override
    public void onAnvilRename(@NotNull PrepareAnvilEvent event) {
        GUIHandler.DefaultImpls.onAnvilRename(this, event);
    }
}

