/*
 * Decompiled with CFR 0.152.
 */
package me.justlime.betterTeamGUI.gui;

import com.booksaw.betterTeams.PlayerRank;
import com.booksaw.betterTeams.Team;
import com.booksaw.betterTeams.TeamPlayer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import me.justlime.betterTeamGUI.config.Config;
import me.justlime.betterTeamGUI.config.Service;
import me.justlime.betterTeamGUI.gui.GUIHandler;
import me.justlime.betterTeamGUI.gui.GUIManager;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.PrepareAnvilEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0001\u001bB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u000fH\u0016J\u0018\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u0005H\u0002R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lme/justlime/betterTeamGUI/gui/TeamLeaderBoard;", "Lme/justlime/betterTeamGUI/gui/GUIHandler;", "rows", "", "title", "", "teamPlayer", "Lcom/booksaw/betterTeams/TeamPlayer;", "<init>", "(ILjava/lang/String;Lcom/booksaw/betterTeams/TeamPlayer;)V", "getTeamPlayer", "()Lcom/booksaw/betterTeams/TeamPlayer;", "sortType", "Lme/justlime/betterTeamGUI/gui/TeamLeaderBoard$SortType;", "inventory", "Lorg/bukkit/inventory/Inventory;", "loadInventory", "", "player", "Lorg/bukkit/entity/Player;", "onClick", "event", "Lorg/bukkit/event/inventory/InventoryClickEvent;", "getInventory", "addItem", "index", "it", "SortType", "BetterTeamGUI"})
@SourceDebugExtension(value={"SMAP\nTeamLeaderBoard.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TeamLeaderBoard.kt\nme/justlime/betterTeamGUI/gui/TeamLeaderBoard\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,109:1\n13467#2,3:110\n13467#2,3:113\n1557#3:116\n1628#3,3:117\n*S KotlinDebug\n*F\n+ 1 TeamLeaderBoard.kt\nme/justlime/betterTeamGUI/gui/TeamLeaderBoard\n*L\n43#1:110,3\n49#1:113,3\n99#1:116\n99#1:117,3\n*E\n"})
public final class TeamLeaderBoard
implements GUIHandler {
    @NotNull
    private final TeamPlayer teamPlayer;
    @NotNull
    private SortType sortType;
    @NotNull
    private final Inventory inventory;

    public TeamLeaderBoard(int rows, @NotNull String title, @NotNull TeamPlayer teamPlayer) {
        Intrinsics.checkNotNullParameter(title, "title");
        Intrinsics.checkNotNullParameter(teamPlayer, "teamPlayer");
        this.teamPlayer = teamPlayer;
        this.sortType = SortType.MONEY;
        Inventory inventory = Bukkit.createInventory((InventoryHolder)this, (int)(rows * 9), (String)title);
        Intrinsics.checkNotNullExpressionValue(inventory, "createInventory(...)");
        this.inventory = inventory;
    }

    @NotNull
    public final TeamPlayer getTeamPlayer() {
        return this.teamPlayer;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void loadInventory(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        GUIManager.INSTANCE.insertBackground(this.inventory);
        int backSlot = Config.TeamLBView.INSTANCE.getBackSlot();
        List<Integer> backSlots = Config.TeamLBView.INSTANCE.getBackSlots();
        ConfigurationSection backSection = Config.INSTANCE.getBackItem();
        GUIManager.INSTANCE.createCertainItem(backSection, backSlot, backSlots, this.inventory);
        ConfigurationSection sortItem = Config.TeamLBView.INSTANCE.getSortType();
        int slot = sortItem.getInt("slot");
        List list = sortItem.getIntegerList("slot");
        Intrinsics.checkNotNullExpressionValue(list, "getIntegerList(...)");
        List slots = list;
        GUIManager.INSTANCE.createCertainItem(sortItem, slot, slots, this.inventory);
        ConfigurationSection balanceTeam = Config.TeamLBView.INSTANCE.getBalanceTeam();
        ConfigurationSection scoreTeam = Config.TeamLBView.INSTANCE.getScoreTeam();
        ConfigurationSection sortType = Config.TeamLBView.INSTANCE.getSortType();
        String[] sortedTeamByBalance = Team.getTeamManager().sortTeamsByBalance();
        String[] sortedTeamByScore = Team.getTeamManager().sortTeamsByScore();
        switch (WhenMappings.$EnumSwitchMapping$0[this.sortType.ordinal()]) {
            case 1: {
                Intrinsics.checkNotNull(sortedTeamByBalance);
                String[] $this$forEachIndexed$iv = sortedTeamByBalance;
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (String item$iv : $this$forEachIndexed$iv) {
                    void it;
                    int n = index$iv++;
                    String string = item$iv;
                    int index = n;
                    boolean bl = false;
                    Intrinsics.checkNotNull(it);
                    this.addItem(index, (String)it);
                }
                break;
            }
            case 2: {
                Intrinsics.checkNotNull(sortedTeamByScore);
                String[] $this$forEachIndexed$iv = sortedTeamByScore;
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (String item$iv : $this$forEachIndexed$iv) {
                    int n = index$iv++;
                    String it = item$iv;
                    int index = n;
                    boolean bl = false;
                    Intrinsics.checkNotNull(it);
                    this.addItem(index, it);
                }
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    @Override
    public void onClick(@NotNull InventoryClickEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        event.setCancelled(true);
        HumanEntity humanEntity = event.getWhoClicked();
        Intrinsics.checkNotNull(humanEntity, "null cannot be cast to non-null type org.bukkit.entity.Player");
        Player player = (Player)humanEntity;
        int backSlot = Config.TeamLBView.INSTANCE.getBackSlot();
        List<Integer> backSlots = Config.TeamLBView.INSTANCE.getBackSlots();
        String string = Config.TeamLBView.INSTANCE.getSortType().getString("slot", " ");
        Integer sortSlot = string != null ? StringsKt.toIntOrNull(string) : null;
        Integer n = sortSlot;
        if (n != null && event.getSlot() == n.intValue()) {
            switch (WhenMappings.$EnumSwitchMapping$0[this.sortType.ordinal()]) {
                case 1: {
                    this.sortType = SortType.SCORE;
                    break;
                }
                case 2: {
                    this.sortType = SortType.MONEY;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            this.inventory.clear();
            this.loadInventory(player);
            return;
        }
        if (backSlots.contains(event.getSlot()) || event.getSlot() == backSlot) {
            GUIManager.INSTANCE.openTeamGUI(player);
            return;
        }
        ItemStack itemStack = event.getCurrentItem();
        if ((itemStack != null ? itemStack.getType() : null) == Material.PLAYER_HEAD) {
            ItemStack itemStack2 = event.getCurrentItem();
            Object object = itemStack2 != null ? itemStack2.getItemMeta() : null;
            Intrinsics.checkNotNull(object, "null cannot be cast to non-null type org.bukkit.inventory.meta.SkullMeta");
            OfflinePlayer offlinePlayer = ((SkullMeta)object).getOwningPlayer();
            if (offlinePlayer == null) {
                return;
            }
            OfflinePlayer headOwner = offlinePlayer;
            Team team = Team.getTeam((OfflinePlayer)headOwner);
            if (team == null) {
                return;
            }
            Team team2 = team;
            TeamPlayer teamPlayer = team2.getTeamPlayer(headOwner);
            if (teamPlayer == null) {
                return;
            }
            TeamPlayer teamPlayer2 = teamPlayer;
            GUIManager.INSTANCE.openTeamOtherGUI(player, team2, teamPlayer2);
            return;
        }
    }

    @NotNull
    public Inventory getInventory() {
        return this.inventory;
    }

    /*
     * WARNING - void declaration
     */
    private final void addItem(int index, String it) {
        ItemMeta itemMeta;
        void $this$mapTo$iv$iv;
        Team team = Team.getTeam((String)it);
        if (team == null) {
            return;
        }
        Team sortedTeam = team;
        List list = sortedTeam.getMembers().getRank(PlayerRank.OWNER);
        Intrinsics.checkNotNullExpressionValue(list, "getRank(...)");
        TeamPlayer owner = (TeamPlayer)CollectionsKt.first(list);
        String string = Config.TeamLBView.INSTANCE.getScoreTeam().getString("name");
        if (string == null || (string = StringsKt.replace$default(string, "{pos}", String.valueOf(index + 1), false, 4, null)) == null) {
            string = " ";
        }
        String name = string;
        List list2 = Config.TeamLBView.INSTANCE.getScoreTeam().getStringList("lore");
        Intrinsics.checkNotNullExpressionValue(list2, "getStringList(...)");
        Iterable $this$map$iv = list2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            String string2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull(it2);
            collection.add(Service.INSTANCE.applyLocalPlaceHolder((String)it2, sortedTeam, this.teamPlayer));
        }
        List<String> lore = CollectionsKt.toMutableList((List)destination$iv$iv);
        OfflinePlayer offlinePlayer = owner.getPlayer();
        Intrinsics.checkNotNullExpressionValue(offlinePlayer, "getPlayer(...)");
        ItemStack item = GUIManager.INSTANCE.createHeadItem(sortedTeam, offlinePlayer, lore);
        ItemMeta itemMeta2 = itemMeta = item.getItemMeta();
        if (itemMeta2 != null) {
            itemMeta2.setDisplayName(Service.INSTANCE.applyLocalPlaceHolder(name, sortedTeam, this.teamPlayer));
        }
        item.setItemMeta(itemMeta);
        int itemSlot = this.inventory.firstEmpty();
        this.inventory.setItem(itemSlot, item);
    }

    @Override
    public void onClose(@NotNull InventoryCloseEvent event) {
        GUIHandler.DefaultImpls.onClose(this, event);
    }

    @Override
    public void onAnvilRename(@NotNull PrepareAnvilEvent event) {
        GUIHandler.DefaultImpls.onAnvilRename(this, event);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lme/justlime/betterTeamGUI/gui/TeamLeaderBoard$SortType;", "", "<init>", "(Ljava/lang/String;I)V", "MONEY", "SCORE", "BetterTeamGUI"})
    public static final class SortType
    extends Enum<SortType> {
        public static final /* enum */ SortType MONEY = new SortType();
        public static final /* enum */ SortType SCORE = new SortType();
        private static final /* synthetic */ SortType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static SortType[] values() {
            return (SortType[])$VALUES.clone();
        }

        public static SortType valueOf(String value) {
            return Enum.valueOf(SortType.class, value);
        }

        @NotNull
        public static EnumEntries<SortType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = sortTypeArray = new SortType[]{SortType.MONEY, SortType.SCORE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SortType.values().length];
            try {
                nArray[SortType.MONEY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SortType.SCORE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

