/*
 * Decompiled with CFR 0.152.
 */
package me.justlime.betterTeamGUI.gui;

import com.booksaw.betterTeams.PlayerRank;
import com.booksaw.betterTeams.Team;
import com.booksaw.betterTeams.TeamPlayer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.justlime.betterTeamGUI.config.Config;
import me.justlime.betterTeamGUI.config.Service;
import me.justlime.betterTeamGUI.gui.GUIHandler;
import me.justlime.betterTeamGUI.gui.GUIManager;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.PrepareAnvilEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001 B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u0011H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lme/justlime/betterTeamGUI/gui/TeamMemberGUI;", "Lme/justlime/betterTeamGUI/gui/GUIHandler;", "rows", "", "title", "", "team", "Lcom/booksaw/betterTeams/Team;", "teamPlayer", "Lcom/booksaw/betterTeams/TeamPlayer;", "<init>", "(ILjava/lang/String;Lcom/booksaw/betterTeams/Team;Lcom/booksaw/betterTeams/TeamPlayer;)V", "getTeam", "()Lcom/booksaw/betterTeams/Team;", "getTeamPlayer", "()Lcom/booksaw/betterTeams/TeamPlayer;", "inventory", "Lorg/bukkit/inventory/Inventory;", "section", "", "Lme/justlime/betterTeamGUI/gui/TeamMemberGUI$MemberType;", "Lorg/bukkit/configuration/ConfigurationSection;", "loadInventory", "", "player", "Lorg/bukkit/entity/Player;", "onClick", "event", "Lorg/bukkit/event/inventory/InventoryClickEvent;", "onClose", "Lorg/bukkit/event/inventory/InventoryCloseEvent;", "getInventory", "MemberType", "BetterTeamGUI"})
@SourceDebugExtension(value={"SMAP\nTeamMemberGUI.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TeamMemberGUI.kt\nme/justlime/betterTeamGUI/gui/TeamMemberGUI\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,130:1\n1863#2:131\n1557#2:132\n1628#2,3:133\n1864#2:136\n1557#2:137\n1628#2,3:138\n1557#2:141\n1628#2,3:142\n*S KotlinDebug\n*F\n+ 1 TeamMemberGUI.kt\nme/justlime/betterTeamGUI/gui/TeamMemberGUI\n*L\n28#1:131\n55#1:132\n55#1:133,3\n28#1:136\n71#1:137\n71#1:138,3\n110#1:141\n110#1:142,3\n*E\n"})
public final class TeamMemberGUI
implements GUIHandler {
    @NotNull
    private final Team team;
    @NotNull
    private final TeamPlayer teamPlayer;
    @NotNull
    private final Inventory inventory;
    @NotNull
    private final Map<MemberType, ConfigurationSection> section;

    public TeamMemberGUI(int rows, @NotNull String title, @NotNull Team team, @NotNull TeamPlayer teamPlayer) {
        Intrinsics.checkNotNullParameter(title, "title");
        Intrinsics.checkNotNullParameter(team, "team");
        Intrinsics.checkNotNullParameter(teamPlayer, "teamPlayer");
        this.team = team;
        this.teamPlayer = teamPlayer;
        Inventory inventory = Bukkit.createInventory((InventoryHolder)this, (int)(rows * 9), (String)title);
        Intrinsics.checkNotNullExpressionValue(inventory, "createInventory(...)");
        this.inventory = inventory;
        Pair[] pairArray = new Pair[]{TuplesKt.to(MemberType.OWNER, Config.TeamMemberView.INSTANCE.getOwner()), TuplesKt.to(MemberType.ADMIN, Config.TeamMemberView.INSTANCE.getAdmin()), TuplesKt.to(MemberType.MEMBER, Config.TeamMemberView.INSTANCE.getMember()), TuplesKt.to(MemberType.MANGE, Config.TeamMemberView.INSTANCE.getManage())};
        this.section = MapsKt.mutableMapOf(pairArray);
    }

    @NotNull
    public final Team getTeam() {
        return this.team;
    }

    @NotNull
    public final TeamPlayer getTeamPlayer() {
        return this.teamPlayer;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void loadInventory(@NotNull Player player) {
        ItemStack[] itemStackArray;
        Object item;
        Intrinsics.checkNotNullParameter(player, "player");
        GUIManager.INSTANCE.insertBackground(this.inventory);
        Set teamMembers = this.team.getMembers().get();
        Intrinsics.checkNotNull(teamMembers);
        Iterable $this$forEach$iv = teamMembers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ItemStack[] itemMeta;
            TeamPlayer it = (TeamPlayer)element$iv;
            boolean bl = false;
            OfflinePlayer offlinePlayer = it.getPlayer();
            Intrinsics.checkNotNullExpressionValue(offlinePlayer, "getPlayer(...)");
            item = GUIManager.createHeadItem$default(GUIManager.INSTANCE, this.team, offlinePlayer, null, 4, null);
            if (itemMeta != null) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                boolean isInSameTeam;
                ItemStack[] $this$loadInventory_u24lambda_u242_u24lambda_u241 = itemStackArray = (itemMeta = item.getItemMeta());
                boolean bl2 = false;
                List cLore = new ArrayList();
                String name = "";
                boolean bl3 = isInSameTeam = this.team.getTeamPlayer(this.teamPlayer.getPlayer()) != null;
                if (it.getRank() == PlayerRank.DEFAULT) {
                    Object object;
                    Object object2 = this.section.get((Object)MemberType.MEMBER);
                    if (object2 == null || (object2 = object2.getString("name")) == null) {
                        object2 = name = " ";
                    }
                    if ((object = this.section.get((Object)MemberType.MEMBER)) == null || (object = object.getStringList("lore")) == null || (object = CollectionsKt.toMutableList((Collection)object)) == null) {
                        object = cLore = (List)new ArrayList();
                    }
                    if ((this.teamPlayer.getRank() == PlayerRank.OWNER || this.teamPlayer.getRank() == PlayerRank.ADMIN) && isInSameTeam) {
                        Object object3 = this.section.get((Object)MemberType.MANGE);
                        cLore.addAll(object3 != null && (object3 = object3.getStringList("lore")) != null ? (Collection)object3 : (Collection)CollectionsKt.emptyList());
                    }
                }
                if (it.getRank() == PlayerRank.ADMIN) {
                    Object object;
                    Object object4 = this.section.get((Object)MemberType.ADMIN);
                    if (object4 == null || (object4 = object4.getString("name")) == null) {
                        object4 = name = " ";
                    }
                    if ((object = this.section.get((Object)MemberType.ADMIN)) == null || (object = object.getStringList("lore")) == null || (object = CollectionsKt.toMutableList((Collection)object)) == null) {
                        object = cLore = (List)new ArrayList();
                    }
                    if (this.teamPlayer.getRank() == PlayerRank.OWNER && isInSameTeam) {
                        Object object5 = this.section.get((Object)MemberType.MANGE);
                        cLore.addAll(object5 != null && (object5 = object5.getStringList("lore")) != null ? (Collection)object5 : (Collection)CollectionsKt.emptyList());
                    }
                }
                if (it.getRank() == PlayerRank.OWNER) {
                    Object object;
                    Object object6 = this.section.get((Object)MemberType.OWNER);
                    if (object6 == null || (object6 = object6.getString("name")) == null) {
                        object6 = name = " ";
                    }
                    if ((object = this.section.get((Object)MemberType.OWNER)) == null || (object = object.getStringList("lore")) == null || (object = CollectionsKt.toMutableList((Collection)object)) == null) {
                        object = new ArrayList();
                    }
                    cLore = object;
                }
                Intrinsics.checkNotNull(it);
                $this$loadInventory_u24lambda_u242_u24lambda_u241.setDisplayName(Service.INSTANCE.applyLocalPlaceHolder(name, this.team, it));
                Iterable iterable = cLore;
                ItemStack[] itemStackArray2 = $this$loadInventory_u24lambda_u242_u24lambda_u241;
                boolean $i$f$map = false;
                void var20_30 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void lore;
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl4 = false;
                    collection.add(Service.INSTANCE.applyLocalPlaceHolder((String)lore, this.team, it));
                }
                itemStackArray2.setLore(CollectionsKt.toMutableList((List)destination$iv$iv));
            }
            item.setItemMeta((ItemMeta)itemMeta);
            itemStackArray = new ItemStack[]{item};
            this.inventory.addItem(itemStackArray);
        }
        ConfigurationSection teamInviteItem = Config.TeamMemberView.INSTANCE.getInvite();
        int teamSize = this.team.getTeamLimit();
        int memberSize = this.team.getMembers().size();
        if (this.teamPlayer.getRank() == PlayerRank.OWNER || this.teamPlayer.getRank() == PlayerRank.ADMIN) {
            for (int i = memberSize; i < teamSize; ++i) {
                Collection<String> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                int emptySlot = this.inventory.firstEmpty();
                String string = teamInviteItem.getString("item");
                if (string == null) {
                    string = "PAPER";
                }
                Material material = Material.valueOf((String)string);
                String string2 = teamInviteItem.getString("name");
                if (string2 == null) {
                    string2 = " ";
                }
                String string3 = Service.INSTANCE.applyColors(string2);
                List list = teamInviteItem.getStringList("lore");
                Intrinsics.checkNotNullExpressionValue(list, "getStringList(...)");
                item = list;
                String string4 = string3;
                Material material2 = material;
                GUIManager gUIManager = GUIManager.INSTANCE;
                boolean $i$f$map = false;
                itemStackArray = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String isInSameTeam = (String)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull(it);
                    collection.add(Service.INSTANCE.applyColors((String)it));
                }
                collection = (List)destination$iv$iv;
                ItemStack teamItem = gUIManager.createItem(material2, string4, (List<String>)collection, teamInviteItem.getBoolean("glow"));
                this.inventory.setItem(emptySlot, teamItem);
            }
        }
        int backSlot = Config.TeamMemberView.INSTANCE.getBackSlot();
        List<Integer> backSlots = Config.TeamMemberView.INSTANCE.getBackSlots();
        ConfigurationSection backSection = Config.INSTANCE.getBackItem();
        GUIManager.loadItem$default(GUIManager.INSTANCE, backSection, this.inventory, this.team, backSlots.isEmpty() ? CollectionsKt.listOf(backSlot) : backSlots, this.teamPlayer, null, 32, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onClick(@NotNull InventoryClickEvent event) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        ConfigurationSection teamInviteItem;
        String string;
        boolean isInSameTeam;
        Intrinsics.checkNotNullParameter(event, "event");
        event.setCancelled(true);
        int backSlot = Config.TeamMemberView.INSTANCE.getBackSlot();
        List<Integer> backSlots = Config.TeamMemberView.INSTANCE.getBackSlots();
        HumanEntity humanEntity = event.getWhoClicked();
        Intrinsics.checkNotNull(humanEntity, "null cannot be cast to non-null type org.bukkit.entity.Player");
        Player player = (Player)humanEntity;
        ItemStack itemStack = event.getCurrentItem();
        if (itemStack == null) {
            return;
        }
        ItemStack clickedItem = itemStack;
        int n = event.getSlot();
        if (backSlots.contains(n) || n == backSlot) {
            GUIManager.INSTANCE.openTeamGUI(player);
        }
        if (this.teamPlayer.getRank() == PlayerRank.DEFAULT) {
            return;
        }
        boolean bl = isInSameTeam = this.team.getTeamPlayer((OfflinePlayer)player) != null;
        if (!isInSameTeam) {
            return;
        }
        if (clickedItem.getType() == Material.PLAYER_HEAD) {
            ItemMeta itemMeta = clickedItem.getItemMeta();
            Intrinsics.checkNotNull(itemMeta, "null cannot be cast to non-null type org.bukkit.inventory.meta.SkullMeta");
            OfflinePlayer clickedPlayer = ((SkullMeta)itemMeta).getOwningPlayer();
            TeamPlayer teamPlayer = this.team.getTeamPlayer(clickedPlayer);
            if (teamPlayer == null) {
                return;
            }
            TeamPlayer clickedTeamPlayer = teamPlayer;
            if (this.teamPlayer.getRank() == PlayerRank.ADMIN && (clickedTeamPlayer.getRank() == PlayerRank.OWNER || clickedTeamPlayer.getRank() == PlayerRank.ADMIN)) {
                return;
            }
            if (this.teamPlayer.getRank() == PlayerRank.OWNER && clickedTeamPlayer.getRank() == PlayerRank.OWNER) {
                return;
            }
            GUIManager.INSTANCE.openTeamMemberManagementGUI(player, this.team, clickedTeamPlayer);
        }
        if ((string = (teamInviteItem = Config.TeamMemberView.INSTANCE.getInvite()).getString("item")) == null) {
            string = "PAPER";
        }
        Material material = Material.valueOf((String)string);
        String string2 = teamInviteItem.getString("name");
        if (string2 == null) {
            string2 = " ";
        }
        String string3 = Service.INSTANCE.applyColors(string2);
        List list = teamInviteItem.getStringList("lore");
        Intrinsics.checkNotNullExpressionValue(list, "getStringList(...)");
        Iterable iterable = list;
        String string4 = string3;
        Material material2 = material;
        GUIManager gUIManager = GUIManager.INSTANCE;
        boolean $i$f$map = false;
        void var11_14 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string5 = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNull(it);
            collection.add(Service.INSTANCE.applyColors((String)it));
        }
        collection = (List)destination$iv$iv;
        ItemStack teamItem = gUIManager.createItem(material2, string4, (List<String>)collection, teamInviteItem.getBoolean("glow"));
        if (Intrinsics.areEqual(clickedItem, teamItem) && this.teamPlayer.getRank() != PlayerRank.DEFAULT) {
            GUIManager.INSTANCE.openTeamInviteGUI(player, this.team, this.teamPlayer);
        }
    }

    @Override
    public void onClose(@NotNull InventoryCloseEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
    }

    @NotNull
    public Inventory getInventory() {
        return this.inventory;
    }

    @Override
    public void onAnvilRename(@NotNull PrepareAnvilEvent event) {
        GUIHandler.DefaultImpls.onAnvilRename(this, event);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lme/justlime/betterTeamGUI/gui/TeamMemberGUI$MemberType;", "", "<init>", "(Ljava/lang/String;I)V", "OWNER", "ADMIN", "MEMBER", "MANGE", "BetterTeamGUI"})
    public static final class MemberType
    extends Enum<MemberType> {
        public static final /* enum */ MemberType OWNER = new MemberType();
        public static final /* enum */ MemberType ADMIN = new MemberType();
        public static final /* enum */ MemberType MEMBER = new MemberType();
        public static final /* enum */ MemberType MANGE = new MemberType();
        private static final /* synthetic */ MemberType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static MemberType[] values() {
            return (MemberType[])$VALUES.clone();
        }

        public static MemberType valueOf(String value) {
            return Enum.valueOf(MemberType.class, value);
        }

        @NotNull
        public static EnumEntries<MemberType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = memberTypeArray = new MemberType[]{MemberType.OWNER, MemberType.ADMIN, MemberType.MEMBER, MemberType.MANGE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

