/*
 * Decompiled with CFR 0.152.
 */
package me.justlime.betterTeamGUI.gui;

import com.booksaw.betterTeams.Team;
import com.booksaw.betterTeams.TeamPlayer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import me.justlime.betterTeamGUI.config.Config;
import me.justlime.betterTeamGUI.gui.GUIHandler;
import me.justlime.betterTeamGUI.gui.GUIManager;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.PrepareAnvilEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001!B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020\u0011H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00030\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00160\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lme/justlime/betterTeamGUI/gui/TeamMemberManagementGUI;", "Lme/justlime/betterTeamGUI/gui/GUIHandler;", "rows", "", "title", "", "team", "Lcom/booksaw/betterTeams/Team;", "teamPlayer", "Lcom/booksaw/betterTeams/TeamPlayer;", "<init>", "(ILjava/lang/String;Lcom/booksaw/betterTeams/Team;Lcom/booksaw/betterTeams/TeamPlayer;)V", "getTeam", "()Lcom/booksaw/betterTeams/Team;", "getTeamPlayer", "()Lcom/booksaw/betterTeams/TeamPlayer;", "inventory", "Lorg/bukkit/inventory/Inventory;", "confirmed", "", "Lme/justlime/betterTeamGUI/gui/TeamMemberManagementGUI$ManagementType;", "sections", "Lorg/bukkit/configuration/ConfigurationSection;", "loadInventory", "", "player", "Lorg/bukkit/entity/Player;", "onClick", "event", "Lorg/bukkit/event/inventory/InventoryClickEvent;", "onClose", "Lorg/bukkit/event/inventory/InventoryCloseEvent;", "getInventory", "ManagementType", "BetterTeamGUI"})
@SourceDebugExtension(value={"SMAP\nTeamMemberManagementGUI.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TeamMemberManagementGUI.kt\nme/justlime/betterTeamGUI/gui/TeamMemberManagementGUI\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,112:1\n1863#2,2:113\n1863#2,2:115\n1863#2,2:117\n1863#2,2:119\n1863#2,2:121\n*S KotlinDebug\n*F\n+ 1 TeamMemberManagementGUI.kt\nme/justlime/betterTeamGUI/gui/TeamMemberManagementGUI\n*L\n29#1:113,2\n51#1:115,2\n64#1:117,2\n77#1:119,2\n90#1:121,2\n*E\n"})
public final class TeamMemberManagementGUI
implements GUIHandler {
    @NotNull
    private final Team team;
    @NotNull
    private final TeamPlayer teamPlayer;
    @NotNull
    private final Inventory inventory;
    @NotNull
    private final Map<ManagementType, Integer> confirmed;
    @NotNull
    private final Map<ManagementType, ConfigurationSection> sections;

    public TeamMemberManagementGUI(int rows, @NotNull String title, @NotNull Team team, @NotNull TeamPlayer teamPlayer) {
        Intrinsics.checkNotNullParameter(title, "title");
        Intrinsics.checkNotNullParameter(team, "team");
        Intrinsics.checkNotNullParameter(teamPlayer, "teamPlayer");
        this.team = team;
        this.teamPlayer = teamPlayer;
        Inventory inventory = Bukkit.createInventory((InventoryHolder)this, (int)(rows * 9), (String)title);
        Intrinsics.checkNotNullExpressionValue(inventory, "createInventory(...)");
        this.inventory = inventory;
        this.confirmed = new LinkedHashMap();
        Pair[] pairArray = new Pair[]{TuplesKt.to(ManagementType.DEMOTE, Config.TeamMemberManagementView.INSTANCE.getDemote()), TuplesKt.to(ManagementType.PROMOTE, Config.TeamMemberManagementView.INSTANCE.getPromote()), TuplesKt.to(ManagementType.KICK, Config.TeamMemberManagementView.INSTANCE.getKick()), TuplesKt.to(ManagementType.BAN, Config.TeamMemberManagementView.INSTANCE.getBan()), TuplesKt.to(ManagementType.CONFIRM, Config.TeamMemberManagementView.INSTANCE.getConfirm())};
        this.sections = MapsKt.mutableMapOf(pairArray);
    }

    @NotNull
    public final Team getTeam() {
        return this.team;
    }

    @NotNull
    public final TeamPlayer getTeamPlayer() {
        return this.teamPlayer;
    }

    @Override
    public void loadInventory(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        GUIManager.INSTANCE.insertBackground(this.inventory);
        int backSlot = Config.TeamMemberManagementView.INSTANCE.getBackSlot();
        List<Integer> backSlots = Config.TeamMemberManagementView.INSTANCE.getBackSlots();
        ConfigurationSection backSection = Config.INSTANCE.getBackItem();
        GUIManager.loadItem$default(GUIManager.INSTANCE, backSection, this.inventory, this.team, backSlots.isEmpty() ? CollectionsKt.listOf(backSlot) : backSlots, this.teamPlayer, null, 32, null);
        Iterable $this$forEach$iv = this.sections.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ConfigurationSection it = (ConfigurationSection)element$iv;
            boolean bl = false;
            GUIManager.loadItem$default(GUIManager.INSTANCE, it, this.inventory, this.team, new ArrayList(), this.teamPlayer, null, 32, null);
        }
    }

    @Override
    public void onClick(@NotNull InventoryClickEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        event.setCancelled(true);
        HumanEntity humanEntity = event.getWhoClicked();
        Intrinsics.checkNotNull(humanEntity, "null cannot be cast to non-null type org.bukkit.entity.Player");
        Player player = (Player)humanEntity;
        int backSlot = Config.TeamMemberManagementView.INSTANCE.getBackSlot();
        List<Integer> backSlots = Config.TeamMemberManagementView.INSTANCE.getBackSlots();
        Object object = this.sections.get((Object)ManagementType.DEMOTE);
        Integer demoteSlot = object != null && (object = object.getString("slot", " ")) != null ? StringsKt.toIntOrNull((String)object) : null;
        Object object2 = this.sections.get((Object)ManagementType.PROMOTE);
        Integer promoteSlot = object2 != null && (object2 = object2.getString("slot", " ")) != null ? StringsKt.toIntOrNull((String)object2) : null;
        Object object3 = this.sections.get((Object)ManagementType.KICK);
        Integer kickSlot = object3 != null && (object3 = object3.getString("slot", " ")) != null ? StringsKt.toIntOrNull((String)object3) : null;
        Object object4 = this.sections.get((Object)ManagementType.BAN);
        Integer banSlot = object4 != null && (object4 = object4.getString("slot", " ")) != null ? StringsKt.toIntOrNull((String)object4) : null;
        int n = event.getSlot();
        if (backSlots.contains(n) || n == backSlot) {
            GUIManager.INSTANCE.openTeamGUI(player);
        } else {
            Integer n2 = demoteSlot;
            if (n2 != null && n == n2) {
                if (!this.confirmed.containsKey((Object)ManagementType.DEMOTE)) {
                    ConfigurationSection configurationSection = this.sections.get((Object)ManagementType.CONFIRM);
                    if (configurationSection == null) {
                        return;
                    }
                    ConfigurationSection confirmedSection = configurationSection;
                    this.confirmed.clear();
                    Integer[] $this$forEach$iv = (Integer[])this.sections.values();
                    boolean $i$f$forEach = false;
                    for (Object t : $this$forEach$iv) {
                        ConfigurationSection it = (ConfigurationSection)t;
                        boolean bl = false;
                        GUIManager.loadItem$default(GUIManager.INSTANCE, it, this.inventory, this.team, new ArrayList(), this.teamPlayer, null, 32, null);
                    }
                    $this$forEach$iv = new Integer[]{demoteSlot};
                    GUIManager.loadItem$default(GUIManager.INSTANCE, confirmedSection, this.inventory, this.team, CollectionsKt.mutableListOf($this$forEach$iv), this.teamPlayer, null, 32, null);
                    this.confirmed.put(ManagementType.DEMOTE, 0);
                    return;
                }
                player.performCommand("team:team demote " + this.teamPlayer.getPlayer().getName());
                GUIManager.INSTANCE.closeInventory(player);
            } else {
                Integer n3 = promoteSlot;
                if (n3 != null && n == n3) {
                    if (!this.confirmed.containsKey((Object)ManagementType.PROMOTE)) {
                        ConfigurationSection configurationSection = this.sections.get((Object)ManagementType.CONFIRM);
                        if (configurationSection == null) {
                            return;
                        }
                        ConfigurationSection confirmedSection = configurationSection;
                        this.confirmed.clear();
                        Integer[] $this$forEach$iv = (Integer[])this.sections.values();
                        boolean $i$f$forEach = false;
                        for (Object t : $this$forEach$iv) {
                            ConfigurationSection it = (ConfigurationSection)t;
                            boolean bl = false;
                            GUIManager.loadItem$default(GUIManager.INSTANCE, it, this.inventory, this.team, new ArrayList(), this.teamPlayer, null, 32, null);
                        }
                        $this$forEach$iv = new Integer[]{promoteSlot};
                        GUIManager.loadItem$default(GUIManager.INSTANCE, confirmedSection, this.inventory, this.team, CollectionsKt.mutableListOf($this$forEach$iv), this.teamPlayer, null, 32, null);
                        this.confirmed.put(ManagementType.PROMOTE, 0);
                        return;
                    }
                    player.performCommand("team:team promote " + this.teamPlayer.getPlayer().getName());
                    GUIManager.INSTANCE.closeInventory(player);
                } else {
                    Integer n4 = kickSlot;
                    if (n4 != null && n == n4) {
                        if (!this.confirmed.containsKey((Object)ManagementType.KICK)) {
                            ConfigurationSection configurationSection = this.sections.get((Object)ManagementType.CONFIRM);
                            if (configurationSection == null) {
                                return;
                            }
                            ConfigurationSection confirmedSection = configurationSection;
                            this.confirmed.clear();
                            Integer[] $this$forEach$iv = (Integer[])this.sections.values();
                            boolean $i$f$forEach = false;
                            for (Object t : $this$forEach$iv) {
                                ConfigurationSection it = (ConfigurationSection)t;
                                boolean bl = false;
                                GUIManager.loadItem$default(GUIManager.INSTANCE, it, this.inventory, this.team, new ArrayList(), this.teamPlayer, null, 32, null);
                            }
                            $this$forEach$iv = new Integer[]{kickSlot};
                            GUIManager.loadItem$default(GUIManager.INSTANCE, confirmedSection, this.inventory, this.team, CollectionsKt.mutableListOf($this$forEach$iv), this.teamPlayer, null, 32, null);
                            this.confirmed.put(ManagementType.KICK, 0);
                            return;
                        }
                        player.performCommand("team:team kick " + this.teamPlayer.getPlayer().getName());
                        GUIManager.INSTANCE.closeInventory(player);
                    } else {
                        Integer n5 = banSlot;
                        if (n5 != null && n == n5) {
                            if (!this.confirmed.containsKey((Object)ManagementType.BAN)) {
                                ConfigurationSection configurationSection = this.sections.get((Object)ManagementType.CONFIRM);
                                if (configurationSection == null) {
                                    return;
                                }
                                ConfigurationSection confirmedSection = configurationSection;
                                this.confirmed.clear();
                                Iterable $this$forEach$iv = this.sections.values();
                                boolean $i$f$forEach = false;
                                for (Object t : $this$forEach$iv) {
                                    ConfigurationSection it = (ConfigurationSection)t;
                                    boolean bl = false;
                                    GUIManager.loadItem$default(GUIManager.INSTANCE, it, this.inventory, this.team, new ArrayList(), this.teamPlayer, null, 32, null);
                                }
                                Integer[] integerArray = new Integer[]{banSlot};
                                GUIManager.loadItem$default(GUIManager.INSTANCE, confirmedSection, this.inventory, this.team, CollectionsKt.mutableListOf(integerArray), this.teamPlayer, null, 32, null);
                                this.confirmed.put(ManagementType.BAN, 0);
                                return;
                            }
                            player.performCommand("team:team ban " + this.teamPlayer.getPlayer().getName());
                            GUIManager.INSTANCE.closeInventory(player);
                        }
                    }
                }
            }
        }
    }

    @Override
    public void onClose(@NotNull InventoryCloseEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
    }

    @NotNull
    public Inventory getInventory() {
        return this.inventory;
    }

    @Override
    public void onAnvilRename(@NotNull PrepareAnvilEvent event) {
        GUIHandler.DefaultImpls.onAnvilRename(this, event);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\b\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lme/justlime/betterTeamGUI/gui/TeamMemberManagementGUI$ManagementType;", "", "<init>", "(Ljava/lang/String;I)V", "DEMOTE", "PROMOTE", "KICK", "BAN", "CONFIRM", "BetterTeamGUI"})
    public static final class ManagementType
    extends Enum<ManagementType> {
        public static final /* enum */ ManagementType DEMOTE = new ManagementType();
        public static final /* enum */ ManagementType PROMOTE = new ManagementType();
        public static final /* enum */ ManagementType KICK = new ManagementType();
        public static final /* enum */ ManagementType BAN = new ManagementType();
        public static final /* enum */ ManagementType CONFIRM = new ManagementType();
        private static final /* synthetic */ ManagementType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ManagementType[] values() {
            return (ManagementType[])$VALUES.clone();
        }

        public static ManagementType valueOf(String value) {
            return Enum.valueOf(ManagementType.class, value);
        }

        @NotNull
        public static EnumEntries<ManagementType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = managementTypeArray = new ManagementType[]{ManagementType.DEMOTE, ManagementType.PROMOTE, ManagementType.KICK, ManagementType.BAN, ManagementType.CONFIRM};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

