/*
 * Decompiled with CFR 0.152.
 */
package me.justlime.betterTeamGUI;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import me.justlime.betterTeamGUI.BetterTeamGUI;
import me.justlime.betterTeamGUI.utilities.ConsoleMessage;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u0010\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\u001a\b\u0010\u0006\u001a\u00020\u0007H\u0002\"\u001a\u0010\u0000\u001a\u00020\u0001X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0004\b\u0004\u0010\u0005\u00a8\u0006\b"}, d2={"pluginInstance", "Lme/justlime/betterTeamGUI/BetterTeamGUI;", "getPluginInstance", "()Lme/justlime/betterTeamGUI/BetterTeamGUI;", "setPluginInstance", "(Lme/justlime/betterTeamGUI/BetterTeamGUI;)V", "checkVersionFromBetterTeamGUIRepo", "", "BetterTeamGUI"})
public final class BetterTeamGUIKt {
    public static BetterTeamGUI pluginInstance;

    @NotNull
    public static final BetterTeamGUI getPluginInstance() {
        BetterTeamGUI betterTeamGUI = pluginInstance;
        if (betterTeamGUI != null) {
            return betterTeamGUI;
        }
        Intrinsics.throwUninitializedPropertyAccessException("pluginInstance");
        return null;
    }

    public static final void setPluginInstance(@NotNull BetterTeamGUI betterTeamGUI) {
        Intrinsics.checkNotNullParameter((Object)betterTeamGUI, "<set-?>");
        pluginInstance = betterTeamGUI;
    }

    private static final void checkVersionFromBetterTeamGUIRepo() {
        try {
            URL url = new URL("https://api.github.com/repos/ItzYashvardhan/BetterTeamGUI/tags");
            URLConnection uRLConnection = url.openConnection();
            Intrinsics.checkNotNull(uRLConnection, "null cannot be cast to non-null type java.net.HttpURLConnection");
            HttpURLConnection conn = (HttpURLConnection)uRLConnection;
            conn.setRequestProperty("User-Agent", "Mozilla/5.0");
            conn.setConnectTimeout(5000);
            conn.setReadTimeout(5000);
            InputStream inputStream = conn.getInputStream();
            Intrinsics.checkNotNullExpressionValue(inputStream, "getInputStream(...)");
            InputStream inputStream2 = inputStream;
            Charset charset = Charsets.UTF_8;
            Reader reader = new InputStreamReader(inputStream2, charset);
            int n = 8192;
            String response = TextStreamsKt.readText(reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n));
            Regex versionPattern = new Regex("\"name\"\\s*:\\s*\"([^\"]+)\"");
            MatchResult matchResult = Regex.find$default(versionPattern, response, 0, 2, null);
            if (matchResult == null) {
                return;
            }
            MatchResult match = matchResult;
            String latestTag = StringsKt.removePrefix(match.getGroupValues().get(1), (CharSequence)"v");
            String string = BetterTeamGUIKt.getPluginInstance().getDescription().getVersion();
            Intrinsics.checkNotNullExpressionValue(string, "getVersion(...)");
            String currentVersion = string;
            if (!Intrinsics.areEqual(currentVersion, latestTag)) {
                ConsoleMessage.printStep$default(ConsoleMessage.INSTANCE, "Outdated Version Found:" + (Object)((Object)ConsoleMessage.Color.WHITE) + ' ' + currentVersion + " -> " + latestTag, ConsoleMessage.Color.BRIGHT_YELLOW, null, 4, null);
                ConsoleMessage.printStep$default(ConsoleMessage.INSTANCE, "Modrinth", ConsoleMessage.Color.LIGHT_BLUE, null, 4, null);
                ConsoleMessage.printStep$default(ConsoleMessage.INSTANCE, "https://modrinth.com/plugin/betterteamsgui/versions", ConsoleMessage.Color.WHITE, null, 4, null);
                ConsoleMessage.printStep$default(ConsoleMessage.INSTANCE, "Download the latest version from above link", ConsoleMessage.Color.BRIGHT_PURPLE, null, 4, null);
            } else {
                ConsoleMessage.printStep$default(ConsoleMessage.INSTANCE, "Latest version found" + (Object)((Object)ConsoleMessage.Color.RESET) + (Object)((Object)ConsoleMessage.Color.WHITE) + " (" + currentVersion + ')', ConsoleMessage.Color.GREEN, null, 4, null);
            }
        }
        catch (Exception e) {
            ConsoleMessage.printStep$default(ConsoleMessage.INSTANCE, "Failed to check for updates", ConsoleMessage.Color.RED, null, 4, null);
            String string = e.getMessage();
            if (string == null) {
                string = "Unidentified Version Error";
            }
            ConsoleMessage.printStep$default(ConsoleMessage.INSTANCE, string, null, null, 6, null);
        }
    }

    public static final /* synthetic */ void access$checkVersionFromBetterTeamGUIRepo() {
        BetterTeamGUIKt.checkVersionFromBetterTeamGUIRepo();
    }
}

