/*
 * Decompiled with CFR 0.152.
 */
package me.justlime.betterTeamGUI.libs.limeframegui.session;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import me.justlime.betterTeamGUI.libs.limeframegui.color.FontStyle;
import me.justlime.betterTeamGUI.libs.limeframegui.handler.GUIEventHandler;
import me.justlime.betterTeamGUI.libs.limeframegui.handler.GuiPage;
import me.justlime.betterTeamGUI.libs.limeframegui.impl.ChestGUIBuilder;
import me.justlime.betterTeamGUI.libs.limeframegui.models.GuiItem;
import me.justlime.betterTeamGUI.libs.limeframegui.models.LimeStyleSheet;
import me.justlime.betterTeamGUI.libs.limeframegui.rendering.ItemRenderer;
import me.justlime.betterTeamGUI.libs.limeframegui.type.ChestGUI;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\n\u001a\u00020\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010\u000eJ\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lme/justlime/betterTeamGUI/libs/limeframegui/session/GuiSession;", "", "blueprint", "Lme/justlime/betterTeamGUI/libs/limeframegui/type/ChestGUI;", "context", "Lme/justlime/betterTeamGUI/libs/limeframegui/models/LimeStyleSheet;", "<init>", "(Lnet/justlime/limeframegui/type/ChestGUI;Lnet/justlime/limeframegui/models/LimeStyleSheet;)V", "player", "Lorg/bukkit/entity/Player;", "start", "", "initialPage", "", "(Ljava/lang/Integer;)V", "generateTitle", "", "rawTitle", "pageId", "LimeFrameGUI"})
@SourceDebugExtension(value={"SMAP\nGuiSession.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GuiSession.kt\nnet/justlime/limeframegui/session/GuiSession\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,80:1\n216#2:81\n216#2,2:82\n216#2,2:84\n217#2:86\n774#3:87\n865#3,2:88\n*S KotlinDebug\n*F\n+ 1 GuiSession.kt\nnet/justlime/limeframegui/session/GuiSession\n*L\n34#1:81\n43#1:82,2\n57#1:84,2\n34#1:86\n67#1:87\n67#1:88,2\n*E\n"})
public final class GuiSession {
    @NotNull
    private final ChestGUI blueprint;
    @NotNull
    private final LimeStyleSheet context;
    @NotNull
    private final Player player;

    public GuiSession(@NotNull ChestGUI blueprint, @NotNull LimeStyleSheet context) {
        Intrinsics.checkNotNullParameter(blueprint, "blueprint");
        Intrinsics.checkNotNullParameter(context, "context");
        this.blueprint = blueprint;
        this.context = context;
        Player player = this.context.getPlayer();
        if (player == null) {
            throw new IllegalStateException("Cannot start a GUI Session without a player in the stylesheet context.");
        }
        this.player = player;
    }

    /*
     * WARNING - void declaration
     */
    public final void start(@Nullable Integer initialPage) {
        int n;
        Object object;
        ChestGUIBuilder builder;
        ChestGUIBuilder chestGUIBuilder = builder = new ChestGUIBuilder(this.blueprint.getSetting());
        this.blueprint.getBlock().invoke(chestGUIBuilder);
        GUIEventHandler handler = builder.build();
        GuiPage globalPage = builder.getPages().get(0);
        Map<Integer, GuiPage> $this$forEach$iv = builder.getPages();
        boolean $i$f$forEach = false;
        for (Map.Entry<Integer, GuiPage> element$iv : $this$forEach$iv.entrySet()) {
            Inventory styledInventory;
            GuiItem guiItem;
            int slot;
            Map.Entry<Integer, GuiItem> entry;
            Map.Entry<Integer, GuiItem> element$iv2;
            Iterator<Map.Entry<Integer, GuiItem>> iterator2;
            boolean $i$f$forEach2;
            Map<Integer, GuiItem> $this$forEach$iv2;
            object = element$iv;
            boolean bl = false;
            int pageId = ((Number)object.getKey()).intValue();
            GuiPage guiPage = object.getValue();
            String styledTitle = this.generateTitle(this.blueprint.getSetting().getTitle(), pageId);
            int size = this.blueprint.getSetting().getRows() * 9;
            Intrinsics.checkNotNullExpressionValue(Bukkit.createInventory((InventoryHolder)handler, (int)size, (String)styledTitle), "createInventory(...)");
            if (pageId != 0 && globalPage != null) {
                $this$forEach$iv2 = globalPage.getItems();
                $i$f$forEach2 = false;
                iterator2 = $this$forEach$iv2.entrySet().iterator();
                while (iterator2.hasNext()) {
                    entry = element$iv2 = iterator2.next();
                    boolean bl2 = false;
                    slot = ((Number)entry.getKey()).intValue();
                    guiItem = entry.getValue();
                    boolean isDynamic = globalPage.getTrackAddItemSlot().containsKey(slot);
                    if (isDynamic) continue;
                    ItemStack globalStack = ItemRenderer.INSTANCE.render(guiItem, this.context);
                    styledInventory.setItem(slot, globalStack);
                }
            }
            $this$forEach$iv2 = guiPage.getItems();
            $i$f$forEach2 = false;
            iterator2 = $this$forEach$iv2.entrySet().iterator();
            while (iterator2.hasNext()) {
                entry = element$iv2 = iterator2.next();
                boolean bl3 = false;
                slot = ((Number)entry.getKey()).intValue();
                guiItem = entry.getValue();
                ItemStack finalItemStack = ItemRenderer.INSTANCE.render(guiItem, this.context);
                styledInventory.setItem(slot, finalItemStack);
            }
            Integer n2 = pageId;
            handler.getPageInventories().put(n2, styledInventory);
            guiPage.setInventory(styledInventory);
        }
        if (builder.getPages().size() == 1) {
            n = 0;
        } else {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = builder.getPages().keySet();
            boolean $i$f$filter = false;
            object = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                int it = ((Number)element$iv$iv).intValue();
                boolean bl = false;
                if (!(it != 0)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Integer n3 = (Integer)CollectionsKt.minOrNull((List)destination$iv$iv);
            n = n3 != null ? n3 : 1;
        }
        int minPageId = n;
        Integer n4 = initialPage;
        int finalPageId = n4 != null ? n4 : minPageId;
        handler.open(this.player, finalPageId);
    }

    public static /* synthetic */ void start$default(GuiSession guiSession, Integer n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = null;
        }
        guiSession.start(n);
    }

    private final String generateTitle(String rawTitle, int pageId) {
        String title = StringsKt.replace$default(rawTitle, "{page}", String.valueOf(pageId), false, 4, null);
        boolean useStylishFont = this.blueprint.getSetting().getStyle().getStylishTitle();
        return FontStyle.INSTANCE.applyStyle(title, this.context, useStylishFont);
    }
}

