/*
 * Decompiled with CFR 0.152.
 */
package me.justlime.betterTeamGUI.libs.limeframegui.utilities;

import com.google.common.primitives.Ints;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.Base64;
import java.util.Collection;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.bukkit.Bukkit;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.profile.PlayerProfile;
import org.bukkit.profile.PlayerTextures;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0017B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0001J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u0012\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0013\u001a\u00020\u0014J\u0010\u0010\u0015\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0016\u001a\u00020\fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lme/justlime/betterTeamGUI/libs/limeframegui/utilities/SkullUtils;", "", "<init>", "()V", "applySkin", "", "meta", "Lorg/bukkit/inventory/meta/SkullMeta;", "profileObject", "createLegacyGameProfile", "Lcom/mojang/authlib/GameProfile;", "texture", "", "createProfileFromTexture", "Lorg/bukkit/profile/PlayerProfile;", "getSkinUrl", "GSON", "Lcom/google/gson/Gson;", "getTextureFromSkull", "item", "Lorg/bukkit/inventory/ItemStack;", "decodeSkinUrl", "base64Texture", "VersionHelper", "LimeFrameGUI"})
public final class SkullUtils {
    @NotNull
    public static final SkullUtils INSTANCE = new SkullUtils();
    @NotNull
    private static final Gson GSON = new Gson();

    private SkullUtils() {
    }

    public final void applySkin(@NotNull SkullMeta meta, @NotNull Object profileObject) {
        Intrinsics.checkNotNullParameter(meta, "meta");
        Intrinsics.checkNotNullParameter(profileObject, "profileObject");
        if (VersionHelper.INSTANCE.getHAS_PLAYER_PROFILES()) {
            if (profileObject instanceof PlayerProfile) {
                meta.setOwnerProfile((PlayerProfile)profileObject);
            }
            return;
        }
        if (profileObject instanceof GameProfile) {
            try {
                Field profileField = meta.getClass().getDeclaredField("profile");
                profileField.setAccessible(true);
                profileField.set(meta, profileObject);
            }
            catch (Exception e) {
                Bukkit.getLogger().warning("[LimeFrameGUI] Failed to apply legacy skull texture via reflection: " + e.getMessage());
            }
        }
    }

    @NotNull
    public final GameProfile createLegacyGameProfile(@NotNull String texture) {
        Intrinsics.checkNotNullParameter(texture, "texture");
        GameProfile profile = new GameProfile(UUID.randomUUID(), null);
        String skinUrl = this.getSkinUrl(texture);
        if (((CharSequence)skinUrl).length() > 0) {
            Base64.Encoder encoder = Base64.getEncoder();
            String string = "{\"textures\":{\"SKIN\":{\"url\":\"" + skinUrl + "\"}}}";
            byte[] byArray = string.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue(byArray, "getBytes(...)");
            String base64 = encoder.encodeToString(byArray);
            profile.getProperties().put((Object)"textures", (Object)new Property("textures", base64));
        }
        return profile;
    }

    @NotNull
    public final PlayerProfile createProfileFromTexture(@NotNull String texture) {
        Intrinsics.checkNotNullParameter(texture, "texture");
        PlayerProfile playerProfile = Bukkit.createPlayerProfile((UUID)UUID.randomUUID());
        Intrinsics.checkNotNullExpressionValue(playerProfile, "createPlayerProfile(...)");
        PlayerProfile profile = playerProfile;
        PlayerTextures playerTextures = profile.getTextures();
        Intrinsics.checkNotNullExpressionValue(playerTextures, "getTextures(...)");
        PlayerTextures textures = playerTextures;
        String skinUrl = this.getSkinUrl(texture);
        if (((CharSequence)skinUrl).length() > 0) {
            Object object;
            Object object2 = this;
            try {
                SkullUtils $this$createProfileFromTexture_u24lambda_u240 = object2;
                boolean bl = false;
                textures.setSkin(new URL(skinUrl));
                object = Result.constructor-impl(Unit.INSTANCE);
            }
            catch (Throwable bl) {
                object = Result.constructor-impl(ResultKt.createFailure(bl));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl(object2);
            if (throwable != null) {
                Object it = object = throwable;
                boolean bl = false;
                Bukkit.getLogger().warning("[LimeFrameGUI] Could not set skull skin from a malformed URL: " + skinUrl + ". Error: " + ((Throwable)it).getMessage());
            }
        }
        profile.setTextures(textures);
        return profile;
    }

    private final String getSkinUrl(String texture) {
        if (StringsKt.startsWith$default(texture, "http", false, 2, null)) {
            return texture;
        }
        String string = this.decodeSkinUrl(texture);
        if (string == null) {
            string = "https://textures.minecraft.net/texture/" + texture;
        }
        return string;
    }

    @Nullable
    public final String getTextureFromSkull(@NotNull ItemStack item) {
        GameProfile gameProfile;
        Intrinsics.checkNotNullParameter(item, "item");
        ItemMeta itemMeta = item.getItemMeta();
        SkullMeta skullMeta = itemMeta instanceof SkullMeta ? (SkullMeta)itemMeta : null;
        if (skullMeta == null) {
            return null;
        }
        SkullMeta meta = skullMeta;
        if (VersionHelper.INSTANCE.getHAS_PLAYER_PROFILES()) {
            PlayerProfile playerProfile = meta.getOwnerProfile();
            if (playerProfile == null) {
                return null;
            }
            PlayerProfile profile = playerProfile;
            URL uRL = profile.getTextures().getSkin();
            if (uRL == null) {
                return null;
            }
            URL url = uRL;
            String string = url.toString();
            Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
            return StringsKt.removePrefix(string, (CharSequence)"https://textures.minecraft.net/texture/");
        }
        try {
            Field profileField = meta.getClass().getDeclaredField("profile");
            profileField.setAccessible(true);
            Object object = profileField.get(meta);
            gameProfile = object instanceof GameProfile ? (GameProfile)object : null;
        }
        catch (Exception e) {
            gameProfile = null;
        }
        GameProfile gameProfile2 = gameProfile;
        if (gameProfile2 == null) {
            return null;
        }
        GameProfile profile = gameProfile2;
        Collection collection = profile.getProperties().get((Object)"textures");
        Intrinsics.checkNotNullExpressionValue(collection, "get(...)");
        Property property = (Property)CollectionsKt.firstOrNull(collection);
        if (property == null) {
            return null;
        }
        Property property2 = property;
        String string = property2.getValue();
        Intrinsics.checkNotNullExpressionValue(string, "getValue(...)");
        return this.decodeSkinUrl(string);
    }

    @Nullable
    public final String decodeSkinUrl(@NotNull String base64Texture) {
        String string;
        Intrinsics.checkNotNullParameter(base64Texture, "base64Texture");
        try {
            byte[] decodedBytes = Base64.getDecoder().decode(base64Texture);
            Intrinsics.checkNotNull(decodedBytes);
            if (decodedBytes.length == 0) {
                return null;
            }
            String decodedJson = new String(decodedBytes, Charsets.UTF_8);
            if (!StringsKt.startsWith$default(((Object)StringsKt.trim((CharSequence)decodedJson)).toString(), "{", false, 2, null)) {
                return null;
            }
            JsonObject decodedObject = (JsonObject)GSON.fromJson(decodedJson, JsonObject.class);
            JsonElement jsonElement = decodedObject.get("textures");
            if (jsonElement == null || (jsonElement = jsonElement.getAsJsonObject()) == null) {
                return null;
            }
            JsonElement textures = jsonElement;
            JsonElement jsonElement2 = textures.get("SKIN");
            if (jsonElement2 == null || (jsonElement2 = jsonElement2.getAsJsonObject()) == null) {
                return null;
            }
            JsonElement skin = jsonElement2;
            JsonElement jsonElement3 = skin.get("url");
            string = jsonElement3 != null ? jsonElement3.getAsString() : null;
        }
        catch (Exception e) {
            string = null;
        }
        return string;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0010\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\r\u00a8\u0006\u0011"}, d2={"Lme/justlime/betterTeamGUI/libs/limeframegui/utilities/SkullUtils$VersionHelper;", "", "<init>", "()V", "V1_18_1", "", "V1_12", "CURRENT_VERSION", "getCURRENT_VERSION", "()I", "HAS_PLAYER_PROFILES", "", "getHAS_PLAYER_PROFILES", "()Z", "IS_SKULL_OWNER_LEGACY", "getIS_SKULL_OWNER_LEGACY", "getCurrentVersion", "LimeFrameGUI"})
    public static final class VersionHelper {
        @NotNull
        public static final VersionHelper INSTANCE = new VersionHelper();
        public static final int V1_18_1 = 1181;
        public static final int V1_12 = 1120;
        private static final int CURRENT_VERSION = INSTANCE.getCurrentVersion();
        private static final boolean HAS_PLAYER_PROFILES = CURRENT_VERSION >= 1181;
        private static final boolean IS_SKULL_OWNER_LEGACY = CURRENT_VERSION <= 1120;

        private VersionHelper() {
        }

        public final int getCURRENT_VERSION() {
            return CURRENT_VERSION;
        }

        public final boolean getHAS_PLAYER_PROFILES() {
            return HAS_PLAYER_PROFILES;
        }

        public final boolean getIS_SKULL_OWNER_LEGACY() {
            return IS_SKULL_OWNER_LEGACY;
        }

        private final int getCurrentVersion() {
            Matcher matcher = Pattern.compile("(?<version>\\d+\\.\\d+)(?<patch>\\.\\d+)?").matcher(Bukkit.getBukkitVersion());
            Intrinsics.checkNotNullExpressionValue(matcher, "matcher(...)");
            Matcher matcher2 = matcher;
            StringBuilder stringBuilder = new StringBuilder();
            if (matcher2.find()) {
                String string = matcher2.group("version");
                Intrinsics.checkNotNullExpressionValue(string, "group(...)");
                stringBuilder.append(StringsKt.replace$default(string, ".", "", false, 4, null));
                String patch = matcher2.group("patch");
                StringBuilder stringBuilder2 = patch == null ? stringBuilder.append("0") : stringBuilder.append(StringsKt.replace$default(patch, ".", "", false, 4, null));
            }
            Integer n = Ints.tryParse((String)stringBuilder.toString());
            if (n == null) {
                throw new RuntimeException("Could not retrieve server version!");
            }
            return n;
        }
    }
}

