/*
 * Decompiled with CFR 0.152.
 */
package me.justlime.betterTeamGUI.utilities;

import com.booksaw.betterTeams.Team;
import com.booksaw.betterTeams.TeamPlayer;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import me.justlime.betterTeamGUI.BetterTeamGUIKt;
import me.justlime.betterTeamGUI.config.ConfigManager;
import me.justlime.betterTeamGUI.gui.GUIManager;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b$\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u000b2\u0006\u0010\f\u001a\u00020\rJ\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u000b2\u0006\u0010\u000f\u001a\u00020\u0010J\"\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010J\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0005J\u0016\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0005J\u0016\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u0005J\u0016\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u0005J\"\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u00052\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u0005J\u0016\u0010\u001f\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u0005J\u0016\u0010 \u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u0005J\u001e\u0010 \u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u0005J\u000e\u0010!\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\"\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010#\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010$\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010%\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0016\u0010&\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010'\u001a\u00020\u0005J\u000e\u0010(\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0016\u0010)\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010*\u001a\u00020\u0005J\u0016\u0010+\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010,\u001a\u00020\u0005J\u0016\u0010-\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010.\u001a\u00020\u0005J\u000e\u0010/\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0016\u00100\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0005J\u0016\u00101\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u00102\u001a\u00020\u0005J\u0016\u00103\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u00104\u001a\u00020\u0010J\u0016\u00105\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u00104\u001a\u00020\u0010J\u0016\u00106\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u00107\u001a\u00020\u0010J\u0016\u00108\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u00107\u001a\u00020\u0010J\u0016\u00109\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u00104\u001a\u00020:J\u0016\u0010;\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010<\u001a\u00020\rJ\u0016\u0010=\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010<\u001a\u00020\rJ\u0006\u0010>\u001a\u00020\u0013R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006?"}, d2={"Lme/justlime/betterTeamGUI/utilities/TeamService;", "", "<init>", "()V", "command", "", "getCommand", "()Ljava/lang/String;", "setCommand", "(Ljava/lang/String;)V", "teamToPlaceholderMap", "", "team", "Lcom/booksaw/betterTeams/Team;", "teamPlayerToPlaceholderMap", "teamPlayer", "Lcom/booksaw/betterTeams/TeamPlayer;", "applyPlaceHolder", "joinTeam", "", "player", "Lorg/bukkit/entity/Player;", "teamName", "invitePlayer", "invitedPlayerName", "depositAmount", "amount", "withdrawAmount", "setWarp", "warpName", "password", "delWarp", "warp", "teleportToHome", "setHome", "removeHome", "openTeamEnderChest", "leaveTeam", "setTitle", "title", "togglePvp", "setDescription", "description", "setTag", "tag", "rename", "newName", "disbandTeam", "createTeam", "setTeamColor", "color", "promote", "targetPlayer", "demote", "kick", "targetTeamPlayer", "ban", "unban", "Lorg/bukkit/OfflinePlayer;", "addAlly", "allyTeam", "removeAlly", "reload", "BetterTeamGUI"})
public final class TeamService {
    @NotNull
    public static final TeamService INSTANCE = new TeamService();
    @NotNull
    private static String command;

    private TeamService() {
    }

    @NotNull
    public final String getCommand() {
        return command;
    }

    public final void setCommand(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        command = string;
    }

    @NotNull
    public final Map<String, String> teamToPlaceholderMap(@NotNull Team team) {
        Intrinsics.checkNotNullParameter(team, "team");
        Pair[] pairArray = new Pair[12];
        String string = team.getName();
        if (string == null) {
            string = "N/A";
        }
        pairArray[0] = TuplesKt.to("{team}", string);
        String string2 = team.getTag();
        if (string2 == null) {
            string2 = "N/A";
        }
        pairArray[1] = TuplesKt.to("{tag}", string2);
        pairArray[2] = TuplesKt.to("{team_size}", String.valueOf(team.getMembers().size()));
        pairArray[3] = TuplesKt.to("{team_limit}", String.valueOf(team.getTeamLimit()));
        pairArray[4] = TuplesKt.to("{team_level}", String.valueOf(team.getLevel()));
        pairArray[5] = TuplesKt.to("{team_score}", String.valueOf(team.getScore()));
        pairArray[6] = TuplesKt.to("{team_money}", String.valueOf(team.getMoney()));
        pairArray[7] = TuplesKt.to("{anchor}", String.valueOf(team.isAnchored()));
        pairArray[8] = TuplesKt.to("{team_description}", team.getDescription());
        pairArray[9] = TuplesKt.to("{team_color_code}", '<' + team.getColor().name() + '>');
        pairArray[10] = TuplesKt.to("{/team_color_code}", "</" + team.getColor().name() + '>');
        pairArray[11] = TuplesKt.to("{allies_request}", String.valueOf(team.getAllyRequests().size()));
        return MapsKt.mapOf(pairArray);
    }

    @NotNull
    public final Map<String, String> teamPlayerToPlaceholderMap(@NotNull TeamPlayer teamPlayer) {
        Intrinsics.checkNotNullParameter(teamPlayer, "teamPlayer");
        Pair[] pairArray = new Pair[2];
        pairArray[0] = TuplesKt.to("{rank}", teamPlayer.getRank().name());
        String string = teamPlayer.getPlayer().getName();
        if (string == null) {
            string = "";
        }
        pairArray[1] = TuplesKt.to("{team_player}", string);
        return MapsKt.mapOf(pairArray);
    }

    @NotNull
    public final Map<String, String> applyPlaceHolder(@NotNull Team team, @NotNull TeamPlayer teamPlayer) {
        Intrinsics.checkNotNullParameter(team, "team");
        Intrinsics.checkNotNullParameter(teamPlayer, "teamPlayer");
        Map map = new LinkedHashMap();
        map.putAll(this.teamToPlaceholderMap(team));
        map.putAll(this.teamPlayerToPlaceholderMap(teamPlayer));
        return map;
    }

    public final void joinTeam(@NotNull Player player, @NotNull String teamName) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(teamName, "teamName");
        player.performCommand(command + " join " + teamName);
    }

    public final void invitePlayer(@NotNull Player player, @NotNull String invitedPlayerName) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(invitedPlayerName, "invitedPlayerName");
        player.performCommand(command + " invite " + invitedPlayerName);
    }

    public final void depositAmount(@NotNull Player player, @NotNull String amount) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(amount, "amount");
        player.performCommand(command + " deposit " + amount);
    }

    public final void withdrawAmount(@NotNull Player player, @NotNull String amount) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(amount, "amount");
        player.performCommand(command + " withdraw " + amount);
    }

    public final void setWarp(@NotNull Player player, @NotNull String warpName, @Nullable String password) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(warpName, "warpName");
        boolean bl = password != null ? player.performCommand(command + " setwarp " + warpName + ' ' + password) : player.performCommand(command + " setwarp " + warpName);
    }

    public static /* synthetic */ void setWarp$default(TeamService teamService, Player player, String string, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = null;
        }
        teamService.setWarp(player, string, string2);
    }

    public final void delWarp(@NotNull Player player, @NotNull String warpName) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(warpName, "warpName");
        player.performCommand(command + " delwarp " + warpName);
    }

    public final void warp(@NotNull Player player, @NotNull String warpName) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(warpName, "warpName");
        player.performCommand(command + " warp " + warpName);
    }

    public final void warp(@NotNull Player player, @NotNull String warpName, @NotNull String password) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(warpName, "warpName");
        Intrinsics.checkNotNullParameter(password, "password");
        player.performCommand(command + " warp " + warpName + ' ' + password);
    }

    public final void teleportToHome(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        player.performCommand(command + " home");
    }

    public final void setHome(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        player.performCommand(command + " sethome");
    }

    public final void removeHome(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        player.performCommand(command + " delhome");
    }

    public final void openTeamEnderChest(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        player.performCommand(command + " echest");
    }

    public final void leaveTeam(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        player.performCommand(command + " leave");
    }

    public final void setTitle(@NotNull Player player, @NotNull String title) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(title, "title");
        boolean bl = StringsKt.isBlank(title) ? player.performCommand(command + " title") : player.performCommand(command + " title " + title);
    }

    public final void togglePvp(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        player.performCommand(command + " pvp");
    }

    public final void setDescription(@NotNull Player player, @NotNull String description) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(description, "description");
        boolean bl = StringsKt.isBlank(description) ? player.performCommand(command + " description") : player.performCommand(command + " description " + description);
    }

    public final void setTag(@NotNull Player player, @NotNull String tag) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(tag, "tag");
        boolean bl = StringsKt.isBlank(tag) ? player.performCommand(command + " tag") : player.performCommand(command + " tag " + tag);
    }

    public final void rename(@NotNull Player player, @NotNull String newName) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(newName, "newName");
        player.performCommand(command + " name " + newName);
    }

    public final void disbandTeam(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        player.performCommand(command + " disband");
        Bukkit.getScheduler().runTaskLater((Plugin)BetterTeamGUIKt.getPluginInstance(), () -> TeamService.disbandTeam$lambda$0(player), 4L);
    }

    public final void createTeam(@NotNull Player player, @NotNull String teamName) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(teamName, "teamName");
        player.performCommand(command + " create " + teamName);
    }

    public final void setTeamColor(@NotNull Player player, @NotNull String color) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(color, "color");
        player.performCommand(command + " color " + color);
        Bukkit.getScheduler().runTaskLater((Plugin)BetterTeamGUIKt.getPluginInstance(), () -> TeamService.setTeamColor$lambda$1(player), 4L);
    }

    public final void promote(@NotNull Player player, @NotNull TeamPlayer targetPlayer) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(targetPlayer, "targetPlayer");
        player.performCommand(command + " promote " + targetPlayer.getPlayer().getName());
    }

    public final void demote(@NotNull Player player, @NotNull TeamPlayer targetPlayer) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(targetPlayer, "targetPlayer");
        player.performCommand(command + " demote " + targetPlayer.getPlayer().getName());
    }

    public final void kick(@NotNull Player player, @NotNull TeamPlayer targetTeamPlayer) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(targetTeamPlayer, "targetTeamPlayer");
        player.performCommand(command + " kick " + targetTeamPlayer.getPlayer().getName());
    }

    public final void ban(@NotNull Player player, @NotNull TeamPlayer targetTeamPlayer) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(targetTeamPlayer, "targetTeamPlayer");
        player.performCommand(command + " ban " + targetTeamPlayer.getPlayer().getName());
    }

    public final void unban(@NotNull Player player, @NotNull OfflinePlayer targetPlayer) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(targetPlayer, "targetPlayer");
        Player player2 = targetPlayer.getPlayer();
        player.performCommand(command + " unban " + (player2 != null ? player2.getName() : null));
    }

    public final void addAlly(@NotNull Player player, @NotNull Team allyTeam) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(allyTeam, "allyTeam");
        player.performCommand(command + " ally " + allyTeam.getName());
    }

    public final void removeAlly(@NotNull Player player, @NotNull Team allyTeam) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(allyTeam, "allyTeam");
        player.performCommand(command + " neutral " + allyTeam.getName());
    }

    public final void reload() {
        String string = ConfigManager.INSTANCE.getConfig().getString("command-prefix");
        if (string == null) {
            string = "team";
        }
        command = string;
    }

    private static final void disbandTeam$lambda$0(Player $player) {
        $player.performCommand(command + " disband");
    }

    private static final void setTeamColor$lambda$1(Player $player) {
        GUIManager.INSTANCE.openTeamSettingGUI($player);
    }

    static {
        String string = ConfigManager.INSTANCE.getConfig().getString("command-prefix");
        if (string == null) {
            string = "team";
        }
        command = string;
    }
}

