/*
 * Decompiled with CFR 0.152.
 */
package com.liba.dependency;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.managers.RegionManager;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import com.sk89q.worldguard.protection.regions.RegionContainer;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;

public class WorldGuardDep {
    boolean enabled;
    Plugin pl = Bukkit.getServer().getPluginManager().getPlugin("WorldGuard");

    public WorldGuardDep() {
        if (this.pl != null) {
            Bukkit.getLogger().info("[" + this.pl.getName() + "] WorldGuard connected");
            this.enabled = true;
        }
    }

    public boolean checkLocation(Location location, UUID player) {
        if (this.isEnabled()) {
            RegionContainer container = WorldGuard.getInstance().getPlatform().getRegionContainer();
            RegionManager mng = container.get(BukkitAdapter.adapt((World)location.getWorld()));
            if (mng != null) {
                ApplicableRegionSet regions = mng.getApplicableRegions(BukkitAdapter.asBlockVector((Location)location));
                if (regions.size() == 0) {
                    return true;
                }
                for (ProtectedRegion region : regions) {
                    if (!region.getOwners().contains(player) && !region.getMembers().contains(player) && !Bukkit.getPlayer((UUID)player).isOp()) continue;
                    return true;
                }
            }
        } else {
            return true;
        }
        return false;
    }

    public boolean getRadiusRegion(Location location, int radius, UUID player) {
        if (this.isEnabled()) {
            for (int x = location.getBlockX() - radius; x < location.getBlockX() + radius; ++x) {
                for (int y = location.getBlockY() - radius; y < location.getBlockY() + radius; ++y) {
                    for (int z = location.getBlockZ() - radius; z < location.getBlockZ() + radius; ++z) {
                        if (this.checkLocation(new Location(location.getWorld(), (double)x, (double)y, (double)z), player)) continue;
                        return false;
                    }
                }
            }
        }
        return true;
    }

    public boolean isEnabled() {
        return this.enabled;
    }
}

