/*
 * Decompiled with CFR 0.152.
 */
package com.liba.gui.listeners;

import com.liba.gui.Gui;
import com.liba.gui.InventoryType;
import com.liba.gui.SlotType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryMoveItemEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public class InventoryListener
implements Listener {
    @EventHandler
    public void inventoryClick(InventoryClickEvent e) {
        Inventory clickedInventory = e.getClickedInventory();
        if (clickedInventory == null) {
            return;
        }
        if (e.getView().getTopInventory().getHolder() instanceof Gui) {
            Gui holder = (Gui)e.getView().getTopInventory().getHolder();
            holder.clickInventory(e);
        }
    }

    public void move(InventoryMoveItemEvent e) {
    }

    @EventHandler
    public void openInventory(InventoryOpenEvent e) {
        Gui gui;
        Inventory openInventory = e.getInventory();
        InventoryHolder holder = openInventory.getHolder();
        if (holder instanceof Gui && (gui = (Gui)holder).getOwner() == null) {
            gui.setOwner((Player)e.getPlayer());
        }
    }

    @EventHandler
    public void inventoryDrag(InventoryDragEvent event) {
        InventoryHolder holder = event.getView().getTopInventory().getHolder();
        if (!(holder instanceof Gui)) {
            return;
        }
        Gui gui = (Gui)holder;
        if (gui.getInventoryType().equals((Object)InventoryType.INVENTORY)) {
            return;
        }
        if (event.getWhoClicked().getInventory() == event.getInventory()) {
            return;
        }
        for (Integer slot : event.getRawSlots()) {
            if (slot >= event.getView().getTopInventory().getSize()) continue;
            ItemStack current = event.getInventory().getItem(slot.intValue());
            if (gui.getMenuSlot(slot) != null && !gui.getMenuSlot(slot).getSlotType().equals((Object)SlotType.GUI)) continue;
            if (event.getOldCursor().isSimilar(current)) {
                event.setCancelled(true);
                return;
            }
            event.setCancelled(true);
            return;
        }
    }
}

