/*
 * Decompiled with CFR 0.152.
 */
package com.modencore;

import com.liba.Liba;
import com.modencore.api.LogBlockApi;
import com.modencore.base.DataSource;
import com.modencore.commands.LogBlockCommands;
import com.modencore.datastorage.DbStorage;
import com.modencore.events.LogBlockEvents;
import com.modencore.lang.Lang;
import java.io.File;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandExecutor;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class LogBlock
extends JavaPlugin {
    private static LogBlock logBlock;
    private static DbStorage dbStorage;
    private static Lang lang;
    private static LogBlockApi logBlockApi;
    private Liba liba;

    public void onEnable() {
        logBlock = this;
        if (!this.getDataFolder().exists()) {
            this.getDataFolder().mkdir();
        }
        DataSource dataSource = new DataSource();
        this.liba = new Liba((Plugin)this);
        lang = new Lang(String.valueOf(this.getDataFolder()) + File.separator + "lang.yml");
        dbStorage = new DbStorage();
        logBlockApi = new LogBlockApi(this);
        this.liba.registerMetrica(27302);
        this.liba.registerVersionChecker(32, "https://www.curseforge.com/minecraft/bukkit-plugins/logblocks");
        this.getServer().getPluginManager().registerEvents((Listener)new LogBlockEvents(this), (Plugin)this);
        this.getServer().getPluginCommand("logblock").setExecutor((CommandExecutor)new LogBlockCommands());
    }

    public void onDisable() {
        DataSource.close();
    }

    public static LogBlock getLogBlock() {
        return logBlock;
    }

    public static DbStorage getDbStorage() {
        return dbStorage;
    }

    public static void broadcast(Player player, String world, int x, int y, int z) {
        DbStorage.getBlockHistoryAsync(world, x, y, z).thenAccept(logEntries -> logEntries.forEach(block -> {
            OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)block.getPlayerUUID());
            String name = null;
            name = offlinePlayer.isOnline() ? ((Player)offlinePlayer).getName() : offlinePlayer.getName();
            LocalDateTime dateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(block.getTime()), ZoneId.systemDefault());
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd.MM.yyyy HH:mm");
            player.sendMessage(lang.getString("messages.logmessage").replace("{date}", dateTime.format(formatter)).replace("{player}", name).replace("{action}", block.getAction().toString().toLowerCase()).replace("{block_type}", block.getMaterial().name().toLowerCase()));
        }));
    }

    public static LogBlockApi getLogBlockApi() {
        return logBlockApi;
    }

    public static Lang getLang() {
        return lang;
    }

    public Liba getLiba() {
        return this.liba;
    }
}

