/*
 * Decompiled with CFR 0.152.
 */
package com.modencore.datastorage;

import com.modencore.LogBlock;
import com.modencore.LogEntry;
import com.modencore.base.DataSource;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.plugin.Plugin;

public class DbStorage {
    private static PreparedStatement insertStatement;
    private static final ConcurrentLinkedQueue<LogEntry> logQueue;

    public DbStorage() {
        try {
            insertStatement = DataSource.getConnection().prepareStatement("INSERT INTO block_log(player, action, world, x, y, z, block_type, timestamp) VALUES (?,?,?,?,?,?,?,?);");
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)LogBlock.getLogBlock(), this::flush, 20L, 20L);
    }

    public static void logBlock(LogEntry logEntry) {
        logQueue.add(logEntry);
    }

    public static List<LogEntry> getLastEntries(List<Block> coords) throws SQLException {
        if (coords.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<LogEntry> result = new ArrayList<LogEntry>();
        List<String> keys = coords.stream().map(b -> b.getWorld().getName() + "_" + b.getX() + "_" + b.getY() + "_" + b.getZ()).distinct().toList();
        int batchSize = 100;
        for (int i = 0; i < keys.size(); i += batchSize) {
            List<String> batchKeys = keys.subList(i, Math.min(i + batchSize, keys.size()));
            DbStorage.fetchBatch(result, batchKeys);
        }
        return result;
    }

    private static void fetchBatch(List<LogEntry> result, List<String> keys) throws SQLException {
        if (keys.isEmpty()) {
            return;
        }
        String placeholders = keys.stream().map(k -> "?").collect(Collectors.joining(", "));
        String sql = "SELECT player, action, block_type, x, y, z, world, timestamp FROM (     SELECT player, action, block_type, x, y, z, world, timestamp,            ROW_NUMBER() OVER (PARTITION BY key ORDER BY timestamp DESC) AS rn     FROM block_log     WHERE key IN (" + placeholders + ") ) sub WHERE rn = 1";
        try (Connection conn = DataSource.getConnection();
             PreparedStatement ps = conn.prepareStatement(sql);){
            int index = 1;
            for (String key : keys) {
                ps.setString(index++, key);
            }
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    UUID playerId = DbStorage.parseUUID(rs.getString("player"));
                    LogEntry.BlockAction action = DbStorage.parseAction(rs.getString("action"));
                    Material material = DbStorage.parseMaterial(rs.getString("block_type"));
                    if (action == null || material == null) continue;
                    result.add(new LogEntry(playerId, rs.getInt("x"), rs.getInt("y"), rs.getInt("z"), rs.getString("world"), action, material, rs.getLong("timestamp")));
                }
            }
        }
    }

    private static UUID parseUUID(String str) {
        if (str == null) {
            return null;
        }
        try {
            return UUID.fromString(str);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private static LogEntry.BlockAction parseAction(String str) {
        if (str == null) {
            return null;
        }
        try {
            return LogEntry.BlockAction.valueOf(str);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private static Material parseMaterial(String str) {
        if (str == null) {
            return null;
        }
        try {
            return Material.valueOf((String)str);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static CompletableFuture<List<LogEntry>> getAllLogsAsync() {
        return CompletableFuture.supplyAsync(() -> {
            ArrayList<LogEntry> logs = new ArrayList<LogEntry>();
            String sql = "SELECT * FROM block_log ORDER BY timestamp DESC";
            try (Connection conn = DataSource.getConnection();
                 PreparedStatement ps = conn.prepareStatement(sql);
                 ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    logs.add(new LogEntry(UUID.fromString(rs.getString("player")), rs.getInt("x"), rs.getInt("y"), rs.getInt("z"), rs.getString("world"), LogEntry.BlockAction.valueOf(rs.getString("action")), Material.valueOf((String)rs.getString("block_type")), rs.getLong("timestamp")));
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            return logs;
        });
    }

    private void flush() {
        if (logQueue.isEmpty()) {
            return;
        }
        ArrayList<LogEntry> batch = new ArrayList<LogEntry>();
        while (!logQueue.isEmpty() && batch.size() < 500) {
            batch.add(logQueue.poll());
        }
        String sql = "INSERT INTO block_log(player, action, world, x, y, z, block_type, timestamp, key) VALUES (?,?,?,?,?,?,?,?,?);";
        try (Connection conn = DataSource.getConnection();
             PreparedStatement ps = conn.prepareStatement(sql);){
            for (LogEntry entry : batch) {
                ps.setString(1, entry.getPlayerUUID().toString());
                ps.setString(2, entry.getAction().toString());
                ps.setString(3, entry.getLocation().getWorld().getName());
                ps.setInt(4, entry.getLocation().getBlockX());
                ps.setInt(5, entry.getLocation().getBlockY());
                ps.setInt(6, entry.getLocation().getBlockZ());
                ps.setString(7, entry.getMaterial().name());
                ps.setLong(8, entry.getTime());
                ps.setString(9, entry.getWorld() + "_" + entry.getX() + "_" + entry.getY() + "_" + entry.getZ());
                ps.addBatch();
            }
            ps.executeBatch();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static CompletableFuture<LogEntry> getLastActionAtLocationAsync(String world, int x, int y, int z) {
        return CompletableFuture.supplyAsync(() -> {
            String sql = "SELECT * FROM block_log WHERE key=? ORDER BY timestamp DESC LIMIT 1";
            try (Connection conn = DataSource.getConnection();
                 PreparedStatement ps = conn.prepareStatement(sql);){
                ps.setString(1, world + "_" + x + "_" + y + "_" + z);
                try (ResultSet rs = ps.executeQuery();){
                    if (!rs.next()) return null;
                    LogEntry logEntry = new LogEntry(UUID.fromString(rs.getString("player")), rs.getInt("x"), rs.getInt("y"), rs.getInt("z"), rs.getString("world"), LogEntry.BlockAction.valueOf(rs.getString("action")), Material.valueOf((String)rs.getString("block_type")), rs.getLong("timestamp"));
                    return logEntry;
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            return null;
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static LogEntry getLastActionAtLocation(String world, int x, int y, int z) {
        String sql = "SELECT * FROM block_log WHERE world=? AND x=? AND y=? AND z=? ORDER BY timestamp DESC LIMIT 1";
        try (Connection conn = DataSource.getConnection();
             PreparedStatement ps = conn.prepareStatement(sql);){
            ps.setString(1, world);
            ps.setInt(2, x);
            ps.setInt(3, y);
            ps.setInt(4, z);
            try (ResultSet rs = ps.executeQuery();){
                if (!rs.next()) return null;
                LogEntry logEntry = new LogEntry(UUID.fromString(rs.getString("player")), rs.getInt("x"), rs.getInt("y"), rs.getInt("z"), rs.getString("world"), LogEntry.BlockAction.valueOf(rs.getString("action")), Material.valueOf((String)rs.getString("block_type")), rs.getLong("timestamp"));
                return logEntry;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void logBlockAsync(LogEntry entry) {
        CompletableFuture.runAsync(() -> {
            String sql = "INSERT INTO block_log(player, action, world, x, y, z, block_type, timestamp,key) VALUES (?,?,?,?,?,?,?,?,?);";
            try (Connection conn = DataSource.getConnection();
                 PreparedStatement ps = conn.prepareStatement(sql);){
                ps.setString(1, entry.getPlayerUUID().toString());
                ps.setString(2, entry.getAction().toString());
                ps.setString(3, entry.getWorld());
                ps.setInt(4, entry.getX());
                ps.setInt(5, entry.getY());
                ps.setInt(6, entry.getZ());
                ps.setString(7, entry.getMaterial().name());
                ps.setLong(8, entry.getTime());
                ps.setString(9, entry.getWorld() + "_" + entry.getX() + "_" + entry.getY() + "_" + entry.getZ());
                ps.executeUpdate();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        });
    }

    public static CompletableFuture<List<LogEntry>> getBlockHistoryAsync(String world, int x, int y, int z) {
        return CompletableFuture.supplyAsync(() -> {
            ArrayList<LogEntry> logEntries = new ArrayList<LogEntry>();
            String sql = "SELECT * FROM block_log WHERE world=? AND x=? AND y=? AND z=? ORDER BY timestamp ASC";
            try (Connection conn = DataSource.getConnection();
                 PreparedStatement ps = conn.prepareStatement(sql);){
                ps.setString(1, world);
                ps.setInt(2, x);
                ps.setInt(3, y);
                ps.setInt(4, z);
                try (ResultSet rs = ps.executeQuery();){
                    while (rs.next()) {
                        logEntries.add(new LogEntry(UUID.fromString(rs.getString("player")), rs.getInt("x"), rs.getInt("y"), rs.getInt("z"), rs.getString("world"), LogEntry.BlockAction.valueOf(rs.getString("action")), Material.valueOf((String)rs.getString("block_type")), rs.getLong("timestamp")));
                    }
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            return logEntries;
        });
    }

    public static List<LogEntry> getBlockHistory(String world, int x, int y, int z) {
        ArrayList<LogEntry> logEntries = new ArrayList<LogEntry>();
        try (PreparedStatement ps = DataSource.getConnection().prepareStatement("SELECT * FROM block_log WHERE world=? AND x=? AND y=? AND z=? ORDER BY timestamp DESC;");){
            ps.setString(1, world);
            ps.setInt(2, x);
            ps.setInt(3, y);
            ps.setInt(4, z);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                logEntries.add(new LogEntry(UUID.fromString(rs.getString("player")), rs.getInt("x"), rs.getInt("y"), rs.getInt("z"), rs.getString("world"), LogEntry.BlockAction.valueOf(rs.getString("action")), Material.valueOf((String)rs.getString("block_type")), rs.getLong("timestamp")));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return logEntries;
    }

    static {
        logQueue = new ConcurrentLinkedQueue();
    }
}

