/*
 * Decompiled with CFR 0.152.
 */
package com.modencore.events;

import com.modencore.LogBlock;
import com.modencore.LogEntry;
import com.modencore.datastorage.DbStorage;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class LogBlockEvents
implements Listener {
    private final LogBlock plugin;

    public LogBlockEvents(LogBlock plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent e) {
        Block block = e.getBlock();
        LogEntry logEntry = new LogEntry(e.getPlayer().getUniqueId(), block.getX(), block.getY(), block.getZ(), block.getWorld().getName(), LogEntry.BlockAction.BREAK, block.getType(), System.currentTimeMillis());
        DbStorage.logBlock(logEntry);
    }

    @EventHandler
    public void onBlockPlace(BlockPlaceEvent e) {
        Block block = e.getBlock();
        LogEntry logEntry = new LogEntry(e.getPlayer().getUniqueId(), block.getX(), block.getY(), block.getZ(), block.getWorld().getName(), LogEntry.BlockAction.PLACE, block.getType(), System.currentTimeMillis());
        DbStorage.logBlock(logEntry);
    }

    @EventHandler
    public void getLogBlock(PlayerInteractEvent e) {
        if (e.getHand() != EquipmentSlot.HAND) {
            return;
        }
        ItemStack itemInHand = e.getPlayer().getInventory().getItemInMainHand();
        if (itemInHand.getItemMeta() == null) {
            return;
        }
        if (e.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (!e.getPlayer().hasPermission("logblock.admin")) {
            return;
        }
        ItemMeta meta = itemInHand.getItemMeta();
        if (itemInHand.getType() == Material.STICK && e.getClickedBlock() != null && meta.getPersistentDataContainer().get(new NamespacedKey((Plugin)LogBlock.getLogBlock(), "logBlock"), PersistentDataType.STRING) != null) {
            Block block = e.getClickedBlock();
            LogBlock.broadcast(e.getPlayer(), e.getPlayer().getWorld().getName(), block.getX(), block.getY(), block.getZ());
            e.setCancelled(true);
        }
    }
}

