/*
 * Decompiled with CFR 0.152.
 */
package com.liba.gui;

import com.liba.gui.InventoryType;
import com.liba.gui.MenuSlot;
import com.liba.gui.SlotType;
import com.liba.gui.buttons.DebugButton;
import com.liba.utils.Debug;
import com.liba.utils.ItemUtil;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public abstract class Gui
implements InventoryHolder {
    public final HashMap<Integer, MenuSlot> menuSlot = new HashMap();
    public Player owner;
    Inventory inventory;
    String title;
    int rows;
    Gui backGui;
    InventoryType inventoryType = InventoryType.GUI;
    boolean globalcancel;

    public Gui(String title, int rows) {
        this.title = title;
        this.rows = rows;
        this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)(rows * 9), (String)title);
    }

    public Gui(String title, int rows, InventoryType inventoryType) {
        this(title, rows);
        this.inventoryType = inventoryType;
    }

    public Gui(String title, int rows, Gui backGui) {
        this(title, rows);
        this.backGui = backGui;
    }

    public Gui(String title, int rows, InventoryType inventoryType, Gui backGui) {
        this(title, rows, backGui);
        this.inventoryType = inventoryType;
    }

    public void clickInventory(InventoryClickEvent e) {
        InventoryAction action = e.getAction();
        int slot = e.getRawSlot();
        MenuSlot mslot = this.menuSlot.getOrDefault(slot, null);
        if (mslot != null) {
            if (this.inventoryType.equals((Object)InventoryType.GUI) && e.getClickedInventory() != e.getView().getTopInventory() && mslot.getSlotType().equals((Object)SlotType.GUI) && (action.equals((Object)InventoryAction.MOVE_TO_OTHER_INVENTORY) || action.equals((Object)InventoryAction.COLLECT_TO_CURSOR))) {
                e.setCancelled(true);
                return;
            }
            if (e.getClickedInventory() == this.getInventory() && mslot.getEvent() != null) {
                mslot.event.accept(e);
            }
        }
        if (this.isGlobalcancel()) {
            e.setCancelled(true);
        }
    }

    public void render() {
        this.setInventoryItems();
        for (Map.Entry<Integer, MenuSlot> slot : this.menuSlot.entrySet()) {
            if (slot.getValue().slotType == null || !slot.getValue().slotType.equals((Object)SlotType.GUI)) continue;
            this.getInventory().setItem(slot.getKey().intValue(), slot.getValue().guiItem);
        }
    }

    public void render(int slot) {
        this.setInventoryItems();
        MenuSlot menuSlot1 = this.menuSlot.get(slot);
        if (menuSlot1 != null) {
            this.getInventory().setItem(slot, menuSlot1.guiItem);
        }
    }

    public void open(Player player) {
        this.setOwner(player);
        this.render();
        player.openInventory(this.getInventory());
    }

    public abstract void setInventoryItems();

    public void addSlot(int slot, MenuSlot menuSlot) {
        if (menuSlot instanceof DebugButton && !Debug.isDebug()) {
            return;
        }
        this.menuSlot.put(slot, menuSlot);
    }

    public MenuSlot getMenuSlot(int slotid) {
        return this.menuSlot.getOrDefault(slotid, null);
    }

    public void renameSlot(int slotid, String title) {
        ItemUtil.rename(this.menuSlot.get((Object)Integer.valueOf((int)slotid)).guiItem, title);
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public void setTitle(String title) {
        this.title = title;
        this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)(this.rows * 9), (String)title);
    }

    public int getRows() {
        return this.rows;
    }

    public int getSlots() {
        return this.rows * 9;
    }

    public boolean removeSlot(int slot) {
        MenuSlot slot1 = this.getMenuSlot(slot);
        if (slot1 == null) {
            return false;
        }
        this.getInventory().setItem(slot, new ItemStack(Material.AIR));
        this.menuSlot.remove(slot);
        return true;
    }

    public Player getOwner() {
        return this.owner;
    }

    public void setOwner(Player owner) {
        this.owner = owner;
    }

    public void updateSlot(int id) {
        if (this.menuSlot.containsKey(id)) {
            this.getInventory().setItem(id, this.menuSlot.get((Object)Integer.valueOf((int)id)).guiItem);
        }
    }

    public void openBack() {
        if (this.backGui != null) {
            this.backGui.open(this.getOwner());
        }
    }

    public Gui getBackGui() {
        return this.backGui;
    }

    public void setBackGui(Gui backGui) {
        this.backGui = backGui;
    }

    public InventoryType getInventoryType() {
        return this.inventoryType;
    }

    public boolean isGlobalcancel() {
        return this.globalcancel;
    }

    public void setGlobalcancel(boolean globalcancel) {
        this.globalcancel = globalcancel;
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

