/*
 * Decompiled with CFR 0.152.
 */
package com.liba.version;

import com.google.gson.Gson;
import com.liba.Liba;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import org.bukkit.Bukkit;

public class VersionChecker {
    private int resourceId;
    private String apiurl = "https://papi.modncore.com/api/rs/getversion/";
    private String message;
    private String serverMessage;
    private boolean needupdate;
    private String latestversion;

    public VersionChecker(int id, String site) {
        this.resourceId = id;
        this.message = "[\"\",   {\"text\":\"Plugin \",\"bold\":true,\"color\":\"gold\"},{\"text\":\"[\",\"bold\":true,\"color\":\"gray\"},{\"text\":\"" + Liba.getPlugin().getName() + "\",\"bold\":true,\"color\":\"aqua\"},{\"text\":\"]\",\"bold\":true,\"color\":\"gray\"},{\"text\":\" Update Available\\n\",\"bold\":true,\"color\":\"gold\"},  {\"text\":\"Your version: \",\"color\":\"gray\"},  {\"text\":\"{your}\",\"color\":\"red\",\"bold\":true},  {\"text\":\" | Latest: \",\"color\":\"gray\"},  {\"text\":\"{latest}\\n\",\"color\":\"green\",\"bold\":true},  {\"text\":\"Download: \",\"color\":\"gray\"},  {\"text\":\"[Click Here]\",\"color\":\"aqua\",\"underlined\":true,\"clickEvent\":{\"action\":\"open_url\",\"value\":\"" + site + "\"}}]";
        this.serverMessage = "\n\t\u001b[33mPlugin \u001b[90m[\u001b[36m" + Liba.getPlugin().getName() + "\u001b[90m] \u001b[33mUpdate Available\n\t\u001b[90mYour version: \u001b[31m{your} \u001b[90m| Latest: \u001b[32m{latest}\n\t\u001b[90mDownload: \u001b[36m" + site + "\u001b[0m";
        this.checkVersion();
    }

    public String getMessage() {
        return this.message.replace("{your}", Liba.getPlugin().getDescription().getVersion()).replace("{latest}", this.latestversion);
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getServerMessage() {
        return this.serverMessage.replace("{your}", Liba.getPlugin().getDescription().getVersion()).replace("{latest}", this.latestversion);
    }

    public void checkVersion() {
        HttpClient client = HttpClient.newHttpClient();
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(this.apiurl + this.resourceId)).POST(HttpRequest.BodyPublishers.noBody()).build();
        try {
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            Gson gson = new Gson();
            String version = (String)gson.fromJson(response.body(), String.class);
            if (!Liba.getPlugin().getDescription().getVersion().equals(version)) {
                this.latestversion = version;
                this.setNeedupdate(true);
                Bukkit.getLogger().info(this.getServerMessage());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isNeedupdate() {
        return this.needupdate;
    }

    public void setNeedupdate(boolean needupdate) {
        this.needupdate = needupdate;
    }
}

