/*
 * Decompiled with CFR 0.152.
 */
package com.modencore.base;

import com.modencore.LogBlock;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;

public class DataSource {
    private static HikariConfig config = new HikariConfig();
    private static HikariDataSource ds;

    public DataSource() {
        try (Statement st = DataSource.getConnection().createStatement();){
            st.executeUpdate("CREATE TABLE IF NOT EXISTS block_log (id INTEGER PRIMARY KEY AUTOINCREMENT,key TEXT,player TEXT,action TEXT,world TEXT,x INT,y INT,z INT,block_type TEXT,timestamp BIGINT);");
            st.executeUpdate("CREATE INDEX IF NOT EXISTS idx_block_log_key ON block_log(key);");
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public static Connection getConnection() throws SQLException {
        return ds.getConnection();
    }

    public static void close() {
        if (ds != null && !ds.isClosed()) {
            ds.close();
        }
    }

    static {
        config.setJdbcUrl("jdbc:sqlite:" + String.valueOf(LogBlock.getLogBlock().getDataFolder()) + File.separator + "log.db");
        config.setConnectionTestQuery("SELECT 1");
        config.setMaximumPoolSize(5);
        config.setMinimumIdle(1);
        config.setIdleTimeout(30000L);
        config.setMaxLifetime(1800000L);
        config.setConnectionTimeout(10000L);
        config.addDataSourceProperty("cachePrepStmts", "true");
        config.addDataSourceProperty("prepStmtCacheSize", "250");
        config.addDataSourceProperty("prepStmtCacheSqlLimit", "2048");
        ds = new HikariDataSource(config);
    }
}

