/*
 * Decompiled with CFR 0.152.
 */
package com.devid.senpaihud;

import com.devid.senpaihud.MushApiClient;
import com.devid.senpaihud.PlayerStats;
import com.devid.senpaihud.PlayerStatsCallback;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.util.EnumChatFormatting;
import org.lwjgl.input.Mouse;

public class GuiPlayerStats
extends GuiScreen {
    private final List<PlayerStats> statsList = Collections.synchronizedList(new ArrayList());
    private final List<String> errorList = Collections.synchronizedList(new ArrayList());
    private boolean loading = true;
    private int dotCount = 0;
    private long lastUpdateTime = 0L;
    private int scrollOffset = 0;
    private final int lineHeight = 12;
    private final int visibleLines = 10;

    public GuiPlayerStats(List<String> usernames) {
        this.fetchPlayerStats(usernames);
    }

    private void fetchPlayerStats(final List<String> usernames) {
        System.out.println("\ud83d\udd0d Starting search for stats of " + usernames.size() + " players...");
        if (usernames.isEmpty()) {
            this.loading = false;
            return;
        }
        for (int i = 0; i < usernames.size(); ++i) {
            String username = usernames.get(i);
            System.out.println("\ud83d\udd0e Searching for stats of: " + username + " (" + (i + 1) + "/" + usernames.size() + ")");
            MushApiClient.getPlayerStatsAsync(username, new PlayerStatsCallback(){

                @Override
                public void onResult(PlayerStats stats) {
                    GuiPlayerStats.this.statsList.add(stats);
                    Collections.sort(GuiPlayerStats.this.statsList, new Comparator<PlayerStats>(){

                        @Override
                        public int compare(PlayerStats a, PlayerStats b) {
                            return Integer.compare(b.getScore(), a.getScore());
                        }
                    });
                    GuiPlayerStats.this.checkLoadingComplete(usernames.size());
                }

                @Override
                public void onError(String username, String error) {
                    String errorMessage = "Error fetching stats for " + username + ": " + error;
                    GuiPlayerStats.this.errorList.add(errorMessage);
                    System.err.println(errorMessage);
                    GuiPlayerStats.this.checkLoadingComplete(usernames.size());
                }
            });
        }
    }

    private void checkLoadingComplete(int totalUsernames) {
        if (this.statsList.size() + this.errorList.size() == totalUsernames) {
            this.loading = false;
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        ScaledResolution sr = new ScaledResolution(this.field_146297_k);
        int centerX = sr.func_78326_a() / 2;
        int centerY = sr.func_78328_b() / 2;
        if (this.loading) {
            long currentTime = System.currentTimeMillis();
            if (currentTime - this.lastUpdateTime > 100L) {
                this.dotCount = (this.dotCount + 1) % 4;
                this.lastUpdateTime = currentTime;
            }
            String[] gear = new String[]{"\u2699", "\u269a", "\u269b", "\u269c"};
            String rotatingGear = gear[this.dotCount];
            String loadingText = EnumChatFormatting.YELLOW + rotatingGear + " Searching for players... " + rotatingGear;
            this.func_73732_a(this.field_146289_q, loadingText, centerX, centerY, 0xFFFFFF);
        } else if (this.statsList.isEmpty() && this.errorList.isEmpty()) {
            String noPlayersText = EnumChatFormatting.RED + "No players found.";
            this.func_73732_a(this.field_146289_q, noPlayersText, centerX, centerY, 0xFFFFFF);
        } else {
            String title = EnumChatFormatting.BOLD + "" + EnumChatFormatting.RED + "SenpaiHUD - BedWars Stats";
            this.func_73732_a(this.field_146289_q, title, centerX, centerY - 80, 0xFFFFFF);
            this.drawHeader(centerX, centerY - 60);
            ArrayList<PlayerStats> snapshot = new ArrayList<PlayerStats>(this.statsList);
            int startIndex = this.scrollOffset;
            int endIndex = Math.min(snapshot.size(), startIndex + 10);
            int y = centerY - 48;
            for (int i = startIndex; i < endIndex; ++i) {
                PlayerStats stats = (PlayerStats)snapshot.get(i);
                this.drawPlayerStats(stats, centerX, y);
                y += 12;
            }
            ArrayList<String> errorSnapshot = new ArrayList<String>(this.errorList);
            for (String error : errorSnapshot) {
                this.func_73732_a(this.field_146289_q, EnumChatFormatting.RED + error, centerX, y, 0xFFFFFF);
                y += 12;
            }
            this.drawScrollbar();
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    private void drawHeader(int centerX, int y) {
        String header = String.format("%-32s %-10s %-7s %-7s %-7s %-7s %-7s", "Player", "Score", "Wins", "Finals", "FKDR", "Beds", "Level");
        this.func_73732_a(this.field_146289_q, EnumChatFormatting.AQUA + header, centerX, y, 0xFFFFFF);
    }

    private void drawPlayerStats(PlayerStats stats, int centerX, int y) {
        EnumChatFormatting color = this.getColorForScore(stats.getScore());
        StringBuilder playerInfoBuilder = new StringBuilder();
        if ("premium".equalsIgnoreCase(stats.getAccountType())) {
            playerInfoBuilder.append(EnumChatFormatting.AQUA + "\u2605 ");
        } else {
            playerInfoBuilder.append(EnumChatFormatting.GRAY + "\u2606 ");
        }
        if (stats.getBanBlacklistCount() > 0) {
            playerInfoBuilder.append(EnumChatFormatting.RED + "\u26a0 (" + stats.getBanBlacklistCount() + ") ");
        }
        long fortyEightHoursInMillis = 172800000L;
        if (stats.getFirstLogin() > 0L && System.currentTimeMillis() - stats.getFirstLogin() < fortyEightHoursInMillis) {
            playerInfoBuilder.append(EnumChatFormatting.GREEN + "New ");
        }
        String playerDisplay = stats.getUsername() + " " + playerInfoBuilder.toString().trim();
        String fkdr = String.format("%.2f", (double)stats.getFkdr() / 100.0);
        String format = "%s%-32s " + color + "%-10s %-7s %-7s %-7s %-7s %-7s";
        String line = String.format(format, color, playerDisplay, stats.getScore(), stats.getWins(), stats.getFinalKills(), fkdr, stats.getBedsBroken(), stats.getLevel());
        this.func_73732_a(this.field_146289_q, line, centerX, y, 0xFFFFFF);
    }

    private void drawScrollbar() {
        ScaledResolution sr = new ScaledResolution(this.field_146297_k);
        int maxOffset = Math.max(0, this.statsList.size() - 10);
        if (maxOffset > 0) {
            int scrollbarHeight = sr.func_78328_b() - 20;
            int handleHeight = Math.max(10, scrollbarHeight * 10 / this.statsList.size());
            int handleY = 10 + (scrollbarHeight - handleHeight) * this.scrollOffset / maxOffset;
            GuiPlayerStats.func_73734_a((int)(sr.func_78326_a() - 10), (int)10, (int)(sr.func_78326_a() - 5), (int)(sr.func_78328_b() - 10), (int)Integer.MIN_VALUE);
            GuiPlayerStats.func_73734_a((int)(sr.func_78326_a() - 10), (int)handleY, (int)(sr.func_78326_a() - 5), (int)(handleY + handleHeight), (int)-1);
        }
    }

    private EnumChatFormatting getColorForScore(int score) {
        if (score >= 100000) {
            return EnumChatFormatting.DARK_PURPLE;
        }
        if (score >= 50000) {
            return EnumChatFormatting.GOLD;
        }
        if (score >= 20000) {
            return EnumChatFormatting.BLUE;
        }
        if (score >= 10000) {
            return EnumChatFormatting.YELLOW;
        }
        if (score >= 5000) {
            return EnumChatFormatting.GREEN;
        }
        if (score >= 2000) {
            return EnumChatFormatting.DARK_GREEN;
        }
        return EnumChatFormatting.GRAY;
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int delta = Mouse.getDWheel();
        if (delta != 0) {
            int maxOffset = Math.max(0, this.statsList.size() - 10);
            this.scrollOffset -= delta > 0 ? 1 : -1;
            if (this.scrollOffset < 0) {
                this.scrollOffset = 0;
            }
            if (this.scrollOffset > maxOffset) {
                this.scrollOffset = maxOffset;
            }
        }
    }

    public boolean func_73868_f() {
        return false;
    }
}

