/*
 * Decompiled with CFR 0.152.
 */
package com.devid.senpaihud;

import com.devid.senpaihud.PlayerStats;
import com.devid.senpaihud.PlayerStatsCallback;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class MushApiClient {
    private static final int CACHE_LIMIT = 500;
    private static final Map<String, PlayerStats> statsCache = new ConcurrentHashMap<String, PlayerStats>();

    public static void getPlayerStatsAsync(String username, final PlayerStatsCallback callback) {
        final String sanitizedUsername = username.replaceAll("[^A-Za-z0-9_]", "");
        if (statsCache.containsKey(sanitizedUsername)) {
            System.out.println("Player " + sanitizedUsername + " found in cache.");
            callback.onResult(statsCache.get(sanitizedUsername));
            return;
        }
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block9: {
                    try {
                        String line;
                        String urlString = "https://mush.com.br/api/player/" + sanitizedUsername;
                        URL url = new URL(urlString);
                        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                        conn.setRequestMethod("GET");
                        conn.setRequestProperty("User-Agent", "SenpaiHUD-Mod");
                        int responseCode = conn.getResponseCode();
                        if (responseCode != 200) {
                            callback.onError(sanitizedUsername, "HTTP " + responseCode);
                            return;
                        }
                        InputStream inputStream = conn.getInputStream();
                        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
                        StringBuilder response = new StringBuilder();
                        while ((line = reader.readLine()) != null) {
                            response.append(line);
                        }
                        reader.close();
                        String json = response.toString();
                        if (json.contains("\"stats\"") && json.contains("\"bedwars\"")) {
                            String responsePath = MushApiClient.getJsonObject(json, "response");
                            String accountPath = MushApiClient.getJsonObject(responsePath, "account");
                            String statsPath = MushApiClient.getJsonObject(responsePath, "stats");
                            String bedwarsPath = MushApiClient.getJsonObject(statsPath, "bedwars");
                            int wins = MushApiClient.getJsonIntValue(bedwarsPath, "wins");
                            int finalKills = MushApiClient.getJsonIntValue(bedwarsPath, "final_kills");
                            int fkdr = MushApiClient.getJsonIntValue(bedwarsPath, "fkdr");
                            int bedsBroken = MushApiClient.getJsonIntValue(bedwarsPath, "beds_broken");
                            int level = MushApiClient.getJsonIntValue(bedwarsPath, "level");
                            int winstreak = MushApiClient.getJsonIntValue(bedwarsPath, "winstreak");
                            String accountType = MushApiClient.getJsonStringValue(accountPath, "type");
                            int banBlacklistCount = MushApiClient.getJsonIntValue(responsePath, "ban_blacklist_count");
                            long firstLogin = MushApiClient.getJsonLongValue(responsePath, "first_login");
                            PlayerStats stats = new PlayerStats(sanitizedUsername, wins, finalKills, fkdr, bedsBroken, level, winstreak, accountType, banBlacklistCount, firstLogin);
                            Map map = statsCache;
                            synchronized (map) {
                                if (statsCache.size() >= 500) {
                                    System.out.println("\u26a0\ufe0f Cache is full (500 entries). Resetting...");
                                    statsCache.clear();
                                }
                                statsCache.put(sanitizedUsername, stats);
                            }
                            callback.onResult(stats);
                            break block9;
                        }
                        callback.onError(sanitizedUsername, "Stats not found in JSON.");
                    }
                    catch (Exception e) {
                        callback.onError(sanitizedUsername, e.getMessage());
                    }
                }
            }
        }).start();
    }

    private static String getJsonObject(String json, String key) {
        int endIndex;
        int keyIndex = json.indexOf("\"" + key + "\"");
        if (keyIndex == -1) {
            System.out.println("Object not found in JSON: " + key);
            return "";
        }
        int startBrace = json.indexOf(123, keyIndex);
        if (startBrace == -1) {
            return "";
        }
        int braceLevel = 0;
        for (endIndex = startBrace; endIndex < json.length(); ++endIndex) {
            char c = json.charAt(endIndex);
            if (c == '{') {
                ++braceLevel;
            } else if (c == '}') {
                --braceLevel;
            }
            if (braceLevel == 0) break;
        }
        return json.substring(startBrace, endIndex + 1);
    }

    private static String getJsonStringValue(String json, String key) {
        try {
            String searchKey = "\"" + key + "\":";
            int keyIndex = json.indexOf(searchKey);
            if (keyIndex == -1) {
                System.out.println("Key not found in JSON: " + key);
                return "";
            }
            int valueStart = keyIndex + searchKey.length();
            int quoteStart = json.indexOf(34, valueStart);
            if (quoteStart == -1) {
                return "";
            }
            int quoteEnd = json.indexOf(34, quoteStart + 1);
            if (quoteEnd == -1) {
                return "";
            }
            return json.substring(quoteStart + 1, quoteEnd);
        }
        catch (Exception exception) {
            return "";
        }
    }

    private static long getJsonLongValue(String json, String key) {
        try {
            int endIndex;
            String searchKey = "\"" + key + "\":";
            int keyIndex = json.indexOf(searchKey);
            if (keyIndex == -1) {
                System.out.println("Key not found in JSON: " + key);
                return 0L;
            }
            int valueStart = keyIndex + searchKey.length();
            int commaIndex = json.indexOf(44, valueStart);
            int braceIndex = json.indexOf(125, valueStart);
            if (commaIndex != -1 && braceIndex != -1) {
                endIndex = Math.min(commaIndex, braceIndex);
            } else if (commaIndex != -1) {
                endIndex = commaIndex;
            } else if (braceIndex != -1) {
                endIndex = braceIndex;
            } else {
                return 0L;
            }
            String valueStr = json.substring(valueStart, endIndex).trim();
            String numericValue = valueStr.replaceAll("[^0-9-]", "");
            if (numericValue.isEmpty()) {
                return 0L;
            }
            return Long.parseLong(numericValue);
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    private static int getJsonIntValue(String json, String key) {
        try {
            int endIndex;
            String searchKey = "\"" + key + "\":";
            int keyIndex = json.indexOf(searchKey);
            if (keyIndex == -1) {
                System.out.println("Key not found in JSON: " + key);
                return 0;
            }
            int valueStart = keyIndex + searchKey.length();
            int commaIndex = json.indexOf(44, valueStart);
            int braceIndex = json.indexOf(125, valueStart);
            if (commaIndex != -1 && braceIndex != -1) {
                endIndex = Math.min(commaIndex, braceIndex);
            } else if (commaIndex != -1) {
                endIndex = commaIndex;
            } else if (braceIndex != -1) {
                endIndex = braceIndex;
            } else {
                return 0;
            }
            String valueStr = json.substring(valueStart, endIndex).trim();
            String numericValue = valueStr.replaceAll("[^0-9-]", "");
            if (numericValue.isEmpty()) {
                return 0;
            }
            return Integer.parseInt(numericValue);
        }
        catch (Exception exception) {
            return 0;
        }
    }
}

