/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.fabrication.client;

import codechicken.lib.colour.EnumColour;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.buffer.TransformingVertexConsumer;
import codechicken.lib.vec.Transformation;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.LinkedList;
import java.util.List;
import mrtjp.projectred.fabrication.engine.InterfaceSpec;
import mrtjp.projectred.fabrication.item.component.ICDataComponent;
import mrtjp.projectred.integration.client.GateComponentModels;
import mrtjp.projectred.integration.client.GateModelRenderer;
import mrtjp.projectred.integration.part.IGateRenderData;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class RenderFabricatedGate
extends GateModelRenderer.GateRenderer {
    private final List<GateComponentModels.ComponentModel> models = new LinkedList<GateComponentModels.ComponentModel>();
    private final GateComponentModels.SidedWireModel simpleWires = new GateComponentModels.SidedWireModel(GateComponentModels.generateWireModels((String)"ic1", (int)4));
    private final GateComponentModels.SidedWireModel analogWires = new GateComponentModels.SidedWireModel(GateComponentModels.generateWireModels((String)"ic2", (int)4));
    private final GateComponentModels.SidedICBundledCableModel bundledWires = new GateComponentModels.SidedICBundledCableModel();
    private final GateComponentModels.FabricatedICModel icHousing = GateComponentModels.FabricatedICModel.INSTANCE;
    private boolean runtimeError = false;
    private String name = "untitled";

    public RenderFabricatedGate() {
        this.models.add((GateComponentModels.ComponentModel)GateComponentModels.BaseComponentModel.INSTANCE);
        this.models.add((GateComponentModels.ComponentModel)this.simpleWires);
        this.models.add((GateComponentModels.ComponentModel)this.analogWires);
        this.models.add((GateComponentModels.ComponentModel)this.bundledWires);
        this.models.add((GateComponentModels.ComponentModel)this.icHousing);
    }

    protected List<GateComponentModels.ComponentModel> getModels() {
        return this.models;
    }

    protected void prepareInventory(@Nullable ItemStack stack) {
        ICDataComponent component;
        ICDataComponent iCDataComponent = component = stack == null ? null : ICDataComponent.getComponent(stack);
        if (component == null) {
            this.runtimeError = true;
            this.name = "ERROR!";
            this.simpleWires.sidemask = 0;
            this.analogWires.sidemask = 0;
            this.bundledWires.sidemask = 0;
            return;
        }
        this.runtimeError = false;
        this.name = component.getName();
        InterfaceSpec ifSpec = component.getInterfaceSpec();
        this.simpleWires.sidemask = ifSpec.getRedstoneInputMask() | ifSpec.getRedstoneOutputMask();
        this.analogWires.sidemask = ifSpec.getAnalogInputMask() | ifSpec.getAnalogOutputMask();
        this.bundledWires.sidemask = ifSpec.getBundledInputMask() | ifSpec.getBundledOutputMask();
    }

    protected void prepare(IGateRenderData gate) {
        this.simpleWires.sidemask = gate.state2() & 0xF;
        this.analogWires.sidemask = gate.state2() >> 4 & 0xF;
        this.bundledWires.sidemask = gate.state2() >> 8 & 0xF;
        this.simpleWires.wires[0].on = (gate.state() & 0x11) != 0;
        this.simpleWires.wires[1].on = (gate.state() & 0x22) != 0;
        this.simpleWires.wires[2].on = (gate.state() & 0x44) != 0;
        this.simpleWires.wires[3].on = (gate.state() & 0x88) != 0;
        this.analogWires.wires[0].on = this.simpleWires.wires[0].on;
        this.analogWires.wires[1].on = this.simpleWires.wires[1].on;
        this.analogWires.wires[2].on = this.simpleWires.wires[2].on;
        this.analogWires.wires[3].on = this.simpleWires.wires[3].on;
    }

    public boolean hasSpecials() {
        return true;
    }

    protected void prepareDynamic(IGateRenderData gate, float partialFrame) {
        this.runtimeError = gate.hasRuntimeError();
        this.name = gate.getGateName();
    }

    public void renderDynamic(CCRenderState ccrs, Transformation t) {
    }

    public void renderCustomDynamic(CCRenderState ccrs, Transformation t, PoseStack mStack, MultiBufferSource buffers, int packedLight, int packedOverlay, float partialTicks) {
        this.icHousing.renderName(this.name, t, mStack, buffers, this.runtimeError ? EnumColour.RED.argb() : EnumColour.WHITE.argb(), packedLight);
        ccrs.reset();
        ccrs.brightness = packedLight;
        ccrs.overlay = packedOverlay;
        ccrs.bind((VertexConsumer)new TransformingVertexConsumer(buffers.getBuffer(RenderType.translucentMovingBlock()), mStack), DefaultVertexFormat.BLOCK);
        this.icHousing.renderGlass(t, ccrs);
    }
}

